/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public final class PKIXValidator
extends Validator {
    private static final boolean TRY_VALIDATOR = true;
    private final Set trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private Set trustedSubjects;
    private CertificateFactory factory;

    private void initCommon() {
        this.trustedSubjects = new HashSet();
        Iterator iterator = this.trustedCerts.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            this.trustedSubjects.add(x509Certificate.getSubjectX500Principal());
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Internal error", certificateException);
        }
    }

    private void setDefaultParameters(String string) {
        this.parameterTemplate.setRevocationEnabled(false);
    }

    public PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    private void setDate(PKIXBuilderParameters pKIXBuilderParameters) {
        Date date = this.validationDate;
        if (date != null) {
            pKIXBuilderParameters.setDate(date);
        }
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    PKIXValidator(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        super("PKIX", string);
        this.trustedCerts = new HashSet();
        Iterator iterator = pKIXBuilderParameters.getTrustAnchors().iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate == null) continue;
            this.trustedCerts.add(x509Certificate);
        }
        this.parameterTemplate = pKIXBuilderParameters;
        this.initCommon();
    }

    private X509Certificate[] doValidate(X509Certificate[] x509CertificateArray) throws CertificateException {
        try {
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(pKIXBuilderParameters);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            CertPath certPath = this.factory.generateCertPath(Arrays.asList(x509CertificateArray));
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
            return PKIXValidator.toArray(certPath, pKIXCertPathValidatorResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path validation failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }

    PKIXValidator(String string, Collection collection) {
        super("PKIX", string);
        this.trustedCerts = collection instanceof Set ? (Set)collection : new HashSet(collection);
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            hashSet.add(new TrustAnchor(x509Certificate, null));
        }
        try {
            this.parameterTemplate = new PKIXBuilderParameters(hashSet, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Unexpected error: " + invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
        }
        this.setDefaultParameters(string);
        this.initCommon();
    }

    private static X509Certificate[] toArray(CertPath certPath, TrustAnchor trustAnchor) throws CertificateException {
        List list = certPath.getCertificates();
        Object[] objectArray = new X509Certificate[list.size() + 1];
        list.toArray(objectArray);
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate == null) {
            throw new ValidatorException("TrustAnchor must be specified as certificate");
        }
        objectArray[objectArray.length - 1] = x509Certificate;
        return objectArray;
    }

    private X509Certificate[] doBuild(X509Certificate[] x509CertificateArray, Collection collection) throws CertificateException {
        try {
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(pKIXBuilderParameters);
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificate(x509CertificateArray[0]);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(Arrays.asList(x509CertificateArray));
            if (collection != null) {
                arrayList.addAll(collection);
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList));
            pKIXBuilderParameters.addCertStore(certStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
            return PKIXValidator.toArray(pKIXCertPathBuilderResult.getCertPath(), pKIXCertPathBuilderResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path building failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }

    X509Certificate[] engineValidate(X509Certificate[] x509CertificateArray, Collection collection, Object object) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            if (!this.trustedCerts.contains(x509CertificateArray[i2])) continue;
            if (i2 == 0) {
                return new X509Certificate[]{x509CertificateArray[0]};
            }
            X509Certificate[] x509CertificateArray2 = new X509Certificate[i2];
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, i2);
            return this.doValidate(x509CertificateArray2);
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        if (this.trustedSubjects.contains(x500Principal) && !x500Principal.equals(x500Principal2)) {
            return this.doValidate(x509CertificateArray);
        }
        return this.doBuild(x509CertificateArray, collection);
    }
}

