/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class FlowLayout2
implements LayoutManager,
Serializable {
    public static final String LEFT = "LEFT";
    public static final String CENTER = "CENTER";
    public static final String RIGHT = "RIGHT";
    private Component leftC;
    private Component centerC;
    private Component rightC;
    int hgap;
    int vgap;

    public int getHgap() {
        return this.hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public FlowLayout2() {
        this(5, 5);
    }

    public FlowLayout2(int align, int hgap) {
        this.hgap = hgap;
        this.vgap = this.vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name.equals(LEFT)) {
            this.leftC = comp;
        } else if (name.equals(CENTER)) {
            this.centerC = comp;
        } else if (name.equals(RIGHT)) {
            this.rightC = comp;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
        }
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                Dimension d = m.getPreferredSize();
                dim.height = Math.max(dim.height, d.height);
                dim.width += d.width;
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 4;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int centerWidth = this.centerC.getWidth();
            int x = insets.left + this.hgap;
            int y = insets.top + this.vgap;
            int h = target.getHeight() - insets.top - insets.bottom - this.vgap * 2;
            int w = target.getWidth() - insets.right - insets.left - this.hgap * 2;
            int wlr = (w - centerWidth - this.hgap * 2) / 2;
            this.leftC.setBounds(x, y, wlr, h);
            this.centerC.setBounds(x += wlr + this.hgap, y, centerWidth, h);
            this.rightC.setBounds(x += centerWidth + this.hgap, y, wlr, h);
        }
    }
}

