/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.JFileTree;
import com.office.swing.OpenSwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class JDirChooser
extends JDialog
implements TreeSelectionListener,
ActionListener,
Serializable {
    boolean hasCancel = true;
    JPanel pCenter = new JPanel(new BorderLayout());
    JFileTree fileTree = new JFileTree();
    JScrollPane spTree = new JScrollPane(this.fileTree);
    JPanel pSouth = new JPanel(new BorderLayout());
    JPanel pButtons = new JPanel(new FlowLayout(2, 7, 0));
    JPanel pResult = new JPanel(new BorderLayout());
    JLabel lbFolder = new JLabel(OpenSwingUtil.getOpenResource("Folder"));
    JTextField txtResult = new JTextField();
    JButton bttCreateNew = new JButton(OpenSwingUtil.getOpenResource("CreateNew"));
    JButton bttCancel = new JButton(OpenSwingUtil.getOpenResource("Cancel"));
    JButton bttOK = new JButton(OpenSwingUtil.getOpenResource("OK"));
    JLabel lbView = new JLabel();
    JPanel pAdjust = new JPanel(){
        private static final long serialVersionUID = 1L;

        public void paintChildren(Graphics g) {
            super.paintChildren(g);
            int w = this.getWidth();
            int h = this.getHeight();
            Color oldColor = g.getColor();
            g.setColor(Color.white);
            g.drawLine(w, h - 12, w - 12, h);
            g.drawLine(w, h - 8, w - 8, h);
            g.drawLine(w, h - 4, w - 4, h);
            g.setColor(new Color(128, 128, 128));
            g.drawLine(w, h - 11, w - 11, h);
            g.drawLine(w, h - 10, w - 10, h);
            g.drawLine(w, h - 7, w - 7, h);
            g.drawLine(w, h - 6, w - 6, h);
            g.drawLine(w, h - 3, w - 3, h);
            g.drawLine(w, h - 2, w - 2, h);
            g.setColor(oldColor);
        }
    };
    MouseInputAdapter adjustWindowListener = new MouseInputAdapter(){
        Point oldP = null;

        public void mouseDragged(MouseEvent e) {
            if (this.oldP != null) {
                Point newP = e.getPoint();
                JDirChooser c = JDirChooser.this;
                c.setBounds(c.getX(), c.getY(), c.getWidth() + (newP.x - this.oldP.x), c.getHeight() + (newP.y - this.oldP.y));
                c.validate();
                this.oldP = newP;
            }
        }

        public void mouseMoved(MouseEvent e) {
            Component c = e.getComponent();
            Rectangle r = new Rectangle(c.getWidth() - 12, 0, 12, c.getHeight());
            if (r.contains(e.getPoint())) {
                JDirChooser.this.setCursor(Cursor.getPredefinedCursor(5));
            } else {
                JDirChooser.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            Rectangle r = new Rectangle(c.getWidth() - 12, 0, 12, c.getHeight());
            this.oldP = r.contains(e.getPoint()) ? e.getPoint() : null;
        }

        public void mouseExited(MouseEvent e) {
            JDirChooser.this.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseReleased(MouseEvent e) {
            this.oldP = null;
        }
    };

    public static File showDialog(Component c, String title, boolean modal, File initDir, String msg) {
        JDirChooser dialog;
        Window owner = JDirChooser.getRootWindow(c);
        if (owner instanceof Dialog) {
            dialog = new JDirChooser((Dialog)owner, title, modal);
        } else if (owner instanceof Frame) {
            dialog = new JDirChooser((Frame)owner, title, modal);
        } else {
            dialog = new JDirChooser();
            dialog.setTitle(title);
        }
        if (initDir != null) {
            try {
                dialog.setSelectFile(initDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg != null) {
            dialog.setMsg(msg);
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((d.width - dialog.getSize().width) / 2, (d.height - dialog.getSize().height) / 2);
        dialog.show();
        return dialog.getSelectFile();
    }

    /*
     * Unable to fully structure code
     */
    static Window getRootWindow(Component c) {
        if (c == null) {
            return null;
        }
        parent = c.getParent();
        if (!(c instanceof Window)) ** GOTO lbl7
        return (Window)c;
lbl-1000:
        // 1 sources

        {
            parent = parent.getParent();
lbl7:
            // 2 sources

            ** while (!(parent instanceof Window))
        }
lbl8:
        // 1 sources

        return (Window)parent;
    }

    public JDirChooser(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JDirChooser(Dialog frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JDirChooser() {
        this((Frame)null, "", false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.bttCreateNew.setPreferredSize(new Dimension(88, 21));
        this.bttCreateNew.setMargin(new Insets(0, 0, 0, 0));
        this.bttCancel.setPreferredSize(new Dimension(88, 21));
        this.bttCancel.setMargin(new Insets(0, 0, 0, 0));
        this.bttOK.setPreferredSize(new Dimension(88, 21));
        this.pCenter.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 24));
        this.lbView.setPreferredSize(new Dimension(190, 50));
        this.pButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, -7));
        this.pResult.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
        this.pAdjust.setPreferredSize(new Dimension(10, 15));
        this.getContentPane().add((Component)this.pCenter, "Center");
        this.pCenter.add((Component)this.spTree, "Center");
        this.pCenter.add((Component)this.pSouth, "South");
        this.pResult.add((Component)this.txtResult, "Center");
        this.pResult.add((Component)this.lbFolder, "West");
        this.pSouth.add((Component)this.pButtons, "Center");
        this.pSouth.add((Component)this.pResult, "North");
        this.pButtons.add((Component)this.bttOK, null);
        this.pButtons.add((Component)this.bttCancel, null);
        this.pButtons.add((Component)this.bttCreateNew, null);
        this.pCenter.add((Component)this.lbView, "North");
        this.getContentPane().add((Component)this.pAdjust, "South");
        this.setSize(400, 305);
        this.setResizable(false);
        this.txtResult.setEditable(false);
        this.txtResult.setBackground(Color.white);
        this.fileTree.addTreeSelectionListener(this);
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        this.bttOK.setEnabled(false);
        this.bttCreateNew.setEnabled(false);
        this.bttOK.addActionListener(this);
        this.bttCancel.addActionListener(this);
        this.bttCreateNew.addActionListener(this);
        this.pAdjust.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.pAdjust.addMouseListener(this.adjustWindowListener);
        this.pAdjust.addMouseMotionListener(this.adjustWindowListener);
    }

    public void setMsg(String msg) {
        this.lbView.setText(msg);
    }

    public String getMsg() {
        return this.lbView.getText();
    }

    public void valueChanged(TreeSelectionEvent event) {
        File f = this.fileTree.getSelectFile();
        boolean enabled = f != null;
        this.bttOK.setEnabled(enabled);
        boolean bl = enabled = enabled && JFileTree.fileSystemView.isFileSystem(f);
        if (f != null && JFileTree.fileSystemView.isDrive(f)) {
            enabled = enabled && f.canWrite();
        }
        this.bttCreateNew.setEnabled(enabled);
        if (f != null) {
            this.txtResult.setText(JFileTree.fileSystemView.getSystemDisplayName(f));
        }
    }

    public JFileTree getFileTree() {
        return this.fileTree;
    }

    public void setFileTree(JFileTree tree) {
        if (tree == null || tree == this.fileTree) {
            return;
        }
        this.spTree.getViewport().setView(tree);
        this.spTree.doLayout();
    }

    public File getSelectFile() {
        if (this.hasCancel) {
            return null;
        }
        return this.fileTree.getSelectFile();
    }

    public void setSelectFile(File f) throws Exception {
        this.fileTree.setSelectFile(f);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object obj = actionEvent.getSource();
        if (obj == this.bttCreateNew) {
            String dirName = JOptionPane.showInputDialog(this, "", "new");
            if (dirName == null || dirName.trim().length() == 0) {
                return;
            }
            File f = this.fileTree.getSelectFile();
            if ((f = new File(String.valueOf(f.getAbsolutePath()) + File.separator + dirName)).mkdir()) {
                this.fileTree.getSelectFileNode().removeAllChildren();
                this.fileTree.getSelectFileNode().setExplored(false);
                this.fileTree.getSelectFileNode().explore();
            } else {
                JOptionPane.showMessageDialog(this, "Error", "Error", 0);
            }
        } else {
            if (obj == this.bttOK) {
                this.hasCancel = false;
            }
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JDirChooser Demo");
        JTextArea txt = new JTextArea();
        frame.getContentPane().add((Component)new JScrollPane(txt), "Center");
        frame.setVisible(true);
        File f = JDirChooser.showDialog(frame, "Please Select directory", true, null, "Please Select");
        if (f != null) {
            txt.setText(f.getAbsolutePath());
        }
    }
}

