/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.OpenSwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JFileTree
extends JTree
implements Serializable {
    public static final String SINGLE_FILE_MODEL = "SINGLE_FILE_MODEL";
    public static final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    DefaultTreeModel treeModel = (DefaultTreeModel)UIManager.get("SINGLE_FILE_MODEL");

    public JFileTree() {
        if (this.treeModel == null) {
            FileNode root = new FileNode(fileSystemView.getRoots()[0]);
            this.treeModel = new DefaultTreeModel(root);
            ((FileNode)this.treeModel.getRoot()).explore();
            UIManager.put(SINGLE_FILE_MODEL, this.treeModel);
        }
        this.setModel(this.treeModel);
        this.addTreeExpansionListener(new JFileTreeExpandsionListener());
        this.setCellRenderer(new JFileTreeCellRenderer());
    }

    public FileNode getSelectFileNode() {
        TreePath path = this.getSelectionPath();
        if (path == null || path.getLastPathComponent() == null) {
            return null;
        }
        return (FileNode)path.getLastPathComponent();
    }

    public void setSelectFileNode(FileNode f) throws Exception {
        this.setSelectFile(f.getFile());
    }

    public File getSelectFile() {
        FileNode node = this.getSelectFileNode();
        return node == null ? null : node.getFile();
    }

    public void setSelectFile(File f) throws Exception {
        FileNode node = this.expandFile(f);
        TreePath path = new TreePath(node.getPath());
        this.scrollPathToVisible(path);
        this.setSelectionPath(path);
        this.repaint();
    }

    public FileNode expandFile(File f) throws Exception {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        Vector<File> vTemp = new Vector<File>();
        File fTemp = f;
        while (fTemp != null) {
            vTemp.add(fTemp);
            fTemp = fileSystemView.getParentDirectory(fTemp);
        }
        FileNode nParent = (FileNode)this.treeModel.getRoot();
        int i = vTemp.size() - 1;
        while (i >= 0) {
            fTemp = (File)vTemp.get(i);
            nParent.explore();
            int j = 0;
            while (j < nParent.getChildCount()) {
                FileNode nChild = (FileNode)nParent.getChildAt(j);
                if (nChild.getFile().equals(fTemp)) {
                    nParent = nChild;
                }
                ++j;
            }
            --i;
        }
        return nParent;
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JFileTree Demo");
        JFileTree tree = new JFileTree();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JScrollPane(tree), "Center");
        frame.setVisible(true);
        try {
            tree.setSelectFile(new File("C:/"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class FileNode
    extends DefaultMutableTreeNode {
        private boolean explored = false;

        public FileNode(File file) {
            this.setUserObject(file);
        }

        public boolean getAllowsChildren() {
            return this.isDirectory();
        }

        public boolean isDirectory() {
            return !this.isLeaf();
        }

        public boolean isLeaf() {
            return false;
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored(boolean b) {
            this.explored = b;
        }

        public String toString() {
            if (this.getFile() instanceof File) {
                return fileSystemView.getSystemDisplayName(this.getFile());
            }
            return this.getFile().toString();
        }

        public void explore() {
            if (!this.explored) {
                this.explored = true;
                File file = this.getFile();
                File[] children = file.listFiles();
                if (children == null || children.length == 0) {
                    return;
                }
                int i = 0;
                while (i < children.length) {
                    File f = children[i];
                    if (f.isDirectory()) {
                        this.add(new FileNode(f));
                    }
                    ++i;
                }
                DefaultTreeModel model = (DefaultTreeModel)UIManager.get(JFileTree.SINGLE_FILE_MODEL);
                if (model != null) {
                    model.nodeStructureChanged(this);
                }
            }
        }
    }

    class JFileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        JFileTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            try {
                FileNode node = (FileNode)value;
                this.openIcon = this.closedIcon = fileSystemView.getSystemIcon(((FileNode)value).getFile());
                this.setIcon(this.closedIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }

    class JFileTreeExpandsionListener
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            if (path == null || path.getLastPathComponent() == null) {
                return;
            }
            JFileTree.this.setCursor(new Cursor(3));
            FileNode node = (FileNode)path.getLastPathComponent();
            node.explore();
            JFileTree.this.setCursor(new Cursor(0));
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

