/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.OpenSwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class JStatusBar
extends JComponent
implements Serializable {
    private Vector vecCellWidth = new Vector();

    public JStatusBar() {
        this.setPreferredSize(new Dimension(10, 20));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void addStatusCell(int width) {
        JLabel lb = new JLabel(){

            public void paint(Graphics g) {
                super.paint(g);
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(Color.white);
                g.drawLine(w - 4, 0, w - 4, h - 2);
                g.setColor(new Color(128, 128, 128));
                g.drawLine(w - 1, 0, w - 1, h - 5);
            }

            public Insets getInsets() {
                return new Insets(0, 0, 0, 5);
            }
        };
        lb.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
        this.add(lb);
        this.vecCellWidth.add("" + width);
    }

    public int getCellCount() {
        return this.getComponentCount();
    }

    public void setStatus(int cellIndex, String status) {
        if (this.getLabel(cellIndex) != null) {
            this.getLabel(cellIndex).setText(status);
        }
    }

    private JLabel getLabel(int cellIndex) {
        if (cellIndex >= this.getCellCount()) {
            return null;
        }
        JLabel lb = (JLabel)this.getComponent(cellIndex);
        return lb;
    }

    public String getStatusText(int cellIndex) {
        if (this.getLabel(cellIndex) != null) {
            return this.getLabel(cellIndex).getText();
        }
        return null;
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        int w = this.getWidth();
        int h = this.getHeight();
        Color oldColor = g.getColor();
        g.setColor(Color.white);
        g.drawLine(w, h - 12, w - 12, h);
        g.drawLine(w, h - 8, w - 8, h);
        g.drawLine(w, h - 4, w - 4, h);
        g.setColor(new Color(128, 128, 128));
        g.drawLine(w, h - 11, w - 11, h);
        g.drawLine(w, h - 10, w - 10, h);
        g.drawLine(w, h - 7, w - 7, h);
        g.drawLine(w, h - 6, w - 6, h);
        g.drawLine(w, h - 3, w - 3, h);
        g.drawLine(w, h - 2, w - 2, h);
        g.setColor(UIManager.getColor("Panel.background"));
        int cellW = 0;
        int i = 0;
        while (i < this.vecCellWidth.size()) {
            g.drawLine((cellW += Integer.parseInt(this.vecCellWidth.get(i).toString())) - 2, 0, cellW, 0);
            g.drawLine(cellW - 2, 1, cellW, 1);
            ++i;
        }
        g.setColor(oldColor);
    }

    public static void main(String[] args) {
        JStatusBar bar = new JStatusBar();
        bar.addStatusCell(200);
        bar.addStatusCell(100);
        bar.addStatusCell(100);
        bar.setStatus(0, "Status 0 ");
        bar.setStatus(1, "Status 1 ");
        bar.setStatus(2, "Status 2 ");
        JFrame frame = OpenSwingUtil.createDemoFrame("JStatusBar Demo");
        frame.getContentPane().add((Component)bar, "South");
        frame.getContentPane().add((Component)new JScrollPane(new JTextArea()), "Center");
        frame.setVisible(true);
    }
}

