/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing;

import com.office.swing.JFileTree;
import com.office.swing.OpenSwingUtil;
import com.office.swing.TreePopup;
import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeComboBox
extends JComboBox {
    private JTree tree;

    public JTreeComboBox() {
        this(new JTree());
    }

    public JTreeComboBox(JTree tree) {
        this.setTree(tree);
    }

    public void setTree(JTree tree) {
        this.tree = tree;
        if (tree != null) {
            this.setSelectedItem(tree.getSelectionPath());
            this.setRenderer(new JTreeComboBoxRenderer());
        }
        this.updateUI();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setSelectedItem(Object o) {
        this.tree.setSelectionPath((TreePath)o);
        this.getModel().setSelectedItem(o);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        cui = cui instanceof MetalComboBoxUI ? new MetalJTreeComboBoxUI() : (cui instanceof MotifComboBoxUI ? new MotifJTreeComboBoxUI() : new WindowsJTreeComboBoxUI());
        this.setUI((ComboBoxUI)cui);
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JTreeComboBox Demo");
        frame.getContentPane().setLayout(new FlowLayout());
        JTreeComboBox box = new JTreeComboBox(new JTree());
        box.setPreferredSize(new Dimension(300, 21));
        frame.getContentPane().add(box);
        final JButton btt = new JButton("Set As JFileTree");
        btt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTreeComboBox.this.setTree(new JFileTree());
                btt.setEnabled(false);
            }
        });
        frame.getContentPane().add(btt);
        frame.setVisible(true);
    }

    class JTreeComboBoxRenderer
    extends DefaultListCellRenderer {
        JTreeComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                TreePath path = (TreePath)value;
                TreeNode node = (TreeNode)path.getLastPathComponent();
                value = node;
                TreeCellRenderer r = JTreeComboBox.this.tree.getCellRenderer();
                JLabel lb = (JLabel)r.getTreeCellRendererComponent(JTreeComboBox.this.tree, value, isSelected, false, node.isLeaf(), index, cellHasFocus);
                return lb;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    class MetalJTreeComboBoxUI
    extends MetalComboBoxUI {
        MetalJTreeComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox);
        }
    }

    class MotifJTreeComboBoxUI
    extends MotifComboBoxUI {
        MotifJTreeComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox);
        }
    }

    class WindowsJTreeComboBoxUI
    extends WindowsComboBoxUI {
        WindowsJTreeComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new TreePopup(this.comboBox);
        }
    }
}

