/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import com.office.swing.print.PrintContent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class DrawOut
implements Printable {
    PrintContent content;
    boolean isPreview = true;

    public DrawOut(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public DrawOut(PrintContent content, boolean isPreview) {
        this.content = content;
        this.isPreview = isPreview;
    }

    public void setPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public void setPrintContent(PrintContent content) {
        this.content = content;
    }

    public PrintContent getPrintContent() {
        return this.content;
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        double pW = pf.getImageableWidth();
        double pH = pf.getImageableHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.black);
        g2.translate(pf.getImageableX(), pf.getImageableY());
        if (this.isPreview) {
            this.drawCropMarks(g2, pf);
        }
        g2.drawString("" + (page + 1), (int)(pW - (double)g.getFontMetrics().stringWidth("" + (page + 1)) - 5.0), (int)pH);
        g2.clip(new Rectangle2D.Double(0.0, 0.0, pW, pH));
        g2.translate(0.0, (double)(-page) * pH);
        return page >= this.getPageCount(g2, pf) ? 1 : 0;
    }

    public int getPageCount(Graphics2D g2, PageFormat pf) {
        Point p = new Point(2, 2);
        if (this.content != null) {
            this.content.draw(g2, p, pf);
        }
        int height = p.y - g2.getFontMetrics().getHeight();
        return (int)Math.ceil((double)height / pf.getImageableHeight());
    }

    public void drawCropMarks(Graphics2D g2, PageFormat pf) {
        double c = 36.0;
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        g2.draw(new Line2D.Double(0.0, 0.0, 0.0, 36.0));
        g2.draw(new Line2D.Double(0.0, 0.0, 36.0, 0.0));
        g2.draw(new Line2D.Double(w, 0.0, w, 36.0));
        g2.draw(new Line2D.Double(w, 0.0, w - 36.0, 0.0));
        g2.draw(new Line2D.Double(0.0, h, 0.0, h - 36.0));
        g2.draw(new Line2D.Double(0.0, h, 36.0, h));
        g2.draw(new Line2D.Double(w, h, w, h - 36.0));
        g2.draw(new Line2D.Double(w, h, w - 36.0, h));
    }
}

