/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import com.office.swing.OpenSwingUtil;
import com.office.swing.print.MultiPageRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MultiPagePopup
extends JPopupMenu {
    int hPage = 0;
    int vPage = 0;
    JTable tbl = new JTable(5, 11);
    JPanel pStatus = new JPanel();
    JLabel lbStatus = new JLabel(OpenSwingUtil.getOpenResource("Cancel"));
    TitledBorder titledBorder1;
    Action action;

    public MultiPagePopup() {
        this.tbl.setRowHeight(24);
        TableColumnModel colModel = this.tbl.getColumnModel();
        int i = 0;
        while (i < this.tbl.getColumnCount()) {
            TableColumn col = colModel.getColumn(i);
            col.setPreferredWidth(24);
            col.setResizable(false);
            col.setCellRenderer(new MultiPageRenderer());
            ++i;
        }
        this.tbl.setEnabled(false);
        this.tbl.setRequestFocusEnabled(false);
        this.tbl.setRowSelectionAllowed(true);
        this.tbl.setColumnSelectionAllowed(true);
        this.tbl.setSelectionMode(1);
        this.tbl.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int[] rows = MultiPagePopup.this.tbl.getSelectedRows();
                int[] cols = MultiPagePopup.this.tbl.getSelectedColumns();
                MultiPagePopup.this.setPages(rows.length, cols.length);
                MultiPagePopup.this.setVisible(false);
                if (MultiPagePopup.this.action != null) {
                    MultiPagePopup.this.action.actionPerformed(new ActionEvent(MultiPagePopup.this.tbl, 1001, ""));
                }
            }

            public void mouseExited(MouseEvent e) {
                MultiPagePopup.this.tbl.clearSelection();
                MultiPagePopup.this.setPages(0, 0);
            }
        });
        this.tbl.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                int row = 0;
                while (row < MultiPagePopup.this.tbl.getRowCount()) {
                    int col = 0;
                    while (col < MultiPagePopup.this.tbl.getColumnCount()) {
                        if (MultiPagePopup.this.tbl.getCellRect(row, col, true).contains(e.getPoint())) {
                            MultiPagePopup.this.tbl.setRowSelectionInterval(0, row);
                            MultiPagePopup.this.tbl.setColumnSelectionInterval(0, col);
                            MultiPagePopup.this.setPages(row + 1, col + 1);
                            break;
                        }
                        ++col;
                    }
                    ++row;
                }
            }

            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(""));
        this.add((Component)this.tbl, "Center");
        this.add((Component)this.pStatus, "South");
        this.pStatus.add(this.lbStatus);
        this.pStatus.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setPages(int hPage, int vPage) {
        this.hPage = hPage;
        this.vPage = vPage;
        if (hPage == 0 && vPage == 0) {
            this.setStatus(OpenSwingUtil.getOpenResource("Cancel"));
        } else {
            this.setStatus(String.valueOf(hPage) + " * " + vPage + OpenSwingUtil.getOpenResource("Page"));
        }
    }

    public int getHorizontalPages() {
        return this.hPage;
    }

    public int getVerticalPages() {
        return this.vPage;
    }

    void setStatus(String status) {
        this.lbStatus.setText(status);
    }
}

