/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

public class PreviewCanvas
extends JPanel {
    Book book;
    int currentPage = 0;

    public PreviewCanvas(Book b, int pageNumber) {
        this.book = b;
        this.currentPage = pageNumber;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        PageFormat pageFormat = this.book.getPageFormat(this.currentPage);
        double px = pageFormat.getWidth();
        double py = pageFormat.getHeight();
        double sx = this.getWidth() - 1;
        double sy = this.getHeight() - 1;
        double scale = sy / py;
        double xoff = 0.5 * (sx - scale * px);
        double yoff = 0.0;
        g2.translate((float)xoff, (float)yoff);
        g2.scale((float)scale, (float)scale);
        Rectangle2D.Double page = new Rectangle2D.Double(0.0, 0.0, px, py);
        g2.setPaint(Color.white);
        g2.fill(page);
        Printable printable = this.book.getPrintable(this.currentPage);
        try {
            printable.print(g2, pageFormat, this.currentPage);
        }
        catch (PrinterException eee) {
            g2.draw(new Line2D.Double(0.0, 0.0, px, py));
            g2.draw(new Line2D.Double(0.0, px, 0.0, py));
        }
    }
}

