/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.print.content;

import com.office.swing.print.content.PrintContentInterface;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.print.PageFormat;

public class PrintGridString
implements PrintContentInterface {
    String[] s;

    public PrintGridString(String[] s) {
        this.s = s;
    }

    public void draw(Graphics g, Point p, PageFormat pf, int startPos) {
        FontMetrics fm = g.getFontMetrics();
        int pw = (int)(pf.getImageableWidth() - (double)startPos);
        int ph = (int)pf.getImageableHeight();
        int maxTab = this.getMaxLen(fm);
        int j = 0;
        while (j < this.s.length) {
            g.drawString(this.s[j], p.x, p.y);
            p.x += maxTab;
            if (p.x > pw - maxTab + startPos) {
                p.y += fm.getHeight();
                if ((double)(p.y % ph) < (double)fm.getHeight() * 1.25) {
                    p.y += fm.getHeight();
                }
                p.x = startPos;
            }
            ++j;
        }
    }

    int getMaxLen(FontMetrics fm) {
        int max = 0;
        int i = 0;
        while (i < this.s.length) {
            max = Math.max(max, fm.stringWidth(this.s[i]));
            ++i;
        }
        return max + 5;
    }
}

