/*
 * Decompiled with CFR 0.152.
 */
package com.office.swing.refer;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class SingleObjectComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private SimpleDateFormat dateFormat;
    private String selectedDate = "";

    public SingleObjectComboBoxModel() {
    }

    public SingleObjectComboBoxModel(SimpleDateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setSelectedItem(Object anItem) {
        if (anItem == null) {
            return;
        }
        if (anItem instanceof Date) {
            try {
                this.selectedDate = this.dateFormat.format((Date)anItem);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                String strDate = anItem.toString().trim();
                if (strDate.length() != 10 && strDate.length() != 19) {
                    return;
                }
                String pattern = this.dateFormat.toPattern();
                if (strDate.length() == 10 && pattern.length() == 19) {
                    strDate = String.valueOf(strDate) + this.selectedDate.substring(10);
                }
                this.dateFormat.parse(strDate);
                this.selectedDate = strDate;
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException("Invalid datetime: string [" + anItem + "], format is [" + this.dateFormat.toPattern() + "]. ");
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return this.selectedDate;
    }

    public Object getElementAt(int index) {
        return this.selectedDate;
    }

    public int getSize() {
        return 1;
    }
}

