/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.im.InputContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import softcore.util.ArrayEnumeration;
import softcore.util.JDBC;
import softcore.util.Utilities;
import softcore.util.ValueText;
import softoperation.finance.erpdata.LoginDialog;

public final class AwtUtil {
    public static Object[][] treeobj;
    public static final int cellPrintOnMutiLine = 128;
    public static final int cellAlignCenter = 4096;
    public static final int cellAlignRight = 8192;
    public static final int cellAlignVCenter = 16384;
    public static int cellNonLinebackwind;
    public static final int LINE_NULL = 0;
    public static final int LINE_SOLID = 1;
    public static final int LINE_HATCH = 2;

    static {
        cellNonLinebackwind = 32768;
    }

    private AwtUtil() {
    }

    public static final void locateCenter(Component component, Component component1) {
        Container container = null;
        if (component1 != null) {
            if (component1 instanceof Window || component1 instanceof Applet) {
                container = (Container)component1;
            } else {
                Container container1 = component1.getParent();
                while (container1 != null) {
                    if (container1 instanceof Window || container1 instanceof Applet) {
                        container = container1;
                        break;
                    }
                    container1 = container1.getParent();
                }
            }
        }
        if (component1 != null && !component1.isShowing() || container == null || !container.isShowing()) {
            Dimension dimension = component.getSize();
            Dimension dimension2 = component.getToolkit().getScreenSize();
            component.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        } else {
            Dimension dimension1 = component1.getSize();
            Point point = component1.getLocationOnScreen();
            Rectangle rectangle = component.getBounds();
            int i = point.x + (dimension1.width - rectangle.width >> 1);
            int j = point.y + (dimension1.height - rectangle.height >> 1);
            Dimension dimension3 = component.getToolkit().getScreenSize();
            if (j + rectangle.height > dimension3.height) {
                j = dimension3.height - rectangle.height;
                int n = i = point.x >= dimension3.width >> 1 ? point.x - rectangle.width : point.x + dimension1.width;
            }
            if (i + rectangle.width > dimension3.width) {
                i = dimension3.width - rectangle.width;
            }
            if (i < 0) {
                i = 0;
            }
            if (j < 0) {
                j = 0;
            }
            component.setLocation(i, j);
        }
    }

    private static final int randomN(int i) {
        int l;
        if (i <= 0) {
            return 0;
        }
        int j = (int)(Math.random() * (double)i * (double)i);
        int k = j % i;
        return k <= (l = j / i) ? (i + k) / 2 : k / 2;
    }

    public static final void locateRandom(Component component, Container container) {
        Dimension dimension = container.getSize();
        Dimension dimension1 = component.getSize();
        int i = dimension.width - dimension1.width;
        int j = dimension.height - dimension1.height;
        component.setLocation(AwtUtil.randomN(i), AwtUtil.randomN(j));
    }

    public static void drawLine(Graphics g, int i, int j, int k, int l, Color color, int i1, int j1) {
        BasicStroke basicStroke = new BasicStroke(2.0f);
        ((Graphics2D)g).setStroke(new BasicStroke(j1));
        if (j1 == 0 || i1 == 0) {
            return;
        }
        g.setColor(color);
        if (i != k && j != l) {
            g.drawRect(i, j, k - i, l - j);
            return;
        }
        if (i1 == 1 && j1 == 1) {
            g.drawLine(i, j, k, l);
            return;
        }
        int k1 = i1;
        i1 = i1 < 3 ? (i1 <<= 1) : (i1 <<= 2);
        int l1 = (int)((double)i1 * 3.0 / 5.0);
        if (i == k) {
            if (j > l) {
                int i2 = j;
                j = l;
                l = i2;
            }
            int k2 = j;
            while (k2 < l) {
                int j2 = k2 + l1;
                if (j2 > l) {
                    j2 = l;
                }
                g.drawLine(i, k2, i, j2);
                if (k1 == 4 && j2 + 4 <= l) {
                    g.drawLine(i, j2 + 4, i, j2 + 4);
                } else if (k1 == 5 && j2 + 3 <= l) {
                    g.drawLine(i, j2 + 3, i, j2 + 3);
                    if (j2 + 5 <= l) {
                        g.drawLine(i, j2 + 5, i, j2 + 5);
                    }
                }
                k2 += i1;
            }
        } else {
            double d = (double)(l - j) / (double)(k - i);
            if (i > k) {
                int l2 = i;
                i = k;
                k = l2;
                l2 = j;
                j = l;
                l = l2;
            }
            int l3 = i;
            while (l3 < k) {
                int i3 = l3 + l1;
                if (i3 > k) {
                    i3 = k;
                }
                g.drawLine(l3, j + (int)(d * (double)(l3 - i)), i3, j + (int)(d * (double)(i3 - i)));
                if (k1 == 4) {
                    if ((i3 += 4) > k) {
                        i3 = k;
                    }
                    int j3 = j + (int)(d * (double)(i3 - i));
                    g.drawLine(i3, j3, i3, j3);
                } else if (k1 == 5) {
                    if ((i3 += 3) > k) {
                        i3 = k;
                    }
                    int k3 = j + (int)(d * (double)(i3 - i));
                    g.drawLine(i3, k3, i3, k3);
                    if ((i3 += 2) > k) {
                        i3 = k;
                    }
                    k3 = j + (int)(d * (double)(i3 - i));
                    g.drawLine(i3, k3, i3, k3);
                }
                l3 += i1;
            }
        }
    }

    public static void drawLine(Graphics g, Point point, Point point1, Color color, int i, int j) {
        AwtUtil.drawLine(g, point.x, point.y, point1.x, point1.y, color, i, j);
    }

    public static int splitDrawText(String s, int i, int j, FontMetrics fontmetrics, Vector vector) {
        int k = 0;
        if (s == null) {
            return 0;
        }
        char[] ac = s.toCharArray();
        int l = ac.length;
        if (l == 0) {
            vector.addElement(s);
            return 1;
        }
        int i1 = 0;
        while (i1 < l) {
            int j1 = i1;
            int k1 = i1 + 1;
            while (k1 <= l) {
                if (k1 >= l || !AwtUtil.isEngChar(ac[k1]) || !AwtUtil.isEngChar(ac[k1 - 1])) {
                    if (j1 > i1 && fontmetrics.charsWidth(ac, i1, k1 - i1) >= i - j) break;
                    j1 = k1;
                }
                ++k1;
            }
            if (j1 <= i1) {
                j1 = k1 < l ? k1 : l;
            }
            String s1 = new String(ac, i1, j1 - i1);
            vector.addElement(s1);
            ++k;
            i1 = j1;
            while (i1 < l && (ac[i1] <= ' ' || ac[i1] == '\u3000')) {
                ++i1;
            }
        }
        return k;
    }

    static boolean isEngChar(char c) {
        return Utilities.isLetterOrDigit(c) || ".-$".indexOf(c) >= 0;
    }

    public static int drawText(Graphics g, String s, Rectangle rectangle, Font font, Color color, int i, int j) {
        return AwtUtil.drawText(g, s, rectangle, 0, font, color, i, j, 0, null);
    }

    public static int drawText(Graphics g, String s, Rectangle rectangle, int i, Font font, Color color, int j, int k, int l, String[] as) {
        FontMetrics fontmetrics;
        Font font1;
        Color color1;
        Graphics g1;
        if (s == null || s.length() == 0) {
            return 0;
        }
        Graphics graphics = g1 = g == null ? null : g.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (g1 != null) {
            color1 = g1.getColor();
            font1 = g1.getFont();
            if (font != null) {
                g1.setFont(font);
            }
            if (color != null) {
                g1.setColor(color);
            }
            fontmetrics = g1.getFontMetrics();
        } else {
            color1 = null;
            font1 = null;
            fontmetrics = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(new BufferedImage(1, 1, 1)).getFontMetrics(font);
        }
        int i1 = fontmetrics.getAscent();
        int j1 = 0;
        if ((j & 0x80) == 0) {
            int k1 = 1;
            if ((j & 0x1000) > 0 || (j & 0x2000) > 0) {
                int l1 = fontmetrics.stringWidth(s);
                k1 = (j & 0x2000) > 0 ? rectangle.width - l1 - 4 : (rectangle.width - l1) / 2;
            }
            int i2 = i1 - fontmetrics.getLeading();
            if ((j & 0x4000) > 0) {
                i2 = (rectangle.height + i1) / 2 - fontmetrics.getLeading();
            }
            if (g1 != null) {
                g1.drawString(s, k1, i2);
            }
            j1 = i1;
        } else {
            i1 += k;
            String[] as1 = Utilities.splitString(s, '\n');
            int j2 = 0;
            while (j2 < as1.length) {
                as1[j2] = Utilities.trimRight(as1[j2]);
                ++j2;
            }
            Vector<String> vector = new Vector<String>();
            int k2 = as1.length;
            int l2 = 0;
            while (l2 < k2) {
                if ((j & cellNonLinebackwind) != 0) {
                    vector.addElement(as1[l2]);
                } else {
                    AwtUtil.splitDrawText(as1[l2], rectangle.width - 2, i, fontmetrics, vector);
                }
                ++l2;
            }
            int i3 = (j & 0x4000) > 0 ? (rectangle.height - vector.size() * i1) / 2 + i1 - fontmetrics.getLeading() : i1 - fontmetrics.getLeading();
            int j3 = as != null ? -1 : 0;
            int k3 = 0;
            while (k3 < vector.size()) {
                String s1 = (String)vector.elementAt(k3);
                if (s1.length() > 0) {
                    int i4 = 1;
                    if ((j & 0x1000) > 0 || (j & 0x2000) > 0) {
                        int k4 = fontmetrics.stringWidth(s1);
                        i4 = (j & 0x2000) > 0 ? rectangle.width - k4 - 4 : (rectangle.width - k4) / 2;
                    }
                    if (g1 != null) {
                        g1.drawString(s1, i4, i3);
                    }
                }
                i3 += i1;
                if (j3 < 0 && k3 > 0 && (j1 += i1) > l) {
                    j3 = k3;
                }
                ++k3;
            }
            j1 += fontmetrics.getDescent();
            if (j3 > 0 && j3 < vector.size()) {
                int l3 = 0;
                while (l3 < j3) {
                    as[0] = as[0] == null ? "" : String.valueOf(as[0]) + 10;
                    as[0] = String.valueOf(as[0]) + (String)vector.elementAt(l3);
                    ++l3;
                }
                int j4 = j3;
                while (j4 < vector.size()) {
                    as[1] = as[1] == null ? "" : String.valueOf(as[1]) + 10;
                    as[1] = String.valueOf(as[1]) + (String)vector.elementAt(j4);
                    ++j4;
                }
            }
        }
        if (g1 != null) {
            g1.setFont(font1);
            g1.setColor(color1);
        }
        return j1;
    }

    public static final String treeToString(JTree jtree) {
        if (jtree != null) {
            DefaultTreeModel defaulttreemodel = (DefaultTreeModel)jtree.getModel();
            DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode)defaulttreemodel.getRoot();
            if (!jtree.isRootVisible()) {
                defaultmutabletreenode = defaultmutabletreenode.getChildCount() > 0 ? (DefaultMutableTreeNode)defaultmutabletreenode.getFirstChild() : null;
            }
            StringBuffer stringbuffer = new StringBuffer();
            while (defaultmutabletreenode != null) {
                AwtUtil.treeToString(0, defaultmutabletreenode, stringbuffer);
                defaultmutabletreenode = defaultmutabletreenode.getNextSibling();
            }
            return stringbuffer.toString();
        }
        return "";
    }

    public static final void treeToString(int i, DefaultMutableTreeNode defaultmutabletreenode, StringBuffer stringbuffer) {
        if (defaultmutabletreenode == null || stringbuffer == null) {
            return;
        }
        int j = 0;
        while (j < i) {
            stringbuffer.append('~');
            ++j;
        }
        stringbuffer.append(String.valueOf((String)defaultmutabletreenode.getUserObject()) + "//");
        DefaultMutableTreeNode defaultmutabletreenode1 = defaultmutabletreenode;
        if (!defaultmutabletreenode1.isLeaf()) {
            ++i;
            defaultmutabletreenode1 = (DefaultMutableTreeNode)defaultmutabletreenode1.getFirstChild();
            while (defaultmutabletreenode1 != null) {
                AwtUtil.treeToString(i, defaultmutabletreenode1, stringbuffer);
                defaultmutabletreenode1 = defaultmutabletreenode1.getNextSibling();
            }
        }
    }

    public static final void stringToTree(JTree jtree, String s) {
        DefaultTreeModel defaulttreemodel = (DefaultTreeModel)jtree.getModel();
        DefaultMutableTreeNode defaultmutabletreenode = new DefaultMutableTreeNode("Records");
        defaulttreemodel.setRoot(defaultmutabletreenode);
        jtree.setRootVisible(false);
        DefaultMutableTreeNode[] adefaultmutabletreenode = new DefaultMutableTreeNode[16];
        int i = 0;
        while (i < 16) {
            adefaultmutabletreenode[i] = null;
            ++i;
        }
        while (s.length() > 0) {
            String s1 = "";
            int j = s.indexOf("//");
            if (j >= 0) {
                s1 = s.substring(0, j);
                s = s.substring(j + 2);
            } else {
                s1 = s;
                s = "";
            }
            if (s1.length() == 0) continue;
            int k = 0;
            while (k < s1.length() && s1.charAt(k) == '~') {
                ++k;
            }
            DefaultMutableTreeNode defaultmutabletreenode1 = null;
            defaultmutabletreenode1 = k > 0 ? adefaultmutabletreenode[k - 1] : (DefaultMutableTreeNode)defaulttreemodel.getRoot();
            if (defaultmutabletreenode1 == null) continue;
            adefaultmutabletreenode[k] = new DefaultMutableTreeNode(s1.substring(k));
            defaultmutabletreenode1.add(adefaultmutabletreenode[k]);
        }
        defaulttreemodel.reload();
    }

    private static final Object[] findTreeValue(DefaultMutableTreeNode defaultmutabletreenode, String s) {
        return AwtUtil.findTreeValue(defaultmutabletreenode, s, false);
    }

    private static final Object[] findTreeValue(DefaultMutableTreeNode defaultmutabletreenode, String s, boolean flag) {
        String s1;
        if (defaultmutabletreenode == null) {
            return null;
        }
        if (!flag && Utilities.like(s1 = defaultmutabletreenode.getUserObject().toString(), s)) {
            return defaultmutabletreenode.getPath();
        }
        int i = defaultmutabletreenode.getChildCount();
        int j = 0;
        while (j < i) {
            Object[] aobj = AwtUtil.findTreeValue((DefaultMutableTreeNode)defaultmutabletreenode.getChildAt(j), s, false);
            if (aobj != null) {
                return aobj;
            }
            ++j;
        }
        return null;
    }

    public static final boolean expandTreeToValue(JTree jtree, String s) {
        Object[] aobj = AwtUtil.findTreeValue((DefaultMutableTreeNode)jtree.getModel().getRoot(), s);
        if (aobj != null) {
            TreePath treepath = new TreePath(aobj);
            jtree.setSelectionPath(treepath);
            jtree.scrollPathToVisible(treepath);
            return true;
        }
        return false;
    }

    private static final Object[] findTreeValueNext(JTree jtree, String s) {
        Object[] aobj1;
        int i;
        TreePath treepath = jtree.getSelectionPath();
        Object[] aobj = treepath.getPath();
        if (aobj == null || (i = aobj.length) == 0) {
            return null;
        }
        if (aobj[i - 1] instanceof DefaultMutableTreeNode && (aobj1 = AwtUtil.findTreeValue((DefaultMutableTreeNode)aobj[i - 1], s, true)) != null) {
            return aobj1;
        }
        int j = i - 1;
        while (j >= 0) {
            if (aobj[j] instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode)aobj[j];
                while ((defaultmutabletreenode = defaultmutabletreenode.getNextNode()) != null) {
                    Object[] aobj2 = AwtUtil.findTreeValue(defaultmutabletreenode, s);
                    if (aobj2 == null) continue;
                    return aobj2;
                }
            }
            --j;
        }
        return null;
    }

    public static final boolean expandTreeToValueNext(JTree jtree, String s) {
        Object[] aobj = AwtUtil.findTreeValueNext(jtree, s);
        if (aobj != null) {
            TreePath treepath = new TreePath(aobj);
            jtree.setSelectionPath(treepath);
            jtree.scrollPathToVisible(treepath);
            return true;
        }
        return false;
    }

    public static final JTree createCodeTree(JTree jtree, Enumeration enumeration, String s) {
        return AwtUtil.createCodeTree(jtree, enumeration, s, false);
    }

    public static final void setTreeLeafIcon(JTree jtree, String s) {
        TreeCellRenderer treecellrenderer = jtree.getCellRenderer();
        if (treecellrenderer instanceof DefaultTreeCellRenderer) {
            try {
                ImageIcon imageicon;
                if (s == null) {
                    s = "res/leaf.jpg";
                }
                if ((imageicon = Utilities.createImageIconFromResource(s)) != null) {
                    ((DefaultTreeCellRenderer)treecellrenderer).setLeafIcon(imageicon);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final JTree createCodeTree(JTree jtree, Enumeration enumeration, String s, boolean flag) {
        boolean flag1;
        if (jtree == null) {
            jtree = new JTree();
        }
        boolean bl = flag1 = s != null;
        if (s == null) {
            s = "[ROOT]";
        }
        jtree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(s)));
        TreeModel treemodel = jtree.getModel();
        AwtUtil.setTreeLeafIcon(jtree, null);
        jtree.setShowsRootHandles(true);
        DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode)treemodel.getRoot();
        defaultmutabletreenode.removeAllChildren();
        AwtUtil.addTreeNode(defaultmutabletreenode, enumeration, "", null, flag);
        if (!flag1) {
            jtree.expandPath(new TreePath(defaultmutabletreenode));
            jtree.setRootVisible(false);
        }
        return jtree;
    }

    private static void addTreeNodex(DefaultMutableTreeNode defaultmutabletreenode, Enumeration enumeration, String s, Object[] aobj, boolean flag) {
        int i = 0;
        Object wcode = null;
        DefaultMutableTreeNode famodel = null;
        try {
            while (enumeration.hasMoreElements()) {
                String s2;
                Object[] aobj1 = (Object[])enumeration.nextElement();
                if (String.valueOf(aobj1[3]).trim().length() <= 0) continue;
                Object wname = JDBC.sqlSelect1(LoginDialog.connectionx, "select wname from wcode where wcode ='" + aobj1[3] + "'");
                if (wcode != null && !wcode.equals(aobj1[3])) {
                    i = 0;
                }
                if (i == 0) {
                    wcode = aobj1[3];
                    DefaultMutableTreeNode defaultmutabletreenode1 = new DefaultMutableTreeNode(wname);
                    defaultmutabletreenode.add(defaultmutabletreenode1);
                    famodel = defaultmutabletreenode1;
                }
                if (!wcode.equals(aobj1[3])) continue;
                String s1 = aobj1[0].toString();
                String string = s2 = aobj1[1] != null ? aobj1[1].toString().trim() : "";
                String s3 = s2.length() != 0 ? (flag ? s2 : String.valueOf(s1) + ':' + s2) : s1;
                Object obj = aobj1.length < 3 ? null : aobj1[2];
                Object obj1 = obj != null ? new ValueText(s3, obj) : s3;
                DefaultMutableTreeNode defaultmutabletreenode2 = new DefaultMutableTreeNode(obj1);
                famodel.add(defaultmutabletreenode2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addTreeNode(DefaultMutableTreeNode defaultmutabletreenode, Enumeration enumeration, String s, Object[] aobj, boolean flag) {
        int i = s.length();
        while (enumeration.hasMoreElements()) {
            Object[] aobj1 = (Object[])enumeration.nextElement();
            if (aobj1 == null || aobj1[0] == null) continue;
            String s1 = aobj1[0].toString();
            String s2 = aobj1[1] != null ? aobj1[1].toString().trim() : "";
            Object obj = aobj1.length < 3 ? null : aobj1[2];
            while (s1.length() > i && s1.startsWith(s)) {
                String s3 = s2.length() != 0 ? (flag ? s2 : String.valueOf(s1) + ':' + s2) : s1;
                Object obj1 = obj != null ? new ValueText(s3, obj) : s3;
                DefaultMutableTreeNode defaultmutabletreenode1 = new DefaultMutableTreeNode(obj1);
                defaultmutabletreenode.add(defaultmutabletreenode1);
                Object[] aobj2 = new Object[3];
                AwtUtil.addTreeNode(defaultmutabletreenode1, enumeration, s1, aobj2, flag);
                s1 = (String)aobj2[0];
                s2 = (String)aobj2[1];
                obj = aobj2[2];
                if (s1 == null) break;
            }
            if (aobj == null) break;
            aobj[0] = s1;
            aobj[1] = s2;
            aobj[2] = obj;
            break;
        }
    }

    public static final JTree createCodeTreeFromSql(JTree jtree, Connection connection, String s, String s1) throws SQLException {
        Object[][] aobj = JDBC.sqlSelect3(connection, s);
        treeobj = aobj;
        return AwtUtil.createCodeTree(jtree, new ArrayEnumeration((Object[])aobj), s1);
    }

    public static final void selectWindowInputMethodToUS(Window window) {
        if (window != null) {
            try {
                InputContext inputcontext = window.getInputContext();
                if (inputcontext != null) {
                    inputcontext.selectInputMethod(Locale.US);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Icon[] createSortToggleCheckBoxIcons() throws IOException {
        Icon[] aicon = new Icon[]{Utilities.createImageIconFromResource("res/icon_checknone.jpg"), Utilities.createImageIconFromResource("res/icon_checkup.jpg"), Utilities.createImageIconFromResource("res/icon_checkdown.jpg")};
        return aicon;
    }

    public static Component[] getComponentParentPath(Component component) {
        Vector<Component> vector = new Vector<Component>();
        while (component != null) {
            vector.addElement(component);
            component = component.getParent();
        }
        Component[] acomponent = new Component[vector.size()];
        vector.toArray(acomponent);
        return acomponent;
    }

    public static Component removeFromTabParent(Component component) {
        while (component != null) {
            Container container = component.getParent();
            if (container instanceof JTabbedPane) {
                ((JTabbedPane)container).remove(component);
                return component;
            }
            component = container;
        }
        return null;
    }

    public static void paintImage(Graphics g, ImageIcon imageicon, int i, int j, int k, int l, int i1) {
        if (imageicon == null) {
            return;
        }
        if (i1 == 0) {
            int j1 = imageicon.getIconWidth();
            int l1 = imageicon.getIconHeight();
            g.drawImage(imageicon.getImage(), i + (k - j1) / 2, j + (l - l1) / 2, null);
        } else if (i1 == 1) {
            g.drawImage(imageicon.getImage(), i, j, k, l, null);
        } else {
            int k1 = imageicon.getIconWidth();
            int i2 = imageicon.getIconHeight();
            if (k1 <= 0 || i2 <= 0) {
                return;
            }
            Image image = imageicon.getImage();
            int j2 = 0;
            while (j2 < k) {
                int k2 = 0;
                while (k2 < l) {
                    g.drawImage(image, j2, k2, null);
                    k2 += i2;
                }
                j2 += k1;
            }
        }
    }

    public static void paintImage(Graphics g, ImageIcon imageicon, int i, int j, Dimension dimension, int k) {
        if (dimension == null) {
            return;
        }
        AwtUtil.paintImage(g, imageicon, i, j, dimension.width, dimension.height, k);
    }

    public static int getVisibleComponent(JPanel jpanel, boolean flag) {
        int i = jpanel.getComponentCount();
        if (i == 0) {
            return 0;
        }
        int j = 0;
        int k = 0;
        while (k < i) {
            if (jpanel.getComponent(k).isVisible()) {
                ++j;
                if (!flag) {
                    return j;
                }
            }
            ++k;
        }
        return j;
    }

    public static void setChildWndOpaque(Container container, boolean flag) {
        if (container instanceof JPanel || container instanceof JScrollPane || container instanceof JCheckBox || container instanceof JRadioButton || container instanceof JViewport) {
            ((JComponent)container).setOpaque(flag);
        }
        int i = container.getComponentCount();
        int j = 0;
        while (j < i) {
            Component component = container.getComponent(j);
            if (component instanceof Container) {
                AwtUtil.setChildWndOpaque((Container)component, flag);
            }
            ++j;
        }
    }
}

