/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import softcore.awt.DialogPanel;
import softcore.awt.FilePreviewer;
import softcore.awt.ImgFileView;
import softcore.awt.MutilineTextAidInputer;
import softcore.util.FileNameChooser;
import softcore.util.FileNameLikeFileFilter;
import softcore.util.Message;
import softcore.util.Utilities;
import softcore.win.MSWordApp;
import softface.MainApp;
import softface.MainFrame;

public class ExtObject {
    public static final int DATA_NULL = 0;
    public static final int DATA_MSWORD = 1;
    public static final int DATA_IMAGE = 2;
    public static final int DATA_UNKNOWN = 3;
    public static final int DATA_IMAGE2 = 4;
    public static final int DATA_EXCEL = 5;
    public static final int DATA_MS = 6;
    public static final int HEADERLEN = 8;
    public static final int INT_BYTENUM = 1;
    private int dataType;
    public byte[] m_datas;
    private int[][] pixelsData;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private short bandNum;
    private int objectType;
    private Image m_img;
    private boolean m_bReadOnly;
    private static String szWordExePath = null;
    private boolean m_bChanged;

    public ExtObject(int i) {
        this.close();
        this.objectType = i;
    }

    public ExtObject() {
        this.close();
        this.objectType = 0;
    }

    public void setObjectType(int i) {
        this.objectType = i;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public byte[] getData() {
        return this.m_datas;
    }

    public void setReadOnly(boolean flag) {
        this.m_bReadOnly = flag;
    }

    public void draw(Graphics g, Rectangle rectangle) {
        if (this.dataType == 1) {
            String s;
            String string = s = this.m_datas != null ? "[WORD\u6587\u6863]" : "";
            if (s != null && s.length() > 0) {
                g.drawString(s, rectangle.x, rectangle.y + 16);
            }
        } else if (this.dataType == 5) {
            String s1;
            String string = s1 = this.m_datas != null ? "[EXCEL\u6587\u6863]" : "";
            if (s1 != null && s1.length() > 0) {
                g.drawString(s1, rectangle.x, rectangle.y + 16);
            }
        } else if (this.dataType == 8) {
            String s1;
            String string = s1 = this.m_datas != null ? "[PDF\u6587\u6863]" : "";
            if (s1 != null && s1.length() > 0) {
                g.drawString(s1, rectangle.x, rectangle.y + 16);
            }
        } else if ((this.dataType == 2 || this.dataType == 4) && this.m_img != null) {
            g.drawImage(this.m_img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else if (this.dataType == 9) {
            String s1;
            String string = s1 = this.m_datas != null ? "[IE\u5730\u5740]" : "";
            if (s1 != null && s1.length() > 0) {
                g.drawString(s1, rectangle.x, rectangle.y + 16);
            }
        }
    }

    public boolean isChanged() {
        return this.m_bChanged;
    }

    public void setChanged(boolean flag) {
        this.m_bChanged = flag;
    }

    public int getWidth() {
        return this.imgWidth;
    }

    public int getHeight() {
        return this.imgHeight;
    }

    public static int getDataType(Object obj) {
        byte[] abyte0;
        if (obj instanceof byte[] && ((byte[])obj).length >= 8) {
            abyte0 = (byte[])obj;
        } else if (obj instanceof InputStream) {
            try {
                InputStream inputstream = (InputStream)obj;
                inputstream.reset();
                abyte0 = new byte[8];
                new DataInputStream((InputStream)obj).readFully(abyte0);
            }
            catch (Throwable throwable) {
                return 0;
            }
        } else {
            return 0;
        }
        return ExtObject.stringToType(new String(abyte0, 0, 8));
    }

    public void fromObject(Object obj) {
        this.dataType = 0;
        this.m_datas = null;
        this.m_img = null;
        if (obj == null || !(obj instanceof byte[]) && !(obj instanceof InputStream)) {
            return;
        }
        byte[] abyte0 = null;
        if (obj instanceof byte[]) {
            abyte0 = (byte[])obj;
        } else {
            try {
                InputStream inputstream = (InputStream)obj;
                inputstream.reset();
                abyte0 = new byte[inputstream.available()];
                inputstream.read(abyte0);
            }
            catch (Exception exception) {
                Message.printException(exception, MainApp.isDebug);
            }
        }
        if (abyte0.length <= 8) {
            return;
        }
        String s = new String(abyte0, 0, 8);
        this.dataType = ExtObject.stringToType(s);
        if (this.dataType == 2) {
            this.m_datas = new byte[abyte0.length - 8 - 10];
            this.bandNum = 0;
            this.imgHeight = 0;
            this.imgWidth = 0;
            int i = 0;
            while (i < 4) {
                int j = abyte0[8 + i];
                if (j < 0) {
                    j += 256;
                }
                this.imgWidth += j << 8 * i;
                ++i;
            }
            int k = 0;
            while (k < 4) {
                int l = abyte0[12 + k];
                if (l < 0) {
                    l += 256;
                }
                this.imgHeight += l << 8 * k;
                ++k;
            }
            int i1 = 0;
            while (i1 < 2) {
                int j1 = abyte0[16 + i1];
                if (j1 < 0) {
                    j1 += 256;
                }
                this.bandNum = (short)(this.bandNum + (j1 << 8 * i1));
                ++i1;
            }
            System.arraycopy(abyte0, 18, this.m_datas, 0, this.m_datas.length);
            this.byteToIntArray(true);
        } else {
            this.m_datas = new byte[abyte0.length - 8];
            System.arraycopy(abyte0, 8, this.m_datas, 0, this.m_datas.length);
        }
    }

    public Object toStoreObject() {
        if (this.isNull()) {
            return null;
        }
        String s = this.typeToString(this.dataType);
        byte[] abyte0 = s.getBytes();
        int i = abyte0.length;
        byte[] abyte1 = new byte[i + this.m_datas.length + (this.dataType != 2 && this.dataType != 8 && this.dataType != 9 ? 0 : 10)];
        System.arraycopy(abyte0, 0, abyte1, 0, i);
        if (this.dataType == 1 || this.dataType == 4 || this.dataType == 5) {
            System.arraycopy(this.m_datas, 0, abyte1, i, this.m_datas.length);
        } else {
            int j = this.imgWidth;
            int k = 0;
            while (k < 4) {
                int l = j % 256;
                abyte1[i + k] = (byte)l;
                j = (j - l) / 256;
                ++k;
            }
            j = this.imgHeight;
            int i1 = 0;
            while (i1 < 4) {
                int j1 = j % 256;
                abyte1[i + 4 + i1] = (byte)j1;
                j = (j - j1) / 256;
                ++i1;
            }
            j = this.bandNum;
            int k1 = 0;
            while (k1 < 2) {
                int l1 = j % 256;
                abyte1[i + 8 + k1] = (byte)l1;
                j = (j - l1) / 256;
                ++k1;
            }
            System.arraycopy(this.m_datas, 0, abyte1, i + 10, this.m_datas.length);
        }
        return abyte1;
    }

    private void byteToIntArray(boolean flag) {
        int i = this.imgWidth * this.bandNum;
        if (flag) {
            this.pixelsData = new int[this.imgHeight][i];
            int j = 0;
            while (j < this.imgHeight) {
                int l = 0;
                while (l < i) {
                    int j1 = 0;
                    while (j1 < 1) {
                        int l1 = this.m_datas[(j * i + l) * 1 + j1];
                        if (l1 < 0) {
                            l1 += 256;
                        }
                        int[] nArray = this.pixelsData[j];
                        int n = l;
                        nArray[n] = nArray[n] + (l1 << 8 * j1);
                        ++j1;
                    }
                    ++l;
                }
                ++j;
            }
        } else {
            this.m_datas = new byte[i * this.imgHeight * 1];
            int k = 0;
            while (k < this.imgHeight) {
                int i1 = 0;
                while (i1 < i) {
                    int k1 = this.pixelsData[k][i1];
                    int i2 = 0;
                    while (i2 < 1) {
                        int j2 = k1 % 256;
                        this.m_datas[(i * k + i1) * 1 + i2] = (byte)j2;
                        k1 = (k1 - j2) / 256;
                        ++i2;
                    }
                    ++i1;
                }
                ++k;
            }
        }
    }

    private static int stringToType(String s) {
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).equalsIgnoreCase("msword")) {
            return 1;
        }
        if (s.equalsIgnoreCase("excel")) {
            return 5;
        }
        if (s.equalsIgnoreCase("image")) {
            return 2;
        }
        if (s.equalsIgnoreCase("pdf")) {
            return 8;
        }
        if (s.equalsIgnoreCase("ie")) {
            return 9;
        }
        return !s.equalsIgnoreCase("image2") ? 3 : 4;
    }

    private String typeToString(int i) {
        String s = null;
        switch (i) {
            case 2: {
                s = "IMAGE";
                break;
            }
            case 4: {
                s = "IMAGE2";
                break;
            }
            case 1: {
                s = "MSWORD";
                break;
            }
            case 5: {
                s = "EXCEL";
                break;
            }
            case 8: {
                s = "PDF";
                break;
            }
            case 9: {
                s = "IE";
                break;
            }
            default: {
                s = "UNKNOWN";
            }
        }
        int j = s.length() + 1;
        while (j <= 8) {
            s = String.valueOf(s) + ' ';
            ++j;
        }
        return s;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean fromFile(String s, int i) {
        this.m_datas = null;
        this.m_img = null;
        try {
            if (i == 1 || i == 4 || i == 5 || i == 8) {
                File file = new File(s);
                FileInputStream fileinputstream = new FileInputStream(file);
                int j = (int)file.length();
                this.m_datas = new byte[j];
                fileinputstream.read(this.m_datas);
                fileinputstream.close();
                this.dataType = i;
            } else if (i == 9) {
                this.m_datas = new byte[1024];
                this.m_datas = s.getBytes();
                this.dataType = i;
            } else if (i == 2) {
                ImageIcon imageicon = new ImageIcon(s);
                if (imageicon == null) {
                    // empty if block
                }
                boolean flag = false;
                int k = 0;
                while (k < 2) {
                    this.imgWidth = imageicon.getIconWidth();
                    this.imgHeight = imageicon.getIconHeight();
                    if (this.imgWidth > 0 && this.imgHeight > 0) {
                        BufferedImage bufferedimage = new BufferedImage(this.imgWidth, this.imgHeight, 1);
                        Graphics2D graphics2d = bufferedimage.createGraphics();
                        graphics2d.drawImage(imageicon.getImage(), 0, 0, Color.white, null);
                        WritableRaster writableraster = bufferedimage.getRaster();
                        this.bandNum = (short)writableraster.getNumBands();
                        if (this.bandNum < 1) {
                            this.bandNum = 1;
                        }
                        int l = this.imgWidth * this.bandNum;
                        this.pixelsData = new int[this.imgHeight][l];
                        int[] ai = null;
                        int i1 = 0;
                        while (i1 < this.imgHeight) {
                            ai = writableraster.getPixels(0, i1, this.imgWidth, 1, ai);
                            int j1 = 0;
                            while (j1 < l && j1 < ai.length) {
                                this.pixelsData[i1][j1] = ai[j1];
                                if (ai[j1] >= 256) {
                                    i = 0;
                                    Message.out.println("\u4e0d\u80fd\u8bc6\u522b\u7684\u56fe\u8c61!");
                                    return false;
                                }
                                ++j1;
                            }
                            ++i1;
                        }
                        break;
                    }
                    ++k;
                }
                this.dataType = i;
                this.byteToIntArray(false);
            }
            this.m_bChanged = true;
            return true;
        }
        catch (Exception exception) {
            Message.showErrorDialog("\u9519\u8bef", exception.getMessage());
            this.close();
            return false;
        }
    }

    public void saveAsFile(String s) {
        if (this.m_datas == null || this.m_datas.length == 0) {
            return;
        }
        if (this.dataType == 1 || this.dataType == 5) {
            try {
                File file = new File(s);
                if (!file.exists() || Message.showQuestionDialog("\u63d0\u793a", "\u6587\u4ef6" + s + "\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6?") == 0) {
                    FileOutputStream fileoutputstream = new FileOutputStream(s);
                    fileoutputstream.write(this.m_datas);
                    fileoutputstream.close();
                }
            }
            catch (Exception exception) {
                Message.showErrorDialog("\u9519\u8bef", exception.getMessage());
            }
        }
    }

    public boolean isNull() {
        return this.dataType == 0 || this.dataType == 3 || this.m_datas == null;
    }

    public ImageIcon toImageIcon() {
        Image image = this.getImage();
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public Image getImage() {
        if (this.m_img != null) {
            return this.m_img;
        }
        this.m_img = this.toImage();
        return this.m_img;
    }

    public Image toImage() {
        if (this.dataType == 4) {
            if (this.m_datas == null) {
                return null;
            }
            try {
                return Utilities.createImageFromInputStream(new ByteArrayInputStream(this.m_datas));
            }
            catch (Exception exception) {
                Message.printException(exception, true);
                return null;
            }
        }
        if (this.pixelsData != null && this.m_datas != null && this.dataType == 2) {
            DirectColorModel directcolormodel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
            WritableRaster writableraster = directcolormodel.createCompatibleWritableRaster(this.imgWidth, this.imgHeight);
            int i = 0;
            while (i < this.imgHeight) {
                writableraster.setPixels(0, i, this.imgWidth, 1, this.pixelsData[i]);
                ++i;
            }
            BufferedImage bufferedimage = new BufferedImage(directcolormodel, writableraster, false, null);
            return bufferedimage;
        }
        return null;
    }

    public static String getIncFileName(String s, String s1, String s2) {
        if (s1 == null || s2 == null) {
            return null;
        }
        File file = new File(s);
        String[] as = file.list();
        if (as == null) {
            return null;
        }
        int i = s1.length();
        int j = -1;
        int k = 0;
        while (k < as.length) {
            int l = as[k].indexOf(46);
            if (l > 0) {
                int j1;
                String s5;
                int i1;
                String s3 = as[k].substring(0, l);
                String s4 = as[k].substring(l + 1);
                if (s4.equalsIgnoreCase(s2) && (i1 = s3.length()) > i && (s5 = s3.substring(0, i)).equalsIgnoreCase(s1) && (j1 = Integer.parseInt(s3.substring(i))) > j) {
                    j = j1;
                }
            }
            ++k;
        }
        return String.valueOf(s) + s1 + String.valueOf(j + 1) + "." + s2;
    }

    public void browseExtObject() {
        if (this.dataType == 1) {
            try {
                String s = "c:/temp/";
                File file = new File(s);
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                String s2 = null;
                int i = 0;
                while (i < 100) {
                    s2 = String.valueOf(s) + "H9WORD_" + (i >= 10 ? "" : "0") + i + ".DOC";
                    try {
                        FileOutputStream fileoutputstream = new FileOutputStream(s2);
                        if (this.m_datas != null) {
                            fileoutputstream.write(this.m_datas);
                        }
                        fileoutputstream.close();
                        break;
                    }
                    catch (Exception exception2) {
                        ++i;
                    }
                }
                MSWordApp mswordapp = new MSWordApp(true);
                mswordapp.openDocument(s2, false);
            }
            catch (Exception exception) {
                exception.printStackTrace(Message.out);
            }
        } else if (this.dataType == 5) {
            try {
                String s1 = "c:/temp/";
                File file1 = new File(s1);
                if (!file1.isDirectory()) {
                    file1.mkdir();
                }
                String s3 = null;
                int j = 0;
                while (j < 100) {
                    s3 = String.valueOf(s1) + "H9EXCEL_" + (j >= 10 ? "" : "0") + j + ".xls";
                    try {
                        FileOutputStream fileoutputstream1 = new FileOutputStream(s3);
                        if (this.m_datas != null) {
                            fileoutputstream1.write(this.m_datas);
                        }
                        fileoutputstream1.close();
                        break;
                    }
                    catch (Exception exception3) {
                        ++j;
                    }
                }
                String s4 = "rundll32 url.dll,FileProtocolHandler \"" + new File(s3).getAbsolutePath() + "\"";
                System.out.println(s4);
                Process process = Runtime.getRuntime().exec(s4);
            }
            catch (Exception exception1) {
                exception1.printStackTrace(Message.out);
            }
        } else if (this.dataType == 8) {
            try {
                String s1 = "c:/temp/";
                File file1 = new File(s1);
                if (!file1.isDirectory()) {
                    file1.mkdir();
                }
                String s3 = null;
                int j = 0;
                while (j < 100) {
                    s3 = String.valueOf(s1) + "H9PDF_" + (j >= 10 ? "" : "0") + j + ".pdf";
                    try {
                        FileOutputStream fileoutputstream1 = new FileOutputStream(s3);
                        if (this.m_datas != null) {
                            fileoutputstream1.write(this.m_datas);
                        }
                        fileoutputstream1.close();
                        break;
                    }
                    catch (Exception exception3) {
                        ++j;
                    }
                }
                String s4 = "rundll32 url.dll,FileProtocolHandler \"" + new File(s3).getAbsolutePath() + "\"";
                System.out.println(s4);
                Process process = Runtime.getRuntime().exec(s4);
            }
            catch (Exception exception1) {
                exception1.printStackTrace(Message.out);
            }
        } else if (this.dataType == 9) {
            try {
                String ss;
                String string = ss = this.m_datas != null ? new String(this.m_datas) : "";
                if (ss == "") {
                    return;
                }
                String[] sss = Utilities.splitString(ss, '|');
                String s1 = sss[0].substring(10, sss[0].length());
                this.m_datas = ss.getBytes();
                Runtime.getRuntime().exec("explorer http://" + s1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.dataType == 2 || this.dataType == 4) {
            if (this.isNull()) {
                return;
            }
            ImageIcon imageicon = this.toImageIcon();
            if (imageicon == null) {
                return;
            }
            DialogPanel dialogpanel = new DialogPanel();
            dialogpanel.nPosInsetY = 10;
            dialogpanel.nPosInsetX = 10;
            dialogpanel.setLayout(new GridBagLayout());
            DialogPanel.initGBC();
            DialogPanel.gbc.weighty = 1.0;
            DialogPanel.gbc.weightx = 1.0;
            DialogPanel.gbc.fill = 1;
            JLabel jlabel = new JLabel(imageicon);
            int k = imageicon.getIconWidth() + 10;
            int l = imageicon.getIconHeight() + 10;
            if (k < 200) {
                k = 200;
            }
            if (l < 160) {
                l = 160;
            }
            jlabel.setPreferredSize(new Dimension(k, l));
            jlabel.setBorder(BorderFactory.createTitledBorder(""));
            dialogpanel.add((Component)jlabel, DialogPanel.gbc);
            String s5 = "\u5bbd\u5ea6:" + imageicon.getIconWidth() + "  \u9ad8\u5ea6:" + imageicon.getIconHeight();
            DialogPanel.gbc.gridwidth = 1;
            DialogPanel.gbc.gridy = 1;
            DialogPanel.gbc.weighty = 0.0;
            DialogPanel.gbc.weightx = 0.0;
            DialogPanel.gbc.fill = 0;
            dialogpanel.add((Component)new JLabel(s5), DialogPanel.gbc);
            dialogpanel.showDialog("\u6d4f\u89c8\u56fe\u8c61");
        }
    }

    public boolean selectExtObject(Component component, String s) {
        String s1 = null;
        if (this.objectType == 1) {
            File file;
            FileNameChooser filenamechooser = new FileNameChooser();
            filenamechooser.setFileFilter(new FileNameLikeFileFilter("*.doc"));
            filenamechooser.setDialogType(0);
            if (s != null) {
                filenamechooser.setCurrentDirectory(new File(s));
            }
            if (filenamechooser.showDialog(component, "\u6253\u5f00") == 0 && (file = filenamechooser.getSelectedFile()) != null && file.canRead()) {
                s1 = file.getAbsolutePath();
            }
        } else if (this.objectType == 6) {
            File file1;
            FileNameChooser filenamechooser1 = new FileNameChooser();
            filenamechooser1.setFileFilter(new FileNameLikeFileFilter("*.doc,*.xls"));
            filenamechooser1.setDialogType(0);
            if (s != null) {
                filenamechooser1.setCurrentDirectory(new File(s));
            }
            if (filenamechooser1.showDialog(component, "\u6253\u5f00") == 0 && (file1 = filenamechooser1.getSelectedFile()) != null && file1.canRead()) {
                s1 = file1.getAbsolutePath();
                String s2 = s1.toLowerCase();
                if (s2.endsWith(".doc")) {
                    return this.fromFile(s1, 1);
                }
                if (s2.endsWith(".xls")) {
                    return this.fromFile(s1, 5);
                }
                return false;
            }
        } else if (this.objectType == 2 || this.objectType == 4) {
            s1 = ExtObject.openImgDialog(component, s);
        } else if (this.objectType == 8) {
            File file1;
            FileNameChooser filenamechooser1 = new FileNameChooser();
            filenamechooser1.setFileFilter(new FileNameLikeFileFilter("*.pdf"));
            filenamechooser1.setDialogType(0);
            if (s != null) {
                filenamechooser1.setCurrentDirectory(new File(s));
            }
            if (filenamechooser1.showDialog(component, "\u6253\u5f00") == 0 && (file1 = filenamechooser1.getSelectedFile()) != null && file1.canRead()) {
                s1 = file1.getAbsolutePath();
                String s2 = s1.toLowerCase();
                if (s2.endsWith(".pdf")) {
                    return this.fromFile(s1, 8);
                }
                return false;
            }
        } else if (this.objectType == 9) {
            String ss;
            MutilineTextAidInputer text = new MutilineTextAidInputer("\u5730\u5740");
            String string = ss = this.m_datas != null ? new String(this.m_datas) : "";
            if (ss != "") {
                ss = ss.substring(10, ss.length());
                this.m_datas = ss.getBytes();
            }
            if (text.doAidInput(MainFrame.getMainAppFrame(), ss, 0) != null) {
                s1 = text.getTextArea().getText();
                return this.fromFile(s1, 9);
            }
            return false;
        }
        if (s1 != null) {
            return this.fromFile(s1, this.objectType);
        }
        return false;
    }

    public static String openImgDialog(Component component, String s) {
        try {
            File file;
            int i;
            JFileChooser jfilechooser = new JFileChooser();
            FileNameLikeFileFilter filenamelikefilefilter = new FileNameLikeFileFilter("*.jpg,*.gif");
            ImgFileView imgfileview = new ImgFileView();
            try {
                ImageIcon imageicon = Utilities.createImageIconFromResource("res/jpgflag.jpg");
                ImageIcon imageicon1 = Utilities.createImageIconFromResource("res/gifflag.jpg");
                if (imageicon != null) {
                    imgfileview.putIcon("jpg", imageicon);
                }
                if (imageicon1 != null) {
                    imgfileview.putIcon("gif", imageicon1);
                }
            }
            catch (Exception imageicon) {
                // empty catch block
            }
            jfilechooser.setFileView(imgfileview);
            jfilechooser.addChoosableFileFilter(filenamelikefilefilter);
            jfilechooser.setFileFilter(filenamelikefilefilter);
            jfilechooser.setAccessory(new FilePreviewer(jfilechooser));
            if (s != null) {
                jfilechooser.setCurrentDirectory(new File(s));
            }
            if ((i = jfilechooser.showOpenDialog(component)) == 0 && (file = jfilechooser.getSelectedFile()) != null) {
                return file.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            Message.showErrorDialog("\u9519\u8bef", exception.getMessage());
        }
        return null;
    }

    public void close() {
        this.dataType = 0;
        this.imgHeight = 0;
        this.imgWidth = 0;
        this.bandNum = 0;
        this.m_datas = null;
        this.pixelsData = null;
        this.m_img = null;
        this.m_bReadOnly = false;
        this.m_bChanged = false;
    }

    public static void test() {
        ExtObject snextobject = new ExtObject(1);
        snextobject.selectExtObject(null, "c:/data_set/data/");
        ExtObject snextobject1 = new ExtObject(1);
        snextobject1.fromObject(snextobject.toStoreObject());
        snextobject.browseExtObject();
    }
}

