/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class FilePreviewer
extends JComponent
implements PropertyChangeListener {
    ImageIcon imgIcon = null;
    File f = null;
    private int imgWidth;
    private int imgHeight;

    public FilePreviewer(JFileChooser jfilechooser) {
        this.setPreferredSize(new Dimension(104, 100));
        jfilechooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.f != null) {
            ImageIcon imageicon = new ImageIcon(this.f.getPath());
            this.imgWidth = imageicon.getIconWidth();
            this.imgHeight = imageicon.getIconHeight();
            this.imgIcon = imageicon.getIconWidth() > 90 ? new ImageIcon(imageicon.getImage().getScaledInstance(90, -1, 1)) : imageicon;
        }
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        String s = propertychangeevent.getPropertyName();
        if (s == "SelectedFileChangedProperty") {
            this.f = (File)propertychangeevent.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.imgIcon == null) {
            this.loadImage();
        }
        if (this.imgIcon != null) {
            int i = this.imgIcon.getIconWidth();
            int j = this.imgIcon.getIconHeight();
            int k = this.getWidth() / 2 - i / 2;
            int l = (this.getHeight() - 17) / 2 - j / 2;
            if (l < 0) {
                l = 0;
            }
            if (k < 5) {
                k = 5;
            }
            this.imgIcon.paintIcon(this, g, k, l);
            FontMetrics fontmetrics = g.getFontMetrics();
            String s = "\u5bbd:" + this.imgWidth + "\u9ad8:" + this.imgHeight;
            i = fontmetrics.stringWidth(s);
            k = this.getWidth() / 2 - i / 2;
            if (k < 5) {
                k = 5;
            }
            g.drawString(s, k, this.getHeight() - 1);
        }
    }
}

