/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicArrowButton;
import softcore.util.AidInputer;
import softcore.util.Message;
import softoperation.ERPTrade.CodeDialog;

public class JTextFieldA
extends JTextField
implements LayoutManager,
Serializable,
KeyListener,
ActionListener {
    protected JButton northButton = null;
    protected JButton southButton = null;
    protected boolean bSpinWrap = true;
    protected int minSpinValue = 0;
    protected int maxSpinValue = 0;
    protected AidInputer aidInputer = null;
    boolean showNameOnly;
    public String text;
    boolean replaceSelectionMode;

    public void setLayout(LayoutManager layoutmanager) {
    }

    public JTextFieldA(int i, AidInputer aidinputer) {
        this(null, 0, i, aidinputer);
    }

    public JTextFieldA(AidInputer aidinputer) {
        this(null, 0, 1, aidinputer);
    }

    public JTextFieldA(String s, int i, int j, AidInputer aidinputer) {
        super(s, i);
        try {
            this.setAidArrowType(j);
            this.aidInputer = aidinputer;
            super.setLayout(this);
            this.addKeyListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace(Message.out);
        }
    }

    public JTextFieldA() {
        this(3, null);
    }

    protected void incIntValue(int i) {
        if (this.maxSpinValue <= this.minSpinValue) {
            return;
        }
        try {
            String s = this.getText().trim();
            int j = 0;
            if (s.length() > 0) {
                try {
                    j = Integer.parseInt(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((j += i) < this.minSpinValue || j > this.maxSpinValue) {
                if (!this.bSpinWrap) {
                    return;
                }
                j = j >= this.minSpinValue ? this.minSpinValue : this.maxSpinValue;
            }
            this.setText(Integer.toString(j));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setShowNameOnly(boolean flag) {
        this.showNameOnly = flag;
    }

    public void setReplaceSelectionMode(boolean flag) {
        this.replaceSelectionMode = flag;
    }

    public void actionPerformed(ActionEvent actionevent) {
        this.requestFocus();
        if (actionevent.getSource() == this.northButton) {
            this.incIntValue(1);
        } else if (actionevent.getSource() == this.southButton) {
            if (this.aidInputer != null) {
                String s = this.aidInputer.doAidInput(this, this.getText(), 0);
                if (this.aidInputer instanceof CodeDialog) {
                    this.text = s;
                }
                if (s != null) {
                    int i;
                    if (this.showNameOnly && (i = s.indexOf(58)) >= 0) {
                        this.text = s;
                        s = s.substring(i + 1);
                    }
                    if (this.replaceSelectionMode) {
                        super.replaceSelection(s);
                    } else {
                        super.setText(s);
                    }
                }
            } else {
                this.incIntValue(-1);
            }
        }
    }

    public String getText() {
        return this.text != null ? this.text : super.getText();
    }

    public String getTextA() {
        return super.getText();
    }

    public int getAidArrowType() {
        return (this.southButton == null ? 0 : 1) | (this.northButton == null ? 0 : 2);
    }

    public void setAidArrowType(int i) {
        int j = this.getAidArrowType();
        if (j == i) {
            return;
        }
        if ((i & 1) == 0 && this.southButton != null) {
            this.remove(this.southButton);
            this.southButton = null;
        }
        if ((i & 2) == 0 && this.northButton != null) {
            this.remove(this.northButton);
            this.northButton = null;
        }
        if ((i & 1) != 0 && this.southButton == null) {
            this.southButton = new BasicArrowButton(5);
            this.southButton.addActionListener(this);
            this.southButton.setEnabled(this.isEnabled());
            this.southButton.setCursor(Cursor.getPredefinedCursor(0));
            this.add(this.southButton);
            this.southButton.setForeground(Color.blue);
        }
        if ((i & 2) != 0 && this.northButton == null) {
            this.northButton = new BasicArrowButton(1);
            this.northButton.setCursor(Cursor.getPredefinedCursor(0));
            this.northButton.addActionListener(this);
            this.northButton.setEnabled(this.isEnabled());
            this.add(this.northButton);
        }
        this.invalidate();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (this.southButton != null) {
            this.southButton.setEnabled(flag);
        }
        if (this.northButton != null) {
            this.northButton.setEnabled(flag);
        }
    }

    public boolean isSpinWrap() {
        return this.bSpinWrap;
    }

    public void setSpinWrap(boolean flag) {
        this.bSpinWrap = flag;
    }

    public int getMinSpinValue() {
        return this.minSpinValue;
    }

    public int getMaxSpinValue() {
        return this.maxSpinValue;
    }

    public void setMinSpinValue(int i) {
        this.minSpinValue = i;
    }

    public void setMaxSpinValue(int i) {
        this.maxSpinValue = i;
    }

    public void setSpinRange(int i, int j) {
        this.minSpinValue = i;
        this.maxSpinValue = j;
    }

    public AidInputer getAidInputer() {
        return this.aidInputer;
    }

    public void setAidInputer(AidInputer aidinputer) {
        this.aidInputer = aidinputer;
    }

    public void addLayoutComponent(String s, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        return container.getMinimumSize();
    }

    public void layoutContainer(Container container) {
        int byte0 = 2;
        int i = this.getAidArrowType();
        if (i == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        int j = dimension.height - 2 * byte0;
        this.setMargin(new Insets(0, 1, 0, i != 3 ? dimension.height + 4 : dimension.height * 3 / 4 + 3));
        if (i == 1 || i == 2) {
            if (this.southButton != null) {
                this.southButton.setBounds(byte0 + dimension.width - 2 * byte0 - j, byte0, j, j);
            } else if (this.northButton != null) {
                this.northButton.setBounds(byte0 + dimension.width - 2 * byte0 - j, byte0, j, j);
            }
        }
        if (i == 3) {
            this.northButton.setBounds(byte0 + dimension.width - 2 * byte0 - j * 3 / 4, byte0, j * 3 / 4, j / 2);
            this.southButton.setBounds(byte0 + dimension.width - 2 * byte0 - j * 3 / 4, byte0 + j / 2, j * 3 / 4, j / 2);
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        int i = keyevent.getKeyCode();
        if (this.northButton != null && this.southButton != null) {
            if (i == 38) {
                this.incIntValue(1);
            } else if (i == 40) {
                this.incIntValue(-1);
            }
        }
        if (this.aidInputer != null) {
            String s;
            int byte0 = -1;
            if (i == 118) {
                byte0 = 1;
            } else if (i == 119) {
                byte0 = 0;
            } else if (i == 127 && !this.isEditable()) {
                this.setText("");
            }
            if (byte0 >= 0 && (s = this.aidInputer.doAidInput(this, this.getText(), byte0)) != null) {
                this.setText(s);
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension1;
        Object object = this.getTreeLock();
        synchronized (object) {
            int j;
            Dimension dimension = super.getPreferredSize();
            int i = this.getColumns();
            if (i != 0) {
                dimension.width = i * this.getColumnWidth();
            }
            if ((j = this.getAidArrowType()) > 0) {
                int k = dimension.height;
                if (k < 10) {
                    k = 10;
                }
                dimension.width = dimension.width + (1 + (j != 3 ? k : k * 3 / 4 + 3));
            }
            dimension1 = dimension;
        }
        return dimension1;
    }
}

