/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import softcore.awt.MutiSelectOnControlKeyDown;

public class MutiSelectableListUI
extends BasicListUI {
    public static ComponentUI createUI(JComponent jcomponent) {
        return new MutiSelectableListUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MutiSelectableListMouseInputHandler();
    }

    final JList getList() {
        return this.list;
    }

    final int this_convertYToRow(int i) {
        return this.convertYToRow(i);
    }

    public class MutiSelectableListMouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseevent) {
        }

        public void mouseEntered(MouseEvent mouseevent) {
        }

        public void mouseExited(MouseEvent mouseevent) {
        }

        public void mousePressed(MouseEvent mouseevent) {
            int i;
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            JList jlist = MutiSelectableListUI.this.getList();
            if (!jlist.isEnabled()) {
                return;
            }
            if (!jlist.hasFocus()) {
                jlist.requestFocus();
            }
            if ((i = MutiSelectableListUI.this.this_convertYToRow(mouseevent.getY())) != -1) {
                jlist.setValueIsAdjusting(true);
                int j = jlist.getAnchorSelectionIndex();
                if (mouseevent.isShiftDown() && j != -1) {
                    jlist.setSelectionInterval(j, i);
                } else {
                    if (jlist instanceof MutiSelectOnControlKeyDown && ((MutiSelectOnControlKeyDown)((Object)jlist)).getMutiSelectOnControlKeyDown() && !mouseevent.isControlDown()) {
                        jlist.clearSelection();
                    }
                    if (jlist.isSelectedIndex(i)) {
                        jlist.removeSelectionInterval(i, i);
                    } else {
                        jlist.addSelectionInterval(i, i);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseevent) {
            Rectangle rectangle;
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            JList jlist = MutiSelectableListUI.this.getList();
            if (!jlist.isEnabled()) {
                return;
            }
            if (mouseevent.isShiftDown() || mouseevent.isControlDown()) {
                return;
            }
            int i = MutiSelectableListUI.this.this_convertYToRow(mouseevent.getY());
            if (i != -1 && (rectangle = MutiSelectableListUI.this.getCellBounds(jlist, i, i)) != null) {
                jlist.scrollRectToVisible(rectangle);
                if (jlist.getSelectionMode() == 0) {
                    jlist.setSelectionInterval(i, i);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseevent) {
        }

        public void mouseReleased(MouseEvent mouseevent) {
            if (!SwingUtilities.isLeftMouseButton(mouseevent)) {
                return;
            }
            MutiSelectableListUI.this.getList().setValueIsAdjusting(false);
        }
    }
}

