/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import softcore.awt.DialogPanel;
import softcore.awt.MutiSelectableList;
import softcore.dx.CodeData;
import softcore.table.CodeNameMap;
import softcore.util.AidInputer;
import softcore.util.Filter;
import softcore.util.Utilities;
import softcore.util.ValueText;

public class SelectCode
extends DialogPanel
implements AidInputer,
FocusListener,
MouseListener,
CodeNameMap,
KeyListener {
    protected final JButton selectButton = new JButton("\u9009\u4e2d");
    protected final JButton prevButton = new JButton("\u4e0a\u7ea7");
    protected final JButton refreshButton = new JButton("\u5237\u65b0");
    protected final JButton addNewButton = new JButton("\u65b0\u52a0");
    protected CodeData codeData;
    protected final JComboBox cbListFilterMode = new JComboBox();
    protected final JTextField codeTextField = new JTextField();
    protected final DefaultListModel listModel = new DefaultListModel();
    protected final JList list;
    boolean mutiSelectable;
    String title;
    protected String[] listFilterModeText;
    protected int options;
    String sextFilter;
    public ValueText selectedValue;
    protected JComponent lastFocusedComponent = this.codeTextField;
    public Filter filter;

    public CodeData getCodeData() {
        return this.codeData;
    }

    public SelectCode(String s) {
        this(s, false);
    }

    public SelectCode(String s, boolean flag) {
        this.mutiSelectable = flag;
        this.list = flag ? new MutiSelectableList((ListModel)this.listModel) : new JList(this.listModel);
        this.okButton = new JButton("\u4e0b\u7ea7");
        this.refreshButton.setVisible(false);
        this.addNewButton.setEnabled(false);
        this.addNewButton.setVisible(false);
        this.title = s;
        this.codeTextField.addFocusListener(this);
        this.list.addFocusListener(this);
        this.list.addMouseListener(this);
        this.exitOptions = new JButton[]{this.okButton, this.selectButton, this.prevButton, this.cancelButton, this.refreshButton, this.addNewButton};
        this.setListFilterModeText(new String[]{"\u7f16\u7801", "\u540d\u5b57", "\u7b80\u7801"});
        this.setLayout(new GridBagLayout());
        DialogPanel.initGBC();
        DialogPanel.gbc.gridx = 1;
        DialogPanel.gbc.gridy = 0;
        DialogPanel.gbc.weightx = 1.0;
        DialogPanel.gbc.anchor = 17;
        DialogPanel.gbc.fill = 2;
        this.add((Component)this.codeTextField, DialogPanel.gbc);
        DialogPanel.initGBC();
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.gridy = 0;
        this.add((Component)this.cbListFilterMode, DialogPanel.gbc);
        DialogPanel.initGBC();
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.gridy = 1;
        DialogPanel.gbc.gridwidth = 2;
        DialogPanel.gbc.weightx = 1.0;
        DialogPanel.gbc.weighty = 1.0;
        DialogPanel.gbc.fill = 1;
        JScrollPane jscrollpane = new JScrollPane(this.list);
        jscrollpane.setPreferredSize(new Dimension(350, 250));
        this.add((Component)jscrollpane, DialogPanel.gbc);
        this.nPosOption |= 3;
        if (!flag) {
            this.list.setSelectionMode(0);
        }
        this.list.setAutoscrolls(true);
        this.list.addListSelectionListener(this);
        this.cbListFilterMode.addItemListener(this);
        this.codeTextField.addKeyListener(this);
        this.prevButton.setDefaultCapable(false);
        this.selectButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.refreshButton.setDefaultCapable(false);
        this.addNewButton.setDefaultCapable(false);
        this.addNewButton.setRequestFocusEnabled(false);
    }

    public SelectCode(CodeData codedata, String s) {
        this(s);
        this.codeData = codedata;
    }

    public SelectCode(CodeData codedata, String s, boolean flag) {
        this(s, flag);
        this.codeData = codedata;
    }

    public void setListFilterModeText(String[] as) {
        this.listFilterModeText = as;
        this.resetListFilterModeText();
    }

    public void resetListFilterModeText() {
        int i;
        this.cbListFilterMode.removeAllItems();
        int n = i = this.codeData != null ? this.codeData.getColCount() : 0;
        if (this.listFilterModeText != null) {
            int j = 0;
            while (j < this.listFilterModeText.length && j < i) {
                this.cbListFilterMode.addItem(this.listFilterModeText[j]);
                ++j;
            }
        }
    }

    public void setOptions(int i, boolean flag) {
        this.options = flag ? (this.options |= i) : (this.options &= ~i);
        this.okButton.setVisible((this.options & 1) == 0);
        this.prevButton.setVisible((this.options & 1) == 0);
        this.defaultExitButton = this.isOk() ? 0 : 1;
    }

    public void setExtFilter(String s) {
        this.sextFilter = s;
    }

    public void setCodeData(CodeData codedata) {
        this.codeData = codedata;
    }

    public void addList(String s, int i) {
        if (this.codeData == null) {
            return;
        }
        if (i < 0) {
            i = this.cbListFilterMode.getSelectedIndex();
        }
        int j = this.cbListFilterMode.getItemCount();
        String s1 = null;
        int k = 0;
        int l = 0;
        if (s == null) {
            ValueText valuetext = this.getListSelectedValue();
            if (valuetext != null) {
                l = (Integer)valuetext.getValue() + 1;
                s1 = this.codeData.getCode(l - 1, 0);
                k = s1.length();
            }
            if (s1 == null) {
                s = "*";
                i = 0;
            }
        }
        try {
            this.listModel.removeAllElements();
        }
        catch (Exception valuetext) {
            // empty catch block
        }
        int i1 = this.codeData.getRowCount();
        String s2 = null;
        int j1 = 0;
        int k1 = l;
        while (k1 < i1) {
            String s3 = this.codeData.getCode(k1, 0);
            if (s3 != null) {
                int l1 = s3.length();
                if (k > 0 && (l1 < k || !s3.substring(0, k).equals(s1))) break;
                if ((this.options & 1) != 0 || l1 <= j1 || j1 <= 0 || !s3.substring(0, j1).equals(s2)) {
                    boolean flag;
                    String s4 = this.codeData.getCode(k1, 1);
                    String s5 = this.codeData.getCode(k1, 2);
                    if (s == null) {
                        flag = true;
                    } else {
                        String s6 = null;
                        s6 = i == 1 ? s4 : (i == 2 ? s5 : (i >= 3 && i < j ? this.codeData.getCode(k1, i) : s3));
                        boolean bl = flag = !(s6 == null || !Utilities.like(s6, s, true) || this.sextFilter != null && !Utilities.likeOneOf(s6, this.sextFilter) || this.filter != null && !this.filter.filterAccept(new Object[]{s3, s4, new Integer(k1), this.codeData}));
                    }
                    if (flag) {
                        String s7 = s4;
                        if (s7 == s3) {
                            s7 = null;
                        }
                        if (i == 2 && s5 != null) {
                            if (s7 == null) {
                                s7 = "";
                            }
                            s7 = String.valueOf(s7) + " [" + s5 + "]";
                        }
                        int i2 = 3;
                        while (i2 < j) {
                            String s8 = this.codeData.getCode(k1, i2);
                            if (s8 != null) {
                                s7 = String.valueOf(s7) + " [" + s8 + "]";
                            }
                            ++i2;
                        }
                        String s9 = s7 != null ? String.valueOf(s3) + ":" + s7 : s3;
                        ValueText valuetext1 = new ValueText(s9, new Integer(k1));
                        this.listModel.addElement(valuetext1);
                        s2 = s3;
                        j1 = l1;
                    }
                }
            }
            ++k1;
        }
        if (this.listModel.size() > 0) {
            this.list.requestFocus();
            this.list.setSelectedIndex(0);
        }
    }

    private void refreshListForCodeText() {
        String s = this.codeTextField.getText();
        boolean flag = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '*' || c == '?') {
                flag = true;
            }
            ++i;
        }
        int j = this.cbListFilterMode.getSelectedIndex();
        if (!flag) {
            s = j == 1 ? "*" + s + "*" : String.valueOf(s) + "*";
        }
        this.addList(s, j);
    }

    protected boolean onExit(int i) {
        if (i == 0 || i == 1) {
            this.selectedValue = null;
            if (this.lastFocusedComponent == this.list && (this.selectedValue = (ValueText)this.list.getSelectedValue()) != null) {
                if ((this.options & 1) != 0 || i == 1 && (this.options & 4) != 0) {
                    return true;
                }
                this.addList(null, -1);
            } else {
                this.refreshListForCodeText();
            }
            if (this.listModel.size() == 0 && this.selectedValue != null) {
                return true;
            }
        } else if (i == 2) {
            int[] ai = this.codeData.getParentRowPath(this.getListSelectedCode());
            if (ai == null) {
                return false;
            }
            String s = "*";
            if (ai.length >= 3) {
                s = String.valueOf(this.codeData.getCode(ai[ai.length - 3], 0)) + "?*";
            }
            this.addList(s, 0);
        } else if (i == 4) {
            this.refresh();
            return false;
        }
        return i > 2;
    }

    protected ValueText getListSelectedValue() {
        return (ValueText)this.list.getSelectedValue();
    }

    public String getListSelectedCode() {
        ValueText valuetext = (ValueText)this.list.getSelectedValue();
        if (valuetext == null) {
            return null;
        }
        int i = (Integer)valuetext.getValue();
        return this.codeData.getCode(i, 0);
    }

    protected int _doShowDialog(Component component, String s, int i) {
        if (this.dialogParent == null) {
            this.createDialogParent(component, null, this.exitOptions);
        }
        int j = this.cbListFilterMode.getSelectedIndex();
        if (i == 0 && j >= this.cbListFilterMode.getItemCount()) {
            j = 0;
        }
        if (j < 0) {
            j = 0;
        }
        if (j == 0) {
            this.codeTextField.setText(s);
            if (s != null) {
                int k = s.indexOf(58);
                if (k >= 0) {
                    s = s.substring(0, k);
                }
                this.codeTextField.setText(s);
                int l = s.length();
                this.codeTextField.setSelectionStart(l <= 1 ? l : 0);
                this.codeTextField.setSelectionEnd(l);
            }
        }
        try {
            this.resetListFilterModeText();
            if (i == 0) {
                j = 0;
            }
            if (i == 1) {
                j = this.cbListFilterMode.getItemCount() - 1;
            }
            this.cbListFilterMode.setSelectedIndex(j);
        }
        catch (Exception k) {
            // empty catch block
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        dimension.width = dimension.width * 3 / 5;
        dimension.height = dimension.height * 3 / 5;
        return this.doShowDialog(this.title != null ? this.title : "\u9009\u62e9", dimension, this.codeTextField);
    }

    public String doAidInput(Component component, String s, int i) {
        int j = this._doShowDialog(component, s, i);
        if (this.mutiSelectable && (j == 0 || j == 1)) {
            Object[] aobj = this.list.getSelectedValues();
            if (aobj == null) {
                return null;
            }
            String s1 = null;
            int l = 0;
            while (l < aobj.length) {
                String s5 = aobj[l].toString();
                int i1 = s5.indexOf(58);
                if (i1 >= 0) {
                    s5 = s5.substring(0, i1);
                }
                s1 = s1 == null ? s5 : String.valueOf(s1) + "," + s5;
                ++l;
            }
            return s1;
        }
        if ((this.options & 0x1000) != 0) {
            try {
                this.listModel.removeAllElements();
            }
            catch (Exception aobj) {
                // empty catch block
            }
        }
        if ((j == 0 || j == 1) && this.selectedValue != null) {
            String s4;
            int k = (Integer)this.selectedValue.getValue();
            String s2 = this.codeData.getCode(k, 0);
            if ((this.options & 0x100) != 0) {
                String s3 = this.codeData.getCode(k, 1);
                if (s3 != null && s3.length() > 0) {
                    s2 = String.valueOf(s2) + ":" + s3;
                }
            } else if ((this.options & 0x200) != 0 && (s4 = this.findFullName(s2)) != null && s4.length() > 0) {
                s2 = String.valueOf(s2) + ":" + s4;
            }
            return s2;
        }
        return null;
    }

    public String findFullName(String s) {
        int[] ai = this.codeData.getParentRowPath(s);
        if (ai == null) {
            return null;
        }
        String s1 = "";
        int i = 0;
        while (i < ai.length) {
            if (i > 0) {
                s1 = String.valueOf(s1) + "-";
            }
            s1 = String.valueOf(s1) + this.codeData.getCode(ai[i], 1);
            ++i;
        }
        return s1;
    }

    protected void onListSelectionValueChanged(JList jlist, int i, int j, boolean flag) {
        if (jlist != this.list) {
            // empty if block
        }
    }

    public void focusGained(FocusEvent focusevent) {
        if (focusevent.getSource() == this.codeTextField) {
            this.lastFocusedComponent = this.codeTextField;
            int i = this.list.getSelectedIndex();
            if (i >= 0) {
                this.list.removeSelectionInterval(i, i);
            }
        } else if (focusevent.getSource() == this.list) {
            this.lastFocusedComponent = this.list;
        }
    }

    public void focusLost(FocusEvent focusevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if (mouseevent.getClickCount() == 2 && mouseevent.getSource() == this.list && this.onExit(0)) {
            this.exitValue = 0;
            this.closeFrame();
        }
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    protected void onComboboxItemSelected(JComboBox jcombobox, Object obj) {
        if (jcombobox == this.cbListFilterMode) {
            this.codeTextField.requestFocus();
        }
    }

    public String getNameByCode(Object obj) {
        return this.codeData == null ? null : this.codeData.getNameByCode(obj);
    }

    public Object[][] getCodeNameAsArray() {
        return this.codeData == null ? null : this.codeData.getCodeNameAsArray();
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
        if (keyevent.getSource() == this.codeTextField) {
            int byte0 = 0;
            if (keyevent.getKeyCode() == 38) {
                byte0 = -1;
            } else if (keyevent.getKeyCode() == 40) {
                byte0 = 1;
            }
            int i = this.cbListFilterMode.getItemCount();
            if (i > 1 && byte0 != 0) {
                this.cbListFilterMode.setSelectedIndex((this.cbListFilterMode.getSelectedIndex() + byte0 + i) % i);
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void refresh() {
        this.codeData.refresh(false);
        this.addList("*", -1);
    }

    public void setRefreshable(boolean flag) {
        this.refreshButton.setVisible(flag);
    }

    public JList getList() {
        return this.list;
    }
}

