/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import softcore.util.Utilities;

public class SplitPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    int rowCount;
    int colCount;
    protected int dividerSize;
    private Component[][] subComponent;
    private int[] widthComponent;
    private int[] heightComponent;
    private int[] widthWeight;
    private int[] heightWeight;
    int rAt;
    int cAt;
    int resizingType;
    int resizingX;
    int resizingY;
    private int[] curTypes;

    public SplitPanel(int i, int j) {
        int[] nArray = new int[4];
        nArray[1] = 9;
        nArray[2] = 11;
        nArray[3] = 1;
        this.curTypes = nArray;
        this.dividerSize = 3;
        if (i <= 0 || j <= 0) {
            throw new IllegalArgumentException();
        }
        this.rowCount = i;
        this.colCount = j;
        this.subComponent = new Component[i][j];
        this.widthComponent = new int[j];
        this.widthWeight = new int[j];
        this.heightComponent = new int[i];
        this.heightWeight = new int[i];
        this.setBackground(Color.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setWeight(int[] ai, int[] ai1) {
        if (ai1 != null) {
            int i = 0;
            while (i < ai1.length && i < this.widthWeight.length) {
                this.widthWeight[i] = ai1[i];
                ++i;
            }
        }
        if (ai != null) {
            int j = 0;
            while (j < ai.length && j < this.heightWeight.length) {
                this.heightWeight[j] = ai[j];
                ++j;
            }
        }
    }

    public void setDividerSize(int i) {
        this.dividerSize = i;
    }

    public Component getComponent(int i, int j) {
        return this.subComponent[i][j];
    }

    public void setComponent(Component component, int i, int j) {
        if (this.subComponent[i][j] != null) {
            this.remove(this.subComponent[i][j]);
        }
        Component component2 = component;
        this.subComponent[i][j] = component2;
        this.add(component2, null, i * this.colCount + j);
    }

    public Component addComponent(Component component) {
        int i = 0;
        while (i < this.subComponent.length) {
            int j = 0;
            while (j < this.subComponent[i].length) {
                if (this.subComponent[i][j] == null) {
                    Component component2 = component;
                    this.subComponent[i][j] = component2;
                    this.add(component2, null, i * this.colCount + j);
                    return component;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void reshape(int i, int j, int k, int l) {
        boolean flag = this.getWidth() != k;
        boolean flag1 = this.getHeight() != l;
        super.reshape(i, j, k, l);
        if (flag) {
            Utilities.resizeToFit(this.widthComponent, this.widthWeight, 0, this.colCount - 1, this.getWidth() - this.dividerSize * (this.colCount - 1));
        }
        if (flag1) {
            Utilities.resizeToFit(this.heightComponent, this.heightWeight, 0, this.rowCount - 1, this.getHeight() - this.dividerSize * (this.rowCount - 1));
        }
    }

    public void doLayout() {
        int i = 0;
        int j = 0;
        while (j < this.rowCount) {
            int k = 0;
            int l = 0;
            while (l < this.colCount) {
                if (this.subComponent[j][l] != null) {
                    this.subComponent[j][l].setBounds(k, i, this.widthComponent[l], this.heightComponent[j]);
                    this.subComponent[j][l].doLayout();
                }
                k += this.widthComponent[l] + this.dividerSize;
                ++l;
            }
            i += this.heightComponent[j] + this.dividerSize;
            ++j;
        }
    }

    int pointAtDivider(int i, int j) {
        this.cAt = -1;
        this.rAt = -1;
        int k = 0;
        int l = 0;
        int i1 = 0;
        while (i1 < this.rowCount - 1) {
            if (j < (k += this.heightComponent[i1] + this.dividerSize) - (this.dividerSize + 1)) break;
            if (j < k + 1) {
                this.rAt = i1;
                break;
            }
            ++i1;
        }
        int j1 = 0;
        while (j1 < this.colCount - 1) {
            if (i < (l += this.widthComponent[j1] + this.dividerSize) - (this.dividerSize + 1)) break;
            if (i < l + 1) {
                this.cAt = j1;
                break;
            }
            ++j1;
        }
        return (this.rAt < 0 ? 0 : 1) | (this.cAt < 0 ? 0 : 2);
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.resizingX = mouseevent.getX();
        this.resizingY = mouseevent.getY();
        this.resizingType = this.pointAtDivider(this.resizingX, this.resizingY);
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        boolean flag = false;
        if (this.cAt >= 0 && this.resizingX - mouseevent.getX() != 0) {
            Utilities.resizeToFit(this.widthComponent, this.widthWeight, 0, this.cAt, mouseevent.getX() - this.dividerSize * this.cAt);
            Utilities.resizeToFit(this.widthComponent, this.widthWeight, this.cAt + 1, this.colCount - 1, this.getWidth() - mouseevent.getX() - this.dividerSize * (this.colCount - 1 - this.cAt));
            this.resizingX = mouseevent.getX();
            flag = true;
        }
        if (this.rAt >= 0 && this.resizingY - mouseevent.getY() != 0) {
            Utilities.resizeToFit(this.heightComponent, this.heightWeight, 0, this.rAt, mouseevent.getY() - this.dividerSize * this.rAt);
            Utilities.resizeToFit(this.heightComponent, this.heightWeight, this.rAt + 1, this.rowCount - 1, this.getHeight() - mouseevent.getY() - this.dividerSize * (this.rowCount - 1 - this.rAt));
            this.resizingY = mouseevent.getY();
            flag = true;
        }
        if (flag) {
            this.doLayout();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        int i = this.pointAtDivider(mouseevent.getX(), mouseevent.getY());
        if (this.getCursor().getType() != this.curTypes[i]) {
            this.setCursor(Cursor.getPredefinedCursor(this.curTypes[i]));
        }
    }
}

