/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import softcore.awt.TableRow;

public class TableStyleTreeCellRenderer
extends DefaultTreeCellRenderer {
    TableRow tableRow;
    public static final int X0 = 3;

    public Component getTreeCellRendererComponent(JTree jtree, Object obj, boolean flag, boolean flag1, boolean flag2, int i, boolean flag3) {
        Object obj1 = null;
        if (obj instanceof DefaultMutableTreeNode) {
            obj1 = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        this.tableRow = obj1 instanceof TableRow ? (TableRow)obj1 : null;
        super.getTreeCellRendererComponent(jtree, obj, flag, flag1, flag2, i, flag3);
        return this;
    }

    public void paint(Graphics g) {
        int i;
        FontMetrics fontmetrics = g.getFontMetrics();
        if (this.tableRow != null && (i = this.tableRow.getCellCount()) > 0) {
            int j = this.getHeight();
            Color color = this.tableRow.getBackground();
            if (this.selected && color == null) {
                color = this.getBackgroundSelectionColor();
            }
            if (color != null) {
                g.setColor(color);
                g.fillRect(3, 0, this.getWidth() - 3 - 2, j);
            }
            int k = 3;
            g.setColor(Color.black);
            int l = 0;
            while (l < i) {
                int i1 = this.tableRow.getCellWidth(l);
                int j1 = this.tableRow.getCellAlign(l);
                g.drawRect(k, 0, i1, j);
                String s = this.tableRow.getCellValue(l);
                if (s != null) {
                    Graphics g1 = g.create(k + 1, 0, i1 - 2, j);
                    if (this.selected) {
                        g1.setColor(Color.white);
                    }
                    if (j1 == 1 || j1 == 2) {
                        int k1 = fontmetrics.stringWidth(s);
                        int l1 = j1 == 1 ? i1 - 3 - k1 : (i1 - k1) / 2;
                        g1.drawString(s, l1, j - 2);
                    } else {
                        g1.drawString(s, 1, j - 2);
                    }
                }
                k += i1;
                ++l;
            }
        } else {
            super.paint(g);
        }
    }

    public Dimension getPreferredSize() {
        int i;
        Dimension dimension = super.getPreferredSize();
        if (this.tableRow != null && (i = this.tableRow.getCellCount()) > 0) {
            int j = 3;
            int k = 0;
            while (k < i) {
                j += this.tableRow.getCellWidth(k);
                ++k;
            }
            dimension.width = j + 2;
            dimension.height += 2;
        }
        return dimension;
    }
}

