/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Reader;
import java.util.Vector;

public class TextEditor
implements Runnable,
ClipboardOwner {
    Component parent;
    FontMetrics fontMetrics;
    Font font;
    Color color;
    Color background;
    int charSize;
    int x;
    int y;
    int width;
    int height;
    boolean activated = false;
    boolean visible = false;
    int alignment;
    final Vector textList = new Vector();
    char echoChar;
    boolean editable;
    Thread caretThread = new Thread(this);
    int xAt;
    int yAt;
    int xPixelAt0;
    int yAt0;
    int startSelectedX;
    int startSelectedY;
    protected transient TextListener textListener;
    private Dimension preferredSize;
    private int offWidth;
    private int offHeight;
    private Image offImage;
    private Graphics offGraphics;
    private boolean forceRedraw = true;
    boolean drawBlueBorder;
    private Color selectedColor = new Color(0, 0, 128);
    private boolean changed;
    private int caretHeight = 17;
    private int xPixelCaret;
    private int yPixelCaret;
    boolean caretOn;
    private int countLockCaret;
    private char[] valueEditBuffer = new char[32];
    private int countEditBuffer = 0;

    public TextEditor(Component component) {
        this.setParent(component);
        this.caretThread.setPriority(1);
        this.caretThread.start();
    }

    private void initFontMetrics() {
        if (this.parent != null) {
            try {
                this.fontMetrics = this.parent.getFontMetrics(this.getFont());
                this.charSize = this.fontMetrics.charWidth('m');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setParent(Component component) {
        this.parent = component;
        this.initFontMetrics();
    }

    public void setBounds(int i, int j, int k, int l) {
        this.x = i;
        this.y = j;
        this.width = k;
        this.height = l;
        if (this.fontMetrics == null) {
            this.initFontMetrics();
        }
        this.setCaretPixelPosition();
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String getSetectedText() {
        if (this.yAt == this.startSelectedY) {
            if (this.startSelectedX == this.xAt) {
                return null;
            }
            int i = this.startSelectedX <= this.xAt ? this.startSelectedX : this.xAt;
            int j = this.startSelectedX >= this.xAt ? this.startSelectedX : this.xAt;
            return new String(this.valueEditBuffer, i, j - i);
        }
        return null;
    }

    private int getSelectedXX(int i) {
        if (this.yAt == this.startSelectedY) {
            if (i != this.yAt || this.startSelectedX == this.xAt) {
                return 0;
            }
            int j = this.startSelectedX <= this.xAt ? this.startSelectedX : this.xAt;
            int k = this.startSelectedX >= this.xAt ? this.startSelectedX : this.xAt;
            return j << 16 | k;
        }
        return 0;
    }

    public void setText(String s) {
        this.textList.removeAllElements();
        this.countEditBuffer = 0;
        this.forceRedraw = true;
        if (s != null) {
            int i = 0;
            while (i <= s.length()) {
                int j = s.indexOf(10, i);
                if (j < i) {
                    j = s.length();
                }
                int k = j;
                while (j > i && s.charAt(j - 1) <= ' ') {
                    --j;
                }
                this.textList.addElement(s.substring(i, j));
                i = k + 1;
            }
        } else {
            this.textList.addElement("");
        }
        this.yAt = -1;
        this.setCaretPosition(0, 0, false);
        this.changed = true;
        if (this.textListener != null) {
            this.textListener.textValueChanged(new TextEvent(this.parent, 900));
        }
    }

    public synchronized void addTextListener(TextListener textlistener) {
        if (textlistener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.add(this.textListener, textlistener);
    }

    public synchronized void removeTextListener(TextListener textlistener) {
        if (textlistener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.remove(this.textListener, textlistener);
    }

    public final int getLines() {
        return this.textList.size();
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.fontMetrics == null) {
            this.initFontMetrics();
        }
        if (this.fontMetrics == null) {
            return new Dimension(100, 100);
        }
        int i = 0;
        int j = 0;
        while (j < this.textList.size()) {
            String s = (String)this.textList.elementAt(j);
            if (s != null && s.length() > i) {
                i = s.length();
            }
            ++j;
        }
        return new Dimension((i + 4) * this.charSize, this.textList.size() * this.fontMetrics.getAscent() + 8);
    }

    public void selectAll() {
        int j;
        int i = this.textList.size() - 1;
        if (i < 0) {
            return;
        }
        int n = j = i != this.yAt ? ((String)this.textList.elementAt(this.textList.size() - 1)).length() : this.countEditBuffer;
        if (this.startSelectedX != 0 || this.startSelectedY != 0 || this.yAt != i || this.xAt != j) {
            this.forceRedraw = true;
            this.startSelectedX = 0;
            this.startSelectedY = 0;
            this.setCaretPosition(j, i, true);
        }
    }

    public String getText() {
        int i = this.textList.size();
        if (i == 1) {
            return this.getEditBufferAsString();
        }
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            if (j > 0) {
                stringbuffer.append("\r\n");
            }
            if (j == this.yAt) {
                stringbuffer.append(this.getEditBufferAsString());
            } else {
                stringbuffer.append((String)this.textList.elementAt(j));
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public void setAlignment(int i) {
        if (this.alignment != i) {
            this.alignment = i;
            this.forceRedraw = true;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setFont(Font font1) {
        this.font = font1;
        this.initFontMetrics();
        this.forceRedraw = true;
    }

    public Font getFont() {
        Font font1 = this.font;
        if (font1 == null && this.parent != null) {
            font1 = this.parent.getFont();
        }
        return font1;
    }

    public void setColor(Color color1) {
        this.color = color1;
    }

    public Color getColor() {
        return this.color;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
    }

    public void setEditable(boolean flag) {
        this.editable = flag;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActived(boolean flag) {
        if (this.activated != flag) {
            TextEditor textEditor = this;
            synchronized (textEditor) {
                this.activated = flag;
                if (this.caretOn) {
                    this.switchCaret();
                }
                if (flag) {
                    this.switchCaret();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean flag) {
        if (this.visible != flag) {
            TextEditor textEditor = this;
            synchronized (textEditor) {
                this.visible = flag;
                if (this.caretOn) {
                    this.switchCaret();
                }
            }
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void forceRedraw() {
        this.forceRedraw = true;
    }

    public void setDrawBlueBorder(boolean flag) {
        this.drawBlueBorder = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (!this.visible || g == null) {
            return;
        }
        if (this.offImage == null || this.offWidth != this.width || this.offHeight != this.height) {
            if (this.width <= 2 || this.height <= 2) {
                if (this.width > 0 && this.height > 0 && this.drawBlueBorder) {
                    g.setColor(Color.blue);
                    g.drawRect(this.x, this.y, this.width - 1, this.height - 1);
                }
                return;
            }
            this.offWidth = this.width;
            this.offHeight = this.height;
            this.offImage = this.parent.createImage(this.offWidth, this.offHeight);
            if (this.offImage == null) {
                this.offGraphics = null;
                return;
            }
            this.offGraphics = this.offImage.getGraphics();
            this.forceRedraw = true;
        }
        if (this.forceRedraw) {
            this.draw(-1);
            this.forceRedraw = false;
        }
        if (this.offImage != null) {
            TextEditor textEditor = this;
            synchronized (textEditor) {
                g.drawImage(this.offImage, this.x, this.y, this.parent);
                this.caretOn = false;
            }
        }
    }

    private void drawLine(String s, int i, Graphics g, int j) {
        this.drawLine(s.toCharArray(), -1, i, g, j);
    }

    private int startDrawPixelPosition(int i) {
        if (this.alignment == 1) {
            return this.width - i - 2 + this.xPixelAt0;
        }
        if (this.alignment == 2) {
            return (this.width - i) / 2 + this.xPixelAt0 - 1;
        }
        return 1 - this.xPixelAt0;
    }

    private void drawLine(char[] ac, int i, int j, Graphics g, int k) {
        char[] ac1;
        if (i < 0) {
            i = ac.length;
        }
        if (this.echoChar == '\u0000') {
            ac1 = ac;
        } else {
            ac1 = new char[i];
            int l = 0;
            while (l < i) {
                ac1[l] = this.echoChar;
                ++l;
            }
        }
        int i1 = 1 + (j + 1 - this.yAt0) * k;
        int j1 = this.getSelectedXX(j);
        int k1 = j1 >>> 16;
        int l1 = j1 & 0xFFFF;
        int i2 = this.fontMetrics.charsWidth(ac1, 0, i);
        int j2 = this.startDrawPixelPosition(i2);
        if (this.activated && k1 < l1 && k1 < i) {
            if (l1 > i) {
                l1 = i;
            }
            int k2 = this.fontMetrics.charsWidth(ac1, 0, k1);
            int l2 = this.fontMetrics.charsWidth(ac1, k1, l1 - k1);
            g.drawChars(ac1, 0, k1, j2, i1);
            g.setColor(this.selectedColor);
            g.fillRect(j2 + k2, 1, l2, this.height - 2);
            g.setColor(Color.white);
            g.drawChars(ac1, k1, l1 - k1, j2 + k2, i1);
            g.setColor(Color.black);
            g.drawChars(ac1, l1, this.countEditBuffer - l1, j2 + k2 + l2, i1);
        } else {
            g.drawChars(ac1, 0, i, j2, i1);
        }
    }

    private void draw(int i) {
        if (this.offGraphics == null) {
            return;
        }
        Graphics g = this.offGraphics.create();
        g.setColor(Color.white);
        g.fillRect(1, 1, this.width - 2, this.height - 2);
        if (this.drawBlueBorder) {
            g.setColor(Color.blue);
            g.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        g.setColor(Color.black);
        Font font1 = this.getFont();
        if (font1 != null && !font1.equals(g.getFont())) {
            g.setFont(font1);
        }
        if (this.fontMetrics == null) {
            this.initFontMetrics();
        }
        int j = this.fontMetrics.getAscent();
        int k = this.textList.size();
        if (i >= 0 || k == 1) {
            this.drawLine(this.valueEditBuffer, this.countEditBuffer, i < 0 ? 0 : i, g, j);
        } else {
            int l = 0;
            while (l < k) {
                if (l == this.yAt) {
                    this.drawLine(this.valueEditBuffer, this.countEditBuffer, l, g, j);
                } else {
                    this.drawLine((String)this.textList.elementAt(l), l, g, j);
                }
                ++l;
            }
        }
    }

    private Point mapPixelPositionToCharPosition(int i, int j) {
        int k = this.echoChar != '\u0000' ? this.countEditBuffer * this.fontMetrics.charWidth(this.echoChar) : this.fontMetrics.charsWidth(this.valueEditBuffer, 0, this.countEditBuffer);
        int l = this.startDrawPixelPosition(k);
        int i1 = 0;
        while (i1 < this.countEditBuffer) {
            int j1 = this.fontMetrics.charWidth(this.echoChar != '\u0000' ? this.echoChar : this.valueEditBuffer[i1]);
            if (i <= l + (j1 >> 1)) break;
            l += j1;
            ++i1;
        }
        return new Point(i1, 0);
    }

    public boolean handleKeyEvent(KeyEvent keyevent) {
        char c = keyevent.getKeyChar();
        if (c >= ' ' && c < '\uffff' && c != '\u007f' || c == '\n') {
            if (this.editable) {
                this.insertText("" + c);
            }
            return true;
        }
        int i = keyevent.getKeyCode();
        if (keyevent.isControlDown()) {
            switch (i) {
                case 67: {
                    this.copy();
                    return true;
                }
                case 86: {
                    this.paste();
                    return true;
                }
                case 88: {
                    this.cut();
                    return true;
                }
            }
            return false;
        }
        boolean flag = keyevent.isShiftDown();
        switch (i) {
            case 37: {
                if (this.xAt <= 0) {
                    return false;
                }
                this.setCaretPosition(this.xAt - 1, this.yAt, flag);
                return true;
            }
            case 39: {
                if (this.xAt < this.countEditBuffer) {
                    this.setCaretPosition(this.xAt + 1, this.yAt, flag);
                    return true;
                }
                int j = this.textList.size();
                if (this.yAt < j - 1) {
                    this.setCaretPosition(0, this.yAt + 1, flag);
                    return true;
                }
                return false;
            }
            case 36: {
                if (this.xAt > 0) {
                    this.setCaretPosition(0, this.yAt, flag);
                }
                return true;
            }
            case 35: {
                if (this.xAt < this.countEditBuffer) {
                    this.setCaretPosition(this.countEditBuffer, this.yAt, flag);
                }
                return true;
            }
            case 8: {
                if (!this.editable || this.deleteSelectedText() != null) {
                    return true;
                }
                if (this.xAt <= 0) {
                    return true;
                }
                this.deleteEditBuffer(this.xAt - 1, this.xAt);
                this.setCaretPosition(this.xAt - 1, this.yAt, false);
                this.forceRedraw = true;
                this.paint(this.parent.getGraphics());
                return true;
            }
            case 127: {
                if (!this.editable || this.deleteSelectedText() != null) {
                    return true;
                }
                if (this.xAt >= this.countEditBuffer) {
                    return true;
                }
                this.deleteEditBuffer(this.xAt, this.xAt + 1);
                this.setCaretPosition(this.xAt, this.yAt, false);
                this.forceRedraw = true;
                this.paint(this.parent.getGraphics());
                return true;
            }
        }
        return false;
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.setCaretPositionByMouseEvent(mouseevent, false);
    }

    public void mouseDragged(MouseEvent mouseevent) {
        this.setCaretPositionByMouseEvent(mouseevent, true);
    }

    private void setCaretPositionByMouseEvent(MouseEvent mouseevent, boolean flag) {
        if (mouseevent == null) {
            return;
        }
        Point point = this.mapPixelPositionToCharPosition(mouseevent.getX(), mouseevent.getY());
        if (point != null && (point.x != this.xAt || point.y != this.yAt)) {
            this.setCaretPosition(point.x, point.y, flag);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean flag) {
        this.changed = flag;
    }

    public void insertText(String s) {
        if (s != null && s.length() > 0) {
            this.deleteSelectedText();
            int i = this.xAt;
            int j = this.yAt;
            int k = 0;
            int l = 0;
            while (l < s.length()) {
                int i1 = s.indexOf(l, 10);
                if (i1 < l) {
                    i1 = s.length();
                }
                int j1 = i1;
                if (k == 0) {
                    this.insertEditBuffer(this.xAt, s);
                    i += s.length();
                } else {
                    this.textList.insertElementAt(s, j + 1);
                    i = s.length();
                    ++j;
                }
                ++k;
                l = j1 + 1;
            }
            if (k > 0) {
                this.forceRedraw = true;
            } else {
                this.draw(this.yAt);
            }
            this.paint(this.parent.getGraphics());
            this.setCaretPosition(i, j, false);
            this.changed = true;
            if (this.textListener != null) {
                this.textListener.textValueChanged(new TextEvent(this.parent, 900));
            }
        }
    }

    public String deleteSelectedText() {
        if (this.yAt == this.startSelectedY) {
            if (this.startSelectedX == this.xAt) {
                return null;
            }
            int i = this.startSelectedX <= this.xAt ? this.startSelectedX : this.xAt;
            int j = this.startSelectedX >= this.xAt ? this.startSelectedX : this.xAt;
            String s = this.deleteEditBuffer(i, j);
            this.forceRedraw = true;
            this.setCaretPosition(i, this.yAt, false);
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCaretPosition(int i, int j, boolean flag) {
        this.lockCaret(true);
        try {
            int k = this.getSelectedXX(this.yAt);
            int l = this.textList.size();
            if (j >= l) {
                j = l - 1;
            }
            if (i < 0) {
                i = 0;
            }
            if (j < 0) {
                j = 0;
            }
            if (j != this.yAt) {
                if (this.yAt >= 0) {
                    this.textList.setElementAt(this.getEditBufferAsString(), this.yAt);
                }
                this.yAt = j;
                this.resetEditBuffer((String)this.textList.elementAt(this.yAt));
            }
            if (i > this.countEditBuffer) {
                i = this.countEditBuffer;
            }
            this.xAt = i;
            if (this.yAt0 > this.yAt) {
                this.yAt0 = this.yAt;
                this.forceRedraw = true;
            }
            if (flag) {
                this.forceRedraw = true;
            } else {
                this.startSelectedX = this.xAt;
                this.startSelectedY = this.yAt;
                if (k != 0) {
                    this.forceRedraw = true;
                }
            }
            this.setCaretPixelPosition();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lockCaret(false);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.lockCaret(false);
            return;
        }
    }

    public void setCaretPositionToEnd() {
        int i = this.textList.size();
        int j = this.yAt == i - 1 ? this.countEditBuffer : ((String)this.textList.elementAt(i - 1)).length();
        this.setCaretPosition(j, i - 1, false);
    }

    private void setCaretPixelPosition() {
        if (this.width <= 1) {
            return;
        }
        int i = this.fontMetrics.getAscent();
        int j = 0;
        int k = this.xPixelAt0;
        if (this.alignment == 1) {
            if (this.xAt < this.countEditBuffer) {
                int n = j = this.echoChar != '\u0000' ? (this.countEditBuffer - this.xAt) * this.fontMetrics.charWidth(this.echoChar) : this.fontMetrics.charsWidth(this.valueEditBuffer, this.xAt, this.countEditBuffer - this.xAt);
            }
            if (this.xPixelAt0 > j - this.charSize) {
                this.xPixelAt0 = j - this.charSize;
            } else if (j > this.xPixelAt0 + this.width - 3) {
                this.xPixelAt0 = j - this.width + 3;
            }
            if (this.xPixelAt0 < 0) {
                this.xPixelAt0 = 0;
            }
            j = this.x - 2 + this.width - j + this.xPixelAt0;
        } else if (this.alignment == 2) {
            int j1;
            int l = this.countEditBuffer;
            int i1 = this.echoChar != '\u0000' ? l * this.fontMetrics.charWidth(this.echoChar) : this.fontMetrics.charsWidth(this.valueEditBuffer, 0, l);
            j = (this.width - i1) / 2 + (j1 = this.echoChar != '\u0000' ? this.xAt * this.fontMetrics.charWidth(this.echoChar) : this.fontMetrics.charsWidth(this.valueEditBuffer, 0, this.xAt)) + this.xPixelAt0 - 1;
            if (j > this.width - this.charSize) {
                this.xPixelAt0 -= j - this.width + this.charSize - 1;
            } else if (j < 1) {
                this.xPixelAt0 -= j - 1;
            }
            j = this.x + (this.width - i1) / 2 + j1 + this.xPixelAt0 - 1;
        } else {
            if (this.xAt > 0) {
                int n = j = this.echoChar != '\u0000' ? this.xAt * this.fontMetrics.charWidth(this.echoChar) : this.fontMetrics.charsWidth(this.valueEditBuffer, 0, this.xAt);
            }
            if (this.xPixelAt0 > j) {
                this.xPixelAt0 = j;
            } else if (j > this.xPixelAt0 + this.width - this.charSize) {
                this.xPixelAt0 = j - this.width + this.charSize;
            }
            if (this.xPixelAt0 < 0) {
                this.xPixelAt0 = 0;
            }
            j += this.x + 1 - this.xPixelAt0;
        }
        if (k != this.xPixelAt0) {
            this.forceRedraw = true;
        }
        if (this.forceRedraw) {
            this.paint(this.parent.getGraphics());
        }
        this.setCaretPixelPosition(j, this.y + i * (this.yAt - this.yAt0 + 1) + 3);
    }

    public synchronized void switchCaret() {
        Graphics g = this.parent.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        g.drawLine(this.xPixelCaret, this.yPixelCaret - this.caretHeight, this.xPixelCaret, this.yPixelCaret);
        g.setPaintMode();
        this.caretOn = !this.caretOn;
    }

    public synchronized void offCaret() {
        if (this.caretOn) {
            this.switchCaret();
        }
    }

    private synchronized void setCaretPixelPosition(int i, int j) {
        if (i == this.xPixelCaret && j == this.yPixelCaret) {
            return;
        }
        if (this.caretOn) {
            this.switchCaret();
        }
        this.xPixelCaret = i;
        this.yPixelCaret = j;
        this.notifyAll();
    }

    public synchronized void lockCaret(boolean flag) {
        this.countLockCaret = flag ? ++this.countLockCaret : --this.countLockCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            TextEditor textEditor = this;
            synchronized (textEditor) {
                while (this.caretOn || this.visible) {
                    if (this.caretOn || this.activated && this.width > 1 && this.height > 1 && this.countLockCaret == 0) {
                        this.switchCaret();
                    }
                    this.wait(500L);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void expandEditBufferCapacity(int i) {
        if (i <= this.valueEditBuffer.length) {
            return;
        }
        int j = (this.valueEditBuffer.length + 1) * 2;
        if (j < 0) {
            j = Integer.MAX_VALUE;
        } else if (i > j) {
            j = i;
        }
        char[] ac = new char[j];
        System.arraycopy(this.valueEditBuffer, 0, ac, 0, this.countEditBuffer);
        this.valueEditBuffer = ac;
    }

    private void appendEditBuffer(String s) {
        this.insertEditBuffer(this.countEditBuffer, s);
    }

    private void appendEditBuffer(char c) {
        this.expandEditBufferCapacity(this.countEditBuffer + 1);
        this.valueEditBuffer[this.countEditBuffer++] = c;
    }

    private void insertEditBuffer(int i, String s) {
        if (s == null) {
            return;
        }
        if (i < 0 || i > this.countEditBuffer) {
            throw new StringIndexOutOfBoundsException();
        }
        int j = s.length();
        int k = this.countEditBuffer + j;
        if (k > this.valueEditBuffer.length) {
            this.expandEditBufferCapacity(k);
        }
        System.arraycopy(this.valueEditBuffer, i, this.valueEditBuffer, i + j, this.countEditBuffer - i);
        s.getChars(0, j, this.valueEditBuffer, i);
        this.countEditBuffer = k;
    }

    private void insertEditBuffer(int i, char c) {
        int j = this.countEditBuffer + 1;
        if (j > this.valueEditBuffer.length) {
            this.expandEditBufferCapacity(j);
        }
        System.arraycopy(this.valueEditBuffer, i, this.valueEditBuffer, i + 1, this.countEditBuffer - i);
        this.valueEditBuffer[i] = c;
        this.countEditBuffer = j;
    }

    private String deleteEditBuffer(int i, int j) {
        if (i < 0) {
            throw new StringIndexOutOfBoundsException(i);
        }
        if (j > this.countEditBuffer) {
            j = this.countEditBuffer;
        }
        if (i > j) {
            throw new StringIndexOutOfBoundsException();
        }
        int k = j - i;
        if (k > 0) {
            String s = new String(this.valueEditBuffer, i, k);
            System.arraycopy(this.valueEditBuffer, i + k, this.valueEditBuffer, i, this.countEditBuffer - j);
            this.countEditBuffer -= k;
            this.changed = true;
            if (this.textListener != null) {
                this.textListener.textValueChanged(new TextEvent(this.parent, 900));
            }
            return s;
        }
        return null;
    }

    private void resetEditBuffer(String s) {
        if (s == null) {
            this.countEditBuffer = 0;
        } else {
            int i = s.length();
            this.expandEditBufferCapacity(i);
            s.getChars(0, i, this.valueEditBuffer, 0);
            this.countEditBuffer = i;
        }
    }

    private String getEditBufferAsString() {
        return new String(this.valueEditBuffer, 0, this.countEditBuffer);
    }

    private String substringEditBuffer(int i, int j) {
        if (j > this.countEditBuffer) {
            j = this.countEditBuffer;
        }
        return new String(this.valueEditBuffer, i, j - i);
    }

    private String substringEditBuffer(int i) {
        return new String(this.valueEditBuffer, i, this.countEditBuffer - i);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void copy() {
        if (this.echoChar != '\u0000') {
            return;
        }
        String s = this.getSetectedText();
        if (s == null || s.length() == 0) {
            return;
        }
        Clipboard clipboard = this.parent.getToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(s), this);
    }

    public void cut() {
        String s;
        String string = s = this.editable ? this.deleteSelectedText() : this.getSetectedText();
        if (s == null || s.length() == 0 || this.echoChar != '\u0000') {
            return;
        }
        Clipboard clipboard = this.parent.getToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(s), this);
    }

    public void paste() {
        block7: {
            if (!this.editable) {
                return;
            }
            try {
                Clipboard clipboard = this.parent.getToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(this);
                DataFlavor[] adataflavor = transferable.getTransferDataFlavors();
                if (adataflavor == null) break block7;
                int i = 0;
                while (i < adataflavor.length) {
                    Object obj = transferable.getTransferData(adataflavor[0]);
                    if (obj instanceof String) {
                        this.insertText((String)obj);
                        break;
                    }
                    if (obj instanceof Reader) {
                        int j;
                        Reader reader = (Reader)obj;
                        StringBuffer stringbuffer = new StringBuffer();
                        while ((j = reader.read()) >= 0) {
                            stringbuffer.append((char)j);
                        }
                        this.insertText(stringbuffer.toString());
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

