/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.Color;
import java.io.Serializable;

public class ChartSample
implements Serializable {
    protected Double value;
    protected String label;
    Color labelColor;
    private static final Color DEFAULT_COLOR = Color.black;
    private int series;
    private int index;
    Object key;
    private boolean selected;

    public void set(double d, String s, Object obj) {
        this.value = new Double(d);
        this.label = s;
        this.key = obj;
    }

    public void setValue(double d) {
        this.value = new Double(d);
    }

    public long getValue() {
        if (this.value != null) {
            return this.value.longValue();
        }
        return 0L;
    }

    public String toString() {
        if (this.label != null && this.value != null) {
            return String.valueOf(this.series) + ":" + this.index + " " + this.label + " " + this.value;
        }
        if (this.value != null) {
            return String.valueOf(this.series) + ":" + this.index + " " + "null " + this.value;
        }
        if (this.label != null) {
            return String.valueOf(this.series) + ":" + this.index + " " + this.label;
        }
        return String.valueOf(this.series) + ":" + this.index + " " + "null 0";
    }

    public ChartSample(int i) {
        this.index = i;
    }

    public ChartSample(int i, double d) {
        this.index = i;
        this.value = new Double(d);
    }

    public ChartSample(int i, double d, String s, Object obj) {
        this.index = i;
        this.value = new Double(d);
        this.label = s;
        this.key = obj;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public double getFloatValue() {
        if (this.value != null) {
            return this.value;
        }
        return 0.0;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean setSelection(boolean flag) {
        this.selected = flag;
        return this.selected;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean toggleSelection() {
        this.selected = !this.selected;
        return this.selected;
    }

    void setSeries(int i) {
        this.series = i;
    }

    public int getSeries() {
        return this.series;
    }

    public void clearValue() {
        this.value = null;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getLabel() {
        return this.label;
    }
}

