/*
 * Decompiled with CFR 0.152.
 */
package softcore.awt.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import softcore.awt.DialogPanel;
import softcore.awt.chart.BarChart;
import softcore.awt.chart.Chart;
import softcore.awt.chart.ChartComponent;
import softcore.awt.chart.LineChart;
import softcore.awt.chart.PieChart;

public class ChartStyleDialogPanel
extends DialogPanel {
    final Vector optionVector = new Vector();
    final int chartType;
    final Chart chart;
    public static final int DFTBARSTYLE = 831;
    public static final int DFTPIESTYLE = 63;
    public static final int DFTLINESTYLE = 636;

    private ChartStyleDialogPanel(int i, int j, Chart chart1, boolean flag) {
        String[] as;
        this.chartType = i;
        if (i == 1) {
            as = new String[]{"\u4e09\u7ef4\u6548\u679c", "\u663e\u793a\u6a2a\u7ebf\u95f4\u9694", "\u663e\u793a\u76f4\u65b9\u7684\u503c", "\u663e\u793a\u56fe\u5f62\u7ec4\u6807\u8bc6", "\u663e\u793a\u6a2a\u8f74\u6807\u8bc6", "\u663e\u793a\u7eb5\u8f74\u6807\u8bc6", "\u81ea\u52a8\u8c03\u6574\u6807\u8bc6\u95f4\u8ddd", "\u663e\u793a\u76f4\u65b9\u8fb9\u7ebf", "\u591a\u8272\u663e\u793a", "\u603b\u6309\u591a\u7ec4\u663e\u793a"};
            if (chart1 == null) {
                chart1 = ChartStyleDialogPanel.createSampleBarChart(j);
            }
        } else if (i == 2) {
            as = new String[]{"\u4e09\u7ef4\u6548\u679c", "\u663e\u793a\u6bcf\u5757\u6570\u503c", "\u663e\u793a\u6bcf\u5757\u767e\u5206\u6bd4\u503c", "\u663e\u793a\u6bcf\u5757\u6240\u5728\u7ec4\u3001\u9879", "\u663e\u793a\u997c\u56fe\u6807\u8bc6", "\u663e\u793a\u56fe\u5f62\u7ec4\u6807\u8bc6", "\u663e\u793a\u5757\u95f4\u9694\u7ebf"};
            if (chart1 == null) {
                chart1 = ChartStyleDialogPanel.createSamplePieChart(j);
            }
        } else if (i == 3) {
            as = new String[]{"\u4e09\u7ef4\u6548\u679c", "\u5806\u53e0\u6548\u679c", "\u663e\u793a\u6a2a\u7ebf\u95f4\u9694", "\u663e\u793a\u6bcf\u70b9\u6570\u503c", "\u663e\u793a\u56fe\u5f62\u7ec4\u6807\u8bc6", "\u663e\u793a\u6a2a\u8f74\u6807\u8bc6", "\u663e\u793a\u7eb5\u8f74\u6807\u8bc6", "\u53ef\u8c03\u8282\u7eb5\u8f74", "\u81ea\u52a8\u8c03\u6574\u6807\u8bc6\u95f4\u8ddd"};
            if (chart1 == null) {
                chart1 = ChartStyleDialogPanel.createSampleLineChart(j);
            }
        } else {
            throw new IllegalArgumentException();
        }
        JPanel jpanel = DialogPanel.createGridLayoutCheckBox(this.optionVector, as, as.length, 1);
        DialogPanel.setValueOfCheckBox(this.optionVector, j);
        this.addListenerToButtons(this.optionVector);
        this.setLayout(new GridBagLayout());
        DialogPanel.initGBC();
        this.chart = chart1;
        if (flag) {
            ChartComponent chartcomponent = new ChartComponent(chart1);
            chartcomponent.setPreferredSize(new Dimension(400, 400));
            this.add((Component)chartcomponent, DialogPanel.gbc);
            DialogPanel.gbc.gridx = 1;
        }
        this.add((Component)jpanel, DialogPanel.gbc);
    }

    public ChartStyleDialogPanel(int i, int j) {
        this(i, j, null, true);
    }

    public ChartStyleDialogPanel(Chart chart1) {
        this(ChartStyleDialogPanel.getCharType(chart1), ChartStyleDialogPanel.getCharStyleValue(chart1), chart1, false);
    }

    protected void onToggleButtonSelected(JToggleButton jtogglebutton, boolean flag) {
        ChartStyleDialogPanel.setCharStyleValue(this.chart, DialogPanel.getValueOfCheckBox(this.optionVector));
    }

    public static int askChartStyle(int i, int j) {
        ChartStyleDialogPanel chartstyledialogpanel = new ChartStyleDialogPanel(i, j);
        return chartstyledialogpanel.showDialog("\u56fe\u5f62\u98ce\u683c") != 0 ? -1 : DialogPanel.getValueOfCheckBox(chartstyledialogpanel.optionVector);
    }

    public static void setChartStyle(Chart chart1) {
        if (chart1 == null) {
            return;
        }
        ChartStyleDialogPanel chartstyledialogpanel = new ChartStyleDialogPanel(chart1);
        int i = ChartStyleDialogPanel.getCharStyleValue(chart1);
        if (chartstyledialogpanel.showDialog("\u56fe\u5f62\u98ce\u683c") != 0) {
            ChartStyleDialogPanel.setCharStyleValue(chart1, i);
        }
    }

    private static int getCharType(Chart chart1) {
        if (chart1 instanceof BarChart) {
            return 1;
        }
        if (chart1 instanceof PieChart) {
            return 2;
        }
        return !(chart1 instanceof LineChart) ? 0 : 3;
    }

    public static int getCharStyleValue(Chart chart1) {
        if (chart1 instanceof BarChart) {
            return ChartStyleDialogPanel.getBarChartValue((BarChart)chart1);
        }
        if (chart1 instanceof PieChart) {
            return ChartStyleDialogPanel.getPieChartValue((PieChart)chart1);
        }
        if (chart1 instanceof LineChart) {
            return ChartStyleDialogPanel.getLineChartValue((LineChart)chart1);
        }
        throw new IllegalArgumentException();
    }

    public static void setCharStyleValue(Chart chart1, int i) {
        if (chart1 instanceof BarChart) {
            ChartStyleDialogPanel.setBarChartValue((BarChart)chart1, i);
        } else if (chart1 instanceof PieChart) {
            ChartStyleDialogPanel.setPieChartValue((PieChart)chart1, i);
        } else if (chart1 instanceof LineChart) {
            ChartStyleDialogPanel.setLineChartValue((LineChart)chart1, i);
        }
    }

    public static void setBarChartValue(BarChart barchart, int i) {
        if (i < 0) {
            i = 831;
        }
        barchart.set3DModeOn((i & 1) != 0);
        barchart.setValueLinesOn((i & 2) != 0);
        barchart.setValueLabelsOn((i & 4) != 0);
        barchart.setLegendOn((i & 8) != 0);
        barchart.setBarLabelsOn((i & 0x10) != 0);
        barchart.setRangeLabelsOn((i & 0x20) != 0);
        barchart.setAutoLabelSpacingOn((i & 0x40) != 0);
        barchart.setBarOutlineOn((i & 0x80) != 0);
        barchart.setMultiColorOn((i & 0x100) != 0);
        barchart.setMultiSeriesOn((i & 0x200) != 0);
    }

    public static int getBarChartValue(BarChart barchart) {
        int i = 0;
        if (barchart.is3DModeOn()) {
            i |= 1;
        }
        if (barchart.isValueLinesOn()) {
            i |= 2;
        }
        if (barchart.isValueLabelsOn()) {
            i |= 4;
        }
        if (barchart.isLegendOn()) {
            i |= 8;
        }
        if (barchart.isBarLabelsOn()) {
            i |= 0x10;
        }
        if (barchart.isRangeLabelsOn()) {
            i |= 0x20;
        }
        if (barchart.isAutoLabelSpacingOn()) {
            i |= 0x40;
        }
        if (barchart.isBarOutlineOn()) {
            i |= 0x80;
        }
        if (barchart.isMultiColorOn()) {
            i |= 0x100;
        }
        if (barchart.isMultiSeriesOn()) {
            i |= 0x200;
        }
        return i;
    }

    public static void setPieChartValue(PieChart piechart, int i) {
        if (i < 0) {
            i = 63;
        }
        piechart.set3DModeOn((i & 1) != 0);
        piechart.setValueLabelsOn((i & 2) != 0);
        piechart.setPercentLabelsOn((i & 4) != 0);
        piechart.setSampleLabelsOn((i & 8) != 0);
        piechart.setPieLabelsOn((i & 0x10) != 0);
        piechart.setLegendOn((i & 0x20) != 0);
        piechart.setSliceSeperatorOn((i & 0x40) != 0);
    }

    public static int getPieChartValue(PieChart piechart) {
        int i = 0;
        if (piechart.is3DModeOn()) {
            i |= 1;
        }
        if (piechart.isValueLabelsOn()) {
            i |= 2;
        }
        if (piechart.isPercentLabelsOn()) {
            i |= 4;
        }
        if (piechart.isSampleLabelsOn()) {
            i |= 8;
        }
        if (piechart.isPieLabelsOn()) {
            i |= 0x10;
        }
        if (piechart.isLegendOn()) {
            i |= 0x20;
        }
        if (piechart.isSliceSeperatorOn()) {
            i |= 0x40;
        }
        return i;
    }

    public static void setLineChartValue(LineChart linechart, int i) {
        if (i < 0) {
            i = 636;
        }
        linechart.set3DModeOn((i & 1) != 0);
        linechart.setStackedOn((i & 2) != 0);
        linechart.setValueLinesOn((i & 4) != 0);
        linechart.setValueLabelsOn((i & 8) != 0);
        linechart.setLegendOn((i & 0x10) != 0);
        linechart.setSampleLabelsOn((i & 0x20) != 0);
        linechart.setRangeLabelsOn((i & 0x40) != 0);
        linechart.setRangeAdjusterOn((i & 0x80) != 0);
        linechart.setAutoLabelSpacingOn((i & 0x100) != 0);
    }

    public static int getLineChartValue(LineChart linechart) {
        int i = 0;
        if (linechart.is3DModeOn()) {
            i |= 1;
        }
        if (linechart.isStackedOn()) {
            i |= 2;
        }
        if (linechart.isValueLinesOn()) {
            i |= 4;
        }
        if (linechart.isValueLabelsOn()) {
            i |= 8;
        }
        if (linechart.isLegendOn()) {
            i |= 0x10;
        }
        if (linechart.isSampleLabelsOn()) {
            i |= 0x20;
        }
        if (linechart.isRangeLabelsOn()) {
            i |= 0x40;
        }
        if (linechart.isRangeAdjusterOn()) {
            i |= 0x80;
        }
        if (linechart.isAutoLabelSpacingOn()) {
            i |= 0x100;
        }
        return i;
    }

    private static BarChart createSampleBarChart(int i) {
        BarChart barchart = new BarChart(4);
        ChartStyleDialogPanel.setBarChartValue(barchart, i);
        barchart.setTitleOn(true);
        barchart.setRange(650.0);
        barchart.setLowerRange(0.0);
        barchart.setSeriesCount(3);
        barchart.setSampleCount(4);
        barchart.setSampleValues(0, new double[]{200.0, 300.0, 450.0, 400.0});
        barchart.setSampleValues(1, new double[]{300.0, 400.0, 620.0, 500.0});
        barchart.setSampleValues(2, new double[]{260.0, 320.0, 400.0, 300.0});
        barchart.setTitle("Example");
        barchart.setSeriesLabels(new String[]{"A", "B", "C"});
        barchart.setBarLabels(new String[]{"2000", "2001", "2002", "2003"});
        barchart.setBarType(0);
        barchart.setLegendPosition(1);
        barchart.setBarWidth(0.6);
        return barchart;
    }

    private static PieChart createSamplePieChart(int i) {
        PieChart piechart = new PieChart();
        ChartStyleDialogPanel.setPieChartValue(piechart, i);
        piechart.setTitleOn(true);
        piechart.setSeriesCount(3);
        piechart.setSampleCount(4);
        piechart.setSampleValues(0, new double[]{300.0, 400.0, 500.0, 700.0});
        piechart.setSampleValues(1, new double[]{240.0, 560.0, 300.0, 600.0});
        piechart.setSampleValues(2, new double[]{500.0, 700.0, 500.0, 500.0});
        piechart.setTitle("Example");
        piechart.setSeriesLabels(new String[]{"A", "B", "C"});
        piechart.setSampleLabels(new String[]{"2000", "2001", "2002", "2003"});
        piechart.setSampleColors(new Color[]{Color.red, Color.yellow, Color.orange});
        return piechart;
    }

    private static LineChart createSampleLineChart(int i) {
        LineChart linechart = new LineChart();
        ChartStyleDialogPanel.setLineChartValue(linechart, i);
        linechart.setTitleOn(true);
        linechart.setRange(800.0);
        linechart.setSeriesCount(3);
        linechart.setSampleCount(12);
        linechart.setSampleValues(0, new double[]{100.0, 170.0, 200.0, 150.0, 200.0, 250.0, 200.0, 300.0, 400.0, 300.0, 150.0, 50.0});
        linechart.setSampleValues(1, new double[]{200.0, 150.0, 100.0, 100.0, 200.0, 350.0, 300.0, 400.0, 500.0, 600.0, 400.0, 200.0});
        linechart.setSampleValues(2, new double[]{100.0, 120.0, 80.0, 50.0, 100.0, 50.0, 100.0, 150.0, 200.0, 250.0, 200.0, 50.0});
        linechart.setTitle("Example");
        linechart.setSeriesLabels(new String[]{"A", "B", "C"});
        linechart.setSampleLabels(new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"});
        return linechart;
    }
}

