/*
 * Decompiled with CFR 0.152.
 */
package softcore.borlanddx;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.Variant;
import softcore.dx.CodeData;
import softcore.table.DataWindow;
import softcore.util.Message;
import softcore.util.Utilities;
import softface.MainApp;
import softoperation.finance.erpdata.ErpdataDataWindow;

public class BdxCodeData
implements CodeData {
    private DataWindow dataWindow;
    final DataSet dataSet;
    boolean close;
    final int[] columnMap;
    Variant tmpVariant = new Variant();

    public int getColCount() {
        int i = 0;
        while (i < this.columnMap.length && this.columnMap[i] >= 0) {
            ++i;
        }
        return i;
    }

    public BdxCodeData(String s, String[] as) throws DataSetException {
        this.dataWindow = new ErpdataDataWindow();
        this.dataSet = this.dataWindow.openQueryDataSet(s);
        this.columnMap = BdxCodeData.findCodeNameMapColumn(this.dataSet, as);
        Column column = this.dataSet.getColumn(this.columnMap[0]);
        this.dataSet.setSort(new SortDescriptor(new String[]{column.getColumnName()}));
    }

    public BdxCodeData(DataWindow datawindow, String s) throws DataSetException {
        this.dataWindow = datawindow != null ? datawindow : new ErpdataDataWindow();
        this.dataSet = this.dataWindow.openQueryDataSet(s, false);
        this.columnMap = BdxCodeData.guessCodeNameMapColumn(this.dataSet);
        Column column = this.dataSet.getColumn(this.columnMap[0]);
        this.dataSet.setSort(new SortDescriptor(new String[]{column.getColumnName()}));
    }

    public BdxCodeData(String s) throws DataSetException {
        this(null, s);
    }

    public BdxCodeData(DataSet dataset, String[] as) {
        this.dataSet = dataset;
        this.columnMap = BdxCodeData.findCodeNameMapColumn(dataset, as);
    }

    public BdxCodeData(DataSet dataset) {
        this.dataSet = dataset;
        this.columnMap = BdxCodeData.guessCodeNameMapColumn(dataset);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public String getCode(int i, int j) {
        block7: {
            block6: {
                try {
                    if (this.columnMap[j] >= 0) break block6;
                    return null;
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception.getMessage());
                }
            }
            this.dataSet.getVariant(this.columnMap[j], i, this.tmpVariant);
            if (this.tmpVariant.getType() == 16) {
                return this.tmpVariant.getString();
            }
            if (!this.tmpVariant.isNull()) break block7;
            return null;
        }
        return this.tmpVariant.getAsObject().toString();
    }

    public String getParentCode(String s) {
        throw new UnsupportedOperationException("Method getParentCode() not yet implemented.");
    }

    public int getRowCount() {
        try {
            return this.dataSet.getRowCount();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        if (this.close) {
            try {
                this.dataSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.dataWindow.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int[] guessCodeNameMapColumn(DataSet dataset) {
        int[] ai = new int[]{-1, -1, -1};
        int i = 0;
        Column[] acolumn = dataset.getColumns();
        int j = 0;
        while (j < acolumn.length && i < 3) {
            if (!acolumn[j].isHidden()) {
                ai[i++] = j;
            }
            ++j;
        }
        return ai;
    }

    private static int[] findCodeNameMapColumn(DataSet dataset, String[] as) {
        Column[] acolumn = dataset.getColumns();
        int[] ai = new int[]{-1, -1, -1};
        int i = 0;
        while (i < acolumn.length) {
            String s = acolumn[i].getColumnName();
            int j = 0;
            while (j < as.length && j < 3) {
                if (as[j].equalsIgnoreCase(s)) {
                    ai[j] = i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return ai;
    }

    public int[] getParentRowPath(String s) {
        block7: {
            if (s != null) break block7;
            return null;
        }
        try {
            int[] ai = new int[32];
            int i = 0;
            int j = s.length();
            while (j > 0) {
                int k = Utilities.findDataSetRow(this.dataSet, s.substring(0, j));
                if (k >= 0) {
                    ai[i++] = k;
                }
                --j;
            }
            int[] ai1 = new int[i];
            int l = 0;
            while (l < i) {
                ai1[l] = ai[i - 1 - l];
                ++l;
            }
            return ai1;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public DataWindow getDataWindow() {
        return this.dataWindow;
    }

    public String getNameByCode(Object obj) {
        block4: {
            if (this.dataSet == null) {
                return null;
            }
            try {
                int i = Utilities.findDataSetRow(this.dataSet, obj);
                if (i >= 0) {
                    this.dataSet.getVariant(this.columnMap[1], i, this.tmpVariant);
                    return this.tmpVariant.getString();
                }
            }
            catch (Exception exception) {
                Message.out.println(exception);
                if (!MainApp.isDebug) break block4;
                System.out.println("seekDataSet " + obj + " from " + this.dataSet);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public Object[][] getCodeNameAsArray() {
        int i;
        Object[][] aobj;
        block5: {
            if (this.dataSet == null) {
                return null;
            }
            aobj = null;
            i = this.dataSet.getRowCount();
            if (i != 0) break block5;
            return null;
        }
        try {
            aobj = new Object[i][];
            int j = 0;
            while (j < i) {
                aobj[j] = new Object[2];
                this.dataSet.getVariant(this.columnMap[0], j, this.tmpVariant);
                aobj[j][0] = this.tmpVariant.getAsObject();
                this.dataSet.getVariant(this.columnMap[1], j, this.tmpVariant);
                aobj[j][1] = this.tmpVariant.getAsObject();
                ++j;
            }
        }
        catch (Exception exception) {
            Message.out.println(exception);
        }
        return aobj;
    }

    public void refresh(boolean flag) {
        try {
            this.dataSet.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

