/*
 * Decompiled with CFR 0.152.
 */
package softcore.dataset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import softcore.dataset.AbstractDataSet;
import softcore.dataset.DataColumn;
import softcore.dataset.DataSetException;
import softcore.util.JDBC;

public class JdbcDataSet
extends AbstractDataSet {
    private Statement stmt;
    private ResultSet rs;
    int rowAt = -1;

    public JdbcDataSet(Connection connection, String s) throws SQLException {
        if (connection == null) {
            connection = JDBC.getDefaultJdbcConnection();
        }
        this.stmt = connection.createStatement();
        this.rs = this.stmt.executeQuery(s);
        ResultSetMetaData resultsetmetadata = this.rs.getMetaData();
        int i = resultsetmetadata.getColumnCount();
        this.dataColumns = new DataColumn[i];
        int j = 0;
        while (j < i) {
            this.dataColumns[j] = new DataColumn();
            this.dataColumns[j].columnName = resultsetmetadata.getColumnName(j + 1);
            this.dataColumns[j].sqlType = resultsetmetadata.getColumnType(j + 1);
            this.dataColumns[j].size = resultsetmetadata.getPrecision(j + 1);
            this.dataColumns[j].decimals = resultsetmetadata.getScale(j + 1);
            ++j;
        }
    }

    public JdbcDataSet(String s) throws SQLException {
        this(null, s);
    }

    public void close() throws DataSetException {
        try {
            this.rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = null;
        try {
            this.stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt = null;
    }

    public int getRowCount() throws DataSetException {
        throw new DataSetException("getRowCount() not implement.");
    }

    public int getRow() throws DataSetException {
        return this.rowAt;
    }

    public void gotoRow(int i) throws DataSetException {
        try {
            if (i == this.rowAt + 1) {
                if (this.rs.next()) {
                    this.rowAt = i;
                    return;
                }
                throw new DataSetException("End of DataSet.");
            }
        }
        catch (SQLException sqlexception) {
            throw new DataSetException(sqlexception.getMessage());
        }
        throw new DataSetException();
    }

    public Object getValue(int i, int j) throws DataSetException {
        try {
            if (i == this.rowAt) {
                return this.rs.getObject(j + 1);
            }
        }
        catch (SQLException sqlexception) {
            throw new DataSetException(sqlexception.getMessage());
        }
        throw new DataSetException();
    }
}

