/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import softcore.datechooser.Pallet;
import softcore.datechooser.RoundBox;
import softcore.datechooser.TablePanel;

class ConfigLine
extends JPanel {
    private TablePanel tablePanel = null;
    private Calendar showMonth = null;
    private int startYear = 0;
    private int lastYear = 0;
    private int nowYear = 0;
    private int nowMonth = 0;
    Timer timer = new Timer(true);
    private RoundBox yearBox = null;
    private RoundBox monthBox = null;
    private JLabel txtYear = new JLabel("\u5e74");
    private JLabel txtMonth = new JLabel("\u6708");

    ConfigLine(TablePanel tablePanel, Calendar showMonth, int startYear, int lastYear) {
        this.tablePanel = tablePanel;
        this.showMonth = showMonth;
        this.startYear = startYear;
        this.lastYear = lastYear;
        this.nowYear = Integer.valueOf(new SimpleDateFormat("yyyy").format(showMonth.getTime()));
        this.nowMonth = Integer.valueOf(new SimpleDateFormat("M").format(showMonth.getTime()));
        this.yearBox = new RoundBox(this.nowYear, startYear, lastYear);
        this.monthBox = new RoundBox(this.nowMonth, 1, 12);
        this.makeFace();
        this.addListener();
    }

    private void makeFace() {
        Font txtFont = new Font("\u5b8b\u4f53", 0, 12);
        this.setBorder(null);
        this.setBackground(Pallet.configLineColor);
        this.setLayout(new FlowLayout(1, 7, 1));
        this.setPreferredSize(new Dimension(50, 19));
        this.txtYear.setForeground(Pallet.cfgTextColor);
        this.txtYear.setPreferredSize(new Dimension(14, 14));
        this.txtYear.setFont(txtFont);
        this.txtMonth.setForeground(Pallet.cfgTextColor);
        this.txtMonth.setPreferredSize(new Dimension(14, 14));
        this.txtMonth.setFont(txtFont);
        this.monthBox.setShowWidth(17);
        this.add(this.yearBox);
        this.add(this.txtYear);
        this.add(this.monthBox);
        this.add(this.txtMonth);
    }

    private void addListener() {
        this.yearBox.bt_UP.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ConfigLine.this.btPressed(ConfigLine.this.yearBox, 1);
            }

            public void mouseReleased(MouseEvent e) {
                ConfigLine.this.btReleased(ConfigLine.this.yearBox, 1);
                ConfigLine.this.nowYear = ((ConfigLine)ConfigLine.this).yearBox.showNow;
                ConfigLine.this.tablePanel.setMonth(ConfigLine.this.nowYear, ConfigLine.this.nowMonth);
            }
        });
        this.yearBox.bt_DOWN.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ConfigLine.this.btPressed(ConfigLine.this.yearBox, 2);
            }

            public void mouseReleased(MouseEvent e) {
                ConfigLine.this.btReleased(ConfigLine.this.yearBox, 2);
                ConfigLine.this.nowYear = ((ConfigLine)ConfigLine.this).yearBox.showNow;
                ConfigLine.this.tablePanel.setMonth(ConfigLine.this.nowYear, ConfigLine.this.nowMonth);
            }
        });
        this.monthBox.bt_UP.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ConfigLine.this.btPressed(ConfigLine.this.monthBox, 1);
            }

            public void mouseReleased(MouseEvent e) {
                ConfigLine.this.btReleased(ConfigLine.this.monthBox, 1);
                ConfigLine.this.nowMonth = ((ConfigLine)ConfigLine.this).monthBox.showNow;
                ConfigLine.this.tablePanel.setMonth(ConfigLine.this.nowYear, ConfigLine.this.nowMonth);
            }
        });
        this.monthBox.bt_DOWN.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ConfigLine.this.btPressed(ConfigLine.this.monthBox, 2);
            }

            public void mouseReleased(MouseEvent e) {
                ConfigLine.this.btReleased(ConfigLine.this.monthBox, 2);
                ConfigLine.this.nowMonth = ((ConfigLine)ConfigLine.this).monthBox.showNow;
                ConfigLine.this.tablePanel.setMonth(ConfigLine.this.nowYear, ConfigLine.this.nowMonth);
            }
        });
    }

    private void btPressed(RoundBox box, int theBT) {
        final RoundBox theBox = box;
        if (theBT == 1) {
            this.timer = new Timer(true);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    if (theBox.showNow < theBox.showMax) {
                        theBox.showing.setText("" + (theBox.showNow + 1));
                        ++theBox.showNow;
                    }
                }
            }, 500L, 100L);
        } else if (theBT == 2) {
            this.timer = new Timer(true);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    if (theBox.showNow > theBox.showMin) {
                        theBox.showing.setText("" + (theBox.showNow - 1));
                        --theBox.showNow;
                    }
                }
            }, 500L, 100L);
        }
    }

    private void btReleased(RoundBox box, int theBT) {
        RoundBox theBox = box;
        this.timer.cancel();
        if (theBT == 1) {
            if (theBox.showNow < theBox.showMax) {
                theBox.showing.setText("" + (theBox.showNow + 1));
                ++theBox.showNow;
            }
        } else if (theBT == 2 && theBox.showNow > theBox.showMin) {
            theBox.showing.setText("" + (theBox.showNow - 1));
            --theBox.showNow;
        }
    }
}

