/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import softcore.datechooser.MonthlyCalendar;

public class DateChooserx
extends JDialog {
    private Calendar calendar;
    private Calendar retCal;
    private JPanel basePanel;
    private JPanel containerPanel;
    private JPanel controlPanel;
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;
    private MonthlyCalendar monthCalendar;
    private JPanel viewPanel;

    public DateChooserx() {
        this.init();
    }

    public DateChooserx(Dialog owner) {
        super(owner);
        this.init();
    }

    public DateChooserx(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooserx(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooserx(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooserx(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public DateChooserx(Frame owner) {
        super(owner);
        this.init();
    }

    public DateChooserx(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public DateChooserx(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public DateChooserx(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public DateChooserx(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    private void init() {
        this.initComponents();
        this.calendar = Calendar.getInstance();
        int y = this.calendar.get(1);
        int m = this.calendar.get(2);
        this.jComboBox1.setSelectedIndex(m);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m + 1);
    }

    private void initComponents() {
        this.basePanel = new JPanel();
        this.containerPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jSpinner1 = new JSpinner();
        this.viewPanel = new JPanel();
        this.monthCalendar = new MonthlyCalendar(){

            protected void dateSelected() {
                DateChooserx.this.doSelection();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle("Date Chooser");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DateChooserx.this.formWindowClosing(evt);
            }
        });
        this.basePanel.setLayout(new FlowLayout(1, 10, 10));
        this.basePanel.setBackground(new Color(252, 250, 252));
        this.containerPanel.setLayout(new BorderLayout());
        this.containerPanel.setBorder(new TitledBorder("Date"));
        this.containerPanel.setOpaque(false);
        this.controlPanel.setLayout(new FlowLayout(1, 12, 0));
        this.controlPanel.setBorder(new EmptyBorder(new Insets(5, 0, 10, 0)));
        this.controlPanel.setOpaque(false);
        this.jComboBox1.setFont(new Font("Tahoma", 0, 11));
        this.jComboBox1.setMaximumRowCount(7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}));
        this.jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DateChooserx.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.controlPanel.add(this.jComboBox1);
        this.jSpinner1.setFont(new Font("Tahoma", 0, 11));
        this.jSpinner1.setModel(new SpinnerDateModel());
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "yyyy"));
        this.jSpinner1.setPreferredSize(this.jComboBox1.getPreferredSize());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DateChooserx.this.jSpinner1StateChanged(evt);
            }
        });
        this.controlPanel.add(this.jSpinner1);
        this.containerPanel.add((Component)this.controlPanel, "North");
        this.viewPanel.setLayout(new FlowLayout(1, 0, 0));
        this.viewPanel.setBorder(new EmptyBorder(new Insets(0, 0, 10, 0)));
        this.viewPanel.setOpaque(false);
        this.monthCalendar.setBorder(new BevelBorder(1));
        this.viewPanel.add(this.monthCalendar);
        this.containerPanel.add((Component)this.viewPanel, "Center");
        this.basePanel.add(this.containerPanel);
        this.getContentPane().add((Component)this.basePanel, "Center");
        this.pack();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Date date = (Date)this.jSpinner1.getValue();
        this.calendar.setTime(date);
        this.monthCalendar.setYear(this.calendar.get(1));
        this.monthCalendar.repaint();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        this.monthCalendar.setMonth(this.jComboBox1.getSelectedIndex() + 1);
        this.monthCalendar.repaint();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.retCal = null;
    }

    public void setVisible(boolean b) {
        this.monthCalendar.resetHighlight();
        super.setVisible(b);
    }

    private void doSelection() {
        this.retCal = this.monthCalendar.getSelectedDate();
        super.setVisible(false);
        this.dispose();
    }

    public Calendar getSelectedDate() {
        return this.retCal;
    }

    public void setYearMonth(int y, int m) {
        if (y < 1970) {
            throw new IllegalArgumentException("Year must be later than 1970.");
        }
        if (m < 1 || m > 12) {
            throw new IllegalArgumentException("Invalid month.");
        }
        this.jComboBox1.setSelectedIndex(m - 1);
        this.calendar.set(1, y);
        this.jSpinner1.setValue(this.calendar.getTime());
        this.monthCalendar.setYearMonth(y, m);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.monthCalendar.setWeekStartOnSunday(b);
    }

    public boolean getWeekStartOnSunday() {
        return this.monthCalendar.getWeekStartOnSunday();
    }
}

