/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MonthlyCalendar
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final String[] DEFAULT_HEADER_SYMBOLS = new String[]{"S", "M", "T", "W", "T", "F", "S"};
    public static final Font DEFAULT_FONT = new Font("Verdana", 0, 11);
    public static final Color DEFAULT_HEADER_BG = new Color(122, 150, 223);
    public static final Color DEFAULT_HEADER_FG = new Color(216, 228, 248);
    public static final Color DEFAULT_DATE_BG = Color.white;
    public static final Color DEFAULT_DATE_FG = Color.black;
    public static final Color DEFAULT_HIGHLIGHT_BG = new Color(0, 84, 227);
    public static final Color DEFAULT_HIGHLIGHT_FG = Color.white;
    public static final int DEFAULT_CELL_WIDTH = 24;
    public static final int DEFAULT_CELL_HEIGHT = 18;
    private int[] dateData = new int[42];
    private int year = -1;
    private int month = -1;
    private int hindex = -1;
    private int selectedDate = 0;
    private boolean startOnSunday = true;
    private int cellWidth = 24;
    private int cellHeight = 18;
    private Font headerFont = DEFAULT_FONT;
    private Font dateFont = DEFAULT_FONT;
    private Color headerBg = DEFAULT_HEADER_BG;
    private Color headerFg = DEFAULT_HEADER_FG;
    private Color dateBg = DEFAULT_DATE_BG;
    private Color dateFg = DEFAULT_DATE_FG;
    private Color highBg = DEFAULT_HIGHLIGHT_BG;
    private Color highFg = DEFAULT_HIGHLIGHT_FG;
    private JComponent headerComponent;
    private Dimension pSize = new Dimension(this.cellWidth * 7, this.cellHeight * 7);
    private int basex = 0;
    private int basey = 0;
    private boolean isListening;

    public MonthlyCalendar() {
        super.setPreferredSize(this.pSize);
        this.setMouseListeningEnabled(true);
    }

    public void setMouseListeningEnabled(boolean b) {
        if (b && !this.isListening) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else if (!b && this.isListening) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.isListening = b;
    }

    public boolean getMouseListeningEnabled() {
        return this.isListening;
    }

    public void setYear(int year) {
        if (year < 1970) {
            throw new IllegalArgumentException("Year must be later than 1970!");
        }
        if (this.month != -1) {
            this.setYearMonth(year, this.month);
        } else {
            this.year = year;
        }
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month specified!");
        }
        if (this.year != -1) {
            this.setYearMonth(this.year, month);
        } else {
            this.month = month;
        }
    }

    public int getMonth() {
        return this.month;
    }

    public void setYearMonth(int year, int month) {
        if (this.year == year && this.month == month) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        this.setYearMonth(calendar);
    }

    public void setYearMonth(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2) + 1;
        if (this.year == y && this.month == m) {
            return;
        }
        this.year = y;
        this.month = m;
        int backupDate = calendar.get(5);
        calendar.set(5, 1);
        int max = calendar.getActualMaximum(5);
        int start = calendar.get(7);
        start = this.startOnSunday ? --start : (start + 5) % 7;
        int i = 0;
        while (i < start) {
            this.dateData[i] = -1;
            ++i;
        }
        i = 0;
        while (i < max) {
            this.dateData[i + start] = i + 1;
            ++i;
        }
        i = start + max;
        while (i < 42) {
            this.dateData[i] = -1;
            ++i;
        }
        calendar.set(5, backupDate);
    }

    public void setWeekStartOnSunday(boolean b) {
        this.startOnSunday = b;
    }

    public boolean getWeekStartOnSunday() {
        return this.startOnSunday;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setDateFont(Font font) {
        this.dateFont = font;
    }

    public Font getDateFont() {
        return this.dateFont;
    }

    public void setHeaderBackground(Color c) {
        this.headerBg = c;
    }

    public Color getHeaderBackground() {
        return this.headerBg;
    }

    public void setHeaderForeground(Color c) {
        this.headerFg = c;
    }

    public Color getHeaderForeground() {
        return this.headerFg;
    }

    public void setDateBackground(Color c) {
        this.dateBg = c;
    }

    public Color getDateBackground() {
        return this.dateBg;
    }

    public void setDateForeground(Color c) {
        this.dateFg = c;
    }

    public Color getDateForeground() {
        return this.dateFg;
    }

    public void setHighlightBackground(Color c) {
        this.highBg = c;
    }

    public Color getHighlightBackground() {
        return this.highBg;
    }

    public void setHighlightForeground(Color c) {
        this.highFg = c;
    }

    public Color getHighlightForeground() {
        return this.highFg;
    }

    public void setCellDimension(Dimension d) {
        if (this.headerComponent != null) {
            return;
        }
        this.cellWidth = d.width;
        this.cellHeight = d.height;
        this.resize();
    }

    public Dimension getCellDimension() {
        return new Dimension(this.cellWidth, this.cellHeight);
    }

    private void resize() {
        int ah;
        int aw;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            aw = insets.left + insets.right;
            ah = insets.top + insets.bottom;
            this.basex = insets.left;
            this.basey = insets.top;
        } else {
            this.basey = 0;
            this.basex = 0;
            ah = 0;
            aw = 0;
        }
        if (this.headerComponent == null) {
            this.pSize.width = this.cellWidth * 7 + aw;
            this.pSize.height = this.cellHeight * 7 + ah;
        } else {
            Dimension d = this.headerComponent.getPreferredSize();
            this.cellWidth = d.width / 7;
            this.cellHeight = d.height;
            this.pSize.width = this.cellWidth * 7 + d.width % 7 + aw;
            this.pSize.height = this.cellHeight * 7 + ah;
            this.headerComponent.setBounds(this.basex, this.basey, d.width, d.height);
        }
        super.setPreferredSize(this.pSize);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.resize();
    }

    public void setHeaderComponent(JComponent comp) {
        this.removeAll();
        this.headerComponent = comp;
        if (comp != null) {
            this.add(comp);
        }
        this.resize();
    }

    public JComponent getHeaderComponent() {
        return this.headerComponent;
    }

    public final void setPreferredSize(Dimension d) {
    }

    protected final void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        if (this.headerComponent == null) {
            i = 0;
            while (i < 7) {
                int shift = this.startOnSunday ? i : (i + 6) % 7;
                int x = shift * this.cellWidth;
                int y = 0;
                MonthlyCalendar.paintSymbol(g, this.headerFont, this.headerBg, this.headerFg, DEFAULT_HEADER_SYMBOLS[i], this.basex + x, this.basey + y, this.cellWidth, this.cellHeight);
                ++i;
            }
        }
        if (this.year != -1 && this.month != -1) {
            i = 0;
            while (i < 42) {
                int x = this.cellWidth * (i % 7);
                int y = this.cellHeight * (i / 7 + 1);
                if (this.dateData[i] == -1) {
                    MonthlyCalendar.paintSymbol(g, this.dateFont, this.dateBg, this.dateFg, null, this.basex + x, this.basey + y, this.cellWidth, this.cellHeight);
                } else if (this.hindex == i) {
                    MonthlyCalendar.paintSymbol(g, this.dateFont, this.highBg, this.highFg, String.valueOf(this.dateData[i]), this.basex + x, this.basey + y, this.cellWidth, this.cellHeight);
                } else {
                    MonthlyCalendar.paintSymbol(g, this.dateFont, this.dateBg, this.dateFg, String.valueOf(this.dateData[i]), this.basex + x, this.basey + y, this.cellWidth, this.cellHeight);
                }
                ++i;
            }
        }
    }

    public static void paintSymbol(Graphics g, Font f, Color bg, Color fg, String s, int x, int y, int w, int h) {
        if (s == null) {
            g.setColor(bg);
            g.fillRect(x, y, w, h);
        } else {
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int sx = (w - fm.stringWidth(s)) / 2;
            int sy = (h - fm.getHeight()) / 2 + fm.getAscent();
            g.setColor(bg);
            g.fillRect(x, y, w, h);
            g.setColor(fg);
            g.drawString(s, x + sx, y + sy);
        }
    }

    public void resetHighlight() {
        this.hindex = -1;
    }

    public int getSelectedDay() {
        return this.selectedDate;
    }

    public Calendar getSelectedDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(this.year, this.month - 1, this.selectedDate);
        return cal;
    }

    public final void mouseEntered(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse handler to any component other than itself.");
        }
    }

    public final void mouseExited(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse handler to any component other than itself.");
        }
        this.hindex = -1;
        this.repaint();
    }

    public final void mouseClicked(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse handler to any component other than itself.");
        }
        int x = e.getX();
        int y = e.getY();
        int i = x / this.cellWidth;
        int j = y / this.cellHeight;
        if (--j >= 0 && this.dateData[j * 7 + i] != -1) {
            this.selectedDate = this.dateData[j * 7 + i];
            this.dateSelected();
        } else {
            this.selectedDate = 0;
        }
    }

    public final void mousePressed(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse handler to any component other than itself.");
        }
    }

    public final void mouseReleased(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse handler to any component other than itself.");
        }
    }

    public final void mouseMoved(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse motion handler to any component other than itself.");
        }
        this.mousePositionChanged(e);
    }

    public final void mouseDragged(MouseEvent e) {
        if (e.getSource() != this) {
            throw new RuntimeException("You are not supposed to install 'this' mouse motion handler to any component other than itself.");
        }
        this.mousePositionChanged(e);
    }

    private void mousePositionChanged(MouseEvent e) {
        int x = e.getX() - this.basex;
        int y = e.getY() - this.basey - this.cellHeight;
        int width = this.cellWidth * 7;
        int height = this.cellHeight * 6;
        if (x < 0 || x >= width || y < 0 || y >= height) {
            if (this.hindex != -1) {
                this.hindex = -1;
                this.repaint();
            }
            return;
        }
        int j = y / this.cellHeight;
        int i = x / this.cellWidth;
        this.hindex = this.dateData[j * 7 + i] != -1 ? j * 7 + i : -1;
        this.repaint();
    }

    protected void dateSelected() {
    }
}

