/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MyCalendar
extends JApplet {
    public static final String WEEK_SUN = "SUN";
    public static final String WEEK_MON = "MON";
    public static final String WEEK_TUE = "TUE";
    public static final String WEEK_WED = "WED";
    public static final String WEEK_THU = "THU";
    public static final String WEEK_FRI = "FRI";
    public static final String WEEK_SAT = "SAT";
    public static final Color background = Color.white;
    public static final Color foreground = Color.black;
    public static final Color headerBackground = Color.blue;
    public static final Color headerForeground = Color.white;
    public static final Color selectedBackground = Color.blue;
    public static final Color selectedForeground = Color.white;
    private JPanel cPane = (JPanel)this.getContentPane();
    private JLabel yearsLabel;
    private JSpinner yearsSpinner;
    private JLabel monthsLabel;
    private JComboBox monthsComboBox;
    private JTable daysTable;
    private AbstractTableModel daysModel;
    private Calendar calendar;

    public void init() {
        this.cPane.setLayout(new BorderLayout());
        this.calendar = Calendar.getInstance();
        this.calendar = Calendar.getInstance();
        this.yearsLabel = new JLabel("Year: ");
        this.yearsSpinner = new JSpinner();
        this.yearsSpinner.setEditor(new JSpinner.NumberEditor(this.yearsSpinner, "0000"));
        this.yearsSpinner.setValue(new Integer(this.calendar.get(1)));
        this.yearsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int day = MyCalendar.this.calendar.get(5);
                MyCalendar.this.calendar.set(5, 1);
                MyCalendar.this.calendar.set(1, (Integer)MyCalendar.this.yearsSpinner.getValue());
                int maxDay = MyCalendar.this.calendar.getActualMaximum(5);
                MyCalendar.this.calendar.set(5, day > maxDay ? maxDay : day);
                MyCalendar.this.updateView();
            }
        });
        JPanel yearMonthPanel = new JPanel();
        this.cPane.add((Component)yearMonthPanel, "North");
        yearMonthPanel.setLayout(new BorderLayout());
        yearMonthPanel.add((Component)new JPanel(), "Center");
        JPanel yearPanel = new JPanel();
        yearMonthPanel.add((Component)yearPanel, "West");
        yearPanel.setLayout(new BorderLayout());
        yearPanel.add((Component)this.yearsLabel, "West");
        yearPanel.add((Component)this.yearsSpinner, "Center");
        this.monthsLabel = new JLabel("Month: ");
        this.monthsComboBox = new JComboBox();
        int i = 1;
        while (i <= 12) {
            this.monthsComboBox.addItem(new Integer(i));
            ++i;
        }
        this.monthsComboBox.setSelectedIndex(this.calendar.get(2));
        this.monthsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int day = MyCalendar.this.calendar.get(5);
                MyCalendar.this.calendar.set(5, 1);
                MyCalendar.this.calendar.set(2, MyCalendar.this.monthsComboBox.getSelectedIndex());
                int maxDay = MyCalendar.this.calendar.getActualMaximum(5);
                MyCalendar.this.calendar.set(5, day > maxDay ? maxDay : day);
                MyCalendar.this.updateView();
            }
        });
        JPanel monthPanel = new JPanel();
        yearMonthPanel.add((Component)monthPanel, "East");
        monthPanel.setLayout(new BorderLayout());
        monthPanel.add((Component)this.monthsLabel, "West");
        monthPanel.add((Component)this.monthsComboBox, "Center");
        this.daysModel = new AbstractTableModel(){

            public int getRowCount() {
                return 7;
            }

            public int getColumnCount() {
                return 7;
            }

            public Object getValueAt(int row, int column) {
                if (row == 0) {
                    return MyCalendar.getHeader(column);
                }
                Calendar calendar = (Calendar)MyCalendar.this.calendar.clone();
                calendar.set(5, 1);
                int dayCount = calendar.getActualMaximum(5);
                int moreDayCount = calendar.get(7) - 1;
                int index = --row * 7 + column;
                int dayIndex = index - moreDayCount + 1;
                if (index < moreDayCount || dayIndex > dayCount) {
                    return null;
                }
                return new Integer(dayIndex);
            }
        };
        this.daysTable = new CalendarTable((TableModel)this.daysModel, this.calendar);
        this.daysTable.setCellSelectionEnabled(true);
        this.daysTable.setSelectionMode(0);
        this.daysTable.setDefaultRenderer(this.daysTable.getColumnClass(0), new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String text = value == null ? "" : value.toString();
                JLabel cell = new JLabel(text);
                cell.setOpaque(true);
                if (row == 0) {
                    cell.setForeground(headerForeground);
                    cell.setBackground(headerBackground);
                } else if (isSelected) {
                    cell.setForeground(selectedForeground);
                    cell.setBackground(selectedBackground);
                } else {
                    cell.setForeground(foreground);
                    cell.setBackground(background);
                }
                return cell;
            }
        });
        this.updateView();
        this.cPane.add((Component)this.daysTable, "Center");
    }

    public static String getHeader(int index) {
        switch (index) {
            case 0: {
                return WEEK_SUN;
            }
            case 1: {
                return WEEK_MON;
            }
            case 2: {
                return WEEK_TUE;
            }
            case 3: {
                return WEEK_WED;
            }
            case 4: {
                return WEEK_THU;
            }
            case 5: {
                return WEEK_FRI;
            }
            case 6: {
                return WEEK_SAT;
            }
        }
        return null;
    }

    public void updateView() {
        this.daysModel.fireTableDataChanged();
        this.daysTable.setRowSelectionInterval(this.calendar.get(4), this.calendar.get(4));
        this.daysTable.setColumnSelectionInterval(this.calendar.get(7) - 1, this.calendar.get(7) - 1);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Calendar Application");
        frame.setDefaultCloseOperation(3);
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.init();
        frame.getContentPane().add(myCalendar);
        frame.setSize(240, 172);
        frame.show();
    }

    public static class CalendarTable
    extends JTable {
        private Calendar calendar;

        public CalendarTable(TableModel model, Calendar calendar) {
            super(model);
            this.calendar = calendar;
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            super.changeSelection(row, column, toggle, extend);
            if (row == 0) {
                return;
            }
            Object obj = this.getValueAt(row, column);
            if (obj != null) {
                this.calendar.set(5, (Integer)obj);
            }
        }
    }
}

