/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import softcore.datechooser.Pallet;

class RoundBox
extends JPanel {
    public int showMin = 0;
    public int showMax = 0;
    public int showNow = 0;
    public JLabel showing = new JLabel("", 4);
    private int showWidth = 35;
    private int showHeight = 15;
    public JButton bt_DOWN = new JButton("-");
    public JButton bt_UP = new JButton("+");

    RoundBox(int showNow, int showMin, int showMax) {
        if (showNow >= showMin && showNow <= showMax) {
            this.showNow = showNow;
            this.showMin = showMin;
            this.showMax = showMax;
        }
        this.makeFace();
    }

    private void makeFace() {
        Font txtFont = new Font("\u5b8b\u4f53", 0, 12);
        this.setLayout(new FlowLayout(1, 2, 1));
        this.setBackground(Pallet.configLineColor);
        this.setBorder(null);
        this.showing.setText("" + this.showNow);
        this.showing.setBorder(new LineBorder(Pallet.rbBorderColor, 1));
        this.showing.setForeground(Pallet.rbFontColor);
        this.showing.setPreferredSize(new Dimension(this.showWidth, this.showHeight));
        this.showing.setFont(txtFont);
        this.bt_UP.setBorder(new LineBorder(Pallet.rbBorderColor, 1));
        this.bt_UP.setBackground(Pallet.rbButtonColor);
        this.bt_UP.setForeground(Pallet.rbBtFontColor);
        this.bt_UP.setPreferredSize(new Dimension(15, 7));
        this.bt_UP.setFont(txtFont);
        this.bt_UP.setFocusable(false);
        this.bt_DOWN.setBorder(new LineBorder(Pallet.rbBorderColor, 1));
        this.bt_DOWN.setBackground(Pallet.rbButtonColor);
        this.bt_DOWN.setForeground(Pallet.rbBtFontColor);
        this.bt_DOWN.setPreferredSize(new Dimension(15, 7));
        this.bt_DOWN.setFont(txtFont);
        this.bt_DOWN.setFocusable(false);
        JPanel btPanel = new JPanel(new BorderLayout(0, 1));
        btPanel.setBorder(null);
        btPanel.setBackground(Pallet.configLineColor);
        btPanel.add((Component)this.bt_UP, "North");
        btPanel.add((Component)this.bt_DOWN, "South");
        this.add(this.showing);
        this.add(btPanel);
    }

    public void setShowWidth(int showWidth) {
        if (showWidth > 0) {
            this.showWidth = showWidth;
        }
        this.showing.setPreferredSize(new Dimension(showWidth, this.showHeight));
    }
}

