/*
 * Decompiled with CFR 0.152.
 */
package softcore.datechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import softcore.datechooser.DateChooser;
import softcore.datechooser.MonthMaker;
import softcore.datechooser.Pallet;

class TablePanel
extends JPanel {
    DateChooser dateChooser = null;
    private Calendar showMonth = null;
    private Date selectedDate = null;
    private String[] colname = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private String[][] date = new String[7][7];
    private DefaultTableModel model;
    private JTable table;

    TablePanel(DateChooser dateChooser, Calendar showMonth) {
        this.dateChooser = dateChooser;
        this.showMonth = showMonth;
        this.makeFace();
        this.addListener();
    }

    private void makeFace() {
        this.date[0][0] = "\u65e5";
        this.date[0][1] = "\u4e00";
        this.date[0][2] = "\u4e8c";
        this.date[0][3] = "\u4e09";
        this.date[0][4] = "\u56db";
        this.date[0][5] = "\u4e94";
        this.date[0][6] = "\u516d";
        this.model = new DefaultTableModel(this.date, this.colname){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.setFont(new Font("\u5b8b\u4f53", 0, 12));
        DefaultTableCellRenderer tcr = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(4);
                if (row == 0) {
                    this.setBackground(Pallet.backGroundColor);
                } else if (("" + new GregorianCalendar().get(5)).equals(TablePanel.this.date[row][column])) {
                    this.setBackground(Pallet.todayBackColor);
                } else {
                    this.setBackground(Pallet.palletTableColor);
                }
                if (column == 0 && row != 0 || column == 6 && row != 0) {
                    this.setForeground(Pallet.weekendFontColor);
                } else if (row != 0 && column != 0 && column != 6) {
                    this.setForeground(Pallet.dateFontColor);
                } else {
                    this.setForeground(Pallet.weekFontColor);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        };
        int i = 0;
        while (i < this.colname.length) {
            this.table.getColumn(this.colname[i]).setCellRenderer(tcr);
            ++i;
        }
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.setMonth(this.showMonth);
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
    }

    private void addListener() {
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selectedRow = TablePanel.this.table.getSelectedRow();
                    int selectedColumn = TablePanel.this.table.getSelectedColumn();
                    if (selectedRow > 0 && !TablePanel.this.date[selectedRow][selectedColumn].equals("")) {
                        TablePanel.this.showMonth.set(5, Integer.valueOf(TablePanel.this.date[selectedRow][selectedColumn]));
                        TablePanel.this.selectedDate = TablePanel.this.showMonth.getTime();
                        TablePanel.this.dateChooser.hideChooser();
                    }
                }
            }
        });
    }

    private void setMonth(Calendar showMonth) {
        this.showMonth = showMonth;
        String[][] tmpDate = MonthMaker.makeMonth(showMonth);
        int i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 7) {
                this.date[i][j] = tmpDate[i - 1][j];
                this.table.setValueAt(tmpDate[i - 1][j], i, j);
                ++j;
            }
            ++i;
        }
    }

    public void setMonth(int year, int month) {
        this.showMonth.set(year, month - 1, 1);
        this.setMonth(this.showMonth);
    }

    public Date getDate() {
        return this.selectedDate;
    }
}

