/*
 * Decompiled with CFR 0.152.
 */
package softcore.dbf;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import softcore.util.KeyValueGetter;

public class DbfRead
implements KeyValueGetter {
    private InputStream is;
    boolean autoClose;
    final int year;
    final int month;
    final int day;
    final int recordCount;
    int currentRecord = 0;
    String[] columnName;
    byte[] columnType;
    short[] columnSize;
    short[] columnDeci;
    final byte[] recordBuffer;

    private int readInt() throws IOException {
        int l;
        int k;
        int j;
        int i = this.is.read();
        if ((i | (j = this.is.read()) | (k = this.is.read()) | (l = this.is.read())) < 0) {
            throw new EOFException();
        }
        return (l << 24) + (k << 16) + (j << 8) + (i << 0);
    }

    private int readShort() throws IOException {
        int j;
        int i = this.is.read();
        if ((i | (j = this.is.read())) < 0) {
            throw new EOFException();
        }
        return (short)((j << 8) + (i << 0));
    }

    private String readString(int i) throws IOException {
        byte[] abyte0 = new byte[i];
        int j = -1;
        int k = 0;
        while (k < i) {
            int l = this.is.read();
            if (l > 0) {
                abyte0[k] = (byte)l;
            } else if (j == -1) {
                j = k;
            }
            ++k;
        }
        if (j == -1) {
            j = i;
        }
        return this.readString(abyte0, 0, j);
    }

    private String readString(byte[] abyte0, int i, int j) {
        while (j > 0 && abyte0[i + j - 1] >= 0 && abyte0[i + j - 1] <= 32) {
            --j;
        }
        return new String(abyte0, i, j);
    }

    public DbfRead(InputStream inputstream) throws IOException {
        this.is = inputstream;
        int i = inputstream.read();
        this.year = inputstream.read();
        this.month = inputstream.read();
        this.day = inputstream.read();
        this.recordCount = this.readInt();
        int j = this.readShort();
        int k = this.readShort();
        inputstream.skip(20L);
        int l = (j - 32) / 32;
        this.columnName = new String[l];
        this.columnType = new byte[l];
        this.columnSize = new short[l];
        this.columnDeci = new short[l];
        if (i == 48) {
            int i1 = 32;
            int k1 = 0;
            int byte0 = 11;
            byte[] abyte0 = new byte[byte0];
            int l1 = 0;
            while (i1 < j && l1 < l) {
                int i2 = -1;
                int j2 = 0;
                while (j2 < byte0) {
                    int k2 = inputstream.read();
                    if (k2 > 0) {
                        abyte0[j2] = (byte)k2;
                    } else if (i2 == -1) {
                        i2 = j2;
                    }
                    ++j2;
                }
                if (i2 == -1) {
                    i2 = byte0;
                }
                if (abyte0[0] == 13) {
                    k1 = l1;
                    inputstream.skip(j - i1 - 11);
                    break;
                }
                this.columnName[l1] = this.readString(abyte0, 0, i2);
                this.columnType[l1] = (byte)inputstream.read();
                inputstream.skip(4L);
                this.columnSize[l1] = (short)inputstream.read();
                this.columnDeci[l1] = (short)inputstream.read();
                inputstream.skip(14L);
                i1 += 32;
                ++l1;
            }
            if (k1 < l) {
                String[] as = new String[k1];
                byte[] abyte1 = new byte[k1];
                short[] aword0 = new short[k1];
                short[] aword1 = new short[k1];
                System.arraycopy(this.columnName, 0, as, 0, k1);
                System.arraycopy(this.columnType, 0, abyte1, 0, k1);
                System.arraycopy(this.columnSize, 0, aword0, 0, k1);
                System.arraycopy(this.columnDeci, 0, aword1, 0, k1);
                this.columnName = as;
                this.columnType = abyte1;
                this.columnSize = aword0;
                this.columnDeci = aword1;
            }
        } else {
            int j1 = 0;
            while (j1 < l) {
                this.columnName[j1] = this.readString(11);
                this.columnType[j1] = (byte)inputstream.read();
                inputstream.skip(4L);
                this.columnSize[j1] = (short)inputstream.read();
                this.columnDeci[j1] = (short)inputstream.read();
                inputstream.skip(14L);
                ++j1;
            }
            if (inputstream.read() != 13) {
                throw new IOException();
            }
        }
        this.recordBuffer = new byte[k];
    }

    public DbfRead(String s) throws FileNotFoundException, IOException {
        this(new FileInputStream(s));
        this.autoClose = true;
    }

    public boolean isOpen() {
        return this.is != null;
    }

    public void close() {
        if (this.is != null && this.autoClose) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.is = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getColumnCount() {
        return this.columnName.length;
    }

    public String getColumnName(int i) {
        return this.columnName[i];
    }

    public char getColumnType(int i) {
        return (char)this.columnType[i];
    }

    public short getColumnSize(int i) {
        return this.columnSize[i];
    }

    public short getColumnDeci(int i) {
        return this.columnDeci[i];
    }

    public boolean next() throws IOException {
        if (this.currentRecord >= this.recordCount) {
            return false;
        }
        int i = 0;
        while (i < this.recordBuffer.length) {
            this.recordBuffer[i] = (byte)this.is.read();
            ++i;
        }
        ++this.currentRecord;
        return true;
    }

    public Object getColumnValue(int i) throws IOException {
        int j = 1;
        int k = 0;
        while (k < i) {
            j += this.columnSize[k];
            ++k;
        }
        String s = this.readString(this.recordBuffer, j, this.columnSize[i]);
        if (this.columnType[i] == 67) {
            return s;
        }
        if (this.columnType[i] == 78) {
            int l1;
            int l = this.columnDeci[i];
            int j1 = s.indexOf(46);
            if (j1 >= 0 && (l1 = s.length() - (j1 + 1)) > l) {
                l = l1;
            }
            if (s.length() == 0) {
                return null;
            }
            if (l == 0 && this.columnSize[i] < 9) {
                return Integer.valueOf(s.trim());
            }
            return new BigDecimal(s.trim()).setScale(l, 4);
        }
        if (this.columnType[i] == 68) {
            if (s == null || s.length() == 0) {
                return null;
            }
            int i1 = Integer.parseInt(s.substring(0, 4));
            int k1 = Integer.parseInt(s.substring(4, 6));
            int i2 = Integer.parseInt(s.substring(6, 8));
            GregorianCalendar gregoriancalendar = new GregorianCalendar();
            gregoriancalendar.clear();
            gregoriancalendar.set(1, i1);
            gregoriancalendar.set(2, k1 - 1);
            gregoriancalendar.set(5, i2);
            return gregoriancalendar.getTime();
        }
        if (this.columnType[i] == 76) {
            return new Boolean("T".equals(s));
        }
        throw new IOException("Unknown DBF column type '" + this.columnType[i] + "'");
    }

    public int getColumnIndex(String s) {
        int i = 0;
        while (i < this.columnName.length) {
            if (this.columnName[i].equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getColumnValue(String s) throws IOException {
        int i = this.getColumnIndex(s);
        if (i < 0) {
            throw new IOException();
        }
        return this.getColumnValue(i);
    }

    public Object getValue(Object obj) {
        try {
            return this.getColumnValue((String)obj);
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    public boolean isDeleted() {
        return this.recordBuffer[0] == 42;
    }
}

