/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FontChooser
extends JDialog
implements ActionListener {
    JColorChooser colorChooser;
    JComboBox fontName;
    JCheckBox fontBold;
    JCheckBox fontItalic;
    JTextField fontSize;
    JLabel previewLabel;
    SimpleAttributeSet attributes;
    Font newFont;
    Color newColor;

    public FontChooser(Frame parent) {
        super(parent, "\u5b57\u4f53\u9009\u62e9", true);
        this.setSize(450, 450);
        this.attributes = new SimpleAttributeSet();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FontChooser.this.closeAndCancel();
            }
        });
        Container c = this.getContentPane();
        JPanel fontPanel = new JPanel();
        this.fontName = new JComboBox();
        GraphicsEnvironment graphicsenvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] afont = graphicsenvironment.getAllFonts();
        int i = 0;
        while (i < afont.length) {
            String s = afont[i].getFontName();
            if (s != null && s.length() > 0) {
                if (s.charAt(0) < '\u0000' || s.charAt(0) > '\u007f') {
                    this.fontName.insertItemAt(s, 0);
                } else {
                    this.fontName.addItem(s);
                }
            }
            ++i;
        }
        this.fontName.setSelectedIndex(1);
        this.fontName.addActionListener(this);
        this.fontSize = new JTextField("12", 4);
        this.fontSize.setHorizontalAlignment(4);
        this.fontSize.addActionListener(this);
        this.fontBold = new JCheckBox("Bold");
        this.fontBold.setSelected(true);
        this.fontBold.addActionListener(this);
        this.fontItalic = new JCheckBox("Italic");
        this.fontItalic.addActionListener(this);
        fontPanel.add(this.fontName);
        fontPanel.add(new JLabel(" Size: "));
        fontPanel.add(this.fontSize);
        fontPanel.add(this.fontBold);
        fontPanel.add(this.fontItalic);
        c.add((Component)fontPanel, "North");
        this.colorChooser = new JColorChooser(Color.black);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FontChooser.this.updatePreviewColor();
            }
        });
        c.add((Component)this.colorChooser, "Center");
        JPanel previewPanel = new JPanel(new BorderLayout());
        this.previewLabel = new JLabel("Here's a sample of this font.");
        this.previewLabel.setForeground(this.colorChooser.getColor());
        previewPanel.add((Component)this.previewLabel, "Center");
        JButton okButton = new JButton("\u786e\u5b9a");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontChooser.this.closeAndSave();
            }
        });
        JButton cancelButton = new JButton("\u53d6\u6d88");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontChooser.this.closeAndCancel();
            }
        });
        JPanel controlPanel = new JPanel();
        controlPanel.add(okButton);
        controlPanel.add(cancelButton);
        previewPanel.add((Component)controlPanel, "South");
        previewPanel.setMinimumSize(new Dimension(100, 100));
        previewPanel.setPreferredSize(new Dimension(100, 100));
        c.add((Component)previewPanel, "South");
    }

    public void actionPerformed(ActionEvent ae) {
        if (!StyleConstants.getFontFamily(this.attributes).equals(this.fontName.getSelectedItem())) {
            StyleConstants.setFontFamily(this.attributes, (String)this.fontName.getSelectedItem());
        }
        if (StyleConstants.getFontSize(this.attributes) != Integer.parseInt(this.fontSize.getText())) {
            StyleConstants.setFontSize(this.attributes, Integer.parseInt(this.fontSize.getText()));
        }
        if (StyleConstants.isBold(this.attributes) != this.fontBold.isSelected()) {
            StyleConstants.setBold(this.attributes, this.fontBold.isSelected());
        }
        if (StyleConstants.isItalic(this.attributes) != this.fontItalic.isSelected()) {
            StyleConstants.setItalic(this.attributes, this.fontItalic.isSelected());
        }
        this.updatePreviewFont();
    }

    protected void updatePreviewFont() {
        String name = StyleConstants.getFontFamily(this.attributes);
        boolean bold = StyleConstants.isBold(this.attributes);
        boolean ital = StyleConstants.isItalic(this.attributes);
        int size = StyleConstants.getFontSize(this.attributes);
        Font f = new Font(name, (bold ? 1 : 0) + (ital ? 2 : 0), size);
        this.previewLabel.setFont(f);
    }

    protected void updatePreviewColor() {
        this.previewLabel.setForeground(this.colorChooser.getColor());
        this.previewLabel.repaint();
    }

    public Font getNewFont() {
        return this.newFont;
    }

    public Color getNewColor() {
        return this.newColor;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public void closeAndSave() {
        this.newFont = this.previewLabel.getFont();
        this.newColor = this.previewLabel.getForeground();
        this.setVisible(false);
    }

    public void closeAndCancel() {
        this.newFont = null;
        this.newColor = null;
        this.setVisible(false);
    }
}

