/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import softcore.print.Print;

public class PageWrite {
    final DataOutput os;

    public PageWrite(DataOutput dataoutput) {
        this.os = dataoutput;
    }

    void writeRect(Rectangle rectangle) throws IOException {
        this.os.writeDouble(rectangle.getX());
        this.os.writeDouble(rectangle.getY());
        this.os.writeDouble(rectangle.getWidth());
        this.os.writeDouble(rectangle.getHeight());
    }

    void writeColor(Color color) throws IOException {
        if (color == null) {
            color = Color.black;
        }
        this.os.writeInt((color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF);
    }

    void writeFont(Font font) throws IOException {
        this.os.writeUTF(font.getFontName());
        this.os.writeInt(font.getStyle());
        this.os.writeInt(font.getSize());
    }

    void writeCell(Print.TextCell textcell) throws IOException {
        this.os.writeByte(1);
        this.writeRect(textcell);
        this.os.writeUTF(textcell.id != null ? textcell.id : "");
        this.os.writeShort((short)textcell.groupTag);
        this.writeColor(textcell.color);
        this.os.writeUTF(textcell.text != null ? textcell.text : "");
        this.writeFont(textcell.font);
        this.os.writeInt(textcell.format);
        this.os.writeInt(textcell.lineGap);
    }

    void writeCell(Print.LineCell linecell) throws IOException {
        this.os.writeByte(2);
        this.writeRect(linecell);
        this.os.writeShort((short)linecell.groupTag);
        this.writeColor(linecell.color);
        this.os.writeInt(linecell.penStyle);
    }

    void writeCell(Print.BoolCell boolcell) throws IOException {
        this.os.writeByte(3);
        this.writeRect(boolcell);
        this.os.writeShort((short)boolcell.groupTag);
        this.writeColor(boolcell.color);
    }

    void writePage(Print print, Print.Page page) throws IOException {
        this.os.writeByte(1);
        this.os.writeInt(print.getOrientation());
        this.os.writeBoolean(print.printLandScape());
        this.os.writeInt(page.defaultRuleUnit);
        this.os.writeDouble(print.getPageWidth());
        this.os.writeDouble(print.getPageHeight());
        int i = 0;
        while (i < page.cellSet.size()) {
            Print.PrintCell printcell = (Print.PrintCell)page.cellSet.elementAt(i);
            if (printcell instanceof Print.TextCell) {
                this.writeCell((Print.TextCell)printcell);
            } else if (printcell instanceof Print.LineCell) {
                this.writeCell((Print.LineCell)printcell);
            } else if (printcell instanceof Print.BoolCell) {
                this.writeCell((Print.BoolCell)printcell);
            }
            ++i;
        }
        this.os.writeByte(0);
        ((OutputStream)((Object)this.os)).flush();
    }

    public void writePages(Print print) throws IOException {
        Vector vector = print.getPages();
        int i = 0;
        while (i < vector.size()) {
            this.writePage(print, (Print.Page)vector.elementAt(i));
            ++i;
        }
        this.os.writeByte(0);
    }
}

