/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import softcore.awt.AwtUtil;
import softcore.awt.DialogPanel;
import softcore.print.PreviewPanel;
import softcore.print.PreviewView;
import softcore.print.PrintablePages;
import softface.MainFrame;
import softface.mdi.JMDIDesktopPane;
import softface.mdi.JMDIFrame;

public class PreviewFrame
extends JMDIFrame {
    final PreviewPanel previewPanel;

    public PreviewFrame(String s, PrintablePages printablepages) {
        this(s, new PreviewView(printablepages));
        this.setMenu(MainFrame.MenuBar);
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
    }

    public PreviewFrame(String s, PreviewView previewview) {
        this.setDefaultCloseOperation(2);
        this.previewPanel = new PreviewPanel(previewview);
        this.getContentPane().add((Component)this.previewPanel, "Center");
    }

    public PreviewView getPreviewView() {
        return this.previewPanel.getPreviewView();
    }

    public static PreviewFrame preview(String s, PrintablePages printablepages) {
        PreviewFrame previewframe = new PreviewFrame(s, printablepages);
        previewframe.setSize(650, 500);
        JMDIDesktopPane appdesktoppane = MainFrame.getDesktopPane();
        if (appdesktoppane == null) {
            return null;
        }
        previewframe.addInternalFrameListener(appdesktoppane);
        AwtUtil.locateRandom(previewframe, appdesktoppane);
        appdesktoppane.add((Component)previewframe, new Integer(JLayeredPane.PALETTE_LAYER + 1));
        try {
            previewframe.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        previewframe.setVisible(true);
        return previewframe;
    }

    public static JFrame preview(JFrame jframe, String s, PrintablePages printablepages, boolean flag) {
        PreviewPanel previewpanel = new PreviewPanel(printablepages);
        if (jframe == null) {
            jframe = new JFrame(s);
        }
        jframe.setSize(650, 500);
        jframe.getContentPane().setLayout(new BorderLayout());
        jframe.getContentPane().add((Component)previewpanel, "Center");
        if (flag) {
            jframe.setVisible(true);
        }
        return jframe;
    }

    public static DialogPanel createDialogPanel(Component component, String s, PrintablePages printablepages) {
        final PreviewPanel previewPanel = new PreviewPanel(printablepages);
        DialogPanel dialogpanel = new DialogPanel(){

            protected boolean onOkExit() {
                try {
                    previewPanel.getPreviewView().stopEditCell();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.onOkExit();
            }
        };
        dialogpanel.nPosInsetY = 0;
        dialogpanel.nPosInsetX = 0;
        dialogpanel.defaultExitButton = -1;
        dialogpanel.setLayout(new BorderLayout());
        dialogpanel.add((Component)previewPanel, "Center");
        dialogpanel.createDialogParent(component, s, null);
        return dialogpanel;
    }
}

