/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import softcore.print.PreviewView;
import softcore.print.PrintablePages;
import softcore.util.Constants;
import softcore.util.Message;
import softcore.util.Utilities;

public class PreviewPanel
extends JPanel
implements ActionListener,
ItemListener {
    final JToolBar toolBar = new JToolBar();
    final JButton[] toolbarButtons = new JButton[8];
    final JLabel pageStatus = new JLabel();
    final JComboBox drarRateComboBox = new JComboBox();
    final PreviewView previewView;
    JScrollPane scrollPane;

    public PreviewPanel(PrintablePages printablepages) {
        this(new PreviewView(printablepages));
    }

    public PreviewView getPreviewView() {
        return this.previewView;
    }

    public PreviewPanel(PreviewView previewview) {
        Font font = new Font("Serif", 0, 12);
        this.previewView = previewview;
        previewview.previewPanel = this;
        this.scrollPane = new JScrollPane(previewview);
        String[] as = new String[]{"\u6253\u5370", "\u7b2c\u4e00\u9875", "\u524d\u4e00\u9875", "\u4e0b\u4e00\u9875", "\u6700\u540e\u9875", "\u6807\u5c3a"};
        String[] as1 = new String[]{"print", "navfirst", "navprev", "navnext", "navlast", "rule"};
        this.toolBar.setLayout(new FlowLayout(0, 0, 0));
        int i = 0;
        while (i < as.length) {
            ImageIcon imageicon = null;
            try {
                imageicon = Utilities.createImageIconFromResource("res/icon16_" + as1[i] + ".jpg");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JButton jbutton = new JButton(as[i], imageicon);
            jbutton.addActionListener(this);
            jbutton.setRequestFocusEnabled(false);
            jbutton.setMargin(Constants.ZEROINSETS);
            this.toolbarButtons[i] = jbutton;
            this.toolBar.add(jbutton);
            ++i;
        }
        this.pageStatus.setBorder(BorderFactory.createLoweredBevelBorder());
        this.toolBar.addSeparator();
        int j = 0;
        while (j < PreviewView.listPreviewRate.length) {
            this.drarRateComboBox.addItem(String.valueOf(PreviewView.listPreviewRate[j] >= 100 ? "" : " ") + PreviewView.listPreviewRate[j] + "%");
            ++j;
        }
        if (previewview != null && previewview.drawRateIndex > 0 && previewview.drawRateIndex < PreviewView.listPreviewRate.length) {
            this.drarRateComboBox.setSelectedIndex(previewview.drawRateIndex);
        }
        this.drarRateComboBox.setSelectedIndex(previewview.drawRateIndex);
        this.drarRateComboBox.addItemListener(this);
        this.toolBar.add(new JLabel(" \u6bd4\u4f8b:"));
        this.toolBar.add(this.drarRateComboBox);
        this.toolBar.add(this.pageStatus);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setToolbarStatus();
    }

    public void setToolbarStatus() {
        boolean flag = this.previewView.atFirst();
        boolean flag1 = this.previewView.atLast();
        this.toolbarButtons[1].setEnabled(!flag);
        this.toolbarButtons[2].setEnabled(!flag);
        this.toolbarButtons[3].setEnabled(!flag1);
        this.toolbarButtons[4].setEnabled(!flag1);
        int i = this.previewView.pages.getNumberOfPages();
        int j = this.previewView.pageIndex;
        if (i > 0) {
            this.pageStatus.setText("\u7b2c " + (j + 1) + " \u9875 , \u5171 " + i + " \u9875");
        } else {
            this.pageStatus.setText(null);
        }
        if (this.previewView.drawRateIndex != this.drarRateComboBox.getSelectedIndex()) {
            this.drarRateComboBox.setSelectedIndex(this.previewView.drawRateIndex);
        }
    }

    private JInternalFrame getParentInternalFrame() {
        Container obj = this;
        while (obj != null) {
            if (obj instanceof JInternalFrame) {
                return (JInternalFrame)obj;
            }
            obj = ((Component)obj).getParent();
        }
        return null;
    }

    private Frame getParentFrame() {
        Container obj = this;
        while (obj != null) {
            if (obj instanceof Frame) {
                return (Frame)obj;
            }
            obj = ((Component)obj).getParent();
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionevent) {
        int i = 0;
        while (i < this.toolbarButtons.length) {
            if (actionevent.getSource() == this.toolbarButtons[i]) break;
            ++i;
        }
        if (i == 0) {
            try {
                this.previewView.pages.print();
            }
            catch (PrinterException printerexception) {
                Message.out.println(printerexception);
                return;
            }
            if (Message.showQuestionDialog("\u63d0\u793a", "\u5173\u95ed\u6253\u5370\u9884\u89c8\u7a97\u53e3?") == 0) {
                Container obj = this.getParentInternalFrame();
                if (obj != null) {
                    ((JComponent)obj).setVisible(false);
                    ((JInternalFrame)obj).dispose();
                }
                if ((obj = this.getParentFrame()) != null) {
                    ((Component)obj).setVisible(false);
                    ((Window)obj).dispose();
                }
            }
            return;
        }
        if (i >= 1 && i <= 4) {
            this.previewView.toPage(i);
            this.setToolbarStatus();
        } else if (i == 5) {
            this.previewView.showRuler = !this.previewView.showRuler;
            this.previewView.repaintView();
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        int i;
        if (itemevent.getSource() == this.drarRateComboBox && (i = this.drarRateComboBox.getSelectedIndex()) != this.previewView.drawRateIndex) {
            this.previewView.setDrawRate(i);
            this.scrollPane.revalidate();
            Dimension dimension = this.scrollPane.getViewport().getExtentSize();
            Dimension dimension1 = this.previewView.getPreferredSize();
            this.scrollPane.getViewport().setViewSize(new Dimension(dimension.width <= dimension1.width ? dimension1.width : dimension.width, dimension.height <= dimension1.height ? dimension1.height : dimension.height));
            this.setToolbarStatus();
        }
    }
}

