/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import softcore.awt.DialogPanel;
import softcore.awt.ExtObject;
import softcore.awt.JTextFieldA;
import softcore.awt.ListAidInputer;
import softcore.net.EMail;
import softcore.print.PageWrite;
import softcore.print.PreviewPanel;
import softcore.print.Print;
import softcore.print.PrintablePages;
import softcore.tac.Tac;
import softcore.util.FileNameChooser;
import softcore.util.FileNameLikeFileFilter;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.Utilities;
import softcore.win.PrintToExcel;
import softcore.win.PrintToWord;
import softface.MainApp;
import softoperation.finance.erpdata.ErpdataConfig;

public class PreviewView
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener {
    JPopupMenu attrMenu = new JPopupMenu();
    JMenuItem menuItem = new JMenuItem("\u5bfc\u5230WORD\u6587\u4ef6");
    JMenuItem menuExcelItem = new JMenuItem("\u5bfc\u5230EXCEL\u6587\u4ef6");
    JMenuItem menuSaveToFile;
    JMenuItem menuSave;
    JMenuItem menuLoad;
    JMenuItem menuEMailItem;
    JMenuItem deleteItem;
    String[] emailAccountInfo;
    final PrintablePages pages;
    int pageIndex;
    int dblDrawRate = 100;
    int drawRateIndex;
    boolean showRuler;
    private Image offImage;
    Graphics offGraphics;
    int viewWidth;
    int viewHeight;
    PreviewPanel previewPanel;
    private int xo;
    private int yo;
    Rectangle handleR = new Rectangle();
    static final int[] listPreviewRate = new int[]{100, 50, 25, 150, 200};
    int[] columnPos = null;
    int[] rowPos = null;
    int curHandleCount;
    Print.PrintCell pActiveCell;
    int nAppendMode;
    private Rectangle moveRect = new Rectangle();
    Color xorColor = new Color(0, 128, 128);
    int mouseMode;
    boolean bDrawing;
    int moveHandle;
    int lastMouseX;
    int lastMouseY;
    int[] cellHandles = new int[1];
    MimeBodyPart[] emailMimeBodyPart;

    public PrintablePages getPages() {
        return this.pages;
    }

    public PreviewView(PrintablePages printablepages) {
        this.setDoubleBuffered(false);
        this.pages = printablepages;
        int i = MainApp.getAppIntOption(90, 4);
        int j = 0;
        while (j < listPreviewRate.length) {
            if (i == listPreviewRate[j]) {
                this.drawRateIndex = j;
                this.dblDrawRate = i;
                break;
            }
            ++j;
        }
        this.viewWidth = (int)printablepages.getPageFormat(0).getPaper().getWidth();
        this.viewHeight = (int)printablepages.getPageFormat(0).getPaper().getHeight();
        if (this.getPages() != null && (this.emailAccountInfo = this.getPages().getEMailAccountInfo()) != null) {
            this.menuEMailItem = new JMenuItem("\u6309WORD\u683c\u5f0f\u53d1EMail");
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.menuItem.addActionListener(this);
        this.menuExcelItem.addActionListener(this);
        this.attrMenu.add(this.menuItem);
        this.attrMenu.add(this.menuExcelItem);
        if (printablepages instanceof Print && ((Print)printablepages).saveID != null) {
            String cfr_ignored_0 = ((Print)printablepages).saveFmtnm;
        }
        if (this.menuEMailItem != null) {
            this.menuEMailItem.addActionListener(this);
            this.attrMenu.add(this.menuEMailItem);
        }
        this.attrMenu.setBorder(BorderFactory.createEtchedBorder());
        this.attrMenu.setInvoker(this);
    }

    public Dimension getPreferredSize() {
        if (this.pages.printLandScape()) {
            return new Dimension(this.viewHeight * this.dblDrawRate / 100, this.viewWidth * this.dblDrawRate / 100);
        }
        return new Dimension(this.viewWidth * this.dblDrawRate / 100, this.viewHeight * this.dblDrawRate / 100);
    }

    protected void paintComponent(Graphics g) {
        Dimension dimension = this.getSize();
        int i = this.viewWidth * this.dblDrawRate / 100;
        int j = this.viewHeight * this.dblDrawRate / 100;
        boolean flag = this.pages.printLandScape();
        if (this.offImage == null) {
            int k = flag ? j : i;
            int l = flag ? i : j;
            this.offImage = this.createImage(k, l);
            this.offGraphics = this.offImage.getGraphics();
            this.offGraphics.setColor(Color.white);
            this.offGraphics.fillRect(0, 0, k, l);
            this.offGraphics.setColor(Color.black);
            this.pages.printPage(this.offGraphics, this.pageIndex, false, this.dblDrawRate);
            if (this.pActiveCell != null) {
                int i1 = this.getHandleCount(this.pActiveCell);
                int k1 = 1;
                while (k1 <= i1) {
                    Point point = this.getRectHandlePoint(this.pActiveCell, k1, null);
                    this.offGraphics.fillRect(point.x - 3, point.y - 3, 6, 6);
                    ++k1;
                }
            }
            if (this.showRuler) {
                int j1 = 50;
                double d = (double)j1 * 2.834645669291339 * (double)this.dblDrawRate / 100.0;
                this.offGraphics.setColor(new Color(128, 255, 255));
                int l1 = 1;
                while ((double)l1 * d < (double)k) {
                    this.offGraphics.drawLine((int)((double)l1 * d), 0, (int)((double)l1 * d), l);
                    ++l1;
                }
                int i2 = 1;
                while ((double)i2 * d < (double)l) {
                    this.offGraphics.drawLine(0, (int)((double)i2 * d), k, (int)((double)i2 * d));
                    ++i2;
                }
            }
        }
        g.setColor(Color.darkGray);
        g.fillRect(0, 0, dimension.width, dimension.height);
        this.xo = (dimension.width - (flag ? j : i)) / 2;
        this.yo = (dimension.height - (flag ? i : j)) / 2;
        if (this.xo < 0) {
            this.xo = 0;
        }
        if (this.yo < 0) {
            this.yo = 0;
        }
        g.drawImage(this.offImage, this.xo, this.yo, this);
    }

    public boolean atFirst() {
        return this.pageIndex == 0;
    }

    public boolean atLast() {
        return this.pageIndex >= this.pages.getNumberOfPages() - 1;
    }

    void toPage(int i) {
        int j;
        this.pActiveCell = null;
        this.columnPos = null;
        this.rowPos = null;
        if (i == 1) {
            j = 0;
        } else if (i == 2) {
            j = this.pageIndex - 1;
        } else if (i == 3) {
            j = this.pageIndex + 1;
        } else if (i == 4) {
            j = this.pages.getNumberOfPages() - 1;
        } else {
            return;
        }
        if (j >= this.pages.getNumberOfPages()) {
            j = this.pages.getNumberOfPages() - 1;
        }
        if (j < 0) {
            j = 0;
        }
        if (j != this.pageIndex) {
            this.stopEditCell();
            this.pageIndex = j;
            this.repaintView();
        }
    }

    public void repaintView() {
        this.offImage = null;
        this.viewWidth = (int)this.pages.getPageFormat(this.pageIndex).getPaper().getWidth();
        this.viewHeight = (int)this.pages.getPageFormat(this.pageIndex).getPaper().getHeight();
        this.repaint();
    }

    private void createScaledImage() {
    }

    void stopEditCell() {
        if (this.pages instanceof Print) {
            ((Print)this.pages).stopEditCell(this);
        }
    }

    void setDrawRate(int i) {
        if (i >= 0 && i < listPreviewRate.length && listPreviewRate[i] != this.dblDrawRate) {
            this.drawRateIndex = i;
            this.dblDrawRate = listPreviewRate[this.drawRateIndex];
            this.offImage = null;
            this.repaint();
        }
    }

    void figPageRowCol() {
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(this.pageIndex);
        int i = page.cellSet.size();
        int j = 0;
        while (j < i) {
            Print.PrintCell printcell = (Print.PrintCell)page.cellSet.elementAt(j);
            if (printcell instanceof Print.LineCell) {
                if (printcell.width == 0 && (this.columnPos == null || Arrays.binarySearch(this.columnPos, printcell.x) < 0) && this.isLineOfTable((Print.LineCell)printcell)) {
                    this.columnPos = this.appendIntArray(this.columnPos, printcell.x);
                } else if (printcell.height == 0 && (this.rowPos == null || Arrays.binarySearch(this.rowPos, printcell.y) < 0) && this.isLineOfTable((Print.LineCell)printcell)) {
                    this.rowPos = this.appendIntArray(this.rowPos, printcell.y);
                }
            }
            ++j;
        }
    }

    int[] appendIntArray(int[] ai, int i) {
        if (ai != null && Arrays.binarySearch(ai, i) >= 0) {
            return ai;
        }
        if (ai == null) {
            return new int[]{i};
        }
        int[] ai1 = new int[ai.length + 1];
        System.arraycopy(ai, 0, ai1, 0, ai.length);
        ai1[ai.length] = i;
        Arrays.sort(ai1);
        return ai1;
    }

    boolean isLineOfTable(Print.LineCell linecell) {
        int i = linecell.width;
        int j = linecell.height;
        if (i != 0 && j != 0) {
            return false;
        }
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(this.pageIndex);
        int k = Math.min(linecell.x, linecell.x + linecell.width);
        int l = Math.max(linecell.x, linecell.x + linecell.width);
        int i1 = Math.min(linecell.y, linecell.y + linecell.height);
        int j1 = Math.max(linecell.y, linecell.y + linecell.height);
        int k1 = 0;
        while (k1 < page.cellSet.size()) {
            Print.PrintCell printcell = (Print.PrintCell)page.cellSet.elementAt(k1);
            if (printcell != linecell && printcell instanceof Print.LineCell) {
                int l1 = printcell.width;
                int i2 = printcell.height;
                int j2 = Math.min(printcell.x, printcell.x + printcell.width);
                int k2 = Math.max(printcell.x, printcell.x + printcell.width);
                int l2 = Math.min(printcell.y, printcell.y + printcell.height);
                int i3 = Math.max(printcell.y, printcell.y + printcell.height);
                if (i == 0 && i2 == 0 ? i1 <= l2 && j1 >= l2 && k >= j2 && k <= k2 : j == 0 && l1 == 0 && k <= j2 && l >= j2 && i1 >= l2 && i1 <= i3) {
                    return true;
                }
            }
            ++k1;
        }
        return false;
    }

    int lineInTable(Print.LineCell linecell) {
        if (this.columnPos == null) {
            this.figPageRowCol();
        }
        if (this.columnPos == null) {
            return -1;
        }
        int i = linecell.width;
        int j = linecell.height;
        if (i != 0 && j != 0) {
            return -1;
        }
        int k = Math.min(linecell.x, linecell.x + linecell.width);
        int l = Math.max(linecell.x, linecell.x + linecell.width);
        int i1 = Math.min(linecell.y, linecell.y + linecell.height);
        int j1 = Math.max(linecell.y, linecell.y + linecell.height);
        if (i == 0) {
            int k1 = Utilities.binarySearch(this.columnPos, k);
            if (k1 >= 0 && Utilities.binarySearch(this.rowPos, i1) >= 0 && Utilities.binarySearch(this.rowPos, j1) >= 0) {
                return k1;
            }
        } else {
            int l1 = Utilities.binarySearch(this.rowPos, i1);
            if (l1 >= 0 && Utilities.binarySearch(this.columnPos, k) >= 0 && Utilities.binarySearch(this.columnPos, l) >= 0) {
                return l1;
            }
        }
        return -1;
    }

    boolean cellInTable(Print.PrintCell printcell, Rectangle rectangle) {
        if (this.columnPos == null) {
            this.figPageRowCol();
        }
        if (this.columnPos == null) {
            return false;
        }
        int i = printcell.width;
        int j = printcell.height;
        if (i == 0 || j == 0) {
            return false;
        }
        int k = Math.min(printcell.x, printcell.x + printcell.width);
        int l = Math.max(printcell.x, printcell.x + printcell.width);
        int i1 = Math.min(printcell.y, printcell.y + printcell.height);
        int j1 = Math.max(printcell.y, printcell.y + printcell.height);
        int k1 = Utilities.binarySearch(this.rowPos, i1);
        if (k1 < 0) {
            return false;
        }
        int l1 = Utilities.binarySearch(this.columnPos, k);
        if (l1 < 0) {
            return false;
        }
        int i2 = Utilities.binarySearch(this.rowPos, j1);
        if (i2 < 0) {
            return false;
        }
        int j2 = Utilities.binarySearch(this.columnPos, l);
        if (j2 < 0) {
            return false;
        }
        if (rectangle != null) {
            rectangle.setBounds(l1, k1, j2 - l1, i2 - k1);
        }
        return true;
    }

    public int getHandleCount(Print.PrintCell printcell) {
        if (printcell == null) {
            return 0;
        }
        if (printcell instanceof Print.LineCell) {
            return this.lineInTable((Print.LineCell)printcell) < 0 ? 2 : 1;
        }
        return this.cellInTable(printcell, null) ? 0 : 8;
    }

    public Point getRectHandlePoint(Print.PrintCell printcell, int i, Point point) {
        if (point == null) {
            point = new Point(0, 0);
        }
        if (printcell instanceof Print.LineCell) {
            if (i == 1) {
                if (this.curHandleCount == 1) {
                    point.x = printcell.x + printcell.width / 2;
                    point.y = printcell.y + printcell.height / 2;
                } else {
                    point.x = printcell.x;
                    point.y = printcell.y;
                }
            } else {
                point.x = printcell.x + printcell.width;
                point.y = printcell.y + printcell.height;
            }
            return point;
        }
        int j = 0;
        int k = 0;
        int l = printcell.x + printcell.width / 2;
        int i1 = printcell.y + printcell.height / 2;
        switch (i) {
            case 1: {
                j = printcell.x;
                k = printcell.y;
                break;
            }
            case 2: {
                j = l;
                k = printcell.y;
                break;
            }
            case 3: {
                j = printcell.x + printcell.width;
                k = printcell.y;
                break;
            }
            case 4: {
                j = printcell.x + printcell.width;
                k = i1;
                break;
            }
            case 5: {
                j = printcell.x + printcell.width;
                k = printcell.y + printcell.height;
                break;
            }
            case 6: {
                j = l;
                k = printcell.y + printcell.height;
                break;
            }
            case 7: {
                j = printcell.x;
                k = printcell.y + printcell.height;
                break;
            }
            case 8: {
                j = printcell.x;
                k = i1;
            }
        }
        point.x = j;
        point.y = k;
        return point;
    }

    public int atRectHandle(Print.PrintCell printcell, int i, int j, int k) {
        Point point = null;
        Rectangle rectangle = new Rectangle();
        int l = 2 * k;
        int i1 = 1;
        while (i1 <= 8) {
            point = this.getRectHandlePoint(printcell, i1, point);
            rectangle.setBounds(point.x - k, point.y - k, l, l);
            if (rectangle.contains(i, j)) {
                return i1;
            }
            ++i1;
        }
        return 0;
    }

    public Print.PrintCell atCell(int i, int j, boolean flag) {
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(this.pageIndex);
        Print.PrintCell printcell = null;
        int k = page.cellSet.size();
        int l = 0;
        while (l < k) {
            int i1 = flag ? l : k - 1 - l;
            Print.PrintCell printcell1 = (Print.PrintCell)page.cellSet.elementAt(i1);
            if (printcell1 instanceof Print.LineCell) {
                if (printcell1.height == 0 && i >= printcell1.x && i <= printcell1.x + printcell1.width && j >= printcell1.y - 1 && j <= printcell1.y + 1) {
                    return printcell1;
                }
                if (printcell1.width == 0 && j >= printcell1.y && j <= printcell1.y + printcell1.height && i >= printcell1.x - 1 && i <= printcell1.x + 1) {
                    return printcell1;
                }
                if (printcell1.width >= -2 && printcell1.width <= 2 || printcell1.height >= -2 && printcell1.height <= 2) {
                    if (printcell1.contains(i, j)) {
                        return printcell1;
                    }
                } else {
                    Rectangle rectangle = new Rectangle(printcell1.x - 2, printcell1.y - 2, 4, 4);
                    if (rectangle.contains(i, j)) {
                        return printcell1;
                    }
                    rectangle.setBounds(printcell1.x + printcell1.width - 2, printcell1.y + printcell1.height - 2, 4, 4);
                    if (rectangle.contains(i, j)) {
                        return printcell1;
                    }
                }
                if (printcell1.width != 0 && printcell1.height != 0 && (printcell1.x - i) * (printcell1.x + printcell1.width - i) < 0 && (printcell1.y - j) * (printcell1.y + printcell1.height - j) < 0) {
                    double d = (double)printcell1.height / (double)printcell1.width;
                    int j1 = (int)((double)printcell1.y + d * (double)(i - printcell1.x));
                    if ((j1 -= j) <= 2 && j1 >= -2) {
                        return printcell1;
                    }
                }
            } else if (printcell1.contains(i, j)) {
                return printcell1;
            }
            ++l;
        }
        return printcell;
    }

    public Print.PrintCell atCellHandle(int i, int j, int[] ai) {
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(this.pageIndex);
        Print.PrintCell printcell = null;
        int k = page.cellSet.size();
        int l = 0;
        while (l < k) {
            Print.PrintCell printcell1 = (Print.PrintCell)page.cellSet.elementAt(l);
            int i1 = this.atRectHandle(printcell1, i, j, 3);
            if (i1 > 0) {
                if (ai != null && ai.length > 0) {
                    ai[0] = i1;
                }
                return printcell1;
            }
            ++l;
        }
        return printcell;
    }

    private void drawMoveFlag(boolean flag) {
        Graphics g = this.getGraphics();
        g.setXORMode(this.xorColor);
        if (flag) {
            g.drawLine(this.moveRect.x, this.moveRect.y, this.moveRect.x + this.moveRect.width, this.moveRect.y + this.moveRect.height);
        } else {
            int l;
            int i = this.moveRect.x;
            int j = this.moveRect.y;
            int k = this.moveRect.width;
            if (k < 0) {
                i += k;
                k = 0 - k;
            }
            if ((l = this.moveRect.height) < 0) {
                j += l;
                l = 0 - l;
            }
            if (k > 0 || l > 0) {
                g.drawRect(i, j, k, l);
            }
        }
    }

    Print.PrintCell getCellInPage(int i, Rectangle rectangle, int j) {
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(i);
        if (page == null) {
            return null;
        }
        int k = page.cellSet.size();
        int l = this.pages.getNumberOfPages() - 1;
        int i1 = 0;
        while (i1 < k) {
            Print.PrintCell printcell = (Print.PrintCell)page.cellSet.elementAt(i1);
            if (rectangle.equals(printcell)) {
                return printcell;
            }
            if (rectangle.width == 0 && printcell.width == 0 && rectangle.y == printcell.y && rectangle.x == printcell.x && (i == l || j == l)) {
                return printcell;
            }
            ++i1;
        }
        return null;
    }

    void changePagePos(int i, Rectangle rectangle, boolean flag, int j) {
        int k;
        Print print = (Print)this.pages;
        Print.Page page = print.getPage(i);
        Print.PrintCell printcell = this.getCellInPage(i, rectangle, j);
        if (printcell == null) {
            return;
        }
        if (printcell instanceof Print.TextCell && this.cellInTable(printcell, null)) {
            return;
        }
        if (printcell instanceof Print.LineCell && (k = this.lineInTable((Print.LineCell)printcell)) >= 0) {
            if (printcell.width == 0) {
                int l = this.moveRect.x - this.xo;
                if (k == 0 && l <= 0) {
                    this.repaintView();
                    return;
                }
                if (k > 0 && l <= this.columnPos[k - 1]) {
                    this.repaintView();
                    return;
                }
                int j1 = l - printcell.x;
                if (j1 == 0) {
                    this.repaintView();
                    return;
                }
                int l1 = page.cellSet.size();
                int j2 = 0;
                while (j2 < l1) {
                    Print.PrintCell printcell1 = (Print.PrintCell)page.cellSet.elementAt(j2);
                    if (printcell1 != printcell) {
                        int j3 = Math.min(printcell1.x, printcell1.x + printcell1.width);
                        if (j3 >= printcell.x) {
                            printcell1.x += j1;
                        } else {
                            if (printcell1 instanceof Print.TextCell && this.cellInTable(printcell1, null) && printcell1.x + printcell1.width >= printcell.x) {
                                printcell1.width += j1;
                            }
                            if (printcell1 instanceof Print.LineCell && printcell1.height == 0 && this.lineInTable((Print.LineCell)printcell1) >= 0 && printcell1.x + printcell1.width >= printcell.x) {
                                printcell1.width += j1;
                            }
                        }
                    }
                    ++j2;
                }
                int l2 = k;
                while (l2 < this.columnPos.length) {
                    int n = l2++;
                    this.columnPos[n] = this.columnPos[n] + j1;
                }
                printcell.x = l;
            } else {
                int i1 = this.moveRect.y - this.yo;
                if (k == 0 && i1 <= 0) {
                    this.repaintView();
                    return;
                }
                if (k > 0 && i1 <= this.rowPos[k - 1]) {
                    this.repaintView();
                    return;
                }
                int k1 = i1 - printcell.y;
                if (k1 == 0) {
                    this.repaintView();
                    return;
                }
                int i2 = page.cellSet.size();
                int k2 = 0;
                while (k2 < i2) {
                    Print.PrintCell printcell2 = (Print.PrintCell)page.cellSet.elementAt(k2);
                    if (printcell2 != printcell) {
                        int k3 = Math.min(printcell2.y, printcell2.y + printcell2.height);
                        if (k3 >= printcell.y) {
                            printcell2.y += k1;
                        } else {
                            if (printcell2 instanceof Print.TextCell && this.cellInTable(printcell2, null) && printcell2.y + printcell2.height >= printcell.y) {
                                printcell2.height += k1;
                            }
                            if (printcell2 instanceof Print.LineCell && printcell2.width == 0 && this.lineInTable((Print.LineCell)printcell2) >= 0 && printcell2.y + printcell2.height >= printcell.y) {
                                printcell2.height += k1;
                            }
                        }
                    }
                    ++k2;
                }
                int i3 = k;
                while (i3 < this.rowPos.length) {
                    int n = i3++;
                    this.rowPos[n] = this.rowPos[n] + k1;
                }
                printcell.y = i1;
            }
            this.repaintView();
            return;
        }
        printcell.setBounds(this.moveRect.x - this.xo, this.moveRect.y - this.yo, this.moveRect.width, this.moveRect.height);
        this.repaintView();
    }

    public void mouseReleased(MouseEvent mouseevent) {
        boolean flag;
        if ((mouseevent.getModifiers() & 4) > 0) {
            this.onPopupMenu(mouseevent.getX(), mouseevent.getY());
            return;
        }
        Print print = (Print)this.pages;
        if (print.editable == 0) {
            return;
        }
        Print.Page page = print.getPage(this.pageIndex);
        boolean bl = flag = this.nAppendMode == 2 || this.pActiveCell instanceof Print.LineCell;
        if (this.pActiveCell != null) {
            Print.PrintCell printcell = this.pActiveCell;
            Rectangle rectangle = new Rectangle(this.pActiveCell);
            int i = this.pageIndex;
            int j = this.pages.getNumberOfPages();
            int k = 0;
            while (k < j) {
                this.pageIndex = k;
                this.columnPos = null;
                this.rowPos = null;
                this.pActiveCell = null;
                this.changePagePos(k, rectangle, flag, i);
                ++k;
            }
            this.columnPos = null;
            this.rowPos = null;
            this.pageIndex = i;
            this.pActiveCell = printcell;
        }
        if (this.bDrawing) {
            this.bDrawing = false;
            this.drawMoveFlag(flag);
            if (this.nAppendMode > 0) {
                if (this.nAppendMode == 1 && this.moveRect.width != 0 && this.moveRect.height != 0) {
                    this.moveRect.x -= this.xo;
                    this.moveRect.y -= this.yo;
                    page.addText("", this.moveRect, "", new Font("\u5b8b\u4f53", 0, 12), Color.black, 20608, 2);
                    this.moveRect.x += this.xo;
                    this.moveRect.y += this.yo;
                    ((Print)this.pages).startEditCell(this, this.pageIndex, this.moveRect.x + this.moveRect.width / 2, this.xo, this.moveRect.y + this.moveRect.height / 2, this.yo);
                    this.pActiveCell = print.cellAtachEditTextComponent;
                } else if (this.nAppendMode == 2 && (this.moveRect.width != 0 || this.moveRect.height != 0)) {
                    this.moveRect.x -= this.xo;
                    this.moveRect.y -= this.yo;
                    Print.LineCell linecell = page.addLine(this.moveRect, 257, Color.black);
                    this.pActiveCell = linecell;
                    this.repaintView();
                }
            }
        }
        this.bDrawing = false;
        this.nAppendMode = 0;
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.lastMouseY = mouseevent.getY();
        this.lastMouseX = mouseevent.getX();
        Print.PrintCell printcell = this.pActiveCell;
        Print print = (Print)this.pages;
        if (print.editable == 0) {
            return;
        }
        if ((mouseevent.getModifiers() & 0x10) > 0 && mouseevent.getClickCount() == 2) {
            print.startEditCell(this, this.pageIndex, mouseevent.getX(), this.xo, mouseevent.getY(), this.yo);
            if (print.isEditing()) {
                this.pActiveCell = print.cellAtachEditTextComponent;
                this.curHandleCount = this.getHandleCount(this.pActiveCell);
                this.repaintView();
                return;
            }
        }
        Print.PrintCell printcell1 = this.atCell(mouseevent.getX() - this.xo, mouseevent.getY() - this.yo, !mouseevent.isAltDown());
        if (print.isEditing()) {
            print.stopEditCell(this);
        }
        if (printcell1 != null) {
            if (this.pActiveCell != printcell1) {
                this.pActiveCell = printcell1;
                this.repaintView();
            }
        } else if (this.pActiveCell == null || this.atRectHandle(this.pActiveCell, mouseevent.getX() - this.xo, mouseevent.getY() - this.yo, 3) == 0) {
            this.pActiveCell = printcell1;
            if (printcell != null) {
                this.repaintView();
            }
        }
        this.curHandleCount = this.getHandleCount(this.pActiveCell);
        this.nAppendMode = 0;
        this.bDrawing = true;
        this.moveHandle = 0;
        if (mouseevent.isControlDown()) {
            this.nAppendMode = 1;
        }
        if (mouseevent.isShiftDown()) {
            this.nAppendMode = 2;
        }
        this.moveRect.setBounds(mouseevent.getX(), mouseevent.getY(), 0, 0);
        if (this.pActiveCell != null) {
            this.moveHandle = this.atRectHandle(this.pActiveCell, mouseevent.getX() - this.xo, mouseevent.getY() - this.yo, 3);
            this.moveRect.setBounds(this.pActiveCell.x + this.xo, this.pActiveCell.y + this.yo, this.pActiveCell.width, this.pActiveCell.height);
        }
        boolean flag = this.nAppendMode == 2 || this.pActiveCell instanceof Print.LineCell;
        this.drawMoveFlag(flag);
    }

    public void mouseDragged(MouseEvent mouseevent) {
        boolean flag;
        Print print = (Print)this.pages;
        if (print.editable == 0) {
            return;
        }
        boolean bl = flag = this.nAppendMode == 2 || this.pActiveCell instanceof Print.LineCell;
        if (this.bDrawing) {
            this.drawMoveFlag(flag);
            switch (this.moveHandle) {
                case 1: {
                    if (this.curHandleCount == 1) {
                        if (this.pActiveCell.width == 0) {
                            this.moveRect.x = mouseevent.getX();
                            break;
                        }
                        this.moveRect.y = mouseevent.getY();
                        break;
                    }
                    this.moveRect.width += this.moveRect.x - mouseevent.getX();
                    this.moveRect.height += this.moveRect.y - mouseevent.getY();
                    this.moveRect.x = mouseevent.getX();
                    this.moveRect.y = mouseevent.getY();
                    break;
                }
                case 2: {
                    if (this.pActiveCell instanceof Print.LineCell) {
                        this.moveRect.setBounds(this.moveRect.x, this.moveRect.y, mouseevent.getX() - this.moveRect.x, mouseevent.getY() - this.moveRect.y);
                        break;
                    }
                    this.moveRect.height += this.moveRect.y - mouseevent.getY();
                    this.moveRect.y = mouseevent.getY();
                    break;
                }
                case 3: {
                    int i = mouseevent.getX() - (this.moveRect.x + this.moveRect.width);
                    this.moveRect.width += mouseevent.getX() - (this.moveRect.x + this.moveRect.width);
                    this.moveRect.height += this.moveRect.y - mouseevent.getY();
                    this.moveRect.y = mouseevent.getY();
                    break;
                }
                case 4: {
                    this.moveRect.width += mouseevent.getX() - (this.moveRect.x + this.moveRect.width);
                    break;
                }
                case 5: {
                    this.moveRect.setBounds(this.moveRect.x, this.moveRect.y, mouseevent.getX() - this.moveRect.x, mouseevent.getY() - this.moveRect.y);
                    break;
                }
                case 6: {
                    this.moveRect.height += mouseevent.getY() - this.moveRect.y - this.moveRect.height;
                    break;
                }
                case 7: {
                    this.moveRect.width += this.moveRect.x - mouseevent.getX();
                    this.moveRect.height += mouseevent.getY() - this.moveRect.y - this.moveRect.height;
                    this.moveRect.x = mouseevent.getX();
                    break;
                }
                case 8: {
                    this.moveRect.width += this.moveRect.x - mouseevent.getX();
                    this.moveRect.x = mouseevent.getX();
                    break;
                }
                default: {
                    if (this.pActiveCell == null) {
                        this.moveRect.setBounds(this.moveRect.x, this.moveRect.y, mouseevent.getX() - this.moveRect.x, mouseevent.getY() - this.moveRect.y);
                        break;
                    }
                    if (this.curHandleCount == 1) {
                        if (this.pActiveCell.width == 0) {
                            this.moveRect.x = mouseevent.getX();
                            break;
                        }
                        this.moveRect.y = mouseevent.getY();
                        break;
                    }
                    if (this.curHandleCount == 0) break;
                    int j = mouseevent.getX() - this.lastMouseX;
                    int k = mouseevent.getY() - this.lastMouseY;
                    this.moveRect.setBounds(this.moveRect.x + j, this.moveRect.y + k, this.moveRect.width, this.moveRect.height);
                    this.lastMouseY = mouseevent.getY();
                    this.lastMouseX = mouseevent.getX();
                }
            }
            this.drawMoveFlag(flag);
        }
    }

    public void mouseMoved(MouseEvent mouseevent) {
        Print print = (Print)this.pages;
        if (print.editable == 0) {
            return;
        }
        if (this.pActiveCell != null) {
            int i = this.atRectHandle(this.pActiveCell, mouseevent.getX() - this.xo, mouseevent.getY() - this.yo, 3);
            if (this.pActiveCell instanceof Print.LineCell) {
                if (i == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                } else if (this.curHandleCount == 1) {
                    if (this.pActiveCell.width == 0) {
                        this.setCursor(Cursor.getPredefinedCursor(11));
                    } else {
                        this.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
                return;
            }
            if (!this.bDrawing) {
                switch (i) {
                    case 1: {
                        this.setCursor(Cursor.getPredefinedCursor(6));
                        break;
                    }
                    case 2: {
                        this.setCursor(Cursor.getPredefinedCursor(8));
                        break;
                    }
                    case 3: {
                        this.setCursor(Cursor.getPredefinedCursor(7));
                        break;
                    }
                    case 4: {
                        this.setCursor(Cursor.getPredefinedCursor(11));
                        break;
                    }
                    case 5: {
                        this.setCursor(Cursor.getPredefinedCursor(5));
                        break;
                    }
                    case 6: {
                        this.setCursor(Cursor.getPredefinedCursor(9));
                        break;
                    }
                    case 7: {
                        this.setCursor(Cursor.getPredefinedCursor(4));
                        break;
                    }
                    case 8: {
                        this.setCursor(Cursor.getPredefinedCursor(10));
                        break;
                    }
                    default: {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    String toWinFile(boolean flag, String s) {
        String s1 = null;
        String s2 = "c:/temp/";
        File file = new File(s2);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        if (flag) {
            File file1;
            FileNameChooser filenamechooser = new FileNameChooser();
            filenamechooser.setFileFilter(new FileNameLikeFileFilter("*." + s));
            filenamechooser.setDialogType(1);
            filenamechooser.setCurrentDirectory(new File(Utilities.getUserDir()));
            if (!(filenamechooser.showDialog(this, "\u4fdd\u5b58") != 0 || (file1 = filenamechooser.getSelectedFile()) == null || file1.exists() && Message.showQuestionDialog("\u63d0\u793a", "\u6587\u4ef6'" + file1 + "'\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6?") != 0)) {
                s1 = file1.getAbsolutePath();
            }
        } else {
            s1 = ExtObject.getIncFileName(s2, "TMPMAIL_", s);
        }
        if (s1 == null) {
            return null;
        }
        String s3 = this.getFrameTitle();
        if (this.pages instanceof Print && (s.equalsIgnoreCase("DOC") && PrintToWord.printToWord((Print)this.pages, s1) || s.equalsIgnoreCase("XLS") && PrintToExcel.printToExcel((Print)this.pages, s1, s3 != null ? s3 : "Sheet1"))) {
            return s1;
        }
        return null;
    }

    String getFrameTitle() {
        Container obj = this;
        while (obj != null) {
            if (obj instanceof JInternalFrame) {
                return ((JInternalFrame)obj).getTitle();
            }
            obj = ((Component)obj).getParent();
        }
        return null;
    }

    public void addMailAttachment(String s, byte[] abyte0, String s1) throws MessagingException {
        if (s1 == null) {
            s1 = "application/octet-stream";
        }
        Message.debugPrint("PreviewView:addMailAttachment fileName=" + s + ",data=" + abyte0);
        EMail.MailAttachment mailattachment = new EMail.MailAttachment(s, abyte0, s1);
        MimeBodyPart[] amimebodypart = this.emailMimeBodyPart;
        int i = amimebodypart != null ? amimebodypart.length + 1 : 1;
        this.emailMimeBodyPart = new MimeBodyPart[i];
        if (amimebodypart != null) {
            System.arraycopy(amimebodypart, 0, this.emailMimeBodyPart, 0, amimebodypart.length);
        }
        this.emailMimeBodyPart[i - 1] = mailattachment;
    }

    public void saveTo(Print print, DataOutput dataoutput) throws IOException {
        String s = this.getFrameTitle();
        dataoutput.writeByte(1);
        dataoutput.writeUTF(s != null ? s : "");
        dataoutput.writeUTF(print.saveID != null ? print.saveID : "");
        dataoutput.writeUTF(print.saveFmtnm != null ? print.saveFmtnm : "");
        dataoutput.writeInt(print.editable);
        PageWrite pagewrite = new PageWrite(dataoutput);
        pagewrite.writePages((Print)this.pages);
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (this.deleteItem == actionevent.getSource() && this.pActiveCell != null) {
            Print print = (Print)this.pages;
            Print.Page page = print.getPage(this.pageIndex);
            page.cellSet.removeElement(this.pActiveCell);
            this.pActiveCell = null;
            this.repaintView();
            return;
        }
        if (this.menuItem == actionevent.getSource()) {
            this.toWinFile(true, "DOC");
            return;
        }
        if (this.menuExcelItem == actionevent.getSource()) {
            this.toWinFile(true, "XLS");
            return;
        }
        if (this.menuEMailItem == actionevent.getSource()) {
            String s8;
            String[] as1;
            String[] as;
            Tac tac = this.pages.getInterposeTac();
            this.emailMimeBodyPart = null;
            if (tac != null) {
                tac.callProc("prepareEMailInfo", null, new Object[]{this, this.emailAccountInfo});
            }
            if ((as = new String[]{this.emailAccountInfo[1], this.emailAccountInfo.length <= 6 ? null : this.emailAccountInfo[6], this.emailAccountInfo.length <= 7 ? null : this.emailAccountInfo[7], this.emailAccountInfo[2], this.emailAccountInfo[0], this.emailAccountInfo[3], this.emailAccountInfo[4]})[0] == null || as[0].trim().length() == 0) {
                try {
                    Object[][] aobj = JDBC.sqlSelect3("select ord,vtext from sysoptions2 where grp=16 and (ord=1 or ord=7 or ord=8)");
                    if (aobj != null) {
                        int i = 0;
                        while (i < aobj.length) {
                            int j = ((Number)aobj[i][0]).intValue();
                            String s5 = Utilities.getAsString(aobj[i][1]);
                            if (j == 1) {
                                as[0] = s5;
                            }
                            if (j == 7) {
                                as[1] = s5;
                            }
                            if (j == 8) {
                                as[2] = s5;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (as[4] == null) {
                try {
                    as[4] = JDBC.sqlSelectString("select email from wcode where wcode='" + ErpdataConfig.currentConfig.curWCode + "'");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (as.length != (as1 = new String[]{"SMTP\u670d\u52a1\u5668", "SMTP\u6821\u9a8c\u5e10\u6237", "SMTP\u6821\u9a8c\u53e3\u4ee4", "\u63a5\u53d7\u4eba\u5730\u5740", "\u53d1\u9001\u4eba\u5730\u5740", "\u4e3b\u9898", "\u90ae\u4ef6\u5185\u5bb9"}).length) {
                throw new IllegalArgumentException();
            }
            JTextComponent[] ajtextcomponent = new JTextComponent[as1.length];
            Component[] ajcomponent = new JComponent[ajtextcomponent.length];
            int k = 0;
            while (k < ajtextcomponent.length) {
                if (k == 6) {
                    ajtextcomponent[k] = new JTextArea(6, 80);
                } else if (k == 3 && this.emailAccountInfo.length > 8 && this.emailAccountInfo[8] != null) {
                    String[] as2 = Utilities.splitString(this.emailAccountInfo[8], '\n');
                    String[] as3 = new String[as2.length];
                    int i1 = 0;
                    while (i1 < as2.length) {
                        int j1 = as2[i1].indexOf(9);
                        if (j1 >= 0) {
                            as3[i1] = as2[i1].substring(0, j1);
                            as2[i1] = as2[i1].substring(j1 + 1);
                        } else {
                            as3[i1] = as2[i1];
                        }
                        ++i1;
                    }
                    ajtextcomponent[k] = new JTextFieldA(new ListAidInputer("\u63a5\u53d7\u4eba\u5730\u5740", as3, as2, ","));
                    ((JTextFieldA)ajtextcomponent[k]).setReplaceSelectionMode(true);
                } else {
                    JTextComponent jTextComponent = ajtextcomponent[k] = k != 2 ? new JTextField(20) : new JPasswordField(20);
                }
                if (as[k] != null) {
                    ajtextcomponent[k].setText(as[k]);
                }
                ajcomponent[k] = ajtextcomponent[k] instanceof JTextArea ? new JScrollPane(ajtextcomponent[k]) : ajtextcomponent[k];
                ++k;
            }
            DialogPanel dialogpanel = new DialogPanel();
            DialogPanel.createPanel(dialogpanel, as1, ajcomponent, 15, 20, 8, 30, 3, 5);
            if (dialogpanel.showDialog("\u53d1\u9001\u90ae\u4ef6") != 0) {
                return;
            }
            int l = 0;
            while (l < ajtextcomponent.length) {
                String s6 = ajtextcomponent[l] instanceof JPasswordField ? new String(((JPasswordField)ajtextcomponent[l]).getPassword()) : ajtextcomponent[l].getText();
                if (s6 != null) {
                    s6 = s6.trim();
                }
                as[l] = s6;
                ++l;
            }
            String s7 = this.toWinFile(false, "DOC");
            if (s7 == null) {
                return;
            }
            EMail email = new EMail();
            email.setHost(as[0]);
            if (as[1] != null && as[1].trim().length() > 0) {
                email.setMailUser(as[1].trim(), as[2]);
            }
            if (as[4] != null && as[4].trim().length() > 0) {
                email.setMailFrom(as[4].trim());
            }
            String string = s8 = this.emailAccountInfo.length <= 5 ? null : this.emailAccountInfo[5];
            if (s8 == null) {
                s8 = s7;
            }
            try {
                Object[] aobj1 = new Object[this.emailMimeBodyPart != null ? 2 + this.emailMimeBodyPart.length : 2];
                aobj1[0] = as[6];
                aobj1[1] = new EMail.MailAttachment(s8, new FileInputStream(s7));
                if (this.emailMimeBodyPart != null) {
                    System.arraycopy(this.emailMimeBodyPart, 0, aobj1, 2, this.emailMimeBodyPart.length);
                }
                email.addMail(as[3], as[5], aobj1);
                email.send();
                Message.showInformationDialog("\u53d1\u9001\u90ae\u4ef6", "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
            }
            catch (Exception exception5) {
                Message.printException(exception5, MainApp.isDebug);
            }
            return;
        }
    }

    private void onPopupMenu(int i, int j) {
        Point point = this.getLocationOnScreen();
        Print print = (Print)this.pages;
        if (print.editable != 0) {
            if (this.deleteItem == null) {
                this.deleteItem = new JMenuItem("\u5220\u9664\u5143\u7d20");
                this.deleteItem.addActionListener(this);
            }
            int k = 0;
            while (k < this.attrMenu.getComponentCount()) {
                if (this.deleteItem == this.attrMenu.getComponent(k)) {
                    this.attrMenu.remove(k);
                    break;
                }
                ++k;
            }
            boolean flag = false;
            if (this.pActiveCell instanceof Print.TextCell && !this.cellInTable(this.pActiveCell, null)) {
                flag = true;
            }
            if (!flag && this.pActiveCell instanceof Print.LineCell && this.lineInTable((Print.LineCell)this.pActiveCell) < 0) {
                flag = true;
            }
            if (flag) {
                this.attrMenu.add(this.deleteItem);
            }
        }
        i += point.x;
        j += point.y;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = this.attrMenu.getSize();
        if (dimension1 == null || dimension1.width == 0) {
            this.attrMenu.setLocation(i, j);
            this.attrMenu.setVisible(true);
            dimension1 = this.attrMenu.getSize();
        }
        boolean flag1 = false;
        if (i + dimension1.width > dimension.width) {
            i = dimension.width - dimension1.width;
            flag1 = true;
        }
        if (j + dimension1.height > dimension.height) {
            j = dimension.height - dimension1.height;
            flag1 = true;
        }
        if (flag1 || !this.attrMenu.isVisible()) {
            this.attrMenu.setLocation(i, j);
            this.attrMenu.setVisible(true);
        }
    }

    public int getDrawScale() {
        return this.dblDrawRate;
    }
}

