/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import softcore.awt.AwtUtil;
import softcore.print.Print;
import softcore.print.PrintFormatYacc;
import softcore.table.GridTable;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.tac.Tac;
import softcore.util.Constants;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.PreprocessedTextReader;
import softcore.util.Utilities;
import softface.MainApp;

public class PrintFormat {
    public static int DefaultRowHeight = 28;
    public boolean bRowGroup = true;
    public static Color TitleColor = Color.blue;
    public static Font defaultFont = new Font("\u5b8b\u4f53", 1, 16);
    String startFormula;
    String endFormula;
    int addrStartFormula;
    int addrEndFormula;
    public static int printFullPage = 1;
    public static int printLandScape = 2;
    public static int printPortrait = 4;
    int dmPaperSize;
    int pageWidth;
    int pageHeight;
    int splitRows;
    int splitCols;
    int gridRows;
    int gridCols;
    int groupNumber;
    int options;
    Vector rowSet = new Vector();
    Vector colSet = new Vector();
    Vector freeCellSet = new Vector();
    GraphCell backGraph = null;
    private static final String newLine = "\r\n";

    public void updateRowColNum() {
        this.gridRows = this.rowSet.size();
        this.gridCols = this.colSet.size();
    }

    public Row findRowForID(String s) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < this.rowSet.size()) {
            Row row = (Row)this.rowSet.elementAt(i);
            if (s.equals(row.strid)) {
                return row;
            }
            ++i;
        }
        return null;
    }

    public Col findColForID(String s) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < this.colSet.size()) {
            Col col = (Col)this.colSet.elementAt(i);
            if (s.equals(col.strid)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public Vector getFreeCellSet() {
        return this.freeCellSet;
    }

    public Vector getRowSet() {
        return this.rowSet;
    }

    public Vector getColSet() {
        return this.colSet;
    }

    void initFreeCellPrintRect() {
        int i = this.freeCellSet.size();
        int j = 0;
        while (j < i) {
            Cell cell = (Cell)this.freeCellSet.elementAt(j);
            cell.printRect = new Rectangle();
            cell.flagsAtPrinting = 0;
            ++j;
        }
    }

    public Dimension getSize() {
        Rectangle rectangle = this.getFreeCellBoundRect(false, false);
        int i = (int)this.getColLine(this.gridCols + 1);
        int j = (int)this.getRowLine(this.gridRows + 1);
        if (rectangle != null) {
            if (i < rectangle.width + rectangle.x) {
                i = rectangle.width + rectangle.x;
            }
            if (j < rectangle.height + rectangle.y) {
                j = rectangle.height + rectangle.y;
            }
        }
        return new Dimension(i + 16, j + 8);
    }

    Cell getObjectByPosition(int i, int j) {
        int k = this.freeCellSet.size() - 1;
        while (k >= 0) {
            Cell cell = (Cell)this.freeCellSet.elementAt(k);
            if (cell instanceof LineCell ? ((LineCell)cell).PointAtLine(i, j) : cell.isContains(i, j)) {
                return cell;
            }
            --k;
        }
        return null;
    }

    void getClientRect(Rectangle rectangle) {
        Dimension dimension = this.getSize();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setBounds(0, 0, dimension.width, dimension.height);
    }

    Rectangle getCellSelBoundRect() {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle1 = new Rectangle();
        int i = 1;
        while (i < this.gridRows) {
            Row row = this.getRow(i);
            if (row == null) break;
            int j = 1;
            while (j <= this.gridCols) {
                GridCell gridcell = row.getColCell(j);
                if (gridcell != null && (gridcell.options & FormulaCell.cellSelected) > 0) {
                    if (rectangle.isEmpty()) {
                        this.getCellDrawRect(i, j, rectangle);
                    } else {
                        this.getCellDrawRect(i, j, rectangle1);
                        rectangle = rectangle.union(rectangle1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return rectangle;
    }

    Rectangle getFreeCellBoundRect(boolean flag, boolean flag1) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle1 = new Rectangle();
        Enumeration enumeration = this.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (cell == null || flag1 && !cell.selected) continue;
            this.makeFactRect(cell.r, rectangle1);
            if (!flag) {
                rectangle1.setBounds(rectangle1.x - 3, rectangle1.y - 3, rectangle1.width + 6, rectangle1.height + 6);
            }
            if (rectangle.isEmpty()) {
                rectangle.setBounds(rectangle1);
                continue;
            }
            rectangle = rectangle.union(rectangle1);
        }
        return rectangle;
    }

    int countSelectedRow() {
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowSelected) <= 0) continue;
            ++i;
        }
        return i;
    }

    int countSelectedCol() {
        int i = 0;
        Enumeration enumeration = this.colSet.elements();
        while (enumeration.hasMoreElements()) {
            Col col = (Col)enumeration.nextElement();
            if ((col.options & Col.colSelected) <= 0) continue;
            ++i;
        }
        return i;
    }

    public int[] getSelectedRows() {
        int[] ai = null;
        int i = this.countSelectedRow();
        if (i > 0) {
            ai = new int[i];
            i = 0;
            int j = 0;
            Enumeration enumeration = this.rowSet.elements();
            while (enumeration.hasMoreElements()) {
                Row row = (Row)enumeration.nextElement();
                if ((row.options & Row.rowSelected) > 0) {
                    ai[i++] = j;
                }
                ++j;
            }
        }
        return ai;
    }

    public int[] getSelectedCols() {
        int[] ai = null;
        int i = this.countSelectedCol();
        if (i > 0) {
            ai = new int[i];
            i = 0;
            int j = 0;
            Enumeration enumeration = this.colSet.elements();
            while (enumeration.hasMoreElements()) {
                Col col = (Col)enumeration.nextElement();
                if ((col.options & Col.colSelected) > 0) {
                    ai[i++] = j;
                }
                ++j;
            }
        }
        return ai;
    }

    int getCountSelectedCell() {
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            Enumeration enumeration1 = row.cellSet.elements();
            while (enumeration1.hasMoreElements()) {
                GridCell gridcell = (GridCell)enumeration1.nextElement();
                if (gridcell == null || !gridcell.selected) continue;
                ++i;
            }
        }
        return i;
    }

    int getCountSelectedFreeCell() {
        int i = 0;
        Enumeration enumeration = this.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (cell == null || !cell.selected) continue;
            ++i;
        }
        return i;
    }

    public void init() {
        this.empty();
        this.gridCols = 5;
        int i = 0;
        while (i <= 5) {
            Col col = new Col();
            col.width = i != 0 ? 96.0 : 6.0;
            this.colSet.addElement(col);
            ++i;
        }
        if (this.bRowGroup) {
            this.gridRows = 4;
            int j = 0;
            while (j <= 4) {
                Row row = new Row();
                if (j == 2) {
                    row.options |= Row.rowGroupBgn | Row.rowGroupEnd;
                }
                this.rowSet.addElement(row);
                row.height = j != 0 && j != 4 ? 20.0 : 36.0;
                int l = 0;
                while (l <= 5) {
                    row.cellSet.addElement(new GridCell());
                    ++l;
                }
                ++j;
            }
        } else {
            this.gridRows = 10;
            int k = 0;
            while (k <= this.gridRows) {
                Row row1 = new Row();
                if (k == 2) {
                    row1.options |= Row.rowGroupBgn;
                } else if (k == this.gridRows - 2) {
                    row1.options |= Row.rowGroupEnd;
                }
                this.rowSet.addElement(row1);
                row1.height = k != 0 && k != this.gridRows ? 18.0 : 36.0;
                int i1 = 0;
                while (i1 <= 5) {
                    row1.cellSet.addElement(new GridCell());
                    ++i1;
                }
                ++k;
            }
        }
        this.groupNumber = this.countGroupNum();
    }

    int countGroupNum() {
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) <= 0) continue;
            ++i;
        }
        return i;
    }

    int rowOfGroup(int i) {
        int j = 0;
        int k = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) > 0) {
                ++j;
            }
            if (i == k) {
                return j;
            }
            ++k;
        }
        return -1;
    }

    int rowsOfGroup() {
        int i = 0;
        int j = 0;
        int k = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) > 0) {
                ++j;
            }
            if ((row.options & Row.rowSelected) > 0) {
                if (i > 0 && i != j) {
                    return -1;
                }
                i = j;
            }
            if ((row.options & Row.rowGroupEnd) > 0) {
                --j;
            }
            ++k;
        }
        return i;
    }

    boolean canDeleteRowCol() {
        int i = this.countSelectedRow();
        int j = this.countSelectedCol();
        if (j > 0 && i == 0) {
            return true;
        }
        int k = this.rowsOfGroup();
        if (k < 0) {
            return false;
        }
        int l = -1;
        int i1 = -1;
        boolean flag = false;
        boolean flag1 = false;
        int j1 = 1;
        int k1 = 1;
        boolean flag2 = false;
        int l1 = 0;
        if (i > 0) {
            Row row;
            int i2 = 0;
            while ((row = this.getRow(i2)) != null) {
                if ((row.options & Row.rowGroupBgn) > 0) {
                    ++l1;
                }
                if (l1 == k) {
                    if (l1 == this.groupNumber) {
                        ++j1;
                        ++k1;
                    } else if (!flag2 && (row.options & Row.rowGroupBgn) == 0) {
                        ++j1;
                    } else if (flag2 && (row.options & Row.rowGroupEnd) == 0) {
                        ++k1;
                    }
                }
                if ((row.options & Row.rowSelected) > 0) {
                    if (i <= 2) {
                        if (l < 0) {
                            l = i2;
                        }
                        i1 = i2;
                    }
                    if ((row.options & Row.rowGroupBgn) > 0) {
                        flag = true;
                    }
                    if ((row.options & Row.rowGroupEnd) > 0) {
                        flag1 = true;
                    }
                    if (i2 == 0 || i2 == this.gridRows || (row.options & (Row.rowGroupBgn | Row.rowGroupEnd)) == (Row.rowGroupBgn | Row.rowGroupEnd)) {
                        return false;
                    }
                    if (k >= 0 && k != l1) {
                        return false;
                    }
                    k = l1;
                }
                if ((row.options & Row.rowGroupEnd) > 0) {
                    flag2 = true;
                    --l1;
                }
                ++i2;
            }
            if (this.bRowGroup) {
                if (l == 1 && (this.getRow((int)(l + 1)).options & Row.rowGroupBgn) > 0) {
                    return false;
                }
                if (i1 == this.gridRows - 1 && (this.getRow((int)(i1 - 1)).options & Row.rowGroupEnd) > 0) {
                    return false;
                }
                return !flag && !flag1 || flag && flag1 && i == j1 + k1 || (!flag || !flag1) && (flag && j1 > 1 || flag1 && k1 > 1);
            }
            return !flag && !flag1 || l1 == 0 && flag && flag1 && i == j1 + k1 || (!flag || !flag1) && (flag && j1 > 1 || flag1 && k1 > 1);
        }
        return false;
    }

    Cell findUniqueFreeCell() {
        Enumeration enumeration = this.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (cell == null || !cell.selected) continue;
            return cell;
        }
        return null;
    }

    GridCell findUniqueGridCell() {
        int i = 1;
        while (i < this.gridRows) {
            Row row = this.getRow(i);
            if (row == null) break;
            int j = 1;
            while (j <= this.gridCols) {
                GridCell gridcell = row.getColCell(j);
                if (gridcell != null && (gridcell.options & FormulaCell.cellSelected) > 0) {
                    return gridcell;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    Row newGridRow() {
        Row row = new Row();
        int i = 0;
        while (i <= this.gridCols) {
            row.cellSet.addElement(new GridCell());
            ++i;
        }
        return row;
    }

    void setRowOptionsForInsertRow(Row row, Row row1) {
        int i = 0;
        while (i <= this.gridCols) {
            GridCell gridcell = row.getColCell(i);
            GridCell gridcell1 = row1.getColCell(i);
            if (gridcell != null && gridcell1 != null && (gridcell1.options & FormulaCell.cellMergeBottom) > 0) {
                gridcell.options |= gridcell1.options & (FormulaCell.cellMergeBottom | FormulaCell.cellMergeRight) | FormulaCell.cellBeMerged;
            }
            ++i;
        }
    }

    public int findFootRow() {
        int i = this.gridRows + 1;
        while (true) {
            Row row = this.getRow(i - 1);
            if ((row.options & Row.rowGroupEnd) > 0) break;
            --i;
        }
        return i;
    }

    double findHeadHeight(boolean flag) {
        double d = 0.0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) > 0) break;
            if ((row.options & Row.rowHideWhenPrinting) != 0 && !flag) continue;
            d += row.height;
        }
        return d;
    }

    double findGroupHeadHeight(int i, boolean flag) {
        double d = 0.0;
        if (i < 0) {
            i = 0;
        }
        int j = this.findFirstDetailRow();
        while (i < j && i <= this.gridRows) {
            Row row = this.getRow(i);
            if ((row.options & Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            ++i;
        }
        return d;
    }

    double findFootHeight(boolean flag) {
        double d = 0.0;
        int i = this.gridRows;
        while (i >= 0) {
            Row row = this.getRow(i);
            if ((row.options & Row.rowGroupEnd) > 0) break;
            if ((row.options & Row.rowHideWhenPrinting) != 0 && !flag) continue;
            d += row.height;
        }
        return d;
    }

    int findFirstRow() {
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) > 0) break;
            ++i;
        }
        return i;
    }

    int findFirstDetailRow() {
        int i = 0;
        int j = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((row.options & Row.rowGroupBgn) > 0) {
                i = j;
            }
            ++j;
        }
        return i;
    }

    double findDetailRowsHeight(boolean flag) {
        double d = 0.0;
        int i = this.findFirstDetailRow();
        while (i <= this.gridRows) {
            Row row = this.getRow(i);
            if ((row.options & Row.rowHideWhenPrinting) == 0 || flag) {
                d += row.height;
            }
            if ((row.options & Row.rowGroupEnd) > 0) break;
            ++i;
        }
        return d;
    }

    int findRowsInGroup(int i) {
        int j = 0;
        int k = this.findFootRow();
        int l = 0;
        int i1 = i;
        while (i1 <= this.gridRows && i1 < k) {
            Row row = this.getRow(i1);
            ++j;
            if ((row.options & Row.rowGroupBgn) > 0 && i1 > i) {
                ++l;
            }
            if ((row.options & Row.rowGroupEnd) > 0 && l-- <= 0) break;
            ++i1;
        }
        return j;
    }

    Dimension findGridSize() {
        int i = 0;
        int j = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            j = (int)((double)j + row.height);
        }
        Enumeration enumeration1 = this.colSet.elements();
        while (enumeration1.hasMoreElements()) {
            Col col = (Col)enumeration1.nextElement();
            i = (int)((double)i + col.width);
        }
        return new Dimension(i, j);
    }

    int PtInGridCell(Point point) {
        int i = 0;
        double d = 0.0;
        Enumeration enumeration = this.rowSet.elements();
        int j = 0;
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if ((double)point.y - d <= 2.0) {
                i |= 8;
            }
            if ((double)point.y < (d += row.height)) break;
            ++j;
        }
        if (!enumeration.hasMoreElements() && (i & 8) == 0 || j == 0) {
            return 0;
        }
        if (d - (double)point.y <= 2.0) {
            i |= 0x10;
        }
        double d1 = 0.0;
        enumeration = this.colSet.elements();
        int k = 0;
        while (enumeration.hasMoreElements()) {
            Col col = (Col)enumeration.nextElement();
            if ((double)point.x - d1 <= 2.0) {
                i |= 2;
            }
            if ((double)point.x <= (d1 += col.width)) break;
            ++k;
        }
        if ((double)point.x > d1 + 1.0 || k == 0) {
            return 0;
        }
        if (d1 - (double)point.x <= 2.0) {
            i |= 4;
        }
        point.x = k;
        point.y = j;
        return i | 1;
    }

    void getCellRect(int i, int j, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int k = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements() && k <= i) {
            Row row = (Row)enumeration.nextElement();
            d = d2;
            d2 = row.height;
            ++k;
        }
        int l = 0;
        Enumeration enumeration1 = this.colSet.elements();
        while (enumeration1.hasMoreElements() && l <= j) {
            Col col = (Col)enumeration1.nextElement();
            d1 = d3;
            d3 += col.width;
            ++l;
        }
        rectangle.setBounds((int)d1, (int)d, (int)(d3 - d1), (int)(d2 - d));
    }

    int isCanBatchAttr() {
        int byte0 = -1;
        boolean flag = false;
        Enumeration enumeration = this.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (!cell.selected) continue;
            int byte1 = cell instanceof StaticCell ? 1 : (cell instanceof FreeCell ? 2 : -1);
            if (byte1 < 0 || byte0 > 0 && byte1 != byte0) {
                return 0;
            }
            byte0 = byte1;
        }
        int i = 1;
        while (i < this.gridRows) {
            Row row = this.getRow(i);
            if (row == null) break;
            int j = 1;
            while (j <= this.gridCols) {
                GridCell gridcell = row.getColCell(j);
                if (gridcell != null && (gridcell.options & FormulaCell.cellSelected) > 0) {
                    return byte0 <= 0 || byte0 == 3 ? 3 : 0;
                }
                ++j;
            }
            ++i;
        }
        return byte0;
    }

    Point getCellRightBottom(int i, int j) {
        double d = 0.0;
        double d1 = 0.0;
        int k = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements() && k <= i) {
            Row row = (Row)enumeration.nextElement();
            d1 += row.height;
            ++k;
        }
        int l = 0;
        Enumeration enumeration1 = this.rowSet.elements();
        while (enumeration1.hasMoreElements() && k <= j) {
            Col col = (Col)enumeration1.nextElement();
            d += col.width;
            ++l;
        }
        return new Point((int)d, (int)d1);
    }

    public void getCellDrawRect(int i, int j, Rectangle rectangle) {
        rectangle.setBounds(0, 0, 0, 0);
        rectangle.x = j;
        rectangle.y = i;
        this.findMergedCells(rectangle);
        this.getCellsRect(rectangle);
    }

    void getCellsRect(Rectangle rectangle) {
        rectangle.width = (int)this.getColLine(rectangle.x + rectangle.width - 1);
        rectangle.height = (int)this.getRowLine(rectangle.y + rectangle.height - 1);
        rectangle.x = (int)this.getColLine(rectangle.x - 1);
        rectangle.y = (int)this.getRowLine(rectangle.y - 1);
        rectangle.width -= rectangle.x;
        rectangle.height -= rectangle.y;
    }

    public double getColLine(int i) {
        double d = 0.0;
        int j = 0;
        Enumeration enumeration = this.colSet.elements();
        while (enumeration.hasMoreElements() && j <= i) {
            Col col = (Col)enumeration.nextElement();
            d += col.width;
            ++j;
        }
        return d;
    }

    public double getRowLine(int i) {
        double d = 0.0;
        int j = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements() && j <= i) {
            Row row = (Row)enumeration.nextElement();
            d += row.height;
            ++j;
        }
        return d;
    }

    Row findGroupEndRow(int i) {
        int j = 0;
        int k = i;
        while (k <= this.gridRows) {
            Row row = this.getRow(k);
            if ((row.options & Row.rowGroupEnd) > 0) {
                if (j == 0) {
                    return row;
                }
                --j;
            }
            if (k > i && (row.options & Row.rowGroupBgn) > 0) {
                ++j;
            }
            ++k;
        }
        return null;
    }

    Row findGroupBgnRow(int i) {
        int j = 0;
        int k = i;
        while (k >= 0) {
            Row row = this.getRow(k);
            if ((row.options & Row.rowGroupBgn) > 0) {
                if (j == 0) {
                    return row;
                }
                --j;
            }
            if (k < i && (row.options & Row.rowGroupEnd) > 0) {
                ++j;
            }
            --k;
        }
        return null;
    }

    boolean isDetailRow(int i) {
        if (i <= 1 || i >= this.gridRows - 1) {
            return false;
        }
        int j = i;
        while (j <= this.gridRows) {
            Row row = this.getRow(j);
            if (row == null) {
                return false;
            }
            if (j > i && (row.options & Row.rowGroupBgn) > 0) {
                return false;
            }
            if ((row.options & Row.rowGroupEnd) > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    boolean hasMergedCell(Rectangle rectangle) {
        Point point = new Point(0, 0);
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            Enumeration enumeration1 = row.cellSet.elements();
            int j = 0;
            while (j <= this.gridCols && enumeration1.hasMoreElements()) {
                int k;
                GridCell gridcell = (GridCell)enumeration1.nextElement();
                point.x = j;
                point.y = i;
                if (rectangle.contains(point) && (gridcell.options & (k = FormulaCell.cellMergeBottom | FormulaCell.cellMergeRight)) > 0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    void setMergedFlag(Rectangle rectangle) {
        Point point = new Point(0, 0);
        int i = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            Enumeration enumeration1 = row.cellSet.elements();
            int j = 0;
            while (j <= this.gridCols && enumeration1.hasMoreElements()) {
                GridCell gridcell = (GridCell)enumeration1.nextElement();
                point.x = j;
                point.y = i;
                if (rectangle.contains(point)) {
                    gridcell.options = i == rectangle.y && j == rectangle.x ? (gridcell.options &= ~FormulaCell.cellBeMerged) : (gridcell.options |= FormulaCell.cellBeMerged);
                    if (i >= rectangle.y && i < rectangle.y + rectangle.height - 1) {
                        gridcell.options |= FormulaCell.cellMergeBottom;
                    }
                    if (j >= rectangle.x && j < rectangle.x + rectangle.width - 1) {
                        gridcell.options |= FormulaCell.cellMergeRight;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    void findMergedCells(Rectangle rectangle) {
        GridCell gridcell1;
        Row row1;
        rectangle.width = 1;
        rectangle.height = 1;
        Row row = this.getRow(rectangle.y);
        if (row == null) {
            return;
        }
        Object obj = null;
        int i = rectangle.x;
        while (true) {
            GridCell gridcell;
            if ((gridcell = row.getColCell(i++)) == null) {
                return;
            }
            if ((gridcell.options & FormulaCell.cellMergeRight) == 0) break;
            ++rectangle.width;
        }
        int j = rectangle.y;
        while ((row1 = this.getRow(j++)) != null && (gridcell1 = row1.getColCell(rectangle.x)) != null && (gridcell1.options & FormulaCell.cellMergeBottom) != 0) {
            ++rectangle.height;
        }
    }

    void findMergeOwner(Point point) {
        if (point.y <= 0 || point.y >= this.gridRows || point.x <= 0 || point.x > this.gridCols) {
            return;
        }
        GridCell gridcell = this.getGridCell(point.y, point.x);
        if (gridcell == null) {
            return;
        }
        if ((gridcell.options & FormulaCell.cellBeMerged) == 0) {
            return;
        }
        Row row = this.getRow(point.y);
        if (row == null) {
            return;
        }
        int i = point.x;
        while (true) {
            GridCell gridcell1;
            if ((gridcell1 = row.getColCell(i - 1)) == null) {
                return;
            }
            if ((gridcell1.options & FormulaCell.cellMergeRight) == 0) break;
            --point.x;
            --i;
        }
        int j = point.y;
        while (true) {
            Row row1;
            if ((row1 = this.getRow(j - 1)) == null) {
                return;
            }
            GridCell gridcell2 = row1.getColCell(i);
            if (gridcell2 == null || (gridcell2.options & FormulaCell.cellMergeBottom) == 0) break;
            --point.y;
            --j;
        }
    }

    public Row getRow(int i) {
        if (i >= 0 && i < this.rowSet.size()) {
            return (Row)this.rowSet.elementAt(i);
        }
        return null;
    }

    public Col getColumn(int i) {
        if (i >= 0 && i < this.colSet.size()) {
            return (Col)this.colSet.elementAt(i);
        }
        return null;
    }

    public GridCell getGridCell(int i, int j) {
        Row row = this.getRow(i);
        if (row != null) {
            return row.getColCell(j);
        }
        return null;
    }

    boolean isValidDrawGridLinePoint(int i, int j) {
        return i >= 0 && i < this.gridRows && j >= 0 && j <= this.gridCols;
    }

    boolean addRowEnable(Dimension dimension) {
        int i = 0;
        int j = 0;
        int k = 0;
        boolean flag = false;
        boolean flag1 = false;
        int l = 0;
        Enumeration enumeration = this.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            block15: {
                Row row;
                block13: {
                    block14: {
                        row = (Row)enumeration.nextElement();
                        if (l != 0 && l != this.gridRows) break block13;
                        if ((row.options & Row.rowSelected) <= 0) break block14;
                        if (this.bRowGroup) {
                            return false;
                        }
                        boolean flag2 = true;
                        break block13;
                    }
                    if (this.bRowGroup) break block15;
                }
                if ((row.options & Row.rowGroupBgn) > 0) {
                    ++k;
                }
                if (i == 1 && (row.options & Row.rowGroupBgn) > 0) {
                    ++j;
                }
                if (this.bRowGroup && (row.options & Row.rowSelected) > 0 && i++ >= 2) {
                    return false;
                }
                if (i == 1 && (row.options & Row.rowGroupEnd) > 0) {
                    flag = true;
                    --j;
                }
                if ((row.options & Row.rowSelected) != 0) {
                    if (i == 1) {
                        dimension.width = l;
                    }
                    if (i == 2) {
                        dimension.height = l;
                    }
                }
            }
            ++l;
        }
        if (this.bRowGroup) {
            return i == true || i == 2 && k < 5 && j == 0 && flag;
        }
        return true;
    }

    private void makeFactRect(Rectangle rectangle, Rectangle rectangle1) {
        int i = rectangle.x;
        int j = rectangle.y;
        int k = rectangle.x + rectangle.width;
        int l = rectangle.y + rectangle.height;
        boolean flag = false;
        if (i > k) {
            int i1 = i;
            i = k;
            k = i1;
        }
        if (j > l) {
            int j1 = j;
            j = l;
            l = j1;
        }
        rectangle1.setBounds(i, j, k - i, l - j);
    }

    public GraphCell getBackGraph() {
        return this.backGraph;
    }

    public void setBackGraph(String s, int i, int j) {
        this.backGraph = new GraphCell(new Rectangle());
        this.backGraph.setImageName(s);
        if (this.backGraph.img != null) {
            this.backGraph.r.setBounds(i, j, this.pageWidth, this.pageHeight);
        }
    }

    void empty() {
        this.backGraph = null;
        this.startFormula = null;
        this.endFormula = null;
        this.gridCols = 0;
        this.gridRows = 0;
        this.splitCols = 1;
        this.splitRows = 1;
        this.pageHeight = 0;
        this.pageWidth = 0;
        this.rowSet.removeAllElements();
        this.colSet.removeAllElements();
        this.freeCellSet.removeAllElements();
    }

    public boolean loadFromDef(int i, int j, String s) {
        try {
            String s1 = JDBC.sqlSelectString("select deftext from defs where sysid=" + i + " and deftype=" + j + " and defname='" + s + "'");
            return s1 != null && this.loadFromText(s1);
        }
        catch (Exception exception) {
            Message.out.println(exception);
            return false;
        }
    }

    public boolean loadFromText(String s) {
        if (s != null && s.length() > 0) {
            this.empty();
            PrintFormatYacc printformatyacc = new PrintFormatYacc(this);
            try {
                PreprocessedTextReader preprocessedtextreader = new PreprocessedTextReader(new StringReader(s));
                printformatyacc.setInputStream(preprocessedtextreader);
                return printformatyacc.yyparse() == 0;
            }
            catch (Exception exception) {
                Message.out.println(exception);
            }
        }
        return false;
    }

    private static int saveFreeCellSet(Vector vector, StringBuffer stringbuffer) {
        int i = vector.size();
        int j = 0;
        while (j < i) {
            Cell cell = (Cell)vector.elementAt(j);
            cell.saveAsText(stringbuffer, 0);
            if (j < i - 1) {
                stringbuffer.append(";\r\n");
            }
            ++j;
        }
        return i;
    }

    public String saveAsText() {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("/*VER0200*/\r\n\r\n");
        if (PrintFormat.saveFreeCellSet(this.freeCellSet, stringbuffer) > 0) {
            stringbuffer.append(";\r\n\r\n");
        }
        stringbuffer.append("GRID : Options=" + this.options);
        if (this.splitRows > 1 || this.splitCols > 1) {
            stringbuffer.append(";GridSplit(" + this.splitRows + ',' + this.splitCols + ')');
        }
        if (this.pageWidth > 1 || this.pageHeight > 1) {
            stringbuffer.append(";FixPageSize(" + this.pageWidth + ',' + this.pageHeight + ')');
        }
        if (this.dmPaperSize > 0) {
            stringbuffer.append(";dmPaperSize=" + this.dmPaperSize);
        }
        if (this.startFormula != null && this.startFormula.length() > 0) {
            PrintFormat.saveText(stringbuffer, this.startFormula, ";StartReport=", 2);
        }
        if (this.endFormula != null && this.endFormula.length() > 0) {
            PrintFormat.saveText(stringbuffer, this.endFormula, ";EndReport=", 2);
        }
        int i = this.colSet.size();
        int j = 0;
        while (j < i) {
            Col col = (Col)this.colSet.elementAt(j);
            stringbuffer.append(";\r\n");
            col.saveAsText(stringbuffer);
            ++j;
        }
        i = this.rowSet.size();
        int k = 0;
        while (k < i) {
            Row row = (Row)this.rowSet.elementAt(k);
            stringbuffer.append(";\r\n");
            row.saveAsText(stringbuffer);
            ++k;
        }
        return stringbuffer.toString();
    }

    private static final void saveLeftSpace(StringBuffer stringbuffer, int i) {
        int j = 0;
        while (j < i) {
            stringbuffer.append(' ');
            ++j;
        }
    }

    private static final void saveColorCommaPrefix(StringBuffer stringbuffer, Color color) {
        PrintFormat.saveColor(stringbuffer, color, ",");
    }

    private static final void saveColor(StringBuffer stringbuffer, Color color, String s) {
        if (color == null) {
            return;
        }
        if (s == null) {
            s = "";
        }
        stringbuffer.append(String.valueOf(s) + "RGB(" + color.getRed() + ',' + color.getGreen() + ',' + color.getBlue() + ')');
    }

    private static final void saveRect(StringBuffer stringbuffer, Rectangle rectangle, String s) {
        if (rectangle == null) {
            return;
        }
        if (s == null) {
            s = "";
        }
        stringbuffer.append(String.valueOf(s) + '(' + rectangle.x + ',' + rectangle.y + ',' + (rectangle.x + rectangle.width) + ',' + (rectangle.y + rectangle.height) + ')');
    }

    private static final void saveFontCommaPrefix(StringBuffer stringbuffer, Font font) {
        PrintFormat.saveFont(stringbuffer, font, ",");
    }

    private static final void saveFont(StringBuffer stringbuffer, Font font, String s) {
        if (font == null) {
            return;
        }
        if (s == null) {
            s = "";
        }
        stringbuffer.append(String.valueOf(s) + "FONT(\"" + font.getName() + "\"," + font.getStyle() + ',' + font.getSize() + ')');
    }

    public static final void saveText(StringBuffer stringbuffer, String s, String s1, int i) {
        if (s1 != null) {
            stringbuffer.append(s1);
        }
        stringbuffer.append('\"');
        if (s != null) {
            int j = s.length();
            int k = 0;
            while (k < j) {
                char c = s.charAt(k);
                switch (c) {
                    case '\"': {
                        stringbuffer.append("\\\"");
                        break;
                    }
                    case '\\': {
                        stringbuffer.append("\\\\");
                        break;
                    }
                    case '\n': {
                        stringbuffer.append("\"\r\n");
                        PrintFormat.saveLeftSpace(stringbuffer, i);
                        stringbuffer.append("&\"");
                        break;
                    }
                    case '\t': {
                        stringbuffer.append("\\t");
                        break;
                    }
                    default: {
                        stringbuffer.append(c);
                    }
                    case '\r': 
                }
                ++k;
            }
        }
        stringbuffer.append('\"');
    }

    private Row newRowByTableColumn(TableColumn[] atablecolumn, int i, int j, int k, Font font, String s, int l, int i1, int j1) {
        if (font == null) {
            font = new Font("Dialog.plan", 0, 16 * j1 / 100);
        }
        Row row = new Row();
        row.height = j;
        if (k > 0) {
            row.options |= k;
        }
        row.cellSet.addElement(new GridCell());
        int k1 = atablecolumn.length;
        int l1 = i;
        while (l1 < k1) {
            if ((atablecolumn[l1].options & 1) == 0) {
                GridCell gridcell = new GridCell();
                if (font != null) {
                    gridcell.font = font;
                }
                if (i1 == 32 && l > 0 && l1 >= k1 - l) {
                    gridcell.text = "innervar" + String.valueOf(l1) + "=toCur(0)";
                }
                if ((i1 & 1) != 0) {
                    gridcell.text = Tac.replaceInvalidIdentifierPart(atablecolumn[l1].displayCaption);
                    gridcell.options |= FormulaCell.cellAlignVCenter | FormulaCell.cellAlignCenter | FormulaCell.cellIsStaticText | FormulaCell.cellPrintOnMutiLine;
                }
                if ((i1 & 2) != 0) {
                    gridcell.options |= FormulaCell.cellAlignVCenter;
                    int[] ai = new int[]{4, 8, 32};
                    int[] ai1 = new int[]{FormulaCell.cellAlignRight, FormulaCell.cellAlignCenter, FormulaCell.cellThousandsSeparator};
                    int i2 = 0;
                    while (i2 < ai.length) {
                        if ((atablecolumn[l1].options & ai[i2]) != 0) {
                            gridcell.options |= ai1[i2];
                        }
                        ++i2;
                    }
                    gridcell.minDecimals = atablecolumn[l1].getMinDecimals();
                    gridcell.maxDecimals = atablecolumn[l1].getMaxDecimals();
                    String s1 = "get$(\"" + Tac.replaceInvalidIdentifierPart(atablecolumn[l1].displayCaption) + "\")";
                    gridcell.text = (i1 & 0x20) != 0 && l > 0 && l1 >= k1 - l ? "if get$(\"" + Tac.replaceInvalidIdentifierPart(atablecolumn[0].displayCaption) + "\") == 0 \n innervar" + String.valueOf(l1) + "=" + "innervar" + String.valueOf(l1) + "+" + s1 + "\nend if\n" + s1 : s1;
                }
                if ((i1 & 4) != 0) {
                    if ((i1 & 0x20) != 0 && l > 0 && l1 >= k1 - l) {
                        gridcell.text = "innervar" + String.valueOf(l1);
                    } else {
                        gridcell.text = "";
                        if (l > 0 && l1 >= k1 - l) {
                            gridcell.totalType = 1;
                        }
                    }
                }
                if ((atablecolumn[l1].options & 0x2000) != 0) {
                    gridcell.minDecimals = 0;
                    gridcell.maxDecimals = 0;
                }
                row.cellSet.addElement(gridcell);
            }
            ++l1;
        }
        row.height += 6.0;
        this.rowSet.addElement(row);
        return row;
    }

    private Row[] newCaptionRows(Table table, TableColumn[] atablecolumn, int i, Font font, String s, int j) {
        if (atablecolumn == null && table != null) {
            atablecolumn = table.getTableColumns();
        }
        if (font == null) {
            font = new Font("Dialog.plan", 0, 16 * j / 100);
        }
        int k = 1;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int l = atablecolumn.length;
        int i1 = 0;
        while (i1 < l) {
            String[] as;
            if ((atablecolumn[i1].options & 1) == 0 && (as = Utilities.splitString(atablecolumn[i1].displayCaption, '|')).length > 1) {
                if (k < as.length) {
                    k = as.length;
                }
                hashtable.put("" + i1, as);
            }
            ++i1;
        }
        if (k == 1) {
            i = 20 * table.findTopFixedRows(null) * j / 100;
        }
        Row[] arow = new Row[k];
        int j1 = 0;
        while (j1 < arow.length) {
            arow[j1] = new Row();
            arow[j1].height = i;
            arow[j1].cellSet.addElement(new GridCell());
            int k1 = 0;
            while (k1 < l) {
                if ((atablecolumn[k1].options & 1) == 0) {
                    Object obj = hashtable.get("" + k1);
                    String[] as1 = obj != null ? (String[])obj : null;
                    GridCell gridcell = new GridCell();
                    if (font != null) {
                        gridcell.font = font;
                    }
                    gridcell.options |= FormulaCell.cellAlignVCenter | FormulaCell.cellAlignCenter | FormulaCell.cellIsStaticText | FormulaCell.cellPrintOnMutiLine;
                    if (as1 == null) {
                        if (j1 == 0) {
                            if (k > 1) {
                                gridcell.options |= FormulaCell.cellMergeBottom;
                            }
                            gridcell.text = Tac.replaceInvalidIdentifierPart(atablecolumn[k1].displayCaption);
                        } else if (k > 1) {
                            gridcell.options |= FormulaCell.cellBeMerged;
                            if (j1 < k - 1) {
                                gridcell.options |= FormulaCell.cellMergeBottom;
                            }
                        }
                    } else if (as1.length < k) {
                        if (j1 < as1.length - 1) {
                            gridcell.text = as1[j1];
                        } else if (j1 == as1.length - 1) {
                            gridcell.options |= FormulaCell.cellMergeBottom;
                            gridcell.text = as1[j1];
                        } else {
                            gridcell.options |= FormulaCell.cellBeMerged;
                            if (j1 < k - 1) {
                                gridcell.options |= FormulaCell.cellMergeBottom;
                            }
                        }
                    } else {
                        gridcell.text = as1[j1];
                    }
                    arow[j1].cellSet.addElement(gridcell);
                }
                ++k1;
            }
            arow[j1].height += 6.0;
            this.rowSet.addElement(arow[j1]);
            ++j1;
        }
        if (k < 2) {
            return arow;
        }
        Vector[] avector = new Vector[k];
        int l1 = 0;
        while (l1 < k) {
            avector[l1] = new Vector();
            ++l1;
        }
        int i2 = 0;
        while (i2 < k - 1) {
            int j2 = 0;
            while (j2 < l) {
                String[] as2;
                int j3;
                Object obj1 = hashtable.get("" + j2);
                if (obj1 != null && i2 < (j3 = (as2 = (String[])obj1).length)) {
                    int l3 = 0;
                    int i4 = j2 + 1;
                    while (i4 < l) {
                        String[] as3;
                        Object obj2 = hashtable.get("" + i4);
                        if (obj2 == null || (as3 = (String[])obj2).length != j3) break;
                        boolean flag = true;
                        int j4 = 0;
                        while (j4 <= i2) {
                            if (!as2[j4].equals(as3[j4])) {
                                flag = false;
                                break;
                            }
                            ++j4;
                        }
                        if (!flag) break;
                        ++l3;
                        ++i4;
                    }
                    if (l3 > 0) {
                        avector[i2].addElement(new Point(j2, l3 + 1));
                    }
                    j2 += l3;
                }
                ++j2;
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < k - 1) {
            int l2 = 0;
            while (l2 < avector[k2].size()) {
                Point point = (Point)avector[k2].elementAt(l2);
                int k3 = point.x;
                while (k3 < point.x + point.y) {
                    GridCell gridcell1 = arow[k2].getColCell(k3 + 1);
                    gridcell1.options = k3 == point.x ? (gridcell1.options |= FormulaCell.cellMergeRight) : (k3 < point.x + point.y - 1 ? (gridcell1.options |= FormulaCell.cellBeMerged | FormulaCell.cellMergeRight) : (gridcell1.options |= FormulaCell.cellBeMerged));
                    ++k3;
                }
                ++l2;
            }
            ++k2;
        }
        int i3 = 0;
        while (i3 < k) {
            avector[i3].removeAllElements();
            ++i3;
        }
        hashtable.clear();
        return arow;
    }

    public void createPrintFormat(Table table) {
        this.createPrintFormat(table, 0, 0, 1, null);
    }

    public void createPrintFormat(Table table, int i, int j, int k, String s) {
        int l = MainApp.getAppIntOption(90, 1);
        if (l <= 0) {
            l = 60;
        }
        this.empty();
        Col col = new Col();
        col.width = 32 * l / 100;
        this.colSet.addElement(col);
        TableColumn[] atablecolumn = table.getTableColumns();
        boolean flag = table instanceof GridTable;
        boolean flag1 = false;
        if (flag) {
            flag1 = ((GridTable)table).getBottomFixedRows() > 0;
        }
        int i1 = 32 * l / 100;
        int j1 = atablecolumn.length;
        int k1 = 0;
        if ((k & 0x20) != 0 || i > 0 || flag1 && i == 0) {
            int l1 = j1 - 1;
            while (l1 >= 0) {
                if ((atablecolumn[l1].options & 1) == 0) {
                    int i2 = atablecolumn[l1].getDataType();
                    if (i2 != 10 && i2 != 7 && i2 != 6) break;
                    ++k1;
                }
                --l1;
            }
        }
        int byte0 = 0;
        if (k1 <= 0) {
            i = j;
        } else if (flag1 && i == 0 && atablecolumn[0].cellId.equals("_INNER_VAL_") && (atablecolumn[0].options & 1) != 0) {
            byte0 = 32;
        }
        int j2 = j;
        int k2 = j;
        while (k2 < j1) {
            if ((atablecolumn[k2].options & 1) == 0) {
                ++j2;
                Col col1 = new Col();
                col1.width = atablecolumn[k2].width * l / 100;
                this.colSet.addElement(col1);
                i1 = (int)((double)i1 + col1.width);
            }
            ++k2;
        }
        String s1 = s;
        if (s1 == null) {
            Container obj = table;
            while (obj != null) {
                if (obj instanceof JInternalFrame) {
                    s1 = ((JInternalFrame)obj).getTitle();
                    break;
                }
                if (obj instanceof Frame) {
                    s1 = ((Frame)obj).getTitle();
                    break;
                }
                obj = ((Component)obj).getParent();
            }
        }
        if (s1 != null) {
            StaticCell staticcell = new StaticCell();
            staticcell.text = s1;
            staticcell.r = new Rectangle(1, 1, i1 - 2, 58 * l / 100);
            staticcell.options = FormulaCell.cellAlignVCenter | FormulaCell.cellAlignCenter | FormulaCell.cellIsStaticText | FormulaCell.cellPrintOnMutiLine;
            staticcell.font = new Font("Dialog", 1, 24 * l / 100);
            this.freeCellSet.addElement(staticcell);
        }
        int l2 = 60 * l / 100;
        if (j > 0) {
            FreeCell freecell = new FreeCell();
            freecell.text = "";
            int i3 = 0;
            while (i3 < j) {
                if (i3 > 0) {
                    freecell.text = String.valueOf(freecell.text) + "+\"  \"+";
                }
                freecell.text = String.valueOf(freecell.text) + '\"' + Tac.replaceInvalidIdentifierPart(atablecolumn[i3].displayCaption) + ":\"+" + "get$(\"" + Tac.replaceInvalidIdentifierPart(atablecolumn[i3].displayCaption) + "\")";
                ++i3;
            }
            freecell.r = new Rectangle(32, l2 + 2, i1 - 2, 36);
            freecell.options = FormulaCell.cellAlignVCenter;
            freecell.font = new Font("Dialog", 0, 18 * l / 100);
            this.freeCellSet.addElement(freecell);
            l2 += 40 * l / 100;
        }
        Row row = this.newRowByTableColumn(atablecolumn, j, l2, 0, null, "", 0, 0, l);
        Font font = new Font("Dialog", 0, 18 * l / 100);
        Row[] arow = this.newCaptionRows(table, atablecolumn, 18 * l / 100, font, "", l);
        int j3 = 0;
        while (j3 < arow.length) {
            l2 = (int)((double)l2 + arow[j3].height);
            ++j3;
        }
        if (j > 0 || k1 > 0) {
            row = this.newRowByTableColumn(atablecolumn, j, 2, Row.rowGroupBgn | Row.rowHideWhenPrinting | Row.rowNewPage, null, "", k1, byte0, l);
            l2 = (int)((double)l2 + row.height);
            row.groupFormula = "";
            int k3 = 0;
            while (k3 < j) {
                if (k3 > 0) {
                    row.groupFormula = String.valueOf(row.groupFormula) + "+";
                }
                row.groupFormula = String.valueOf(row.groupFormula) + "get$(\"" + Tac.replaceInvalidIdentifierPart(atablecolumn[k3].displayCaption) + "\")";
                ++k3;
            }
        }
        if (k1 > 0) {
            int l3 = 0;
            while (l3 < i - j) {
                row = this.newRowByTableColumn(atablecolumn, j, 2, Row.rowGroupBgn | Row.rowHideWhenPrinting, null, "", 0, 0, l);
                l2 = (int)((double)l2 + row.height);
                row.groupFormula = "";
                int j4 = j;
                while (j4 <= j + l3) {
                    if (row.groupFormula.length() > 0) {
                        row.groupFormula = String.valueOf(row.groupFormula) + "+";
                    }
                    row.groupFormula = String.valueOf(row.groupFormula) + "get$(\"" + Tac.replaceInvalidIdentifierPart(atablecolumn[j4].displayCaption) + "\")";
                    ++j4;
                }
                ++l3;
            }
        }
        font = new Font("Dialog", 0, 16 * l / 100);
        row = this.newRowByTableColumn(atablecolumn, j, 18 * l / 100, Row.rowGroupBgn | Row.rowGroupEnd, font, "", k1, 2 + byte0, l);
        l2 = (int)((double)l2 + row.height);
        if (k1 > 0) {
            int i4 = 0;
            while (i4 < i - j) {
                row = this.newRowByTableColumn(atablecolumn, j, 18 * l / 100, Row.rowGroupEnd, font, null, k1, 6, l);
                GridCell gridcell = row.getColCell(i - j - i4);
                gridcell.options = FormulaCell.cellAlignVCenter | FormulaCell.cellIsStaticText;
                gridcell.text = "\u5c0f\u8ba1";
                l2 = (int)((double)l2 + row.height);
                ++i4;
            }
        }
        if (j > 0 || k1 > 0) {
            if (k1 > 0) {
                if (font == null) {
                    // empty if block
                }
                int k4 = ((GridTable)table).getBottomFixedRows();
                int l4 = 0;
                while (l4 < k4) {
                    row = new Row();
                    row.height = 18 * l / 100;
                    if (l4 == k4 - 1) {
                        row.options |= Row.rowGroupEnd;
                    }
                    row.cellSet.addElement(new GridCell());
                    int i5 = j;
                    while (i5 < j1) {
                        if ((atablecolumn[i5].options & 1) == 0) {
                            GridCell gridcell1 = new GridCell();
                            if (font != null) {
                                gridcell1.font = font;
                            }
                            gridcell1.options |= FormulaCell.cellAlignVCenter | FormulaCell.cellIsStaticText;
                            if ((table.getColumn((int)i5).options & 8) != 0) {
                                gridcell1.options |= FormulaCell.cellAlignCenter;
                            } else if ((table.getColumn((int)i5).options & 4) != 0) {
                                gridcell1.options |= FormulaCell.cellAlignRight;
                            }
                            if ((atablecolumn[i5].options & 0x2000) != 0) {
                                gridcell1.minDecimals = 0;
                                gridcell1.maxDecimals = 0;
                            }
                            Object obj1 = table.getBottomValue(atablecolumn[i5].displayCaption, l4);
                            String s2 = "";
                            if (obj1 instanceof BigDecimal || obj1 instanceof Float || obj1 instanceof Double) {
                                s2 = Utilities.format(((Number)obj1).doubleValue(), gridcell1.minDecimals, gridcell1.maxDecimals, true);
                            } else if (obj1 != null) {
                                s2 = obj1.toString();
                            }
                            gridcell1.text = s2;
                            row.cellSet.addElement(gridcell1);
                        }
                        ++i5;
                    }
                    row.height += 6.0;
                    this.rowSet.addElement(row);
                    l2 = (int)((double)l2 + row.height);
                    ++l4;
                }
            } else {
                row = this.newRowByTableColumn(atablecolumn, j, 2, Row.rowGroupEnd | Row.rowHideWhenPrinting, font, null, 0, 0, l);
                l2 = (int)((double)l2 + row.height);
            }
        }
        row = this.newRowByTableColumn(atablecolumn, j, 2, Row.rowHideWhenPrinting, null, null, 0, 0, l);
        l2 = (int)((double)l2 + row.height);
        row = this.newRowByTableColumn(atablecolumn, j, 40 * l / 100, 0, null, null, 0, 0, l);
        if (k > 0) {
            FreeCell freecell1 = new FreeCell();
            freecell1.text = "\"\u7b2c  \"+\u9875\u53f7+\"  \u9875\"";
            freecell1.r = new Rectangle(1, l2 + 2, i1 - 2, 36 * l / 100);
            freecell1.options = FormulaCell.cellAlignVCenter | FormulaCell.cellAlignCenter;
            freecell1.font = new Font("Dialog", 1, 14 * l / 100);
            this.freeCellSet.addElement(freecell1);
        }
    }

    protected void finalize() throws Throwable {
        this.empty();
    }

    public static abstract class Cell {
        public String text;
        public String strid;
        public Font font;
        public int options;
        public Color foreColor;
        public int lineGap;
        public boolean selected;
        public boolean canEdit;
        public Rectangle r;
        transient int flagsAtPrinting;
        transient Rectangle printRect;

        public void setOptions(int i, boolean flag) {
            this.options = flag ? (this.options |= i) : (this.options &= ~i);
        }

        public boolean isContains(int i, int j) {
            int j1;
            int i1;
            int l;
            int k;
            if (this.r.width >= 0) {
                k = this.r.x;
                l = this.r.x + this.r.width;
            } else {
                k = this.r.x + this.r.width;
                l = this.r.x;
            }
            if (this.r.height >= 0) {
                i1 = this.r.y;
                j1 = this.r.y + this.r.height;
            } else {
                i1 = this.r.y + this.r.height;
                j1 = this.r.y;
            }
            return i >= k && i <= l && j >= i1 && j <= j1;
        }

        public boolean isCanSize(int i, int j) {
            return (i -= this.r.x + this.r.width) >= -2 && i <= 2 && (j -= this.r.y + this.r.height) >= -2 && j <= 2;
        }

        public void drawBorderRect(Graphics g) {
            byte byte0 = this instanceof FreeCell ? (byte)(this.selected ? 2 : 5) : (byte)(this.selected ? 2 : 3);
            AwtUtil.drawLine(g, this.r.x, this.r.y, this.r.x + this.r.width, this.r.y, Color.black, byte0, 1);
            AwtUtil.drawLine(g, this.r.x + this.r.width, this.r.y, this.r.x + this.r.width, this.r.y + this.r.height, Color.black, byte0, 1);
            AwtUtil.drawLine(g, this.r.x, this.r.y, this.r.x, this.r.y + this.r.height, Color.black, byte0, 1);
            AwtUtil.drawLine(g, this.r.x, this.r.y + this.r.height, this.r.x + this.r.width, this.r.y + this.r.height, Color.black, byte0, 1);
            if (this.selected) {
                g.setColor(Color.red);
                g.drawRect(this.r.x - 2, this.r.y - 2, 4, 4);
                g.drawRect(this.r.x + this.r.width - 2, this.r.y - 2, 4, 4);
                g.drawRect(this.r.x - 2, this.r.y + this.r.height - 2, 4, 4);
                g.drawRect(this.r.x + this.r.width - 2, this.r.y + this.r.height - 2, 4, 4);
            }
        }

        public abstract void draw(Graphics var1, boolean var2, boolean var3);

        public abstract void saveAsText(StringBuffer var1, int var2);

        public abstract Object printCell(Print var1, Print.Page var2, Object var3);

        public Cell() {
            this(null);
        }

        public Cell(Rectangle rectangle) {
            if (rectangle != null) {
                this.r = new Rectangle(rectangle);
            }
            this.font = Constants.FontDialogPlain16;
            this.options = FormulaCell.cellAlignCenter;
            this.foreColor = Color.black;
            this.selected = false;
            this.canEdit = true;
            this.lineGap = 1;
        }
    }

    public static class Col {
        public static int colHideWhenPrinting = 16;
        public static int colGroupToLeft = 32;
        public static int colLineNo = 64;
        public static int colSelected = 65536;
        public String strid;
        public String dupTimes;
        public int addrDupTimes;
        public double width = 96.0;
        public int options;
        int mapRptdataCol;
        int mapRptdataType;
        transient int duptimes;

        public void setOptions(int i, boolean flag) {
            this.options = flag ? (this.options |= i) : (this.options &= ~i);
        }

        public void saveAsText(StringBuffer stringbuffer) {
            if (this.width == (double)((int)this.width)) {
                stringbuffer.append("GridCol( Width=" + (int)this.width);
            } else {
                stringbuffer.append("GridCol( Width=" + this.width);
            }
            if (this.strid != null && this.strid.length() > 0) {
                stringbuffer.append(",ID=\"" + this.strid + "\"");
            }
            if (this.options != 0) {
                stringbuffer.append(",Options=" + (this.options & 0xFFFFFF & ~colSelected));
            }
            if (this.mapRptdataCol > 0) {
                stringbuffer.append(",MapRptdataCol=" + this.mapRptdataCol);
            }
            if (this.mapRptdataType > 0) {
                stringbuffer.append(",MapRptdataType=" + this.mapRptdataType);
            }
            if (this.dupTimes != null && this.dupTimes.length() > 0) {
                PrintFormat.saveText(stringbuffer, this.dupTimes, ",DupTimes=", 2);
            }
            stringbuffer.append(')');
        }
    }

    public static abstract class FormulaCell
    extends Cell {
        public static int cellMergeBottom = 1;
        public static int cellMergeRight = 2;
        public static int cellBeMerged = 4;
        public static int cellMergeCell = 8;
        public static int cellSuppressIfZero = 16;
        public static int cellSuppressIfDuplicated = 32;
        public static int cellHideWhenPrinting = 64;
        public static int cellPrintOnMutiLine = 128;
        public static int cellIsStaticText = 256;
        public static int cellIsNumber = 512;
        public static int cellThousandsSeparator = 1024;
        public static int cellRedOnNegtive = 2048;
        public static int cellAlignCenter = 4096;
        public static int cellAlignRight = 8192;
        public static int cellAlignVCenter = 16384;
        public static int cellNonLinebackwind = 32768;
        public static int cellEnableRefind = 65536;
        public static int cellAlignVBottom = 131072;
        public static int cellSelected = 0x1000000;
        public static int cellRtLineSelected = 0x2000000;
        public static int cellBtLineSelected = 0x4000000;
        public int addrFormula;
        public int maxDecimals = 2;
        public int minDecimals = 2;

        public Object printCell(Print print, Print.Page page, Object obj) {
            return print.printCell(this, page, obj, false);
        }

        public FormulaCell() {
            this(null);
        }

        public FormulaCell(Rectangle rectangle) {
            super(rectangle);
        }
    }

    public static class FreeCell
    extends FormulaCell {
        public void draw(Graphics g, boolean flag, boolean flag1) {
            if (flag1) {
                this.drawBorderRect(g);
            }
            if (flag) {
                Color color = this.foreColor;
                if ((this.options & FormulaCell.cellIsStaticText) == 0) {
                    color = Color.lightGray;
                }
                AwtUtil.drawText(g, this.text, this.r, this.font, color, this.options, this.lineGap);
            } else {
                AwtUtil.drawText(g, "##", this.r, this.font, this.foreColor, this.options, this.lineGap);
            }
        }

        public void saveAsText(StringBuffer stringbuffer, int i) {
            PrintFormat.saveText(stringbuffer, this.text, "FIELD(", i + 1);
            PrintFormat.saveRect(stringbuffer, this.r, ",");
            stringbuffer.append(",Options=" + (this.options & 0xFFFFFF));
            PrintFormat.saveFont(stringbuffer, this.font, ",");
            if (this.foreColor != Color.black) {
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.foreColor);
            }
            stringbuffer.append(",Decimals=" + this.maxDecimals);
            stringbuffer.append(",Round=" + this.minDecimals);
            if (this.lineGap != 1) {
                stringbuffer.append(",LineGap=" + this.lineGap);
            }
            if (this.strid != null) {
                stringbuffer.append(",ID=\"" + this.strid + "\"");
            }
            stringbuffer.append(')');
        }

        public FreeCell() {
            this(null);
            this.options = FormulaCell.cellAlignCenter | FormulaCell.cellAlignVCenter;
        }

        public FreeCell(Rectangle rectangle) {
            super(rectangle);
            this.options = FormulaCell.cellAlignCenter | FormulaCell.cellAlignVCenter;
        }
    }

    public static class GraphCell
    extends FormulaCell {
        ImageIcon img = null;

        public void setImageName(String s) {
            this.text = s;
            try {
                this.img = new ImageIcon(this.text);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void draw(Graphics g, boolean flag, boolean flag1) {
            if (this.img != null) {
                g.drawImage(this.img.getImage(), this.r.x, this.r.y, this.r.width, this.r.height, null);
            }
            if (flag1) {
                this.drawBorderRect(g);
            }
        }

        public void saveAsText(StringBuffer stringbuffer, int i) {
            PrintFormat.saveText(stringbuffer, this.text, "GRAPH(", i + 1);
            PrintFormat.saveRect(stringbuffer, this.r, ",");
            PrintFormat.saveFont(stringbuffer, this.font, ",");
            stringbuffer.append(')');
        }

        public GraphCell() {
            this(null);
        }

        public GraphCell(Rectangle rectangle) {
            super(rectangle);
        }
    }

    public static class GridCell
    extends FormulaCell {
        public Color rlineColor = Color.black;
        public Color blineColor = Color.black;
        public int rlineStyle = 1;
        public int blineStyle = 1;
        public int rlineWidth = 1;
        public int blineWidth = 1;
        public int totalType;
        transient Row row;

        public void Copy(GridCell gridcell) {
            this.options = this.options & 0xFFFF000F | gridcell.options & 0xFFF0;
            this.text = gridcell.text;
            this.foreColor = gridcell.foreColor;
            this.font = gridcell.font;
            this.minDecimals = gridcell.minDecimals;
            this.maxDecimals = gridcell.maxDecimals;
        }

        public void saveAsText(StringBuffer stringbuffer, int i) {
            PrintFormat.saveText(stringbuffer, this.text, "Cell(", i + 1);
            PrintFormat.saveFont(stringbuffer, this.font, ",");
            stringbuffer.append(",Options=" + (this.options & 0xFFFFFF));
            if (this.foreColor != Color.black) {
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.foreColor);
            }
            stringbuffer.append(",Decimals=" + this.maxDecimals);
            stringbuffer.append(",Round=" + this.minDecimals);
            if (this.totalType != 0) {
                stringbuffer.append(",TotalType=" + this.totalType);
            }
            if (this.lineGap != 1) {
                stringbuffer.append(",LineGap=" + this.lineGap);
            }
            if (this.rlineStyle != 1 || this.rlineWidth != 1 || this.rlineColor != Color.black) {
                stringbuffer.append(",RLine(" + this.rlineStyle + ',' + this.rlineWidth);
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.rlineColor);
                stringbuffer.append(')');
            }
            if (this.blineStyle != 1 || this.blineWidth != 1 || this.blineColor != Color.black) {
                stringbuffer.append(",BLine(" + this.blineStyle + ',' + this.blineWidth);
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.blineColor);
                stringbuffer.append(')');
            }
            stringbuffer.append(')');
        }

        public void draw(Graphics g, boolean flag, boolean flag1) {
        }

        public GridCell() {
            this.options = FormulaCell.cellSuppressIfZero | FormulaCell.cellAlignVCenter | FormulaCell.cellThousandsSeparator;
        }
    }

    public static class LineCell
    extends Cell {
        public int lineStyle;
        public int lineWidth;
        public boolean isLine;

        public void draw(Graphics g, boolean flag, boolean flag1) {
            if (this.isLine) {
                AwtUtil.drawLine(g, this.r.x, this.r.y, this.r.x + this.r.width, this.r.y + this.r.height, this.foreColor, this.lineStyle, this.lineWidth);
                if (this.selected) {
                    g.setColor(Color.red);
                    g.drawRect(this.r.x - 2, this.r.y - 2, 4, 4);
                    g.drawRect(this.r.x + this.r.width - 2, this.r.y + this.r.height - 2, 4, 4);
                }
            } else {
                AwtUtil.drawLine(g, this.r.x, this.r.y, this.r.x + this.r.width, this.r.y, this.foreColor, this.lineStyle, this.lineWidth);
                AwtUtil.drawLine(g, this.r.x + this.r.width, this.r.y, this.r.x + this.r.width, this.r.y + this.r.height, this.foreColor, this.lineStyle, this.lineWidth);
                AwtUtil.drawLine(g, this.r.x, this.r.y, this.r.x, this.r.y + this.r.height, this.foreColor, this.lineStyle, this.lineWidth);
                AwtUtil.drawLine(g, this.r.x, this.r.y + this.r.height, this.r.x + this.r.width, this.r.y + this.r.height, this.foreColor, this.lineStyle, this.lineWidth);
                if (this.selected) {
                    g.setColor(Color.red);
                    g.drawRect(this.r.x - 2, this.r.y - 2, 4, 4);
                    g.drawRect(this.r.x + this.r.width - 2, this.r.y - 2, 4, 4);
                    g.drawRect(this.r.x - 2, this.r.y + this.r.height - 2, 4, 4);
                    g.drawRect(this.r.x + this.r.width - 2, this.r.y + this.r.height - 2, 4, 4);
                }
            }
        }

        public boolean PointAtLine(int i, int j) {
            if (!this.isLine) {
                return this.isContains(i, j);
            }
            if (this.r.width >= -2 && this.r.width <= 2 || this.r.height >= -2 && this.r.height <= 2) {
                if (this.isContains(i, j)) {
                    return true;
                }
            } else {
                Rectangle rectangle = new Rectangle(this.r.x - 2, this.r.y - 2, 4, 4);
                if (rectangle.contains(i, j)) {
                    return true;
                }
                rectangle.setBounds(this.r.x + this.r.width - 2, this.r.y + this.r.height - 2, 4, 4);
                if (rectangle.contains(i, j)) {
                    return true;
                }
            }
            if (this.r.width != 0 && this.r.height != 0 && (this.r.x - i) * (this.r.x + this.r.width - i) < 0 && (this.r.y - j) * (this.r.y + this.r.height - j) < 0) {
                double d = (double)this.r.height / (double)this.r.width;
                int k = (int)((double)this.r.y + d * (double)(i - this.r.x));
                if ((k -= j) <= 2 && k >= -2) {
                    return true;
                }
            }
            return false;
        }

        public boolean PointAtLine(Point point) {
            return this.PointAtLine(point.x, point.y);
        }

        public Object printCell(Print print, Print.Page page, Object obj) {
            page.addLine(this.printRect, this.lineWidth << 8 | this.lineStyle, this.foreColor);
            return null;
        }

        public void saveAsText(StringBuffer stringbuffer, int i) {
            PrintFormat.saveLeftSpace(stringbuffer, i);
            if (this.isLine) {
                stringbuffer.append("LINE( (" + this.r.x + "," + this.r.y + ")-(" + (this.r.x + this.r.width) + "," + (this.r.y + this.r.height) + ")");
            } else {
                stringbuffer.append("RECT( (" + this.r.x + "," + this.r.y + "," + (this.r.x + this.r.width) + "," + (this.r.y + this.r.height) + ")");
            }
            if (this.lineWidth > 1) {
                stringbuffer.append(",LnWidth=" + this.lineWidth);
            }
            if (this.lineStyle != 1) {
                stringbuffer.append(",LnStyle=" + this.lineStyle);
            }
            if (this.foreColor != Color.black) {
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.foreColor);
            }
            stringbuffer.append(')');
        }

        public LineCell() {
            this.foreColor = Color.black;
            this.lineStyle = 1;
            this.lineWidth = 1;
        }

        public LineCell(Rectangle rectangle, boolean flag) {
            this();
            this.r = new Rectangle(rectangle);
            this.isLine = flag;
        }
    }

    public static class PrintFormatErrorException
    extends Exception {
        public PrintFormatErrorException() {
        }

        public PrintFormatErrorException(String s) {
            super(s);
        }
    }

    public static class Row {
        public static int rowGroupBgn = 1;
        public static int rowGroupEnd = 2;
        public static int rowHideWhenPrinting = 16;
        public static int rowNewPage = 32;
        public static int rowPrintAtPageBottom = 64;
        public static int rowAutoReheight = 128;
        public static int rowCellFormulaExecuteIfHide = 256;
        public static int rowNoSplitForReheight = 512;
        public static int rowSamePageToNextRow = 1024;
        public static int rowSelected = 65536;
        public int rowType;
        public int options;
        public String strid;
        public double height = 20.0;
        public String startFormula;
        public int addrStartFormula;
        public String groupFormula;
        public int addrGroupFormula;
        public Vector cellSet = new Vector();
        transient int groupTag;

        public void setOptions(int i, boolean flag) {
            this.options = flag ? (this.options |= i) : (this.options &= ~i);
        }

        public GridCell getColCell(int i) {
            if (i >= 0 && i < this.cellSet.size()) {
                return (GridCell)this.cellSet.elementAt(i);
            }
            return null;
        }

        public void setRow(Row row) {
            if (row == null) {
                return;
            }
            this.startFormula = row.startFormula;
            Enumeration enumeration = this.cellSet.elements();
            Enumeration enumeration1 = row.cellSet.elements();
            while (enumeration.hasMoreElements() && enumeration1.hasMoreElements()) {
                GridCell gridcell = (GridCell)enumeration.nextElement();
                GridCell gridcell1 = (GridCell)enumeration1.nextElement();
                gridcell.Copy(gridcell1);
            }
        }

        public void saveAsText(StringBuffer stringbuffer) {
            if (this.height == (double)((int)this.height)) {
                stringbuffer.append("GridRow( Height=" + (int)this.height);
            } else {
                stringbuffer.append("GridRow( Height=" + this.height);
            }
            if (this.strid != null && this.strid.length() > 0) {
                stringbuffer.append(",ID=\"" + this.strid + "\"");
            }
            if (this.options != 0) {
                stringbuffer.append(",Options=" + (this.options & 0xFFFFFF & ~rowSelected));
            }
            if (this.groupFormula != null && this.groupFormula.length() > 0) {
                PrintFormat.saveText(stringbuffer, this.groupFormula, ",RowGroup=", 2);
            }
            if (this.startFormula != null && this.startFormula.length() > 0) {
                PrintFormat.saveText(stringbuffer, this.startFormula, ",RowStart=", 2);
            }
            int i = this.cellSet.size();
            int j = 0;
            while (j < i) {
                Cell cell = (Cell)this.cellSet.elementAt(j);
                stringbuffer.append(",\r\n \t");
                cell.saveAsText(stringbuffer, 6);
                ++j;
            }
            stringbuffer.append("\r\n\t)/*EndRow*/");
        }
    }

    public static class StaticCell
    extends Cell {
        public void draw(Graphics g, boolean flag, boolean flag1) {
            if (flag1) {
                this.drawBorderRect(g);
            }
            AwtUtil.drawText(g, this.text, this.r, this.font, this.foreColor, this.options, this.lineGap);
        }

        public void saveAsText(StringBuffer stringbuffer, int i) {
            PrintFormat.saveText(stringbuffer, this.text, "TEXT(", i + 1);
            PrintFormat.saveRect(stringbuffer, this.r, ",");
            if ((this.options & 0xFFFFFF) > 0) {
                stringbuffer.append(",Options=" + (this.options & 0xFFFFFF));
            }
            PrintFormat.saveFont(stringbuffer, this.font, ",");
            if (this.foreColor != Color.black) {
                PrintFormat.saveColorCommaPrefix(stringbuffer, this.foreColor);
            }
            if (this.lineGap != 1) {
                stringbuffer.append(",LineGap=" + this.lineGap);
            }
            if (this.strid != null) {
                stringbuffer.append(",ID=\"" + this.strid + "\"");
            }
            stringbuffer.append(')');
        }

        public Object printCell(Print print, Print.Page page, Object obj) {
            if (!print.isPrintingEmptyRow()) {
                page.addText(this.strid, this.printRect, this.text, this.font, this.foreColor, this.options, this.lineGap);
            }
            return null;
        }

        public StaticCell() {
            this(null);
            this.options = FormulaCell.cellPrintOnMutiLine | FormulaCell.cellAlignCenter | FormulaCell.cellAlignVCenter;
        }

        public StaticCell(Rectangle rectangle) {
            super(rectangle);
            this.options = FormulaCell.cellPrintOnMutiLine | FormulaCell.cellAlignCenter | FormulaCell.cellAlignVCenter;
        }
    }
}

