/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.Scrollable;
import softcore.awt.AwtUtil;
import softcore.awt.DialogPanel;
import softcore.awt.ExtObject;
import softcore.awt.FormulaEdit;
import softcore.print.IDTagPanel;
import softcore.print.PrintBar1;
import softcore.print.PrintBar2;
import softcore.print.PrintCellDialog;
import softcore.print.PrintFormat;
import softcore.print.PrintHRule;
import softcore.print.PrintVRule;
import softcore.print.ReportAttrDialog;
import softcore.print.RowColAttr;
import softcore.print.RowColAttrDialog;
import softcore.print.RowColWidthDialog;
import softcore.util.FileNameChooser;
import softcore.util.FileNameLikeFileFilter;
import softcore.util.JDBC;
import softcore.util.Message;
import softcore.util.PreprocessedTextReader;
import softcore.util.Utilities;
import softface.MainApp;
import softface.MainFrame;
import softoperation.finance.erpdata.Erpdata;
import softoperation.finance.erpdata.ErpdataConfig;

public class PrintFormatDesign
extends JComponent
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
Scrollable {
    PrintFormat format;
    JPopupMenu attrMenu;
    String[] szMenuItems = new String[]{"\u5220\u9664\u6240\u9009\u7684\u884c\u5217", "\u5355\u5143\u5408\u5e76", "", "\u8bbe\u7f6e\u5355\u5143\u6587\u5b57/\u516c\u5f0f", "\u5355\u5143\u5c5e\u6027...", "\u5355\u5143\u5c0f\u6570\u4f4d,\u884c\u95f4\u8ddd", "\u884c\u5c5e\u6027...", "\u5217\u5c5e\u6027...", "\u8bbe\u7f6e  \u884c\u9ad8\u3001\u5217\u5bbd", "\u5206\u7ec4\u516c\u5f0f", "\u884c\u542f\u52a8\u6253\u5370\u516c\u5f0f", "\u5217\u91cd\u590d\u6253\u5370\u6b21\u6570", "\u62a5\u8868\u542f\u52a8\u516c\u5f0f", "\u62a5\u8868\u5c5e\u6027...", "", "\u5199\u5165\u6587\u672c\u6587\u4ef6", "\u4ece\u6587\u672c\u6587\u4ef6\u88c5\u5165", "\u8bbe\u7f6e\u80cc\u666f", "\u7ec8\u6b62\u516c\u5f0f"};
    private boolean bModified = false;
    private boolean bShowFormulaInCell = true;
    private Point preMousePoint;
    private Point orgMousePoint;
    private int selectedFreeItem;
    public int nSeleRow;
    public int nSeleCol;
    int curItemType;
    boolean bToMergeCell = false;
    boolean bEnableAddRow = false;
    boolean bInDrawGridLine;
    private int yInDrawGridLine;
    private int xInDrawGridLine;
    private RowColAttr rowcolAttr;
    PrintFormat.Row pUniqueSelectedRow = null;
    PrintFormat.Col pUniqueSelectedCol = null;
    PrintBar1 toolBar1 = null;
    PrintBar2 toolBar2 = null;
    private final JTextArea editor = new JTextArea();
    double cmScale = 14.173228346456694;
    PrintVRule vRule = null;
    PrintHRule hRule = null;
    private IDTagPanel mainPanel = null;
    private int editorRow;
    private int editorCol;
    private int editorFixedCol;
    private static String szClipboardData;
    private PrintFormat.Cell pEditCell = null;
    private boolean bDrawLine = false;
    private Rectangle moveRect;
    private int mouseState = 0;
    PrintFormat.Cell pFirstSelItem = null;
    PrintFormat.Cell pLastSelItem = null;
    private boolean bCanEdit;
    static Color xorColor;
    boolean bDrawOutLook = true;
    public boolean forceRedraw;
    protected Dimension offDimension;
    protected Image offImage;
    protected Graphics offGraphics;
    protected Dimension preferredSize;
    protected Dimension freshdim;
    boolean freshdimb;
    private Vector m_undoList;
    private boolean bFirstUndo;
    boolean bShowRuler = false;
    JScrollPane parentScoll;
    private Object[][] formulaWords;
    private String[] formulaFixWords;
    int sysPrintOption = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        xorColor = new Color(0, 128, 128);
    }

    public PrintFormatDesign() {
        this.format = new PrintFormat();
        this.attrMenu = new JPopupMenu();
        this.preMousePoint = new Point(0, 0);
        this.orgMousePoint = new Point(0, 0);
        this.rowcolAttr = new RowColAttr();
        this.moveRect = new Rectangle();
        this.preferredSize = new Dimension();
        this.m_undoList = new Vector();
        this.setDoubleBuffered(false);
        this.bShowFormulaInCell = true;
        this.setBackground(Color.white);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(480, 360));
        this.nSeleCol = -1;
        this.nSeleRow = -1;
        this.add(this.editor);
        this.editor.setVisible(false);
        this.setAutoscrolls(true);
        Font font = new Font("Serif", 0, 12);
        int i = 0;
        while (i < this.szMenuItems.length) {
            if (this.szMenuItems[i] == null || this.szMenuItems[i].length() == 0) {
                this.attrMenu.addSeparator();
            } else {
                JMenuItem jmenuitem = new JMenuItem(this.szMenuItems[i]);
                jmenuitem.setFont(font);
                jmenuitem.addActionListener(this);
                this.attrMenu.add(jmenuitem);
            }
            ++i;
        }
        this.attrMenu.setBorder(BorderFactory.createEtchedBorder());
        this.attrMenu.setInvoker(this);
    }

    void setToolBar(PrintBar1 printbar1, PrintBar2 printbar2) {
        this.toolBar1 = printbar1;
        this.toolBar2 = printbar2;
        this.toolBar1.responeDisplay(this.bShowFormulaInCell);
        this.indicateCellOnToolbar(null);
    }

    void setRule(PrintHRule printhrule, PrintVRule printvrule) {
        this.hRule = printhrule;
        this.vRule = printvrule;
    }

    void setMainPanel(IDTagPanel idtagpanel) {
        this.mainPanel = idtagpanel;
    }

    void newElement(int i, Rectangle rectangle) {
        if (i != 2) {
            this.normalRect(rectangle);
            if (rectangle.width < 0) {
                rectangle.x += rectangle.width;
                rectangle.width = 0 - rectangle.width;
            }
            if (rectangle.height < 0) {
                rectangle.y += rectangle.height;
                rectangle.height = 0 - rectangle.height;
            }
            if (rectangle.width >= 0 && rectangle.width < 2) {
                rectangle.width = 32;
            }
            if (rectangle.height >= 0 && rectangle.height < 2) {
                rectangle.height = 20;
            }
        }
        PrintFormat.Cell obj = null;
        switch (i) {
            case 1: {
                obj = new PrintFormat.LineCell(rectangle, false);
                ((PrintFormat.LineCell)obj).lineStyle = this.toolBar1.getCurSelLineStyle();
                ((PrintFormat.LineCell)obj).lineWidth = this.toolBar1.getCurSelLineWidth();
                break;
            }
            case 2: {
                obj = new PrintFormat.LineCell(rectangle, true);
                ((PrintFormat.LineCell)obj).lineStyle = this.toolBar1.getCurSelLineStyle();
                ((PrintFormat.LineCell)obj).lineWidth = this.toolBar1.getCurSelLineWidth();
                break;
            }
            case 3: {
                obj = new PrintFormat.StaticCell(rectangle);
                break;
            }
            case 4: {
                obj = new PrintFormat.FreeCell(rectangle);
                break;
            }
            case 5: {
                obj = new PrintFormat.GraphCell(rectangle);
            }
        }
        if (obj != null) {
            if (i >= 3 && i <= 5) {
                ((PrintFormat.Cell)obj).font = this.toolBar1.getCurSelFont();
            }
            ((PrintFormat.Cell)obj).foreColor = this.toolBar1.getCurSelColor();
            this.format.freeCellSet.addElement(obj);
            ((PrintFormat.Cell)obj).selected = true;
            this.pLastSelItem = obj;
            this.selectedFreeItem = 1;
            Rectangle rectangle1 = this.format.getFreeCellBoundRect(false, true);
            if (!rectangle1.isEmpty()) {
                this.redrawRect(rectangle1);
            }
            this.setModified(true);
            this.setScrollSizes();
        }
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
        int j;
        int i;
        this.editorCol = -1;
        this.editorRow = -1;
        this.editorFixedCol = 0;
        Component component = keyevent.getComponent();
        if (component instanceof JTextArea && ((i = keyevent.getKeyCode()) == 38 || i == 40 || i == 39 || i == 37 || i == 8) && (j = this.editor.getSelectionStart()) == this.editor.getSelectionEnd()) {
            try {
                this.editorRow = this.editor.getLineOfOffset(j);
                this.editorCol = j - this.editor.getLineStartOffset(this.editorRow);
                this.editorFixedCol = this.editor.getLineEndOffset(this.editorRow) - j;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
        block63: {
            int i;
            boolean flag;
            block62: {
                Component component = keyevent.getComponent();
                flag = !(component instanceof JTextArea);
                boolean flag1 = keyevent.isControlDown();
                boolean flag2 = keyevent.isShiftDown();
                i = keyevent.getKeyCode();
                switch (i) {
                    case 68: {
                        if (flag1) {
                            this.bDrawOutLook = !this.bDrawOutLook;
                            this.forceRedraw = true;
                            this.repaint();
                        }
                        return;
                    }
                    case 88: {
                        PrintFormat.Cell cell;
                        if (flag1 && (cell = this.findUniqueCell()) != null) {
                            cell.canEdit = !cell.canEdit;
                        }
                        return;
                    }
                    case 67: {
                        if (!flag1 || !flag2) break;
                        szClipboardData = this.saveContent();
                        return;
                    }
                    case 86: {
                        if (!flag1 || !flag2 || szClipboardData == null || szClipboardData.length() <= 0 || Message.showQuestionDialog("\u63d0\u793a", "\u66ff\u6362\u6253\u5370\u683c\u5f0f\u5185\u5bb9\uff1f") != 0) break;
                        this.loadFromText(szClipboardData);
                        this.setModified(true);
                        return;
                    }
                    case 69: {
                        if (!flag1 || !flag2) break;
                        szClipboardData = null;
                        return;
                    }
                    case 83: {
                        if (flag1 && this.mainPanel != null) {
                            this.mainPanel.updateRecord(false);
                        }
                        return;
                    }
                    case 90: {
                        if (flag1) {
                            this.undoItems();
                        }
                        return;
                    }
                    case 65: {
                        if (flag) {
                            if (flag && flag1) {
                                this.selectFreeCell(true);
                                this.selectGridCell(true, true);
                            } else if (keyevent.isAltDown()) {
                                this.selectFreeCell(true);
                                this.indicateCellOnToolbar(null);
                            }
                        }
                        return;
                    }
                }
                if (this.selectedFreeItem <= 0 || !flag) break block62;
                switch (i) {
                    case 127: {
                        this.m_undoList.removeAllElements();
                        this.deleteSelFreeItems();
                        break;
                    }
                    case 38: {
                        if (flag1) {
                            this.insectSelItems(0, 0, 0, -1);
                            break;
                        }
                        this.offsetSelItems(0, -1);
                        break;
                    }
                    case 33: {
                        if (!flag1) {
                            this.offsetSelItems(0, -32);
                            break;
                        }
                        break block63;
                    }
                    case 40: {
                        if (flag1) {
                            this.insectSelItems(0, 0, 0, 1);
                            break;
                        }
                        this.offsetSelItems(0, 1);
                        break;
                    }
                    case 34: {
                        if (!flag1) {
                            this.offsetSelItems(0, 32);
                            break;
                        }
                        break block63;
                    }
                    case 37: {
                        if (flag1) {
                            this.insectSelItems(0, 0, -1, 0);
                            break;
                        }
                        this.offsetSelItems(-1, 0);
                        break;
                    }
                    case 39: {
                        if (flag1) {
                            this.insectSelItems(0, 0, 1, 0);
                            break;
                        }
                        this.offsetSelItems(1, 0);
                    }
                }
                break block63;
            }
            if (this.bInDrawGridLine && flag) {
                int j = this.yInDrawGridLine;
                int l = this.xInDrawGridLine;
                int j1 = this.yInDrawGridLine;
                int l1 = this.xInDrawGridLine;
                int i2 = 0;
                switch (i) {
                    case 38: {
                        this.setDrawGridLinePoint(this.yInDrawGridLine - 1, this.xInDrawGridLine);
                        i2 |= 1;
                        break;
                    }
                    case 40: {
                        this.setDrawGridLinePoint(this.yInDrawGridLine + 1, this.xInDrawGridLine);
                        j1 = this.yInDrawGridLine;
                        i2 |= 1;
                        break;
                    }
                    case 37: {
                        this.setDrawGridLinePoint(this.yInDrawGridLine, this.xInDrawGridLine - 1);
                        i2 |= 2;
                        break;
                    }
                    case 39: {
                        this.setDrawGridLinePoint(this.yInDrawGridLine, this.xInDrawGridLine + 1);
                        l1 = this.xInDrawGridLine;
                        i2 |= 2;
                    }
                }
                if ((keyevent.isAltDown() || keyevent.isShiftDown()) && (j != this.yInDrawGridLine || l != this.xInDrawGridLine) && this.format.isValidDrawGridLinePoint(j1, l1)) {
                    PrintFormat.GridCell gridcell2 = this.format.getGridCell(j1, l1);
                    if ((i2 & 1) > 0) {
                        gridcell2.rlineColor = this.toolBar1.getCurSelColor();
                        gridcell2.rlineStyle = this.toolBar1.getCurSelLineStyle();
                        gridcell2.rlineWidth = this.toolBar1.getCurSelLineWidth();
                        this.invalidateGridCellRLine(j1, l1);
                    }
                    if ((i2 & 2) > 0) {
                        gridcell2.blineColor = this.toolBar1.getCurSelColor();
                        gridcell2.blineStyle = this.toolBar1.getCurSelLineStyle();
                        gridcell2.blineWidth = this.toolBar1.getCurSelLineWidth();
                        this.invalidateGridCellBLine(j1, l1);
                    }
                    this.setModified(true);
                }
            } else {
                int k = this.nSeleRow;
                int i1 = this.nSeleCol;
                if (k < 0 || i1 < 0 || k >= this.format.gridRows || i1 > this.format.gridCols) {
                    return;
                }
                int k1 = 0;
                if (this.editorRow >= 0) {
                    String s = this.editor.getText();
                    k1 = 1;
                    int j2 = 0;
                    while (j2 < s.length()) {
                        if (s.charAt(j2) == '\n') {
                            ++k1;
                        }
                        ++j2;
                    }
                }
                boolean flag3 = false;
                switch (i) {
                    case 38: {
                        if (k <= 1) break;
                        if (this.editorRow == 0) {
                            flag3 = true;
                        }
                        if (!flag3 && !flag) break;
                        --k;
                        break;
                    }
                    case 40: {
                        if (k >= this.format.gridRows - 1) break;
                        if (this.editorRow >= 0 && k1 == this.editorRow + 1) {
                            flag3 = true;
                        }
                        if (!flag3 && !flag) break;
                        while (k < this.format.gridRows) {
                            PrintFormat.GridCell gridcell = this.format.getGridCell(k, this.nSeleCol);
                            if ((gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0) break;
                            ++k;
                        }
                        ++k;
                        break;
                    }
                    case 8: 
                    case 37: {
                        if (i1 <= 1) break;
                        if (this.editorRow == 0 && this.editorCol == 0) {
                            flag3 = true;
                        }
                        if (!flag3 && (!flag || i != 37)) break;
                        --i1;
                        break;
                    }
                    case 39: {
                        if (i1 >= this.format.gridCols) break;
                        if (k1 == this.editorRow + 1 && this.editorFixedCol == 1) {
                            flag3 = true;
                        }
                        if (!flag3 && !flag) break;
                        while (i1 < this.format.gridCols) {
                            PrintFormat.GridCell gridcell1 = this.format.getGridCell(this.nSeleRow, i1);
                            if ((gridcell1.options & PrintFormat.FormulaCell.cellMergeRight) == 0) break;
                            ++i1;
                        }
                        ++i1;
                        break;
                    }
                    default: {
                        if (!flag) break;
                        this.startEdit();
                        return;
                    }
                }
                if (k != this.nSeleRow || i1 != this.nSeleCol) {
                    Point point = new Point(i1, k);
                    this.format.findMergeOwner(point);
                    this.setGridCellActive(point.y, point.x);
                    if (flag3) {
                        this.startEdit();
                    }
                }
            }
        }
    }

    void adjustEditorPos() {
        if (this.pEditCell != null) {
            Rectangle rectangle = new Rectangle();
            this.getCurSelCellRect(rectangle);
            this.editor.setBounds(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
    }

    void startEdit() {
        this.endEdit();
        this.pEditCell = this.findUniqueCell();
        if (this.pEditCell != null && this.pEditCell.canEdit && (this.pEditCell instanceof PrintFormat.StaticCell || this.pEditCell instanceof PrintFormat.FormulaCell)) {
            this.showPosition(null);
            this.adjustEditorPos();
            this.editor.setForeground(this.pEditCell.foreColor);
            this.editor.setText(this.pEditCell.text);
            this.editor.setVisible(true);
            this.editor.addKeyListener(this);
            this.editor.requestFocus();
        }
    }

    void endEdit() {
        if (this.pEditCell != null) {
            String s = this.editor.getText();
            if (!s.equals(this.pEditCell.text)) {
                this.pEditCell.text = this.editor.getText();
                this.setModified(true);
            }
            this.pEditCell = null;
            Rectangle rectangle = this.editor.getBounds();
            this.editor.setBounds(rectangle.x, rectangle.y, 0, 0);
            this.editor.setVisible(false);
            this.invalidateCurSelCell();
            this.editor.removeKeyListener(this);
            this.requestFocus();
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if ((mouseevent.getModifiers() & 0x10) > 0 && mouseevent.getClickCount() == 2) {
            this.startEdit();
        }
    }

    private void resetCursor(MouseEvent mouseevent) {
        if (this.bToMergeCell) {
            if (this.getCursor().getType() != 2) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else if (this.curItemType == 2) {
            if (this.getCursor().getType() != 12) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.curItemType > 0) {
            if (this.getCursor().getType() != 13) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.selectedFreeItem == 1 && this.pLastSelItem != null && this.pLastSelItem.selected && this.pLastSelItem.isCanSize(mouseevent.getX(), mouseevent.getY())) {
            if (this.getCursor().getType() != 6) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            }
        } else if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
        this.resetCursor(mouseevent);
    }

    public void mousePressed(MouseEvent mouseevent) {
        this.endEdit();
        this.bCanEdit = false;
        this.requestFocus();
        if ((mouseevent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.bDrawLine = false;
        this.mouseState = 0;
        if (this.curItemType == 0) {
            if (this.bToMergeCell) {
                this.bToMergeCell = false;
                Point point = new Point(mouseevent.getX(), mouseevent.getY());
                if (this.format.PtInGridCell(point) > 0) {
                    this.mergeCell(point.y, point.x);
                }
                if (this.getCursor().getType() != 0) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            if (this.bInDrawGridLine) {
                Point point1 = new Point(mouseevent.getX(), mouseevent.getY());
                if (this.format.PtInGridCell(point1) > 0) {
                    this.setDrawGridLinePoint(point1.y, point1.x);
                }
                return;
            }
            if (this.selectedFreeItem == 1 && this.pLastSelItem != null && this.pLastSelItem.selected && this.pLastSelItem.isCanSize(mouseevent.getX(), mouseevent.getY())) {
                this.mouseState = 2;
                this.moveRect.setBounds(this.pLastSelItem.r.x, this.pLastSelItem.r.y, this.pLastSelItem.r.width, this.pLastSelItem.r.height);
                this.orgMousePoint.setLocation(this.moveRect.x + this.moveRect.width, this.moveRect.y + this.moveRect.height);
                if (this.pLastSelItem instanceof PrintFormat.LineCell && ((PrintFormat.LineCell)this.pLastSelItem).isLine) {
                    this.bDrawLine = true;
                }
                return;
            }
            Object obj = this.format.getObjectByPosition(mouseevent.getX(), mouseevent.getY());
            if (obj != null) {
                if (this.selectedFreeItem == 1 && this.pLastSelItem == obj) {
                    this.bCanEdit = true;
                }
                this.clearAllSelectedGridCell(true);
                if (!mouseevent.isControlDown()) {
                    this.selectFreeCell(false);
                    this.selectedFreeItem = 1;
                } else if (!((PrintFormat.Cell)obj).selected) {
                    ++this.selectedFreeItem;
                }
                ((PrintFormat.Cell)obj).selected = true;
                if (this.selectedFreeItem == 1) {
                    this.pFirstSelItem = (PrintFormat.Cell)obj;
                    if (obj instanceof PrintFormat.LineCell && ((PrintFormat.LineCell)obj).isLine) {
                        this.bDrawLine = true;
                    }
                }
                this.pLastSelItem = (PrintFormat.Cell)obj;
                this.moveRect = this.format.getFreeCellBoundRect(false, true);
                this.drawMoveFlag();
                this.drawMoveFlag();
                if (this.bDrawLine) {
                    this.moveRect.setBounds(((PrintFormat.Cell)obj).r);
                } else {
                    this.moveRect = this.format.getFreeCellBoundRect(true, true);
                }
                this.preMousePoint.setLocation(mouseevent.getX(), mouseevent.getY());
                this.orgMousePoint.setLocation(mouseevent.getX(), mouseevent.getY());
                this.mouseState = 1;
                this.invalidateCurSelCell();
                return;
            }
            obj = new Point(mouseevent.getX(), mouseevent.getY());
            int i = this.format.PtInGridCell((Point)obj);
            if (i != 0) {
                this.format.findMergeOwner((Point)obj);
                if (mouseevent.isControlDown()) {
                    this.selectFreeCell(false);
                    this.clearCurrentGridCell();
                    if (i == 1) {
                        PrintFormat.GridCell gridcell = this.format.getGridCell(((Point)obj).y, ((Point)obj).x);
                        if (gridcell != null) {
                            gridcell.options ^= PrintFormat.FormulaCell.cellSelected;
                        }
                        this.invalidateGridCell(((Point)obj).y, ((Point)obj).x);
                        return;
                    }
                } else {
                    if (((Point)obj).y == this.nSeleRow && ((Point)obj).x == this.nSeleCol) {
                        this.bCanEdit = true;
                    }
                    this.clearAllSelectedGridCell(true);
                }
                this.clearAllSelectedGridCell(true);
                this.selectFreeCell(false);
                this.setGridCellActive(((Point)obj).y, ((Point)obj).x);
                return;
            }
            int n = this.mouseState = this.selectedFreeItem <= 0 ? 2 : 0;
        }
        if (this.curItemType > 0 && this.curItemType <= 5) {
            if (this.curItemType == 2) {
                this.bDrawLine = true;
            }
            this.mouseState = 2;
        }
        if (!mouseevent.isControlDown()) {
            this.clearAllSelectedGridCell(true);
            this.selectFreeCell(false);
            this.selectedFreeItem = 0;
        }
        this.moveRect.setBounds(mouseevent.getX(), mouseevent.getY(), 0, 0);
    }

    public void mouseReleased(MouseEvent mouseevent) {
        boolean flag = false;
        if ((mouseevent.getModifiers() & 4) > 0) {
            this.OnPopupMenu(mouseevent.getX(), mouseevent.getY());
        } else if ((mouseevent.getModifiers() & 0x10) > 0) {
            if (this.mouseState > 0) {
                if (this.mouseState == 1) {
                    this.offsetSelItems(mouseevent.getX() - this.orgMousePoint.x, mouseevent.getY() - this.orgMousePoint.y);
                } else if (this.mouseState == 2) {
                    this.drawMoveFlag();
                    if (this.curItemType > 0) {
                        this.selectFreeCell(false);
                        this.newElement(this.curItemType, this.moveRect);
                        flag = true;
                    } else if (this.pLastSelItem != null && this.pLastSelItem.selected) {
                        this.insectSelItems(0, 0, mouseevent.getX() - this.orgMousePoint.x, mouseevent.getY() - this.orgMousePoint.y);
                    } else {
                        this.makeSelFlag(this.moveRect);
                    }
                }
            }
            this.mouseState = 0;
        }
        if (flag || this.bCanEdit) {
            this.curItemType = 0;
            this.startEdit();
        }
        this.indicateCellOnToolbar(this.findUniqueCell());
    }

    public void mouseExited(MouseEvent mouseevent) {
        if (this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
        this.endEdit();
        if (this.mouseState == 0) {
            return;
        }
        this.bCanEdit = false;
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        if (this.mouseState == 2) {
            if (i != this.moveRect.x + this.moveRect.width || j != this.moveRect.y + this.moveRect.height) {
                this.drawMoveFlag();
                this.moveRect.width = i - this.moveRect.x;
                this.moveRect.height = j - this.moveRect.y;
                this.drawMoveFlag();
            }
        } else if (this.mouseState == 1 && !this.preMousePoint.equals(mouseevent.getPoint())) {
            this.drawMoveFlag();
            this.moveRect.x += mouseevent.getX() - this.preMousePoint.x;
            this.preMousePoint.x = mouseevent.getX();
            this.moveRect.y += mouseevent.getY() - this.preMousePoint.y;
            this.preMousePoint.y = mouseevent.getY();
            this.drawMoveFlag();
        }
        this.showPosition(this.moveRect);
    }

    public void mouseMoved(MouseEvent mouseevent) {
        this.resetCursor(mouseevent);
    }

    private void redrawRect(Rectangle rectangle) {
        this.forceRedraw = true;
        this.repaint(rectangle);
    }

    private void redrawRect(int i, int j, int k, int l) {
        this.forceRedraw = true;
        this.repaint(i, j, k, l);
    }

    void selectGridCell(boolean flag, boolean flag1) {
        PrintFormat.Col col;
        if (!flag) {
            this.nSeleCol = 0;
            this.nSeleCol = 0;
        }
        double d3 = 0.0;
        double d2 = 0.0;
        double d1 = 0.0;
        double d = 0.0;
        PrintFormat.Row row = this.format.getRow(0);
        if (row != null) {
            d1 = row.height;
        }
        if ((col = this.format.getColumn(0)) != null) {
            d = col.width;
        }
        int i = 1;
        while (i < this.format.gridRows) {
            PrintFormat.Row row1 = this.format.getRow(i);
            if (row1 == null) break;
            if (flag1) {
                row1.options = flag ? (row1.options |= PrintFormat.Row.rowSelected) : (row1.options &= ~PrintFormat.Row.rowSelected);
            }
            d3 += row1.height;
            int j = 1;
            while (j <= this.format.gridCols) {
                PrintFormat.GridCell gridcell;
                PrintFormat.Col col1;
                if (i == 1 && (col1 = this.format.getColumn(j)) != null) {
                    d2 += col1.width;
                }
                if ((gridcell = row1.getColCell(j)) != null) {
                    gridcell.options = flag ? (gridcell.options |= PrintFormat.FormulaCell.cellSelected) : (gridcell.options &= ~PrintFormat.FormulaCell.cellSelected);
                }
                ++j;
            }
            ++i;
        }
        this.forceRedraw = true;
        this.repaint((int)d, (int)d1, (int)d2, (int)d3);
        if (flag1) {
            this.vRule.repaint();
        }
    }

    void selectFreeCell(boolean flag) {
        if (!flag) {
            this.pLastSelItem = null;
            this.pFirstSelItem = null;
        } else {
            this.selectedFreeItem = 0;
        }
        Rectangle rectangle = null;
        if (!flag) {
            rectangle = this.format.getFreeCellBoundRect(false, true);
        }
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            cell.selected = flag;
            if (!flag) continue;
            if (this.selectedFreeItem == 0) {
                this.pFirstSelItem = cell;
            }
            this.pLastSelItem = cell;
            ++this.selectedFreeItem;
        }
        if (flag) {
            rectangle = this.format.getFreeCellBoundRect(false, true);
        }
        if (rectangle != null && !rectangle.isEmpty()) {
            this.redrawRect(rectangle);
        }
    }

    void deleteSelFreeItems() {
        if (this.selectedFreeItem > 0) {
            Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
            int i = this.format.freeCellSet.size();
            int j = i - 1;
            while (j >= 0) {
                PrintFormat.Cell cell = (PrintFormat.Cell)this.format.freeCellSet.elementAt(j);
                if (cell != null && cell.selected) {
                    this.format.freeCellSet.removeElementAt(j);
                }
                this.bModified = true;
                --j;
            }
            this.pLastSelItem = null;
            this.pFirstSelItem = null;
            this.selectedFreeItem = 0;
            if (this.bModified) {
                this.setModified(true);
                this.setScrollSizes();
                this.redrawRect(rectangle);
            }
        }
    }

    private void selBottomCell() {
        this.selectedFreeItem = 0;
        int i = (int)this.format.getRowLine(this.format.gridRows - 1);
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            cell.selected = false;
            if (cell.r.y <= i && cell.r.y + cell.r.height <= i) continue;
            cell.selected = true;
            ++this.selectedFreeItem;
        }
    }

    void normalRect(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        int i = rectangle.x;
        int j = rectangle.width;
        if (j < 0) {
            i += j;
            j = 0 - j;
        }
        int k = rectangle.y;
        int l = rectangle.height;
        if (l < 0) {
            k += l;
            l = 0 - l;
        }
        rectangle.setBounds(i, k, j, l);
    }

    private boolean makeSelFlag(Rectangle rectangle) {
        this.selectedFreeItem = 0;
        this.normalRect(rectangle);
        Rectangle rectangle1 = this.format.getFreeCellBoundRect(false, true);
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            cell.selected = false;
            if (rectangle == null || !rectangle.contains(cell.r.x, cell.r.y) || !rectangle.contains(cell.r.x + cell.r.width, cell.r.y + cell.r.height)) continue;
            cell.selected = true;
            ++this.selectedFreeItem;
            if (this.selectedFreeItem == 1) {
                this.pFirstSelItem = cell;
            }
            this.pLastSelItem = cell;
        }
        Rectangle rectangle2 = this.format.getFreeCellBoundRect(false, true);
        if (!(rectangle1 = rectangle1.union(rectangle2)).isEmpty()) {
            this.redrawRect(rectangle1);
        }
        return this.selectedFreeItem > 0;
    }

    private void makeHeadTailItem() {
        this.pLastSelItem = null;
        this.pFirstSelItem = null;
        int i = 0;
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (cell.selected) {
                if (i == 0) {
                    this.pFirstSelItem = cell;
                }
                this.pLastSelItem = cell;
                ++i;
            }
            ++i;
        }
    }

    void algimentFreeCells(int i) {
        this.RecordUndoItems();
        Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
        if (i == 4 || i == 5) {
            this.redrawRect(rectangle);
            this.makeSelectedOrder(i == 5);
            rectangle = this.format.getFreeCellBoundRect(false, true);
            this.redrawRect(rectangle);
            return;
        }
        this.redrawRect(rectangle);
        if (this.pLastSelItem == null) {
            this.makeHeadTailItem();
        }
        if (this.pLastSelItem != null) {
            rectangle = this.pLastSelItem.r;
        }
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected) continue;
            switch (i) {
                case 0: {
                    cell.r.setLocation(rectangle.x, cell.r.y);
                    break;
                }
                case 1: {
                    cell.r.setLocation(rectangle.x + rectangle.width - cell.r.width, cell.r.y);
                    break;
                }
                case 2: {
                    cell.r.setLocation(cell.r.x, rectangle.y);
                    break;
                }
                case 3: {
                    cell.r.setLocation(cell.r.x, rectangle.y + rectangle.height - cell.r.height);
                    break;
                }
                case 6: {
                    cell.r.width = rectangle.width;
                    break;
                }
                case 7: {
                    cell.r.height = rectangle.height;
                    break;
                }
                case 8: {
                    cell.r.width = rectangle.width;
                    cell.r.height = rectangle.height;
                }
            }
        }
        rectangle = this.format.getFreeCellBoundRect(false, true);
        this.redrawRect(rectangle);
        this.setModified(true);
    }

    private void makeSelectedOrder(boolean flag) {
        if (this.selectedFreeItem <= 2) {
            return;
        }
        Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
        Rectangle rectangle1 = new Rectangle(rectangle.x + 3, rectangle.y + 3, rectangle.width - 7, rectangle.height - 7);
        double d = 0.0;
        int i = 0;
        Vector<PrintFormat.Cell> vector = new Vector<PrintFormat.Cell>();
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected) continue;
            i = flag ? (i += cell.r.height) : (i += cell.r.width);
            boolean flag1 = false;
            int j = 0;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                PrintFormat.Cell cell2 = (PrintFormat.Cell)enumeration2.nextElement();
                if (flag && cell.r.y < cell2.r.y || !flag && cell.r.x < cell2.r.x) {
                    vector.insertElementAt(cell, j);
                    flag1 = true;
                    break;
                }
                ++j;
            }
            if (flag1) continue;
            vector.addElement(cell);
        }
        d = flag ? (double)(rectangle1.height - i) / (double)(this.selectedFreeItem - 1) : (double)(rectangle1.width - i) / (double)(this.selectedFreeItem - 1);
        double d1 = 0.0;
        Enumeration enumeration1 = vector.elements();
        while (enumeration1.hasMoreElements()) {
            PrintFormat.Cell cell1 = (PrintFormat.Cell)enumeration1.nextElement();
            if (flag) {
                cell1.r.setLocation(cell1.r.x, rectangle1.y + (int)d1);
                d1 += d + (double)cell1.r.height;
                continue;
            }
            cell1.r.setLocation(rectangle1.x + (int)d1, cell1.r.y);
            d1 += d + (double)cell1.r.width;
        }
        vector.removeAllElements();
        rectangle = this.format.getFreeCellBoundRect(false, true);
        this.redrawRect(rectangle1);
        this.setModified(true);
    }

    private void drawMoveFlag() {
        Graphics g = this.getGraphics();
        g.setXORMode(xorColor);
        if (this.bDrawLine) {
            g.drawLine(this.moveRect.x, this.moveRect.y, this.moveRect.x + this.moveRect.width, this.moveRect.y + this.moveRect.height);
        } else {
            int l;
            int i = this.moveRect.x;
            int j = this.moveRect.y;
            int k = this.moveRect.width;
            if (k < 0) {
                i += k;
                k = 0 - k;
            }
            if ((l = this.moveRect.height) < 0) {
                j += l;
                l = 0 - l;
            }
            if (k > 0 || l > 0) {
                g.drawRect(i, j, k, l);
            }
        }
    }

    void draw() {
        Dimension dimension = this.getSize();
        if (this.offDimension == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            if (this.offImage == null) {
                this.offDimension = null;
                return;
            }
            this.offGraphics = this.offImage.getGraphics();
        }
        this.offGraphics.setColor(Color.white);
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.format.backGraph != null && this.format.backGraph.img != null) {
            this.offGraphics.drawImage(this.format.backGraph.img.getImage(), this.format.backGraph.r.x, this.format.backGraph.r.y, null);
        }
        this.drawCell(this.offGraphics);
        if (this.bShowRuler) {
            int i = 10;
            while (i < (int)((double)dimension.width / this.cmScale)) {
                int j = (int)((double)i * this.cmScale);
                AwtUtil.drawLine(this.offGraphics, j, 0, j, dimension.height, Color.lightGray, 1, 1);
                i += 10;
            }
            int k = 10;
            while (k < (int)((double)dimension.height / this.cmScale)) {
                int l = (int)((double)k * this.cmScale);
                AwtUtil.drawLine(this.offGraphics, 0, l, dimension.width, l, Color.lightGray, 1, 1);
                k += 10;
            }
        }
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            cell.draw(this.offGraphics, this.bShowFormulaInCell, this.bDrawOutLook);
        }
    }

    void drawCell(Graphics g) {
        int i = 0;
        int j = 0;
        Rectangle rectangle = new Rectangle(0, 0, 32, 32);
        int k = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements() && k < this.format.gridRows) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            j = (int)((double)j + row.height);
            int l = 0;
            int i1 = 0;
            int j1 = 0;
            while (j1 <= this.format.gridCols) {
                int l1;
                PrintFormat.GridCell gridcell = row.getColCell(j1);
                PrintFormat.Col col = this.format.getColumn(j1);
                i1 = (int)((double)i1 + col.width);
                rectangle.setBounds(l + 1, i + 1, i1 - l - 1, j - i - 1);
                String s = "";
                int k1 = l <= i1 ? i1 - l : l - i1;
                int n = l1 = i <= j ? j - i : i - j;
                if (k1 >= 2 && l1 >= 2) {
                    if (j1 > 0 && (gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0) {
                        AwtUtil.drawLine(g, i1, j, l, j, gridcell.blineColor, gridcell.blineStyle, gridcell.blineWidth);
                    }
                    if (k > 0 && k < this.format.gridRows && (gridcell.options & PrintFormat.FormulaCell.cellMergeRight) == 0) {
                        AwtUtil.drawLine(g, i1, j, i1, i, gridcell.rlineColor, gridcell.rlineStyle, gridcell.rlineWidth);
                    }
                    if (this.bInDrawGridLine && this.yInDrawGridLine == k && this.xInDrawGridLine == j1) {
                        g.setColor(PrintFormat.TitleColor);
                        g.drawRect(i1 - 4, j - 4, 8, 8);
                    }
                }
                if (k != 0 && j1 != 0 && (gridcell.options & PrintFormat.FormulaCell.cellBeMerged) <= 0) {
                    if ((gridcell.options & (PrintFormat.FormulaCell.cellMergeBottom | PrintFormat.FormulaCell.cellMergeRight)) > 0) {
                        this.format.getCellDrawRect(k, j1, rectangle);
                    }
                    Color color = gridcell.foreColor;
                    if (this.bShowFormulaInCell && (gridcell.options & PrintFormat.FormulaCell.cellIsStaticText) == 0) {
                        color = Color.lightGray;
                    }
                    if ((row.options & PrintFormat.Row.rowHideWhenPrinting) > 0) {
                        color = Color.pink;
                    }
                    if ((gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0) {
                        g.setColor(Color.black);
                        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        color = Color.white;
                    }
                    if (this.nSeleCol == j1 && this.nSeleRow == k) {
                        g.setColor(Color.blue);
                        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        color = Color.white;
                    }
                    if ((gridcell.options & PrintFormat.FormulaCell.cellIsStaticText) > 0) {
                        s = gridcell.text;
                    } else if (this.bShowFormulaInCell) {
                        s = gridcell.text;
                        if (s == null || s.length() == 0) {
                            if (gridcell.totalType == 1) {
                                s = "(SUM)";
                            } else if (gridcell.totalType == 2) {
                                s = "(AVG)";
                            }
                        }
                    } else if ((gridcell.options & PrintFormat.FormulaCell.cellIsNumber) > 0) {
                        if ((gridcell.options & PrintFormat.FormulaCell.cellRedOnNegtive) > 0) {
                            s = "-";
                        }
                        s = (gridcell.options & PrintFormat.FormulaCell.cellThousandsSeparator) > 0 ? String.valueOf(s) + "#,###" : String.valueOf(s) + "####";
                    } else {
                        s = "XX";
                    }
                    AwtUtil.drawText(g, s, rectangle, gridcell.font, color, gridcell.options, gridcell.lineGap);
                }
                ++j1;
                l = i1;
            }
            i = j;
            ++k;
        }
        if (this.bDrawOutLook) {
            PrintFormat.Row row1 = this.format.getRow(this.format.gridRows);
            if (row1 != null) {
                j = (int)((double)j + row1.height);
            }
            Dimension dimension = this.getSize();
            AwtUtil.drawLine(g, 0, j, dimension.width - 1, j, Color.black, 2, 1);
        }
    }

    void offsetSelItems(int i, int j) {
        this.insectSelItems(i, j, 0, 0);
    }

    void insectSelItems(int i, int j, int k, int l) {
        if (this.selectedFreeItem <= 0 || i == 0 && j == 0 && k == 0 && l == 0) {
            return;
        }
        this.RecordUndoItems();
        Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (cell == null || !cell.selected) continue;
            cell.r.x += i;
            cell.r.y += j;
            cell.r.width += k;
            cell.r.height += l;
        }
        this.setModified(true);
        Rectangle rectangle1 = this.format.getFreeCellBoundRect(false, true);
        rectangle = rectangle.union(rectangle1);
        this.setScrollSizes();
        this.redrawRect(rectangle);
    }

    protected void paintComponent(Graphics g) {
        if (this.forceRedraw) {
            this.draw();
            this.forceRedraw = false;
        }
        if (this.offImage != null) {
            g.drawImage(this.offImage, 0, 0, this);
        }
    }

    public Dimension getSize() {
        return this.format.getSize();
    }

    protected void findDefaultPreferredSize() {
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    void indicateCellOnToolbar(PrintFormat.Cell cell) {
        if (!this.editor.isVisible()) {
            Rectangle rectangle = null;
            if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
                rectangle = new Rectangle();
                this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle);
            } else if (cell != null) {
                rectangle = cell.r;
            }
            this.showPosition(rectangle);
        }
        this.toolBar2.responeAligment(this.selectedFreeItem);
        this.toolBar2.responeItemType(this.curItemType);
        if (this.curItemType > 0 || this.bInDrawGridLine || this.bToMergeCell) {
            this.toolBar2.nButtons[0].setEnabled(false);
            this.toolBar2.nButtons[1].setEnabled(false);
            this.toolBar2.nButtons[2].setEnabled(false);
        } else {
            this.toolBar2.nButtons[0].setEnabled(true);
            this.toolBar2.nButtons[1].setEnabled(this.bEnableAddRow || !this.format.bRowGroup);
            this.toolBar2.nButtons[2].setEnabled(this.selectedFreeItem == 1 || this.nSeleRow >= 0 && this.nSeleCol >= 0);
        }
        int i = 5;
        while (i <= 9) {
            this.toolBar2.tButtons[i].setEnabled(!this.bToMergeCell && !this.bInDrawGridLine);
            ++i;
        }
        this.toolBar2.tButtons[10].setEnabled(this.curItemType == 0 && !this.bToMergeCell);
        if (cell == null) {
            return;
        }
        if (cell instanceof PrintFormat.LineCell) {
            this.toolBar1.indicateLineStyle(((PrintFormat.LineCell)cell).lineStyle);
            this.toolBar1.indicateLineWidth(((PrintFormat.LineCell)cell).lineWidth);
        }
        this.toolBar1.indicateColor(cell.foreColor);
        this.toolBar1.indicateFont(cell.font);
        int j = cell.options;
        this.toolBar1.responeAligment(j);
        if (cell instanceof PrintFormat.FormulaCell) {
            this.toolBar2.responeOption(cell.options);
        }
    }

    void clearSelected() {
        Rectangle rectangle = new Rectangle();
        double d = 0.0;
        int i = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            double d1 = 0.0;
            Enumeration enumeration1 = this.format.colSet.elements();
            Enumeration enumeration2 = row.cellSet.elements();
            int j = 0;
            while (enumeration1.hasMoreElements() && enumeration2.hasMoreElements()) {
                PrintFormat.Col col = (PrintFormat.Col)enumeration1.nextElement();
                PrintFormat.GridCell gridcell = (PrintFormat.GridCell)enumeration2.nextElement();
                if ((gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0) {
                    gridcell.options &= ~PrintFormat.FormulaCell.cellSelected;
                    if ((gridcell.options & (PrintFormat.FormulaCell.cellMergeBottom | PrintFormat.FormulaCell.cellMergeRight)) > 0) {
                        this.format.getCellDrawRect(i, j, rectangle);
                        this.redrawRect(rectangle);
                    } else if ((gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0 && (gridcell.options & PrintFormat.FormulaCell.cellMergeRight) == 0) {
                        rectangle.setBounds((int)d1, (int)d, (int)col.width, (int)row.height);
                        this.redrawRect(rectangle);
                    }
                }
                d1 += col.width;
                ++j;
            }
            d += row.height;
            ++i;
        }
    }

    void clearAllSelectedGridCell(boolean flag) {
        if (flag) {
            this.clearCurrentGridCell();
        }
        this.clearSelected();
        int i = 0;
        Enumeration enumeration = this.format.colSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Col col = (PrintFormat.Col)enumeration.nextElement();
            if ((col.options & PrintFormat.Col.colSelected) > 0) {
                col.options &= ~PrintFormat.Col.colSelected;
                this.hRule.invalidateCol(i);
            }
            ++i;
        }
        i = 0;
        Enumeration enumeration1 = this.format.rowSet.elements();
        while (enumeration1.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration1.nextElement();
            if ((row.options & PrintFormat.Row.rowSelected) > 0) {
                row.options &= ~PrintFormat.Row.rowSelected;
                this.vRule.invalidateRow(i);
            }
            ++i;
        }
        this.bEnableAddRow = false;
        this.findUniqueSelectedRowAndCol();
    }

    void clearCurrentGridCell() {
        if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
            Rectangle rectangle = new Rectangle();
            this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle);
            this.nSeleRow = -1;
            this.nSeleCol = -1;
            this.redrawRect(rectangle);
        }
    }

    void undoItems() {
        if (this.m_undoList.size() <= 0) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        Enumeration enumeration = this.m_undoList.elements();
        while (enumeration.hasMoreElements()) {
            undoItem undoitem = (undoItem)enumeration.nextElement();
            rectangle.setBounds(undoitem.pCell.r);
            undoitem.pCell.r.setBounds(undoitem.r);
            rectangle = rectangle.union(undoitem.r);
            rectangle.x -= 2;
            rectangle.y -= 2;
            rectangle.width += 6;
            rectangle.height += 6;
            this.redrawRect(rectangle);
        }
        this.m_undoList.removeAllElements();
        if (this.bFirstUndo) {
            this.setModified(false);
        }
    }

    void RecordUndoItems() {
        this.m_undoList.removeAllElements();
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected) continue;
            this.m_undoList.addElement(new undoItem(cell));
        }
        this.bFirstUndo = !this.bModified;
    }

    void setGridCellActive(int i, int j) {
        if (i == this.nSeleRow && j == this.nSeleCol || i <= 0 || i >= this.format.gridRows || j <= 0 || j > this.format.gridCols) {
            return;
        }
        this.clearCurrentGridCell();
        Rectangle rectangle = new Rectangle();
        this.nSeleRow = i;
        this.nSeleCol = j;
        this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle);
        this.redrawRect(rectangle);
        PrintFormat.GridCell gridcell = this.format.getGridCell(i, j);
        this.indicateCellOnToolbar(gridcell);
    }

    void getCurSelCellRect(Rectangle rectangle) {
        if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
            this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle);
        } else {
            PrintFormat.Cell cell = this.format.findUniqueFreeCell();
            if (cell != null) {
                rectangle.setBounds(cell.r.x, cell.r.y, cell.r.width, cell.r.height);
            }
        }
    }

    void repaintAllSelectedCell() {
        Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
        this.redrawRect(rectangle);
        rectangle = this.format.getCellSelBoundRect();
        if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
            Rectangle rectangle1 = new Rectangle();
            this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle1);
            rectangle = rectangle.union(rectangle1);
        }
        this.redrawRect(rectangle);
    }

    void invalidateCurSelCell() {
        if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
            this.invalidateCurrentActiveCell();
        } else {
            Rectangle rectangle = this.format.getFreeCellBoundRect(false, true);
            this.redrawRect(rectangle);
        }
    }

    void invalidateCurrentActiveCell() {
        if (this.nSeleRow > 0 && this.nSeleRow <= this.format.gridRows && this.nSeleCol > 0 && this.nSeleCol <= this.format.gridCols) {
            Rectangle rectangle = new Rectangle();
            this.format.getCellDrawRect(this.nSeleRow, this.nSeleCol, rectangle);
            this.redrawRect(rectangle);
        } else {
            Rectangle rectangle1 = this.format.getFreeCellBoundRect(false, true);
            if (!rectangle1.isEmpty()) {
                this.redrawRect(rectangle1);
            }
        }
    }

    void selectColCell(int i) {
        PrintFormat.Col col = this.format.getColumn(i);
        if (col == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        int j = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            PrintFormat.GridCell gridcell = row.getColCell(i);
            if (gridcell != null && (gridcell.options & PrintFormat.FormulaCell.cellSelected) == 0) {
                gridcell.options |= PrintFormat.FormulaCell.cellSelected;
                this.format.getCellDrawRect(j, i, rectangle);
                this.redrawRect(rectangle);
            }
            ++j;
        }
    }

    void unSelectColCell(int i) {
        PrintFormat.Col col = this.format.getColumn(i);
        if (col == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        int j = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            PrintFormat.GridCell gridcell = row.getColCell(i);
            if (gridcell != null && (gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0) {
                gridcell.options &= ~PrintFormat.FormulaCell.cellSelected;
                this.format.getCellDrawRect(j, i, rectangle);
                this.redrawRect(rectangle);
            }
            ++j;
        }
    }

    void selectRowCell(int i) {
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        int j = 0;
        Enumeration enumeration = row.cellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.GridCell gridcell = (PrintFormat.GridCell)enumeration.nextElement();
            if (gridcell != null && (gridcell.options & PrintFormat.FormulaCell.cellSelected) == 0) {
                gridcell.options |= PrintFormat.FormulaCell.cellSelected;
                this.format.getCellDrawRect(i, j, rectangle);
                this.redrawRect(rectangle);
            }
            ++j;
        }
    }

    void unSelectRowCell(int i) {
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        int j = 0;
        Enumeration enumeration = row.cellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.GridCell gridcell = (PrintFormat.GridCell)enumeration.nextElement();
            if (gridcell != null && (gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0) {
                gridcell.options &= ~PrintFormat.FormulaCell.cellSelected;
                this.format.getCellDrawRect(i, j, rectangle);
                this.redrawRect(rectangle);
            }
            ++j;
        }
    }

    void mergeCell(int i, int j) {
        if (this.nSeleRow <= 0 || this.nSeleCol <= 0 || i < this.nSeleRow || j < this.nSeleCol) {
            return;
        }
        PrintFormat.GridCell gridcell = this.format.getGridCell(this.nSeleRow, this.nSeleCol);
        if (gridcell == null || (gridcell.options & PrintFormat.FormulaCell.cellBeMerged) > 0) {
            return;
        }
        Rectangle rectangle = new Rectangle(this.nSeleCol, this.nSeleRow, 0, 0);
        this.format.findMergedCells(rectangle);
        if (rectangle.width != 1 || rectangle.height != 1) {
            this.clearMergedFlag(rectangle);
            Rectangle rectangle1 = new Rectangle(rectangle);
            this.format.getCellsRect(rectangle1);
            --rectangle1.x;
            --rectangle1.y;
            rectangle1.width += 2;
            rectangle1.height += 2;
            this.redrawRect(rectangle1);
        }
        rectangle.setBounds(this.nSeleCol, this.nSeleRow, j + 1 - this.nSeleCol, i + 1 - this.nSeleRow);
        if (this.format.hasMergedCell(rectangle)) {
            return;
        }
        this.format.setMergedFlag(rectangle);
        Rectangle rectangle2 = new Rectangle(rectangle);
        this.format.getCellsRect(rectangle2);
        --rectangle2.x;
        --rectangle2.y;
        rectangle2.width += 2;
        rectangle2.height += 2;
        this.forceRedraw = true;
        this.repaint();
        this.setModified(true);
    }

    void clearMergedFlag(Rectangle rectangle) {
        Point point = new Point(0, 0);
        int i = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            Enumeration enumeration1 = row.cellSet.elements();
            int j = 0;
            while (j <= this.format.gridCols && enumeration1.hasMoreElements()) {
                PrintFormat.GridCell gridcell = (PrintFormat.GridCell)enumeration1.nextElement();
                point.x = j;
                point.y = i;
                if (rectangle.contains(point)) {
                    gridcell.options &= ~(PrintFormat.FormulaCell.cellMergeBottom | PrintFormat.FormulaCell.cellMergeRight | PrintFormat.FormulaCell.cellBeMerged);
                }
                ++j;
            }
            ++i;
        }
    }

    private void OnPopupMenu(int i, int j) {
        this.AutoEnabledMenu();
        Point point = this.getLocationOnScreen();
        i += point.x;
        j += point.y;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension1 = this.attrMenu.getSize();
        if (dimension1 == null || dimension1.width == 0) {
            this.attrMenu.setLocation(i, j);
            this.attrMenu.setVisible(true);
            dimension1 = this.attrMenu.getSize();
        }
        boolean flag = false;
        if (i + dimension1.width > dimension.width) {
            i = dimension.width - dimension1.width;
            flag = true;
        }
        if (j + dimension1.height > dimension.height) {
            j = dimension.height - dimension1.height;
            flag = true;
        }
        if (flag || !this.attrMenu.isVisible()) {
            this.attrMenu.setLocation(i, j);
            this.attrMenu.setVisible(true);
        }
    }

    private void AutoEnabledMenu() {
        MenuElement[] amenuelement = this.attrMenu.getSubElements();
        int i = 0;
        if (amenuelement != null) {
            i = amenuelement.length;
        }
        int j = this.format.countSelectedRow();
        int k = this.format.countSelectedCol();
        ((JMenuItem)amenuelement[0]).setEnabled(this.format.canDeleteRowCol());
        ((JMenuItem)amenuelement[1]).setEnabled(this.nSeleCol >= 0 && this.nSeleCol >= 0 && this.curItemType == 0 && !this.bDrawLine);
        ((JMenuItem)amenuelement[2]).setEnabled(this.selectedFreeItem == 1 || this.nSeleCol >= 0 && this.nSeleCol >= 0);
        ((JMenuItem)amenuelement[3]).setEnabled(this.nSeleCol >= 0 && this.nSeleCol >= 0 || this.format.isCanBatchAttr() > 0);
        ((JMenuItem)amenuelement[5]).setEnabled(j == 1);
        ((JMenuItem)amenuelement[6]).setEnabled(k == 1);
        ((JMenuItem)amenuelement[8]).setEnabled(j == 1);
        ((JMenuItem)amenuelement[9]).setEnabled(j == 1);
        ((JMenuItem)amenuelement[10]).setEnabled(k == 1);
    }

    PrintFormat.Cell findUniqueCell() {
        if (this.nSeleRow >= 0 && this.nSeleCol >= 0) {
            return this.format.getGridCell(this.nSeleRow, this.nSeleCol);
        }
        if (this.selectedFreeItem == 1) {
            return this.format.findUniqueFreeCell();
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionevent) {
        this.attrMenu.setVisible(false);
        String s = actionevent.getActionCommand();
        if (s != null && s.length() > 0) {
            int i = Utilities.findAtStringArray(this.szMenuItems, s);
            switch (i) {
                default: {
                    break;
                }
                case 0: {
                    this.OnDeleteRowCol();
                    break;
                }
                case 1: {
                    this.OnCellMerge();
                    break;
                }
                case 3: {
                    this.OnFormulaEdit();
                    break;
                }
                case 4: {
                    this.OnCellAttribute();
                    break;
                }
                case 5: {
                    Dimension dimension = new Dimension(2, 2);
                    int[] ai = new int[]{1};
                    if (!PrintCellDialog.getCellDimension(dimension, ai)) break;
                    Enumeration enumeration = this.format.freeCellSet.elements();
                    while (enumeration.hasMoreElements()) {
                        PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
                        if (cell instanceof PrintFormat.FreeCell) {
                            ((PrintFormat.FreeCell)cell).maxDecimals = dimension.width;
                            ((PrintFormat.FreeCell)cell).minDecimals = dimension.height;
                        }
                        cell.lineGap = ai[0];
                    }
                    int j = 1;
                    while (j < this.format.gridRows) {
                        PrintFormat.Row row = this.format.getRow(j);
                        if (row == null) break;
                        int l = 1;
                        while (l <= this.format.gridCols) {
                            PrintFormat.GridCell gridcell = row.getColCell(l);
                            if (gridcell == null) break;
                            gridcell.maxDecimals = dimension.width;
                            gridcell.minDecimals = dimension.height;
                            gridcell.lineGap = ai[0];
                            ++l;
                        }
                        ++j;
                    }
                    this.setModified(true);
                    break;
                }
                case 6: {
                    if (!RowColAttrDialog.getRowAttribute(this.pUniqueSelectedRow)) break;
                    this.setModified(true);
                    break;
                }
                case 7: {
                    if (!RowColAttrDialog.getColAttribute(this.pUniqueSelectedCol)) break;
                    this.setModified(true);
                    break;
                }
                case 8: {
                    int[] ai1 = this.format.getSelectedRows();
                    int[] ai2 = this.format.getSelectedCols();
                    if (ai1 != null) {
                        this.rowcolAttr.rowHeight = this.format.getRow((int)ai1[0]).height;
                        this.rowcolAttr.bSelectRow = true;
                        this.rowcolAttr.nRow1 = ai1[0] + 1;
                        this.rowcolAttr.nRow2 = ai1[ai1.length - 1] + 1;
                    } else {
                        this.rowcolAttr.bSelectRow = false;
                        this.rowcolAttr.nRow2 = 0;
                        this.rowcolAttr.nRow1 = 0;
                    }
                    if (ai2 != null) {
                        this.rowcolAttr.colWidth = this.format.getColumn((int)ai2[0]).width;
                        this.rowcolAttr.bSelectCol = true;
                        this.rowcolAttr.nCol1 = ai2[0] + 1;
                        this.rowcolAttr.nCol2 = ai2[ai2.length - 1] + 1;
                    } else {
                        this.rowcolAttr.bSelectCol = false;
                        this.rowcolAttr.nCol2 = 0;
                        this.rowcolAttr.nCol1 = 0;
                    }
                    int k = 0;
                    if (!RowColWidthDialog.getRowColAttribute(this.rowcolAttr)) break;
                    int i1 = 1;
                    while (i1 <= this.format.gridRows + 1) {
                        PrintFormat.Row row1 = this.format.getRow(i1 - 1);
                        if (row1 != null && (this.rowcolAttr.rowHeight >= 0.0 && this.rowcolAttr.bSelectRow && (row1.options & PrintFormat.Row.rowSelected) > 0 || !this.rowcolAttr.bSelectRow && i1 >= this.rowcolAttr.nRow1 && i1 <= this.rowcolAttr.nRow2)) {
                            row1.height = this.rowcolAttr.rowHeight;
                            k = 1;
                        }
                        ++i1;
                    }
                    int j1 = 1;
                    while (j1 <= this.format.gridCols + 1) {
                        PrintFormat.Col col = this.format.getColumn(j1);
                        if (col != null && (this.rowcolAttr.colWidth >= 0.0 && this.rowcolAttr.bSelectCol && (col.options & PrintFormat.Col.colSelected) > 0 || !this.rowcolAttr.bSelectCol && j1 >= this.rowcolAttr.nCol1 && j1 <= this.rowcolAttr.nCol2)) {
                            k |= 2;
                            col.width = this.rowcolAttr.colWidth;
                        }
                        ++j1;
                    }
                    if (k <= 0) break;
                    this.bModified = true;
                    this.forceRedraw = true;
                    this.repaint();
                    this.setModified(true);
                    if ((k & 1) > 0) {
                        this.vRule.repaint();
                    }
                    if ((k & 2) <= 0) break;
                    this.hRule.repaint();
                    break;
                }
                case 9: {
                    String s1 = FormulaEdit.getFormula(this.pUniqueSelectedRow.groupFormula, "\u5206\u7ec4\u516c\u5f0f", this.getFormulaWords(), this.getFormulaFixWords());
                    if (s1 == null) break;
                    this.pUniqueSelectedRow.groupFormula = new String(s1);
                    this.setModified(true);
                    break;
                }
                case 10: {
                    String s2 = FormulaEdit.getFormula(this.pUniqueSelectedRow.startFormula, "\u884c\u542f\u52a8\u6253\u5370\u516c\u5f0f", this.getFormulaWords(), this.getFormulaFixWords());
                    if (s2 == null) break;
                    this.pUniqueSelectedRow.startFormula = new String(s2);
                    this.setModified(true);
                    break;
                }
                case 11: {
                    String s3 = FormulaEdit.getFormula(this.pUniqueSelectedCol.dupTimes, "\u5217\u91cd\u590d\u6253\u5370\u6b21\u6570", this.getFormulaWords(), this.getFormulaFixWords());
                    if (s3 == null) break;
                    this.setModified(true);
                    this.pUniqueSelectedCol.dupTimes = new String(s3);
                    break;
                }
                case 12: {
                    String s4 = FormulaEdit.getFormula(this.format.startFormula, "\u62a5\u8868\u542f\u52a8\u516c\u5f0f", this.getFormulaWords(), this.getFormulaFixWords());
                    if (s4 == null) break;
                    this.format.startFormula = new String(s4);
                    this.setModified(true);
                    break;
                }
                case 13: {
                    if (!ReportAttrDialog.getReportAttribute(this.format)) break;
                    this.setModified(true);
                    break;
                }
                case 15: {
                    try {
                        this.OnSaveToFile();
                    }
                    catch (IOException ioexception) {
                        ioexception.printStackTrace(Message.out);
                    }
                    break;
                }
                case 16: {
                    this.requestFocus();
                    try {
                        this.OnLoadFromFile();
                    }
                    catch (IOException ioexception1) {
                        ioexception1.printStackTrace(Message.out);
                    }
                    break;
                }
                case 17: {
                    String s5 = this.format.backGraph != null ? this.format.backGraph.text : null;
                    String s7 = ExtObject.openImgDialog(this, s5);
                    if (s7 == null) break;
                    this.format.setBackGraph(s7, 0, 0);
                    this.redrawRect(this.format.backGraph.r);
                    this.setModified(true);
                    break;
                }
                case 18: {
                    String s6 = FormulaEdit.getFormula(this.format.endFormula, "\u7ec8\u6b62\u516c\u5f0f", this.getFormulaWords(), this.getFormulaFixWords());
                    if (s6 == null) break;
                    this.format.endFormula = new String(s6);
                    this.setModified(true);
                }
            }
        }
    }

    String saveContent() {
        this.endEdit();
        return this.format.saveAsText();
    }

    void incColWidth(int i, double d) {
        if (d == 0.0) {
            return;
        }
        PrintFormat.Col col = this.format.getColumn(i);
        if (col == null) {
            return;
        }
        double d1 = col.width + d;
        if (d1 < 3.0) {
            d1 = 3.0;
        }
        if (d1 == col.width) {
            return;
        }
        if (i == 0) {
            this.selectFreeCell(true);
            this.offsetSelItems((int)d, 0);
            this.makeSelFlag(null);
        }
        col.width = d1;
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.x = (int)this.format.getColLine(i - 1);
        rectangle.width -= rectangle.x;
        this.redrawRect(rectangle);
        this.setModified(true);
        this.setScrollSizes();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int i, int j) {
        if (i == 0) {
            return 8;
        }
        int k = rectangle.y - 16;
        k = k < 0 ? rectangle.y : 16;
        return k;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int i, int j) {
        return i != 1 ? rectangle.width : rectangle.height;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private void setScrollSizes() {
        Dimension dimension = this.getSize();
        this.setSize(dimension);
    }

    boolean isModified() {
        return this.bModified;
    }

    void setModified(boolean flag) {
        this.bModified = flag;
        if (this.mainPanel != null) {
            this.mainPanel.setSaveButtonAttr();
        }
    }

    void incRowHeight(int i, double d) {
        if (d == 0.0) {
            return;
        }
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return;
        }
        double d1 = row.height + d;
        if (d1 < 3.0) {
            d1 = 3.0;
        }
        if (d1 == row.height) {
            return;
        }
        if (i < this.format.gridRows) {
            this.selBottomCell();
            this.offsetSelItems(0, (int)d);
            this.makeSelFlag(null);
        }
        row.height = d1;
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.y = (int)this.format.getRowLine(i - 1);
        rectangle.height -= rectangle.y;
        this.redrawRect(rectangle);
        this.setModified(true);
        this.setScrollSizes();
    }

    public void OnAddColumn() {
        this.endEdit();
        boolean flag = true;
        int i = 0;
        while (i <= this.format.gridCols) {
            PrintFormat.Col col = this.format.getColumn(i);
            if (col != null && (col.options & PrintFormat.Col.colSelected) > 0) {
                col.options &= ~PrintFormat.Col.colSelected;
                int j = 0;
                while (j <= this.format.gridRows) {
                    PrintFormat.GridCell gridcell = this.format.getGridCell(j, i);
                    if (gridcell != null) {
                        gridcell.options &= ~PrintFormat.FormulaCell.cellSelected;
                    }
                    ++j;
                }
                this.insertColumn(i);
                flag = false;
                ++i;
            }
            ++i;
        }
        if (flag) {
            this.insertColumn(this.format.gridCols);
        }
        this.setScrollSizes();
    }

    void OnAddRow() {
        this.endEdit();
        if (this.format.bRowGroup) {
            Dimension dimension = new Dimension(0, 0);
            if (!this.format.addRowEnable(dimension)) {
                return;
            }
            if (dimension.height == 0) {
                this.insertRow(dimension.width);
            } else {
                this.insertGrpRow(dimension.width, dimension.height);
            }
        } else {
            boolean flag = true;
            Dimension dimension1 = new Dimension(0, 0);
            if (!this.format.addRowEnable(dimension1)) {
                return;
            }
            if (dimension1.height > 0) {
                this.insertGrpRow(dimension1.width, dimension1.height);
                flag = false;
            } else {
                int i;
                String s = DialogPanel.askText("\u589e\u52a0\u884c", "\u589e\u52a0\u884c\u6570", "1", 8);
                int n = i = s != null ? Integer.parseInt(s) : 1;
                if (i < 1) {
                    i = 1;
                }
                int j = 1;
                while (j < this.format.gridRows) {
                    PrintFormat.Row row = this.format.getRow(j);
                    if (row == null) break;
                    if ((row.options & PrintFormat.Row.rowSelected) > 0) {
                        int k = 0;
                        while (k < i) {
                            PrintFormat.Row row1 = this.insertRow(j);
                            if (row1 != null) {
                                row1.setRow(row);
                            }
                            ++k;
                        }
                        flag = false;
                        ++j;
                    }
                    ++j;
                }
            }
            if (flag) {
                this.insertRow(this.format.findFootRow() - 1);
            }
        }
        this.format.groupNumber = this.format.countGroupNum();
        this.clearAllSelectedGridCell(true);
        this.autoSetVRuleHeight();
        this.setScrollSizes();
    }

    void autoSetVRuleHeight() {
        int i = this.format.rowSet.size();
        Dimension dimension = this.vRule.getPreferredSize();
        if (i > 100) {
            Dimension dimension1 = this.format.getSize();
            this.vRule.setPreferredSize(new Dimension(dimension.width, dimension1.height + 10));
        } else if (dimension.height > 4000) {
            this.vRule.setPreferredSize(new Dimension(dimension.width, 4000));
        }
    }

    void OnDeleteRowCol() {
        boolean flag;
        this.endEdit();
        int i = 1;
        while (i <= this.format.gridCols) {
            PrintFormat.Col col = this.format.getColumn(i);
            if (col == null) break;
            if ((col.options & PrintFormat.Col.colSelected) > 0) {
                col.options &= ~PrintFormat.Col.colSelected;
                this.deleteColumn(i);
                continue;
            }
            ++i;
        }
        block1: do {
            PrintFormat.Row row;
            flag = true;
            int j = 0;
            while ((row = this.format.getRow(j)) != null) {
                if (j > 0 && (row.options & PrintFormat.Row.rowSelected) > 0) {
                    row.options &= ~PrintFormat.Row.rowSelected;
                    this.deleteRow(j);
                    this.vRule.invalidateRow(j);
                    flag = false;
                    continue block1;
                }
                ++j;
            }
        } while (!flag);
        this.format.groupNumber = this.format.countGroupNum();
        this.clearAllSelectedGridCell(false);
        this.autoSetVRuleHeight();
        this.vRule.repaint();
        this.hRule.repaint();
        this.setScrollSizes();
    }

    void loadFromText(String s) {
        this.endEdit();
        this.m_undoList.removeAllElements();
        boolean flag = false;
        if (s != null && s.length() > 0) {
            flag = this.format.loadFromText(s);
        }
        if (flag) {
            this.format.gridRows = this.format.rowSet.size() - 1;
            this.format.gridCols = this.format.colSet.size() - 1;
            this.format.groupNumber = this.format.countGroupNum();
            if (!this.format.bRowGroup && this.format.gridRows >= 4 && this.format.countGroupNum() == 0) {
                PrintFormat.Row row = this.format.getRow(2);
                if (row != null) {
                    row.options |= PrintFormat.Row.rowGroupBgn;
                }
                if ((row = this.format.getRow(this.format.gridRows - 1)) != null) {
                    row.options |= PrintFormat.Row.rowGroupEnd;
                }
                row = this.format.newGridRow();
                row.options |= PrintFormat.Row.rowHideWhenPrinting;
                this.format.rowSet.insertElementAt(row, this.format.gridRows);
                this.format.groupNumber = 1;
                ++this.format.gridRows;
            }
        } else {
            this.format.init();
        }
        this.forceRedraw = true;
        this.repaint();
        this.autoSetVRuleHeight();
        this.hRule.repaint();
        this.vRule.repaint();
        this.setScrollSizes();
    }

    private void OnLoadFromFile() throws IOException {
        File file;
        boolean flag = false;
        FileNameChooser filenamechooser = new FileNameChooser();
        filenamechooser.setFileFilter(new FileNameLikeFileFilter("*.txt"));
        filenamechooser.setDialogType(0);
        filenamechooser.setCurrentDirectory(new File(Utilities.getUserDir()));
        if (filenamechooser.showDialog(this, "\u6253\u5f00") == 0 && (file = filenamechooser.getSelectedFile()) != null && file.canRead()) {
            String s1;
            String s = null;
            BufferedReader bufferedreader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            StringBuffer stringbuffer = new StringBuffer();
            while ((s1 = bufferedreader.readLine()) != null) {
                stringbuffer.append(s1);
            }
            s = stringbuffer.toString();
            bufferedreader.close();
            this.loadFromText(s);
            this.setModified(true);
        }
    }

    private void OnSaveToFile() throws IOException {
        File file;
        FileNameChooser filenamechooser = new FileNameChooser();
        filenamechooser.setFileFilter(new FileNameLikeFileFilter("*.txt"));
        filenamechooser.setDialogType(1);
        filenamechooser.setCurrentDirectory(new File(Utilities.getUserDir()));
        if (!(filenamechooser.showDialog(this, "\u4fdd\u5b58") != 0 || (file = filenamechooser.getSelectedFile()) == null || file.exists() && JOptionPane.showConfirmDialog(null, "\u6587\u4ef6'" + file + "'\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6?", "\u63d0\u793a", 1) != 0)) {
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            String s = this.saveContent();
            if (s != null && s.length() > 0) {
                fileoutputstream.write(s.getBytes());
            }
            fileoutputstream.close();
        }
    }

    void OnCellMerge() {
        if (this.nSeleRow > 0 && this.nSeleCol > 0 && !this.bToMergeCell && !this.bInDrawGridLine) {
            this.bToMergeCell = true;
            this.indicateCellOnToolbar(null);
            this.endEdit();
        }
    }

    private void invalidateDrawGridLinePoint(int i, int j) {
        if (this.format.isValidDrawGridLinePoint(i, j)) {
            int k = (int)this.format.getColLine(j);
            int l = (int)this.format.getRowLine(i);
            this.redrawRect(k - 4, l - 4, 9, 9);
        }
    }

    private void setDrawGridLinePoint(int i, int j) {
        if (this.format.isValidDrawGridLinePoint(i, j)) {
            this.invalidateDrawGridLinePoint(this.yInDrawGridLine, this.xInDrawGridLine);
            this.yInDrawGridLine = i;
            this.xInDrawGridLine = j;
            this.invalidateDrawGridLinePoint(this.yInDrawGridLine, this.xInDrawGridLine);
        }
    }

    private void invalidateGridCell(int i, int j) {
        Rectangle rectangle = new Rectangle();
        this.format.getCellDrawRect(i, j, rectangle);
        this.redrawRect(rectangle);
    }

    private void invalidateGridCellBLine(int i, int j) {
        Rectangle rectangle = new Rectangle();
        this.format.getCellRect(i, j, rectangle);
        if (!rectangle.isEmpty()) {
            this.redrawRect(rectangle.x - 1, rectangle.y + rectangle.height - 1, rectangle.width + 2, 2);
        }
    }

    private void invalidateGridCellRLine(int i, int j) {
        Rectangle rectangle = new Rectangle();
        this.format.getCellRect(i, j, rectangle);
        if (!rectangle.isEmpty()) {
            this.redrawRect(rectangle.x + rectangle.width - 1, rectangle.y - 1, 2, rectangle.height + 2);
        }
    }

    void OnDrawGridLine() {
        this.endEdit();
        if (!this.bToMergeCell && this.curItemType == 0) {
            boolean bl = this.bInDrawGridLine = !this.bInDrawGridLine;
            if (this.bInDrawGridLine) {
                this.setDrawGridLinePoint(0, 0);
            } else {
                this.invalidateDrawGridLinePoint(this.yInDrawGridLine, this.xInDrawGridLine);
            }
            this.indicateCellOnToolbar(null);
        }
    }

    void setCellsOption(int i) {
        if (i >= 5 || i < 0) {
            return;
        }
        boolean flag = this.toolBar2.tButtons[i].isSelected();
        int j = 0;
        switch (i) {
            case 0: {
                j = PrintFormat.FormulaCell.cellIsStaticText;
                break;
            }
            case 1: {
                j = PrintFormat.FormulaCell.cellIsNumber;
                break;
            }
            case 2: {
                j = PrintFormat.FormulaCell.cellSuppressIfZero;
                break;
            }
            case 3: {
                j = PrintFormat.FormulaCell.cellThousandsSeparator;
                break;
            }
            case 4: {
                j = PrintFormat.FormulaCell.cellRedOnNegtive;
            }
        }
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected || !(cell instanceof PrintFormat.FreeCell)) continue;
            cell.options = flag ? (cell.options |= j) : (cell.options &= ~j);
            this.bModified = true;
        }
        int k = 1;
        while (k < this.format.gridRows) {
            PrintFormat.Row row = this.format.getRow(k);
            if (row == null) break;
            int l = 1;
            while (l <= this.format.gridCols) {
                PrintFormat.GridCell gridcell = row.getColCell(l);
                if (gridcell != null && ((gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0 || k == this.nSeleRow && l == this.nSeleCol)) {
                    gridcell.options = flag ? (gridcell.options |= j) : (gridcell.options &= ~j);
                    this.bModified = true;
                }
                ++l;
            }
            ++k;
        }
        if (this.bModified) {
            this.repaintAllSelectedCell();
            this.setModified(true);
        }
    }

    void OnFormulaEdit() {
        this.endEdit();
        PrintFormat.Cell cell = this.findUniqueCell();
        if (cell == null || cell instanceof PrintFormat.LineCell) {
            return;
        }
        String s = null;
        s = this.getFields() == null ? FormulaEdit.getFormula(cell.text, null, this.getFormulaWords(), this.getFormulaFixWords()) : FormulaEdit.getFormulax(cell.text, null, this.getFormulaWords(), this.getFormulaFixWords(), this.getFields());
        if (s != null) {
            cell.text = new String(s);
            this.invalidateCurSelCell();
            this.setModified(true);
        }
    }

    public String[] analyzePrint(String Str) {
        if (Str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(Str);
        while (st.hasMoreTokens()) {
            String[] temp;
            String token = st.nextToken();
            if (!token.equals("<DESC>") || (temp = Utilities.splitString(st.nextToken(), '|')) == null) continue;
            return temp;
        }
        return null;
    }

    public String[] getFields() {
        block7: {
            Object[] obj;
            String[] fields;
            block8: {
                fields = new String[500];
                String name = this.mainPanel.defnameField.getText();
                int i = name.indexOf(":");
                if (i <= 0) break block7;
                name = name.substring(0, i);
                String dwdesc = JDBC.loadCacheableString("select sel2 from datawin where dwname='" + name + "'");
                obj = null;
                if (dwdesc != null) {
                    obj = this.analyzePrint(dwdesc);
                }
                if (dwdesc != null) break block8;
                dwdesc = JDBC.loadCacheableString("select sel from dzusedef where docname='" + name + "'");
                obj = this.analyzePrint(dwdesc);
                if (dwdesc != null) break block8;
                return null;
            }
            try {
                int index = 0;
                int h = obj.length - 1;
                while (h >= 0) {
                    Object[][] value = JDBC.loadCacheableValues("select displaycaption,cellid from datatablecell where datatableid =" + obj[h]);
                    String star = "";
                    int h0 = obj.length - 1;
                    while (h0 > h) {
                        star = String.valueOf(star) + "$";
                        --h0;
                    }
                    int h1 = 0;
                    while (h1 < value.length) {
                        fields[index] = String.valueOf(star) + value[h1][0] + ":" + value[h1][1];
                        ++index;
                        ++h1;
                    }
                    --h;
                }
                return fields;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void OnCellAttribute() {
        if (this.selectedFreeItem == 1 || this.nSeleCol >= 0 && this.nSeleCol >= 0) {
            PrintFormat.Cell cell = this.findUniqueCell();
            if (cell != null && (cell instanceof PrintFormat.StaticCell || cell instanceof PrintFormat.FormulaCell) && PrintCellDialog.getCellAttribute(cell, 1)) {
                this.invalidateCurSelCell();
                this.setModified(true);
                this.indicateCellOnToolbar(cell);
            }
        } else {
            int i = this.format.isCanBatchAttr();
            PrintFormat.Cell obj = this.format.findUniqueFreeCell();
            if (obj == null) {
                obj = this.format.findUniqueGridCell();
            }
            if (PrintCellDialog.getCellAttribute(obj, 2)) {
                if (i == 3) {
                    int j = 1;
                    while (j < this.format.gridRows) {
                        PrintFormat.Row row = this.format.getRow(j);
                        if (row != null) {
                            int k = 1;
                            while (k <= this.format.gridCols) {
                                PrintFormat.GridCell gridcell = row.getColCell(k);
                                if (gridcell != null && gridcell != obj && (gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0) {
                                    int l = PrintFormat.FormulaCell.cellSuppressIfZero;
                                    while (l <= PrintFormat.FormulaCell.cellAlignVCenter) {
                                        gridcell.options = (obj.options & l) > 0 ? (gridcell.options |= l) : (gridcell.options &= ~l);
                                        l <<= 1;
                                    }
                                    gridcell.maxDecimals = ((PrintFormat.GridCell)obj).maxDecimals;
                                    gridcell.minDecimals = ((PrintFormat.GridCell)obj).minDecimals;
                                    gridcell.totalType = ((PrintFormat.GridCell)obj).totalType;
                                    gridcell.lineGap = obj.lineGap;
                                }
                                ++k;
                            }
                            ++j;
                            continue;
                        }
                        break;
                    }
                } else if (this.selectedFreeItem > 1) {
                    Enumeration enumeration = this.format.freeCellSet.elements();
                    while (enumeration.hasMoreElements()) {
                        PrintFormat.Cell cell1 = (PrintFormat.Cell)enumeration.nextElement();
                        if (!cell1.selected) continue;
                        cell1.options = obj.options;
                        if (!(cell1 instanceof PrintFormat.FreeCell)) continue;
                        ((PrintFormat.FreeCell)cell1).maxDecimals = ((PrintFormat.FreeCell)obj).maxDecimals;
                        ((PrintFormat.FreeCell)cell1).minDecimals = ((PrintFormat.FreeCell)obj).minDecimals;
                        cell1.lineGap = obj.lineGap;
                    }
                }
                this.repaintAllSelectedCell();
                this.indicateCellOnToolbar(obj);
                this.setModified(true);
            }
        }
    }

    void setDisplayContent(boolean flag) {
        this.bShowFormulaInCell = flag;
        this.forceRedraw = true;
        this.repaint();
    }

    void showRuler(boolean flag) {
        this.bShowRuler = flag;
        if (this.vRule != null) {
            PrintFormatDesign _tmp = this;
            this.vRule.setPreferredSize(new Dimension(PrintVRule.nVRuleWidth + (flag ? 16 : 0), 4000));
            this.vRule.repaint();
        }
        if (this.hRule != null) {
            PrintFormatDesign _tmp1 = this;
            this.hRule.setPreferredSize(new Dimension(2048, PrintHRule.nRuleHeight + (flag ? 16 : 0)));
            this.hRule.repaint();
        }
        JRootPane jrootpane = this.getRootPane();
        this.forceRedraw = true;
        this.repaint();
        if (this.parentScoll != null) {
            this.parentScoll.setViewportView(this);
            this.parentScoll.setRowHeaderView(this.vRule);
            this.parentScoll.setColumnHeaderView(this.hRule);
        }
    }

    void setCellFont() {
        Color color = (Color)this.toolBar1.colorCombo.getSelectedItem();
        String s = (String)this.toolBar1.fontNameCombo.getSelectedItem();
        String s1 = (String)this.toolBar1.fontSizeCombo.getSelectedItem();
        int i = Integer.parseInt(s1);
        boolean flag = this.toolBar1.buttons[1].isSelected();
        boolean flag1 = this.toolBar1.buttons[2].isSelected();
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected || cell instanceof PrintFormat.GraphCell) continue;
            this.bModified = true;
            cell.foreColor = color;
            if (cell instanceof PrintFormat.LineCell) continue;
            int k = 0;
            if (flag) {
                k |= 1;
            }
            if (flag1) {
                k |= 2;
            }
            cell.font = new Font(s, k, i);
        }
        int j = 1;
        while (j < this.format.gridRows) {
            PrintFormat.Row row = this.format.getRow(j);
            if (row == null) break;
            int l = 1;
            while (l <= this.format.gridCols) {
                PrintFormat.GridCell gridcell = row.getColCell(l);
                if (gridcell != null && ((gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0 || j == this.nSeleRow && l == this.nSeleCol)) {
                    this.bModified = true;
                    gridcell.foreColor = color;
                    int i1 = 0;
                    if (flag) {
                        i1 |= 1;
                    }
                    if (flag1) {
                        i1 |= 2;
                    }
                    gridcell.font = new Font(s, i1, i);
                }
                ++l;
            }
            ++j;
        }
        if (this.bModified) {
            this.repaintAllSelectedCell();
            this.setModified(true);
        }
    }

    void setAlingment(int i) {
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (!cell.selected || !(cell instanceof PrintFormat.FreeCell) && !(cell instanceof PrintFormat.StaticCell)) continue;
            cell.options &= ~(PrintFormat.FormulaCell.cellAlignCenter | PrintFormat.FormulaCell.cellAlignRight);
            cell.options |= i;
            this.bModified = true;
        }
        int j = 1;
        while (j < this.format.gridRows) {
            PrintFormat.Row row = this.format.getRow(j);
            if (row == null) break;
            int k = 1;
            while (k <= this.format.gridCols) {
                PrintFormat.GridCell gridcell = row.getColCell(k);
                if (gridcell != null && ((gridcell.options & PrintFormat.FormulaCell.cellSelected) > 0 || j == this.nSeleRow && k == this.nSeleCol)) {
                    gridcell.options &= ~(PrintFormat.FormulaCell.cellAlignCenter | PrintFormat.FormulaCell.cellAlignRight);
                    gridcell.options |= i;
                    this.bModified = true;
                }
                ++k;
            }
            ++j;
        }
        if (this.bModified) {
            this.repaintAllSelectedCell();
            this.setModified(true);
        }
    }

    void setLineOption() {
        String s = (String)this.toolBar1.lineWidthCombo.getSelectedItem();
        int i = Integer.parseInt(s);
        Integer integer = (Integer)this.toolBar1.lineStyleCombo.getSelectedItem();
        int j = integer;
        Enumeration enumeration = this.format.freeCellSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Cell cell = (PrintFormat.Cell)enumeration.nextElement();
            if (cell.selected && cell instanceof PrintFormat.LineCell) {
                ((PrintFormat.LineCell)cell).lineStyle = j;
                ((PrintFormat.LineCell)cell).lineWidth = i;
            }
            this.bModified = true;
        }
        if (this.bModified) {
            this.repaintAllSelectedCell();
            this.setModified(true);
        }
    }

    PrintFormat.Row insertRow(int i) {
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return null;
        }
        PrintFormat.Row row1 = this.format.newGridRow();
        row1.options |= row.options & PrintFormat.Row.rowGroupEnd;
        row.options &= ~PrintFormat.Row.rowGroupEnd;
        this.format.setRowOptionsForInsertRow(row1, row);
        this.format.rowSet.insertElementAt(row1, i + 1);
        ++this.format.gridRows;
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.y = (int)this.format.getRowLine(i - 1);
        rectangle.height -= rectangle.y;
        this.redrawRect(rectangle);
        this.vRule.repaint();
        return row1;
    }

    void insertGrpRow(int i, int j) {
        if (!this.format.bRowGroup) {
            if (i != 0 && j != this.format.gridRows) {
                return;
            }
            PrintFormat.Row row = this.format.newGridRow();
            row.options |= PrintFormat.Row.rowGroupBgn;
            this.format.rowSet.insertElementAt(row, 1);
            ++this.format.gridRows;
            row = this.format.newGridRow();
            row.options |= PrintFormat.Row.rowGroupEnd;
            this.format.rowSet.insertElementAt(row, j);
            ++this.format.gridRows;
        } else {
            if (i == 0 || i >= j || j >= this.format.gridRows) {
                return;
            }
            PrintFormat.Row row1 = this.format.getRow(i);
            if (row1 == null || (row1.options & PrintFormat.Row.rowGroupEnd) > 0) {
                return;
            }
            PrintFormat.Row row2 = this.format.getRow(j);
            if (row2 == null || (row2.options & PrintFormat.Row.rowGroupBgn) > 0) {
                return;
            }
            int k = 0;
            int l = i;
            while (l <= this.format.gridRows && i < j) {
                PrintFormat.Row row3 = this.format.getRow(l);
                if (l != i) {
                    if ((row3.options & PrintFormat.Row.rowGroupBgn) > 0) {
                        ++k;
                    }
                    if ((row3.options & PrintFormat.Row.rowGroupEnd) > 0) {
                        --k;
                    }
                }
                ++l;
            }
            PrintFormat.Row row4 = this.format.newGridRow();
            row4.options |= PrintFormat.Row.rowGroupBgn;
            this.format.setRowOptionsForInsertRow(row4, row1);
            this.format.rowSet.insertElementAt(row4, i + 1);
            ++this.format.gridRows;
            row4 = this.format.newGridRow();
            row4.options |= PrintFormat.Row.rowGroupEnd;
            this.format.setRowOptionsForInsertRow(row4, this.format.getRow(j));
            this.format.rowSet.insertElementAt(row4, j + 1);
            ++this.format.gridRows;
        }
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.y = (int)this.format.getRowLine(i - 1);
        rectangle.height -= rectangle.y;
        this.redrawRect(rectangle);
        this.vRule.repaint();
    }

    void deleteRow(int i) {
        PrintFormat.GridCell gridcell;
        if (i == 0 || i >= this.format.gridRows) {
            return;
        }
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return;
        }
        int j = PrintFormat.Row.rowGroupBgn | PrintFormat.Row.rowGroupEnd;
        if ((row.options & j) == j) {
            return;
        }
        if (i == 1 && ((this.format.getRow((int)2).options & PrintFormat.Row.rowGroupBgn) > 0 || this.format.isDetailRow(2)) || i == this.format.gridRows - 1 && ((this.format.getRow((int)(this.format.gridRows - 2)).options & PrintFormat.Row.rowGroupBgn) > 0 || this.format.isDetailRow(this.format.gridRows - 2))) {
            return;
        }
        if ((row.options & PrintFormat.Row.rowGroupBgn) > 0) {
            row.options &= ~PrintFormat.Row.rowGroupBgn;
            PrintFormat.Row row1 = this.format.getRow(i + 1);
            if ((row1.options & PrintFormat.Row.rowGroupBgn) == 0) {
                row1.options |= PrintFormat.Row.rowGroupBgn;
            } else {
                PrintFormat.Row row3 = this.format.findGroupEndRow(i);
                if (row3 != null) {
                    row3.options &= ~PrintFormat.Row.rowGroupEnd;
                }
            }
        } else if ((row.options & PrintFormat.Row.rowGroupEnd) > 0) {
            row.options &= ~PrintFormat.Row.rowGroupEnd;
            PrintFormat.Row row2 = this.format.getRow(i - 1);
            if ((row2.options & PrintFormat.Row.rowGroupEnd) == 0) {
                row2.options |= PrintFormat.Row.rowGroupEnd;
            } else {
                PrintFormat.Row row4 = this.format.findGroupBgnRow(i);
                if (row4 != null) {
                    row4.options &= ~PrintFormat.Row.rowGroupBgn;
                }
            }
        }
        Object obj = this.format.getRow(i - 1);
        PrintFormat.Row row5 = this.format.getRow(i + 1);
        int k = 0;
        while ((gridcell = row.getColCell(k)) != null) {
            PrintFormat.GridCell gridcell1 = ((PrintFormat.Row)obj).getColCell(k);
            PrintFormat.GridCell gridcell2 = ((PrintFormat.Row)obj).getColCell(k);
            if (gridcell1 == null || gridcell2 == null) break;
            if ((gridcell.options & PrintFormat.FormulaCell.cellMergeBottom) == 0) {
                gridcell1.options &= ~PrintFormat.FormulaCell.cellMergeBottom;
            } else if ((gridcell.options & PrintFormat.FormulaCell.cellBeMerged) == 0) {
                gridcell2.options &= ~PrintFormat.FormulaCell.cellBeMerged;
            }
            ++k;
        }
        this.format.rowSet.removeElementAt(i);
        --this.format.gridRows;
        this.nSeleRow = -1;
        this.nSeleCol = -1;
        this.setModified(true);
        obj = new Rectangle();
        this.format.getClientRect((Rectangle)obj);
        ((Rectangle)obj).y = (int)this.format.getRowLine(i - 1);
        ((Rectangle)obj).height -= ((Rectangle)obj).y;
        this.redrawRect((Rectangle)obj);
        this.vRule.repaint();
    }

    void insertColumn(int i) {
        if (this.format.gridCols >= 64) {
            return;
        }
        this.format.colSet.insertElementAt(new PrintFormat.Col(), i + 1);
        ++this.format.gridCols;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            PrintFormat.GridCell gridcell = row.getColCell(i);
            if (row == null) {
                // empty if block
            }
            PrintFormat.GridCell gridcell1 = new PrintFormat.GridCell();
            if ((gridcell.options & PrintFormat.FormulaCell.cellMergeRight) > 0) {
                gridcell1.options |= gridcell.options & (PrintFormat.FormulaCell.cellMergeBottom | PrintFormat.FormulaCell.cellMergeRight) | PrintFormat.FormulaCell.cellBeMerged;
            }
            row.cellSet.insertElementAt(gridcell1, i + 1);
            gridcell1.font = this.toolBar1.getCurSelFont();
            gridcell1.foreColor = this.toolBar1.getCurSelColor();
        }
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.x = (int)this.format.getColLine(i - 1);
        rectangle.width -= rectangle.x;
        this.redrawRect(rectangle);
        this.hRule.repaint();
    }

    void deleteColumn(int i) {
        if (i <= 0 || i > this.format.gridCols) {
            return;
        }
        PrintFormat.Col col = this.format.getColumn(i);
        if (col == null) {
            return;
        }
        this.format.colSet.removeElementAt(i);
        --this.format.gridCols;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.GridCell gridcell2;
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            PrintFormat.GridCell gridcell = row.getColCell(i - 1);
            PrintFormat.GridCell gridcell1 = row.getColCell(i);
            if ((gridcell1.options & PrintFormat.FormulaCell.cellMergeRight) == 0) {
                gridcell.options &= ~PrintFormat.FormulaCell.cellMergeRight;
            } else if ((gridcell1.options & PrintFormat.FormulaCell.cellBeMerged) == 0 && i <= this.format.gridCols && (gridcell2 = row.getColCell(i + 1)) != null) {
                gridcell2.options &= ~PrintFormat.FormulaCell.cellBeMerged;
            }
            row.cellSet.removeElementAt(i);
        }
        this.nSeleRow = -1;
        this.nSeleCol = -1;
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.x = (int)this.format.getColLine(i - 1);
        rectangle.width -= rectangle.x;
        this.redrawRect(rectangle);
        this.hRule.repaint();
    }

    int findUniqueSelectedRow() {
        this.pUniqueSelectedRow = null;
        int i = -1;
        int j = 0;
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            if ((row.options & PrintFormat.Row.rowSelected) > 0) {
                if (this.pUniqueSelectedRow == null) {
                    this.pUniqueSelectedRow = row;
                    i = j;
                } else {
                    this.pUniqueSelectedRow = null;
                    i = -1;
                    break;
                }
            }
            ++j;
        }
        return i;
    }

    int findUniqueSelectedCol() {
        this.pUniqueSelectedCol = null;
        int i = -1;
        int j = 0;
        Enumeration enumeration = this.format.colSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Col col = (PrintFormat.Col)enumeration.nextElement();
            if ((col.options & PrintFormat.Col.colSelected) > 0) {
                if (this.pUniqueSelectedCol == null) {
                    this.pUniqueSelectedCol = col;
                    i = j;
                } else {
                    this.pUniqueSelectedCol = null;
                    i = -1;
                    break;
                }
            }
            ++j;
        }
        return i;
    }

    void findUniqueSelectedRowAndCol() {
        this.findUniqueSelectedRow();
        this.findUniqueSelectedCol();
    }

    void selectCol(int i, boolean flag) {
        PrintFormat.Col col = this.format.getColumn(i);
        if (col == null) {
            return;
        }
        int j = col.options & PrintFormat.Col.colSelected;
        col.options = flag ? (col.options ^= PrintFormat.Col.colSelected) : (col.options |= PrintFormat.Col.colSelected);
        int k = col.options & PrintFormat.Col.colSelected;
        if (j == k) {
            return;
        }
        if (k > 0) {
            this.selectColCell(i);
        } else {
            this.unSelectColCell(i);
        }
        this.hRule.invalidateCol(i);
        this.findUniqueSelectedRowAndCol();
        this.indicateCellOnToolbar(null);
    }

    void selectRow(int i, boolean flag) {
        PrintFormat.Row row = this.format.getRow(i);
        if (row == null) {
            return;
        }
        int j = row.options & PrintFormat.Row.rowSelected;
        row.options = flag ? (row.options ^= PrintFormat.Row.rowSelected) : (row.options |= PrintFormat.Row.rowSelected);
        int k = row.options & PrintFormat.Row.rowSelected;
        if (j == k) {
            return;
        }
        if (k > 0) {
            this.selectRowCell(i);
        } else {
            this.unSelectRowCell(i);
        }
        this.vRule.invalidateRow(i);
        Dimension dimension = new Dimension(0, 0);
        this.bEnableAddRow = this.format.addRowEnable(dimension);
        this.findUniqueSelectedRowAndCol();
        this.indicateCellOnToolbar(null);
    }

    void setRow(int i, PrintFormat.Row row) {
        PrintFormat.Row row1 = this.format.getRow(i);
        if (row1 == null || row == row1) {
            return;
        }
        row1.setRow(row);
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.y = (int)this.format.getRowLine(i - 1);
        rectangle.height = (int)row1.height;
        this.redrawRect(rectangle);
    }

    void setCol(int i, int j) {
        if (i < 0 || j < 0 || i == j) {
            return;
        }
        Enumeration enumeration = this.format.rowSet.elements();
        while (enumeration.hasMoreElements()) {
            PrintFormat.Row row = (PrintFormat.Row)enumeration.nextElement();
            PrintFormat.GridCell gridcell = row.getColCell(i);
            PrintFormat.GridCell gridcell1 = row.getColCell(j);
            if (gridcell == null || gridcell1 == null) continue;
            gridcell.Copy(gridcell1);
        }
        this.setModified(true);
        Rectangle rectangle = new Rectangle();
        this.format.getClientRect(rectangle);
        rectangle.x = (int)this.format.getColLine(i - 1);
        rectangle.width = (int)this.format.getColLine(i) - rectangle.x;
        this.redrawRect(rectangle);
    }

    private int searchFormulaWords(String s) {
        if (this.formulaWords != null) {
            int i = 0;
            while (i < this.formulaWords.length) {
                if (this.formulaWords[i][0].equals(s)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    String[] getFormulaWords() {
        block7: {
            if (this.mainPanel == null) break block7;
            s = this.mainPanel.getSysidDefName();
            i = s.indexOf(58);
            if (i > 3) {
                s = s.substring(0, i);
            }
            if (s.length() < 2) {
                return null;
            }
            s1 = s.substring(0, 2);
            try {
                j = Integer.parseInt(s1);
            }
            catch (Exception exception) {
                return null;
            }
            k = this.formulaWords != null ? this.formulaWords.length : 0;
            l = this.searchFormulaWords(s1);
            if (l < 0) {
                this.loadWords(j);
                l = k;
            }
            if (this.formulaWords != null && l >= 0 && l < this.formulaWords.length) ** GOTO lbl24
            return null;
lbl-1000:
            // 1 sources

            {
                if (Utilities.like(s, (String)this.formulaWords[l][0])) {
                    return (String[])this.formulaWords[l][1];
                }
                ++l;
lbl24:
                // 2 sources

                ** while (l < this.formulaWords.length)
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    String[] getFormulaFixWords() {
        if (this.formulaFixWords == null) {
            try {
                vector = new Vector<String>();
                v0 = PrintFormatDesign.class$0;
                if (v0 == null) {
                    try {
                        v0 = PrintFormatDesign.class$0 = Class.forName("softface.MainApp");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                }
                preprocessedtextreader = new PreprocessedTextReader(new InputStreamReader(v0.getResourceAsStream("PrintFormatFixWords.txt")));
                block6: while (true) {
                    try {
                        s = preprocessedtextreader.readLine();
                    }
                    catch (IOException ioexception) {
                        break;
                    }
                    if (s == null) break;
                    as = Utilities.splitString(s, ',');
                    if (as == null) continue;
                    j = 0;
                    while (true) {
                        if (j < as.length) ** break;
                        continue block6;
                        if (as[j] != null && (s1 = as[j].trim()).length() > 0) {
                            vector.addElement(s1);
                        }
                        ++j;
                    }
                    break;
                }
                this.formulaFixWords = new String[vector.size()];
                i = 0;
                while (i < this.formulaFixWords.length) {
                    this.formulaFixWords[i] = (String)vector.elementAt(i);
                    ++i;
                }
            }
            catch (Exception var1_2) {
                // empty catch block
            }
        }
        if (this.formulaFixWords == null) {
            this.formulaFixWords = new String[0];
        }
        return this.formulaFixWords;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addWordsToVector(Vector vector, String s, String[] as, Vector vector1) {
        try {
            int j;
            block10: {
                block9: {
                    if (as == null) break block9;
                    if (vector1.size() != 0) break block10;
                }
                Object var7_5 = null;
                vector1.removeAllElements();
                return;
            }
            String[] as1 = new String[vector1.size()];
            int i = 0;
            while (true) {
                if (i >= as1.length) {
                    j = 0;
                    break;
                }
                as1[i] = (String)vector1.elementAt(i);
                ++i;
            }
            while (j < as.length) {
                vector.addElement(new Object[]{String.valueOf(s) + as[j], as1});
                ++j;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            vector1.removeAllElements();
            throw throwable;
        }
        {
            Object var7_7 = null;
            vector1.removeAllElements();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadWords(int i) {
        s = String.valueOf(i >= 10 ? "" : "0") + i;
        vector = new Vector<Object[]>();
        v0 = new Object[2];
        v0[0] = s;
        vector.addElement(v0);
        s1 = MainFrame.getAppProperty("App" + s);
        s2 = Utilities.subSplitString(s1, ',', 1);
        s3 = Utilities.subSplitString(s1, ',', 2);
        s4 = "PrintFormatWords.txt";
        try {
            v1 = PrintFormatDesign.class$0;
            if (v1 == null) {
                try {
                    v1 = PrintFormatDesign.class$0 = Class.forName("softface.MainApp");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
            }
            preprocessedtextreader = new PreprocessedTextReader(new InputStreamReader(v1.getResourceAsStream(s4)));
        }
        catch (Exception exception) {
            return;
        }
        as = null;
        vector1 = new Vector<String>();
        block14: while (true) {
            try {
                s5 = preprocessedtextreader.readLine();
            }
            catch (IOException ioexception) {
                break;
            }
            if (s5 == null) break;
            k = (s5 = s5.trim()).length();
            if (k == 0) continue;
            if (s5.charAt(k - 1) == ':') {
                this.addWordsToVector(vector, s, as, vector1);
                as = Utilities.splitString(s5.substring(0, k - 1), ',');
                continue;
            }
            as1 = Utilities.splitString(s5, ',');
            if (as1 == null) continue;
            i1 = 0;
            while (true) {
                if (i1 < as1.length) ** break;
                continue block14;
                if (as1[i1] != null && (j1 = (s6 = as1[i1].trim()).length()) > 0) {
                    if (s6.charAt(0) == '{' && s6.charAt(j1 - 1) == '}') {
                        if (s3 != null && s2 != null) {
                            try {
                                v3 = new Class[2];
                                v4 = PrintFormatDesign.class$1;
                                if (v4 == null) {
                                    try {
                                        v4 = Class.forName("java.util.Vector");
                                    }
                                    catch (ClassNotFoundException v5) {
                                        throw new NoClassDefFoundError(v5.getMessage());
                                    }
                                }
                                v3[0] = v4;
                                v6 = PrintFormatDesign.class$2;
                                if (v6 == null) {
                                    try {
                                        v6 = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException v7) {
                                        throw new NoClassDefFoundError(v7.getMessage());
                                    }
                                }
                                v3[1] = v6;
                                aclass = v3;
                                class1 = Class.forName("softoperation.finance." + s2 + '.' + s3);
                                method = class1.getMethod("loadPrintFormatWords", aclass);
                                method.invoke(null, new Object[]{vector1, s6.substring(1, j1 - 1)});
                            }
                            catch (ClassNotFoundException aclass) {
                            }
                            catch (NoSuchMethodException aclass) {
                            }
                            catch (Exception exception1) {
                                exception1.printStackTrace(Message.out);
                            }
                        }
                    } else {
                        vector1.addElement(s6);
                    }
                }
                ++i1;
            }
            break;
        }
        this.addWordsToVector(vector, s, as, vector1);
        j = this.formulaWords != null ? this.formulaWords.length : 0;
        aobj = this.formulaWords;
        this.formulaWords = new Object[j + vector.size()][];
        if (j > 0) {
            System.arraycopy(aobj, 0, this.formulaWords, 0, j);
        }
        l = j;
        while (l < this.formulaWords.length) {
            this.formulaWords[l] = (Object[])vector.elementAt(l - j);
            ++l;
        }
    }

    private void showPosition(Rectangle rectangle) {
        if (rectangle != null) {
            String s = "(" + rectangle.x + "," + rectangle.y + "  " + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height) + ")";
        } else {
            String s = "";
        }
    }

    void clear() {
        this.showPosition(null);
        this.m_undoList.removeAllElements();
        this.attrMenu.removeAll();
        this.format.empty();
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    void copyFormat() {
        if (this.sysPrintOption <= 0) {
            this.sysPrintOption = MainApp.getAppIntOption(90, 3);
        }
        try {
            Object[] aobj;
            String s = "select defname from defs where sysid=" + this.mainPanel.defaultSysID + " and deftype=" + this.mainPanel.defaultDefType;
            String s1 = ErpdataConfig.getCurrentConfig().curUserCode;
            if (s1 != null && s1.length() > 0) {
                s = String.valueOf(s) + " and defname not like '" + ErpdataConfig.getCurrentConfig().curUserCode + "%'";
            }
            if ((this.sysPrintOption & 2) > 0) {
                s = String.valueOf(s) + " and defname not like '%|%'";
            }
            if ((aobj = JDBC.sqlSelect2(s)) == null || aobj.length == 0) {
                return;
            }
            String[] as = new String[aobj.length];
            System.arraycopy(aobj, 0, as, 0, aobj.length);
            int i = DialogPanel.askChoice("\u9009\u62e9\u6253\u5370\u683c\u5f0f", as);
            if (i >= 0) {
                String s2 = as[i];
                String s3 = Erpdata.getDefContent(null, this.mainPanel.defaultSysID, this.mainPanel.defaultDefType, s2);
                this.loadFromText(s3);
                int j = s2.indexOf(124);
                if (j >= 0) {
                    s2 = s2.substring(j + 1);
                }
                this.mainPanel.setDefname(s2);
                this.setModified(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class undoItem {
        PrintFormat.Cell pCell = null;
        Rectangle r;

        public undoItem(PrintFormat.Cell cell) {
            this.pCell = cell;
            this.r = new Rectangle(cell.r);
        }
    }
}

