/*
 * Decompiled with CFR 0.152.
 */
package softcore.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import softcore.awt.DialogPanel;
import softcore.awt.JTextFieldA;
import softcore.print.PrintFormat;
import softcore.util.AidInputer;
import softcore.util.Utilities;

class ReportAttrDialog
extends DialogPanel {
    final JTextField txtPageRow = new JTextField(null, 2);
    final JTextField txtPageCol = new JTextField(null, 2);
    final JTextField txtPageHeight = new JTextField(null, 6);
    final JTextField txtPageWidth = new JTextField(null, 6);
    JCheckBox checkFullPage = new JCheckBox("\u6ee1\u9875");
    JComboBox selectPageOrientation = new JComboBox();
    AidInputer pageSelector = new AidInputer(){

        public String doAidInput(Component component, String s, int i) {
            double d;
            double d1;
            PrinterJob printerjob = PrinterJob.getPrinterJob();
            PageFormat pageformat = printerjob.pageDialog(new PageFormat());
            if (pageformat == null) {
                return null;
            }
            if (pageformat.getOrientation() == 0) {
                d1 = pageformat.getWidth();
                d = pageformat.getHeight();
            } else {
                d = pageformat.getWidth();
                d1 = pageformat.getHeight();
            }
            ReportAttrDialog.this.txtPageWidth.setText("" + (int)(d * 1000.0 / 283.464566928));
            ReportAttrDialog.this.txtPageHeight.setText("" + (int)(d1 * 1000.0 / 283.464566928));
            pagew = (int)d;
            pageh = (int)d1;
            return (int)d + "X" + (int)d1;
        }
    };
    public static int pagew = 0;
    public static int pageh = 0;
    final JTextFieldA pageField = new JTextFieldA(null, 16, 1, this.pageSelector);
    PrintFormat format = null;

    public ReportAttrDialog(PrintFormat printformat) {
        this.format = printformat;
        this.nPosOption = 4;
        this.nPosInsetX = 32;
        this.nPosInsetY = 24;
        this.initial();
        this.pageField.setEditable(false);
    }

    void initial() {
        this.setLayout(new GridBagLayout());
        this.selectPageOrientation.addItem("\u7f3a\u7701 ");
        this.selectPageOrientation.addItem("\u6a2a\u5411 ");
        this.selectPageOrientation.addItem("\u7eb5\u5411 ");
        Dimension dimension = this.selectPageOrientation.getPreferredSize();
        dimension.width += 8;
        this.selectPageOrientation.setPreferredSize(dimension);
        DialogPanel.initGBC();
        DialogPanel.gbc.anchor = 17;
        DialogPanel.gbc.fill = 1;
        DialogPanel.gbc.insets = new Insets(8, 8, 0, 0);
        this.add((Component)new JLabel("\u9875\u5206\u5272"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 1;
        this.add((Component)this.txtPageRow, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 2;
        this.add((Component)new JLabel("\u884c"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 3;
        this.add((Component)this.txtPageCol, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 4;
        this.add((Component)new JLabel("\u5217"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 5;
        this.add((Component)this.checkFullPage, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 6;
        this.add(new JLabel("\u65b9\u5411:"));
        DialogPanel.gbc.gridx = 7;
        this.add((Component)this.selectPageOrientation, DialogPanel.gbc);
        DialogPanel.initGBC();
        DialogPanel.gbc.anchor = 17;
        DialogPanel.gbc.gridy = 1;
        DialogPanel.gbc.insets = new Insets(8, 8, 0, 0);
        this.add((Component)new JLabel("\u7eb8\u5f20"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 1;
        DialogPanel.gbc.fill = 2;
        DialogPanel.gbc.gridwidth = 7;
        this.add((Component)this.pageField, DialogPanel.gbc);
        DialogPanel.initGBC();
        DialogPanel.gbc.insets = new Insets(8, 8, 8, 0);
        DialogPanel.gbc.anchor = 17;
        DialogPanel.gbc.gridy = 2;
        this.add((Component)new JLabel("\u56fa\u5b9a\u9875\u5927\u5c0f"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 1;
        this.add((Component)new JLabel("\u5bbd"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 2;
        this.add((Component)this.txtPageWidth, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 3;
        this.add((Component)new JLabel("\u9ad8"), DialogPanel.gbc);
        DialogPanel.gbc.gridx = 4;
        this.add((Component)this.txtPageHeight, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 5;
        this.add((Component)new JLabel("(0.1mm)"), DialogPanel.gbc);
        if (this.format != null) {
            if (this.format.splitRows < 1) {
                this.format.splitRows = 1;
            }
            if (this.format.splitCols < 1) {
                this.format.splitCols = 1;
            }
            this.txtPageRow.setText(String.valueOf(this.format.splitRows));
            this.txtPageCol.setText(String.valueOf(this.format.splitCols));
            this.txtPageWidth.setText(String.valueOf(this.format.pageWidth));
            this.txtPageHeight.setText(String.valueOf(this.format.pageHeight));
            this.checkFullPage.setSelected((this.format.options & PrintFormat.printFullPage) > 0);
            int i = this.format.options >> 1 & 3;
            if (i > 2) {
                i = 0;
            }
            this.selectPageOrientation.setSelectedIndex(i);
        }
    }

    public void getReportAttr() {
        if (this.format != null) {
            this.format.splitRows = Utilities.getIntFromTextField(this.txtPageRow);
            this.format.splitCols = Utilities.getIntFromTextField(this.txtPageCol);
            this.format.pageWidth = Utilities.getIntFromTextField(this.txtPageWidth);
            this.format.pageHeight = Utilities.getIntFromTextField(this.txtPageHeight);
            this.format.options = this.checkFullPage.isSelected() ? (this.format.options |= PrintFormat.printFullPage) : (this.format.options &= ~PrintFormat.printFullPage);
            int i = this.selectPageOrientation.getSelectedIndex();
            this.format.options &= 0xFFFFFFF9;
            this.format.options |= i << 1;
        }
    }

    public static boolean getReportAttribute(PrintFormat printformat) {
        ReportAttrDialog reportattrdialog = new ReportAttrDialog(printformat);
        if (reportattrdialog.showDialog("\u62a5\u8868\u5c5e\u6027") == 0) {
            reportattrdialog.getReportAttr();
            return true;
        }
        return false;
    }
}

