/*
 * Decompiled with CFR 0.152.
 */
package softcore.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import softcore.swing.JDayLabel;
import softcore.swing.OpenSwingUtil;
import softcore.swing.TopBottomLineBorder;

public class JCalendarPanel
extends JPanel {
    private static Border selectedBorder = new LineBorder(Color.black);
    private static Border unselectedBorder = new EmptyBorder(selectedBorder.getBorderInsets(new JLabel()));
    private Calendar calendar = null;
    private JLabel monthLabel = null;
    private JPanel days = null;
    private MouseListener dayBttListener = null;
    private boolean isSupportDateChangeListener = false;
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color background;
    protected Color foreground;
    private Date selectedDate = null;
    final SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public JCalendarPanel() {
        this(new Date());
    }

    public JCalendarPanel(Date selectedDate) {
        this.selectedDate = selectedDate;
        this.calendar = Calendar.getInstance();
        this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
        this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
        this.background = UIManager.getColor("ComboBox.background");
        this.foreground = UIManager.getColor("ComboBox.foreground");
        this.dayBttListener = this.createDayBttListener();
        JPanel pNorth = new JPanel();
        pNorth.setLayout(new BoxLayout(pNorth, 0));
        pNorth.setBackground(new Color(0, 0, 128));
        pNorth.setForeground(Color.white);
        pNorth.setPreferredSize(new Dimension(1, 25));
        JLabel label = this.createSkipButton(1, -1);
        label.setText("<<");
        pNorth.add(Box.createHorizontalStrut(12));
        pNorth.add(label);
        pNorth.add(Box.createHorizontalStrut(12));
        label = this.createSkipButton(2, -1);
        label.setText("< ");
        pNorth.add(label);
        this.monthLabel = new JLabel("", 0);
        this.monthLabel.setBackground(new Color(0, 0, 128));
        this.monthLabel.setForeground(Color.white);
        pNorth.add(Box.createHorizontalGlue());
        pNorth.add(this.monthLabel);
        pNorth.add(Box.createHorizontalGlue());
        label = this.createSkipButton(2, 1);
        label.setText(" >");
        pNorth.add(label);
        label = this.createSkipButton(1, 1);
        label.setText(">>");
        pNorth.add(Box.createHorizontalStrut(12));
        pNorth.add(label);
        pNorth.add(Box.createHorizontalStrut(12));
        JPanel pWeeks = new JPanel(new GridLayout(0, 7));
        pWeeks.setBackground(this.background);
        pWeeks.setOpaque(true);
        DateFormatSymbols sy = new DateFormatSymbols(Locale.getDefault());
        String[] strWeeks = sy.getShortWeekdays();
        int i = 1;
        while (i <= 7) {
            label = new JLabel();
            label.setHorizontalAlignment(0);
            label.setForeground(this.foreground);
            label.setText(strWeeks[i]);
            pWeeks.add(label);
            ++i;
        }
        this.days = new JPanel(new GridLayout(0, 7));
        this.days.setBorder(new TopBottomLineBorder(Color.black));
        this.days.setBackground(this.background);
        this.days.setOpaque(true);
        JPanel pCenter = new JPanel(new BorderLayout());
        pCenter.setBackground(this.background);
        pCenter.setOpaque(true);
        pCenter.add((Component)pWeeks, "North");
        pCenter.add((Component)this.days, "Center");
        JDayLabel lbToday = new JDayLabel(new Date(), false);
        lbToday.setForeground(this.foreground);
        lbToday.addMouseListener(this.dayBttListener);
        JPanel pSouth = new JPanel(new BorderLayout());
        pSouth.setBackground(this.background);
        pSouth.setForeground(this.foreground);
        pSouth.add((Component)lbToday, "Center");
        this.setPreferredSize(new Dimension(280, 180));
        this.setForeground(this.foreground);
        this.setBackground(this.background);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.add("North", pNorth);
        this.add("Center", pCenter);
        this.add("South", pSouth);
        this.updateDays();
    }

    protected JLabel createSkipButton(int field, int amount) {
        JLabel label = new JLabel();
        label.setBorder(unselectedBorder);
        label.setBackground(new Color(0, 0, 128));
        label.setForeground(Color.white);
        label.setRequestFocusEnabled(false);
        label.addMouseListener(this.createSkipListener(field, amount));
        return label;
    }

    protected MouseListener createSkipListener(final int field, final int amount) {
        return new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                JCalendarPanel.this.calendar.add(field, amount);
                JCalendarPanel.this.updateDays();
            }

            public void mouseEntered(MouseEvent e) {
                JComponent com = (JComponent)e.getComponent();
                com.setBorder(selectedBorder);
            }

            public void mouseExited(MouseEvent e) {
                JComponent com = (JComponent)e.getComponent();
                com.setBorder(unselectedBorder);
            }
        };
    }

    protected void updateDays() {
        this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
        this.days.removeAll();
        Calendar selectedCalendar = Calendar.getInstance();
        selectedCalendar.setTime(this.selectedDate);
        Calendar setupCalendar = (Calendar)this.calendar.clone();
        setupCalendar.set(5, 1);
        int first = setupCalendar.get(7);
        setupCalendar.add(5, -first);
        boolean isCurrentMonth = false;
        int i = 0;
        while (i < 42) {
            setupCalendar.add(5, 1);
            JDayLabel label = new JDayLabel(setupCalendar.getTime());
            label.setForeground(this.foreground);
            label.addMouseListener(this.dayBttListener);
            if ("1".equals(label.getText())) {
                isCurrentMonth = !isCurrentMonth;
            }
            label.setEnabled(isCurrentMonth);
            if (setupCalendar.get(1) == selectedCalendar.get(1) && setupCalendar.get(2) == selectedCalendar.get(2) && setupCalendar.get(5) == selectedCalendar.get(5)) {
                label.setBorder(new LineBorder(this.selectedBackground, 1));
            }
            this.days.add(label);
            ++i;
        }
        this.days.validate();
    }

    protected MouseListener createDayBttListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                JDayLabel com = (JDayLabel)e.getComponent();
                if (JCalendarPanel.this.isEnabled()) {
                    com.setOpaque(false);
                    com.setBackground(JCalendarPanel.this.background);
                    com.setForeground(JCalendarPanel.this.foreground);
                }
                JCalendarPanel.this.isSupportDateChangeListener = true;
                JCalendarPanel.this.setSelectedDate(com.getDate());
                JCalendarPanel.this.isSupportDateChangeListener = false;
            }

            public void mouseEntered(MouseEvent e) {
                if (JCalendarPanel.this.isEnabled()) {
                    JComponent com = (JComponent)e.getComponent();
                    com.setOpaque(true);
                    com.setBackground(JCalendarPanel.this.selectedBackground);
                    com.setForeground(JCalendarPanel.this.selectedForeground);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (JCalendarPanel.this.isEnabled()) {
                    JComponent com = (JComponent)e.getComponent();
                    com.setOpaque(false);
                    com.setBackground(JCalendarPanel.this.background);
                    com.setForeground(JCalendarPanel.this.foreground);
                }
            }
        };
    }

    public void addDateChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeDateChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireDateChanged(ChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
    }

    public void setSelectedDate(Date selectedDate) {
        this.selectedDate = selectedDate;
        this.calendar.setTime(selectedDate);
        this.updateDays();
        if (this.isSupportDateChangeListener) {
            this.fireDateChanged(new ChangeEvent(selectedDate));
        }
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JCalendarPanel Demo");
        JCalendarPanel calendarPanel = new JCalendarPanel();
        final JTextField field = new JTextField();
        field.setPreferredSize(new Dimension(120, 25));
        calendarPanel.addDateChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Date selectedDate = (Date)e.getSource();
                SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd");
                field.setText(f.format(selectedDate));
            }
        });
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(field);
        frame.getContentPane().add(calendarPanel);
        frame.setVisible(true);
    }
}

