/*
 * Decompiled with CFR 0.152.
 */
package softcore.swing;

import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JDateDocument
extends PlainDocument {
    private JTextComponent textComponent;
    private int newOffset;
    private SimpleDateFormat dateFormat;

    public JDateDocument(JTextComponent tc, SimpleDateFormat dateFormat) throws UnsupportedOperationException {
        this(tc, dateFormat, JDateDocument.getCurrentDate(dateFormat));
    }

    public JDateDocument(JTextComponent tc, SimpleDateFormat dateFormat, String initDateTime) throws UnsupportedOperationException {
        this.setDateFormat(dateFormat);
        this.textComponent = tc;
        try {
            this.insertString(0, initDateTime, null);
        }
        catch (BadLocationException ex) {
            throw new UnsupportedOperationException(ex.getMessage());
        }
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public static final String getCurrentDate(SimpleDateFormat smFormat) {
        return smFormat.format(new Date());
    }

    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s.length() == 1) {
            try {
                Integer.parseInt(s);
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.newOffset = offset;
            if (offset == 4 || offset == 7 || offset == 10 || offset == 13 || offset == 16) {
                ++this.newOffset;
                this.textComponent.setCaretPosition(this.newOffset);
            }
            if (offset == this.dateFormat.toPattern().length()) {
                return;
            }
            String toTest = this.textComponent.getText();
            boolean isValid = this.isValidDate(toTest = String.valueOf(toTest.substring(0, this.newOffset)) + s + toTest.substring(this.newOffset + 1));
            if (!isValid) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.remove(this.newOffset, 1);
            super.insertString(this.newOffset, s, attributeSet);
        } else if (s.length() == 10 || s.length() == 19) {
            if (!this.isValidDate(s)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.remove(0, this.getLength());
            super.insertString(0, s, attributeSet);
        }
    }

    public void remove(int offset, int length) throws BadLocationException {
        if (offset == 4 || offset == 7 || offset == 10 || offset == 13 || offset == 16) {
            this.textComponent.setCaretPosition(offset - 1);
        } else {
            this.textComponent.setCaretPosition(offset);
        }
    }

    private boolean isValidDate(String strDate) {
        int intD;
        int intM;
        int intY;
        int intH = 0;
        int intMi = 0;
        int intS = 0;
        int iPatternLen = this.getDateFormat().toPattern().length();
        if (strDate == null) {
            return false;
        }
        if ((strDate = strDate.trim()).length() != iPatternLen) {
            return false;
        }
        int i = 0;
        while (i < 10) {
            if (strDate.charAt(i) > '\u00ff') {
                return false;
            }
            ++i;
        }
        try {
            intY = Integer.parseInt(strDate.substring(0, 4));
            intM = Integer.parseInt(strDate.substring(5, 7));
            intD = Integer.parseInt(strDate.substring(8, 10));
        }
        catch (Exception e) {
            return false;
        }
        int iCaretPosition = this.textComponent.getCaretPosition();
        boolean isValid = true;
        if (intM > 12 || intM < 1) {
            intM = Math.min(12, Math.max(1, intM));
            isValid = false;
        }
        if (intD < 1) {
            intD = 1;
            isValid = false;
        }
        switch (intM) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (intD <= 30) break;
                intD = 30;
                isValid = false;
                break;
            }
            case 2: {
                if (intY % 4 == 0 && intY % 100 != 0 || intY % 400 == 0) {
                    if (intD <= 29) break;
                    intD = 29;
                    isValid = false;
                    break;
                }
                if (intD <= 28) break;
                intD = 28;
                isValid = false;
                break;
            }
            default: {
                if (intD <= 31) break;
                intD = 31;
                isValid = false;
            }
        }
        if (iPatternLen > 10) {
            try {
                intH = Integer.parseInt(strDate.substring(11, 13));
                intMi = Integer.parseInt(strDate.substring(14, 16));
                intS = Integer.parseInt(strDate.substring(17));
            }
            catch (Exception e) {
                return false;
            }
            if (intH > 23 || intH < 0) {
                intH = Math.min(23, Math.max(0, intH));
                isValid = false;
            }
            if (intMi > 59 || intMi < 0) {
                intMi = Math.min(59, Math.max(0, intMi));
                isValid = false;
            }
            if (intS > 59 || intS < 0) {
                intS = Math.min(59, Math.max(0, intS));
                isValid = false;
            }
        }
        if (!isValid) {
            this.textComponent.setText(this.toDateString(intY, intM, intD, intH, intMi, intS));
            this.textComponent.setCaretPosition(iCaretPosition + 1);
        }
        return isValid;
    }

    private String toDateString(int y, int m, int d, int h, int mi, int s) {
        m = Math.max(1, Math.min(12, m));
        d = Math.max(1, Math.min(31, d));
        switch (m) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                d = Math.min(30, d);
                break;
            }
            case 2: {
                d = y % 4 == 0 && y % 100 != 0 || y % 400 == 0 ? Math.min(29, d) : Math.min(28, d);
            }
        }
        h = Math.max(1, Math.min(24, h));
        mi = Math.max(1, Math.min(59, mi));
        s = Math.max(1, Math.min(59, s));
        String strPattern = this.getDateFormat().toPattern();
        String strY = this.rPad0(4, "" + y);
        String strM = this.rPad0(2, "" + m);
        String strD = this.rPad0(2, "" + d);
        String strDate = "";
        strDate = String.valueOf(strY) + strPattern.substring(4, 5) + strM + strPattern.substring(7, 8) + strD;
        if (strPattern.length() == 19) {
            strDate = String.valueOf(strDate) + strPattern.substring(10, 11) + this.rPad0(2, "" + h) + strPattern.substring(13, 14) + this.rPad0(2, "" + mi) + strPattern.substring(16, 17) + this.rPad0(2, "" + s);
        }
        return strDate;
    }

    private String rPad0(int maxLen, String str) {
        if (str.length() < maxLen) {
            str = "0" + str;
        }
        return str;
    }
}

