/*
 * Decompiled with CFR 0.152.
 */
package softcore.swing;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import softcore.swing.JPopupButton;
import softcore.swing.OpenSwingUtil;

public class JPopupButton
extends JComboBox
implements Serializable {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_WITH_RIGHT_TOGGLE = 1;
    private int style = -1;
    private int actionIndex = -1;
    private JPopupMenu popup = null;
    private boolean mustRefresh = false;
    private JButton bttLeft;
    private JButton bttRight;
    private PopupButtonListener listener = new PopupButtonListener();

    public JPopupButton() {
        this(0);
    }

    public JPopupButton(int style) {
        this(style, null);
    }

    public JPopupButton(int style, String text) {
        this(style, text, null);
    }

    public JPopupButton(int style, String text, Icon icon) {
        this(style, text, icon, new JPopupMenu());
    }

    public JPopupButton(int style, String text, Icon icon, JPopupMenu popup) {
        this.createButtons();
        this.setText(text);
        this.setIcon(icon);
        this.setPopup(popup);
        this.setStyle(style);
    }

    protected void showPopupMenu() {
        if (this.popup == null) {
            return;
        }
        this.popup.show(this, 0, this.getHeight());
    }

    protected void createButtons() {
        if (this.bttLeft == null) {
            this.bttLeft = new JButton(){

                public void setUI(ButtonUI ui) {
                    if (ui instanceof WindowsButtonUI) {
                        ui = new BasicButtonUI();
                    }
                    super.setUI(ui);
                }
            };
            this.bttLeft.setMargin(new Insets(0, 0, 0, 0));
        }
        if (this.bttRight == null) {
            this.bttRight = new JButton(){

                public void setUI(ButtonUI ui) {
                    if (ui instanceof WindowsButtonUI) {
                        ui = new BasicButtonUI();
                    }
                    super.setUI(ui);
                }

                public void paint(Graphics g) {
                    super.paint(g);
                    Polygon p = new Polygon();
                    int w = this.getWidth();
                    int y = (this.getHeight() - 4) / 2;
                    int x = (w - 6) / 2;
                    if (this.isSelected()) {
                        ++x;
                    }
                    p.addPoint(x, y);
                    p.addPoint(x + 3, y + 3);
                    p.addPoint(x + 6, y);
                    g.fillPolygon(p);
                    g.drawPolygon(p);
                }
            };
            this.bttRight.setUI(new BasicButtonUI());
            this.bttLeft.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    protected void refreshUI() {
        if (!this.mustRefresh) {
            return;
        }
        super.removeAll();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bttLeft, "Center");
        if (this.style == 1) {
            this.add((Component)this.bttRight, "East");
        }
        this.bttLeft.setFocusable(false);
        this.bttLeft.setBorder(null);
        this.bttLeft.addMouseListener(this.listener);
        this.bttRight.setFocusable(false);
        this.bttRight.setPreferredSize(new Dimension(13, 1));
        this.bttRight.setBorder(null);
        this.bttRight.addMouseListener(this.listener);
        this.doLayout();
    }

    public void setStyle(int style) {
        if (this.style != style) {
            this.mustRefresh = true;
        }
        this.style = style;
        this.refreshUI();
    }

    public int getStyle() {
        return this.style;
    }

    public void setText(String text) {
        this.bttLeft.setText(text);
    }

    public String getText() {
        return this.bttLeft.getText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bttLeft.setEnabled(enabled);
        this.bttRight.setEnabled(enabled);
    }

    public void setIcon(Icon icon) {
        this.bttLeft.setIcon(icon);
    }

    public Icon getIcon() {
        return this.bttLeft.getIcon();
    }

    public void setActionSameAsPopup(int index) {
        this.actionIndex = index;
    }

    public int getActionSameAsPopup() {
        return this.actionIndex;
    }

    public void setPopup(JPopupMenu pop) {
        if (this.popup != null) {
            this.popup.removePopupMenuListener(this.listener);
        }
        this.popup = pop;
        this.popup.removePopupMenuListener(this.listener);
        this.popup.addPopupMenuListener(this.listener);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public static void main(String[] args) {
        JFrame frame = OpenSwingUtil.createDemoFrame("JPopupButton Demo");
        JPopupMenu popup = new JPopupMenu("PopupMenu");
        class DemoAction
        extends AbstractAction {
            public DemoAction() {
                super.putValue("Name", "Demo JPopupButton " + new Random().nextInt());
            }

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((Component)e.getSource(), super.getValue("Name"));
            }
        }
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        popup.add(new DemoAction());
        JPopupButton btt1 = new JPopupButton(0, "Button1", null, popup);
        JPopupButton btt2 = new JPopupButton(1, "Button2", null, popup);
        btt2.setActionSameAsPopup(0);
        JPopupButton btt3 = new JPopupButton(1, "", UIManager.getIcon("FileView.computerIcon"), popup);
        btt3.setActionSameAsPopup(0);
        btt1.setPreferredSize(new Dimension(60, 25));
        btt1.setSize(new Dimension(60, 25));
        btt1.setMaximumSize(new Dimension(60, 25));
        btt2.setPreferredSize(new Dimension(100, 25));
        btt2.setSize(new Dimension(100, 25));
        btt2.setMaximumSize(new Dimension(100, 25));
        btt3.setPreferredSize(new Dimension(40, 25));
        btt3.setSize(new Dimension(40, 25));
        btt3.setMaximumSize(new Dimension(40, 25));
        JToolBar bar = new JToolBar("Toolbar");
        bar.setRollover(true);
        bar.add(btt1);
        bar.add(btt2);
        bar.add(btt3);
        frame.getContentPane().add((Component)bar, "North");
        frame.setVisible(true);
    }

    public class DownBorder
    extends AbstractBorder {
        int thickness = 1;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.gray);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(Color.white);
            g.drawLine(width - 1, 0, width - 1, height);
            g.drawLine(0, height - 1, width, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }

    private class PopupButtonListener
    implements MouseListener,
    PopupMenuListener {
        UpBorder upBorder;
        DownBorder downBorder;

        private PopupButtonListener() {
            this.upBorder = new UpBorder();
            this.downBorder = new DownBorder();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!JPopupButton.this.isEnabled()) {
                return;
            }
            if (e.getSource() == JPopupButton.this.bttLeft) {
                JPopupButton.this.bttLeft.setBorder(this.downBorder);
                JPopupButton.this.bttRight.setBorder(this.downBorder);
                if (JPopupButton.this.getStyle() == 0) {
                    JPopupButton.this.showPopupMenu();
                } else if (JPopupButton.this.actionIndex != -1 && JPopupButton.this.actionIndex < JPopupButton.this.popup.getSubElements().length) {
                    AbstractButton btt = (AbstractButton)JPopupButton.this.popup.getSubElements()[JPopupButton.this.actionIndex].getComponent();
                    btt.doClick();
                }
            } else {
                JPopupButton.this.bttLeft.setBorder(this.upBorder);
                JPopupButton.this.bttRight.setBorder(this.downBorder);
                JPopupButton.this.bttRight.setSelected(true);
                JPopupButton.this.showPopupMenu();
            }
        }

        public void mouseReleased(MouseEvent e) {
            JPopupButton.this.bttRight.setSelected(false);
        }

        public void mouseEntered(MouseEvent e) {
            if (!JPopupButton.this.isEnabled()) {
                return;
            }
            if (!JPopupButton.this.popup.isShowing()) {
                JPopupButton.this.bttLeft.setBorder(this.upBorder);
                JPopupButton.this.bttRight.setBorder(this.upBorder);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!JPopupButton.this.isEnabled()) {
                return;
            }
            if (!JPopupButton.this.popup.isShowing()) {
                JPopupButton.this.bttLeft.setBorder(null);
                JPopupButton.this.bttRight.setBorder(null);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!JPopupButton.this.isEnabled()) {
                return;
            }
            JPopupButton.this.bttLeft.setBorder(null);
            JPopupButton.this.bttRight.setBorder(null);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    public class UpBorder
    extends AbstractBorder {
        int thickness = 1;

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            g.setColor(Color.gray);
            g.drawLine(width - 1, 0, width - 1, height);
            g.drawLine(0, height - 1, width, height - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }
    }
}

