/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.Variant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import softcore.awt.DialogPanel;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.tac.Tac;
import softcore.util.Utilities;
import softcore.util.ValueText;

public class FindTableRowDialogPanel
extends DialogPanel
implements KeyListener,
MouseListener {
    final Table table;
    final DataSet dataSet;
    final String[] columns;
    final JComboBox columnSelect = new JComboBox();
    final JTextField findText = new JTextField(16);
    final JList list = new JList(new DefaultListModel());
    final int[] columnDataType;
    int selectedRow = -1;

    public FindTableRowDialogPanel(Table table1, String[] as) {
        this(table1, null, as);
    }

    private String[] listNameColumns(int i) {
        if (i < 0 || i > this.columns.length) {
            return this.columns;
        }
        String[] as = new String[this.columns.length - 1];
        int j = 0;
        int k = 0;
        while (k < this.columns.length) {
            if (k != i) {
                as[j++] = this.columns[k];
            }
            ++k;
        }
        return as;
    }

    public FindTableRowDialogPanel(Table table1, DataSet dataset, String[] as) {
        this.table = table1;
        this.dataSet = dataset != null ? dataset : table1.getDataSet();
        this.columns = as;
        this.columnDataType = new int[as.length];
        int i = 0;
        while (i < as.length) {
            TableColumn tablecolumn = table1.getColumn(as[i]);
            this.columnSelect.addItem(tablecolumn != null ? tablecolumn.displayCaption : as[i]);
            if (tablecolumn != null) {
                this.columnDataType[i] = tablecolumn.dataType;
            } else {
                try {
                    this.columnDataType[i] = dataset.getColumn(as[i]).getDataType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.defaultExitButton = -1;
        this.setLayout(new GridBagLayout());
        DialogPanel.initGBC();
        DialogPanel.gbc.weightx = 1.0;
        DialogPanel.gbc.fill = 2;
        DialogPanel.gbc.gridx = 1;
        DialogPanel.gbc.gridy = 0;
        this.add((Component)this.findText, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.fill = 0;
        DialogPanel.gbc.weightx = 0.0;
        this.add((Component)this.columnSelect, DialogPanel.gbc);
        DialogPanel.gbc.gridx = 0;
        DialogPanel.gbc.gridy = 1;
        DialogPanel.gbc.gridwidth = 2;
        DialogPanel.gbc.weightx = 1.0;
        DialogPanel.gbc.weighty = 1.0;
        DialogPanel.gbc.fill = 1;
        JScrollPane jscrollpane = new JScrollPane(this.list);
        jscrollpane.setPreferredSize(new Dimension(100, 300));
        this.add((Component)jscrollpane, DialogPanel.gbc);
        this.findText.addKeyListener(this);
        this.list.addKeyListener(this);
        this.columnSelect.addItemListener(this);
        this.list.addMouseListener(this);
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    protected boolean onExit(int i) {
        this.selectedRow = -1;
        return i != 0 ? true : this.onOkExit();
    }

    protected boolean onOkExit() {
        Object obj = this.list.getSelectedValue();
        if (obj instanceof ValueText) {
            this.selectedRow = (Integer)((ValueText)obj).getValue();
            return true;
        }
        return false;
    }

    public void refreshList(boolean flag) {
        try {
            DefaultListModel defaultlistmodel = (DefaultListModel)this.list.getModel();
            defaultlistmodel.removeAllElements();
            int i = this.columnSelect.getSelectedIndex();
            if (i < 0 || i >= this.columns.length) {
                return;
            }
            String s = this.findText.getText();
            if (s == null || !flag && s.trim().length() == 0) {
                return;
            }
            Object obj = null;
            Object obj1 = null;
            int j = s.indexOf(44);
            if (this.columnDataType[i] != 16 && this.columnDataType[i] != 12 && s.indexOf(42) < 0 && s.indexOf(63) < 0) {
                String s1 = s;
                String s2 = s;
                if (j >= 0) {
                    s1 = s.substring(0, j);
                    s2 = s.substring(j + 1);
                }
                try {
                    obj = Utilities.parseStringFromVariantType(s1, this.columnDataType[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    obj1 = Utilities.parseStringFromVariantType(s2, this.columnDataType[i]);
                }
                catch (Exception exception) {}
            } else if (j < 0) {
                s = String.valueOf('*') + s + '*';
            }
            int k = this.dataSet.getRowCount();
            Variant variant = new Variant();
            String[] as = this.table.getFindKeys();
            Vector<ValueText> vector = new Vector<ValueText>();
            boolean flag1 = as[0].equals(this.columns[i]);
            int l = 0;
            while (l < k) {
                block27: {
                    String s3;
                    block26: {
                        Date date;
                        Object obj2;
                        block25: {
                            this.dataSet.getVariant(this.columns[i], l, variant);
                            obj2 = variant.getAsObject();
                            String string = s3 = obj2 != null ? Utilities.getAsString(obj2).trim() : "";
                            if (this.columnDataType[i] != 16 && this.columnDataType[i] != 12 && (obj != null || obj1 != null)) break block25;
                            if (Utilities.likeOneOf(s3, s, true)) break block26;
                            break block27;
                        }
                        try {
                            if (obj != null && (Tac.valueCompare(obj, obj2) & 2) != 0) {
                            }
                        }
                        catch (Exception exception3) {}
                        break block27;
                        Object obj3 = obj1;
                        if (obj1 instanceof Date && obj2 instanceof Date && Utilities.toDate(Utilities.getDateYear(date = (Date)obj2), Utilities.getDateMonth(date), Utilities.getDateDay(date)).getTime() != date.getTime()) {
                            obj3 = Utilities.incDate((Date)obj1, 1);
                        }
                        try {
                            if (obj1 != null && (Tac.valueCompare(obj3, obj2) & 4) != 0) {
                            }
                        }
                        catch (Exception exception4) {}
                        break block27;
                    }
                    String s4 = this.table.buildFindListText(l, this.listNameColumns(i));
                    if (s3 != null && s3.trim().length() != 0 || s4 != null && s4.trim().length() != 0) {
                        ValueText valuetext = new ValueText(String.valueOf(s3) + " : " + s4, new Integer(l));
                        if (flag1) {
                            defaultlistmodel.addElement(valuetext);
                        } else {
                            vector.addElement(valuetext);
                        }
                    }
                }
                ++l;
            }
            if (!flag1) {
                Object[] avaluetext = new ValueText[vector.size()];
                vector.toArray(avaluetext);
                Arrays.sort(avaluetext);
                int i1 = 0;
                while (i1 < avaluetext.length) {
                    defaultlistmodel.addElement(avaluetext[i1]);
                    ++i1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
        if (keyevent.getSource() == this.findText) {
            int byte0 = 0;
            if (keyevent.getKeyCode() == 38) {
                byte0 = -1;
            } else if (keyevent.getKeyCode() == 40) {
                byte0 = 1;
            }
            int i = this.columnSelect.getItemCount();
            if (i > 1 && byte0 != 0) {
                this.columnSelect.setSelectedIndex((this.columnSelect.getSelectedIndex() + byte0 + i) % i);
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
        if (keyevent.getKeyCode() == 10) {
            if (keyevent.getSource() == this.findText) {
                this.refreshList(true);
            } else if (keyevent.getSource() == this.list && this.onExit(0)) {
                this.setExitValue(0);
                this.closeFrame();
            }
        }
    }

    protected void onComboboxItemSelected(JComboBox jcombobox, Object obj) {
        if (jcombobox == this.columnSelect) {
            this.findText.requestFocus();
            this.refreshList(false);
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
        if (mouseevent.getSource() == this.list && mouseevent.getClickCount() == 2 && this.onExit(0)) {
            this.setExitValue(0);
            this.closeFrame();
        }
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }
}

