/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSetException;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Vector;
import softcore.awt.AwtUtil;
import softcore.table.Table;
import softcore.table.TableCell;
import softcore.table.TableCellLayout;
import softcore.table.TableColumn;
import softcore.table.TableStaticCell;

public class RecordTable
extends Table {
    private final Dimension maxSize = new Dimension();
    int[] gridWidths;
    int[] gridHeights;
    TableCellLayout tableCellLayout;
    protected int drawedSelectedCol = -1;
    Vector lineCells;

    public RecordTable() {
        this.findStyle = 1;
    }

    public void initial(Dictionary dictionary) {
        super.initial(dictionary);
        this.findMaxSize(this.maxSize);
        this.onSelectedCellChanged(-1);
        this.scrollTo(0, 0);
    }

    public void updateScrollbar(int i) {
        if (!this.hasFocusOrSubComponentHasFocus()) {
            return;
        }
        Dimension dimension = this.getSize();
        if ((i & 1) != 0 && this.vScrollbar != null) {
            int j = dimension.height;
            if (j < 1) {
                j = 1;
            }
            this.vScrollbar.setEnabled(true);
            this.vScrollbar.setValues(this.yPosition, j, 0, this.maxSize.height + 3);
            this.vScrollbar.setUnitIncrement(18);
            this.vScrollbar.setBlockIncrement(j / 2);
        }
        if ((i & 2) != 0 && this.hScrollbar != null && this.tableColumns != null) {
            int k = dimension.width;
            if (k < 1) {
                k = 1;
            }
            this.hScrollbar.setEnabled(true);
            this.hScrollbar.setValues(this.xPosition, k, 0, this.maxSize.width + 3);
            this.hScrollbar.setUnitIncrement(36);
            this.hScrollbar.setBlockIncrement(k / 2);
        }
    }

    public final Dimension findMaxPosition() {
        Dimension dimension = this.getSize();
        int i = dimension.height;
        this.maxPosition.height = this.maxSize.height - (i <= 1 ? 1 : i) + 3;
        i = dimension.width;
        this.maxPosition.width = this.maxSize.width - (i <= 1 ? 1 : i) + 3;
        return this.maxPosition;
    }

    protected void findDefaultPreferredSize() {
        this.findMaxSize(this.preferredSize);
        this.preferredSize.height += 8;
        this.preferredSize.width += 8;
        super.findDefaultPreferredSize();
    }

    private void findMaxSize(Dimension dimension) {
        dimension.width = this.findGridWidth();
        dimension.height = this.findGridHeight();
        RecordTable.findMaxRect(this.tableStaticCells, dimension);
        RecordTable.findMaxRect(this.tableColumns, dimension);
        dimension.width += this.rightFixedColWidth;
    }

    public void getSelectedCellEditRect(int[] ai, boolean flag) {
        ai[3] = 0;
        ai[2] = 0;
        ai[1] = 0;
        ai[0] = 0;
        int i = this.tableColumns.length;
        if (this.colSelected >= i || this.colSelected < 0) {
            return;
        }
        TableColumn tablecolumn = this.tableColumns[this.colSelected];
        if ((tablecolumn.options & 1) != 0) {
            return;
        }
        ai[0] = this.leftFixedColWidth + tablecolumn.left - this.xPosition;
        ai[1] = this.topFixedRowHeight + tablecolumn.top - this.yPosition;
        ai[2] = tablecolumn.width - (!this.dropdownButton.isVisible() || flag ? -1 : 15);
        ai[3] = tablecolumn.height + 1;
    }

    protected final void drawCell(Graphics g, int i, int j) {
        boolean flag;
        int k = this.tableColumns.length;
        if (j >= k || j < 0) {
            return;
        }
        TableColumn tablecolumn = this.tableColumns[j];
        Object obj = tablecolumn.getDataSetValueAt(this.dataSet, -1);
        boolean bl = flag = j == this.colSelected;
        if (flag && this.editingValue != null) {
            obj = this.editingValue;
        }
        this.inDrawingRow = i;
        tablecolumn.paint(g, tablecolumn.left - this.xPosition, tablecolumn.top - this.yPosition, tablecolumn.width - (!flag || !this.showDropdownButton() ? 0 : 16), tablecolumn.height, obj, g.getFontMetrics(), !flag || !this.hasFocusOrSubComponentHasFocus() ? 2 : 3, this.getBackground(), this.getForeground(), null);
        if (flag) {
            this.moveEditor();
        }
        if (j == this.colSelected) {
            this.drawedSelectedCol = j;
        }
    }

    public void setGridXY(int[] ai, int[] ai1) {
        this.gridWidths = ai;
        this.gridHeights = ai1;
    }

    public int findGridWidth() {
        int i = 0;
        if (this.gridWidths != null) {
            int j = 0;
            while (j < this.gridWidths.length) {
                i += this.gridWidths[j++];
            }
        }
        return i;
    }

    public int findGridHeight() {
        int i = 0;
        if (this.gridHeights != null) {
            int j = 0;
            while (j < this.gridHeights.length) {
                i += this.gridHeights[j++];
            }
        }
        return i;
    }

    public TableCellLayout getTableCellLayout() {
        return this.tableCellLayout;
    }

    public void setTableCellLayout(TableCellLayout tablecelllayout) {
        this.tableCellLayout = tablecelllayout;
    }

    protected void configCells(TableCell[] atablecell) {
        if (atablecell == null) {
            return;
        }
        int i = 0;
        while (i < atablecell.length) {
            if (atablecell[i].gridHeight > 0 && atablecell[i].gridWidth > 0) {
                atablecell[i].height = 0;
                atablecell[i].width = 0;
                atablecell[i].top = 0;
                atablecell[i].left = 0;
                if (this.gridWidths != null) {
                    int j = 0;
                    while (j < atablecell[i].gridX + atablecell[i].gridWidth) {
                        if (j < atablecell[i].gridX) {
                            atablecell[i].left += this.gridWidths[j];
                        } else {
                            atablecell[i].width += this.gridWidths[j];
                        }
                        ++j;
                    }
                }
                if (this.gridHeights != null) {
                    int k = 0;
                    while (k < atablecell[i].gridY + atablecell[i].gridHeight) {
                        if (k < atablecell[i].gridY) {
                            atablecell[i].top += this.gridHeights[k];
                        } else {
                            atablecell[i].height += this.gridHeights[k];
                        }
                        ++k;
                    }
                }
            } else {
                if (atablecell[i].width == 0 || atablecell[i].height == 0) {
                    Font font = atablecell[i].font;
                    if (font == null) {
                        font = this.getFont();
                    }
                    if (font != null) {
                        FontMetrics fontmetrics = this.getFontMetrics(font);
                        if (atablecell[i].height == 0) {
                            atablecell[i].height = fontmetrics.getHeight() + 2;
                        }
                        if (atablecell[i].width == 0 && atablecell[i] instanceof TableStaticCell) {
                            atablecell[i].width = fontmetrics.stringWidth(atablecell[i].displayCaption) + 2;
                        }
                    }
                }
                if ((atablecell[i].dockAlign & 0x10) != 0) {
                    atablecell[i].left = atablecell[i].dockX;
                    atablecell[i].width = this.getWidth() - atablecell[i].dockX - atablecell[i].dockRX;
                    if (atablecell[i].width < 2) {
                        atablecell[i].width = 2;
                    }
                } else {
                    atablecell[i].left = (atablecell[i].dockAlign & 1) != 0 ? (this.getWidth() - atablecell[i].width) / 2 + atablecell[i].dockX : ((atablecell[i].dockAlign & 2) != 0 ? this.getWidth() - atablecell[i].width - atablecell[i].dockX : atablecell[i].dockX);
                }
                if ((atablecell[i].dockAlign & 0x20) != 0) {
                    atablecell[i].top = atablecell[i].dockY;
                    atablecell[i].height = this.getHeight() - atablecell[i].dockY - atablecell[i].dockBY;
                    if (atablecell[i].height < 2) {
                        atablecell[i].height = 2;
                    }
                } else {
                    atablecell[i].top = (atablecell[i].dockAlign & 4) != 0 ? (this.getHeight() - atablecell[i].height) / 2 + atablecell[i].dockY : ((atablecell[i].dockAlign & 8) != 0 ? this.getHeight() - atablecell[i].height - atablecell[i].dockY : atablecell[i].dockY);
                }
            }
            ++i;
        }
    }

    private static void findMaxRect(TableCell[] atablecell, Dimension dimension) {
        if (atablecell == null) {
            return;
        }
        int i = 0;
        while (i < atablecell.length) {
            if ((atablecell[i].options & 1) == 0) {
                int k;
                int j = atablecell[i].left + atablecell[i].width;
                if (j > dimension.width) {
                    dimension.width = j;
                }
                if ((k = atablecell[i].top + atablecell[i].height) > dimension.height) {
                    dimension.height = k;
                }
            }
            ++i;
        }
    }

    public void reshape(int i, int j, int k, int l) {
        boolean flag = this.getWidth() != k || this.getHeight() != l;
        super.reshape(i, j, k, l);
        this.thisConfigColumns();
    }

    private void thisConfigColumns() {
        this.configCells(this.tableStaticCells);
        this.configCells(this.tableColumns);
        if (this.tableCellLayout != null) {
            this.tableCellLayout.layoutTableCells(this);
        }
    }

    public void configColumns(Dictionary dictionary) {
        super.configColumns(dictionary);
        this.thisConfigColumns();
    }

    private int atColumn(int i, int j) {
        if (this.tableColumns != null) {
            int k = 0;
            while (k < this.tableColumns.length) {
                if ((this.tableColumns[k].options & 1) == 0 && i >= this.tableColumns[k].left && i < this.tableColumns[k].left + this.tableColumns[k].width && j >= this.tableColumns[k].top && j < this.tableColumns[k].top + this.tableColumns[k].height) {
                    return k;
                }
                ++k;
            }
        }
        return -1;
    }

    protected boolean showDropdownButton() {
        if (this.tableColumns != null && this.colSelected >= 0 && this.colSelected < this.tableColumns.length) {
            boolean flag;
            TableColumn tablecolumn = this.tableColumns[this.colSelected];
            boolean bl = flag = (tablecolumn.options & 0x2000000) != 0 && this.hasFocusOrSubComponentHasFocus() && ((tablecolumn.options & 0x100) == 0 && (this.rwFlags & 1) == 0 || (tablecolumn.options & 0x8000000) != 0);
            if (flag) {
                Dimension dimension = this.getSize();
                int i = tablecolumn.top - this.yPosition;
                if (i >= dimension.height) {
                    flag = false;
                } else {
                    int j = tablecolumn.left - this.xPosition;
                    if (j < this.leftFixedColWidth || j >= dimension.width) {
                        flag = false;
                    } else {
                        this.dropdownButton.setBounds(j + tablecolumn.width - 16, i + 1, 16, tablecolumn.height - 1);
                    }
                }
            }
            this.dropdownButton.setVisible(flag);
        }
        return this.dropdownButton.isVisible();
    }

    public int posEnsureSelectedCellVisible() {
        if (this.tableColumns != null && this.colSelected >= 0 && this.colSelected < this.tableColumns.length) {
            int j;
            TableColumn tablecolumn = this.tableColumns[this.colSelected];
            Dimension dimension = this.getSize();
            int i = this.yPosition;
            if (tablecolumn.top + tablecolumn.height > i + dimension.height) {
                i = tablecolumn.top + tablecolumn.height - dimension.height;
            }
            if (i > tablecolumn.top) {
                i = tablecolumn.top;
            }
            if (i < 0) {
                i = 0;
            }
            if (tablecolumn.left + tablecolumn.width > (j = this.xPosition) + dimension.width) {
                j = tablecolumn.left + tablecolumn.width - dimension.width;
            }
            if (j > tablecolumn.left) {
                j = tablecolumn.left;
            }
            if (j < 0) {
                j = 0;
            }
            return i << 16 | j;
        }
        return 0;
    }

    private void onSelectedCellChanged(int i) {
        this.onSelectedCellChanged(i, null);
    }

    protected void onSelectedCellChanged(int i, AWTEvent awtevent) {
        if (i < 0) {
            i = this.drawedSelectedCol;
        }
        this.stopEdit();
        int j = this.posEnsureSelectedCellVisible();
        if (j != (this.yPosition << 16 | this.xPosition)) {
            this.scrollTo(j & 0xFFFF, j >> 16);
            this.updateScrollbar(3);
        } else {
            TableColumn tablecolumn;
            this.dropdownButton.setVisible(false);
            this.setEditorInvisible();
            if (this.offGraphics != null) {
                this.drawCell(this.offGraphics, this.getRowSelected(), i);
                this.drawCell(this.offGraphics, this.getRowSelected(), this.colSelected);
            }
            if ((tablecolumn = this.getSelectedColumn()) != null && (tablecolumn.options & 0x40000000) != 0) {
                this.startEdit(awtevent);
            }
            this.repaint();
        }
    }

    public void addLine(Rectangle rectangle, int i, Color color) {
        if ((i & 0xFF) == 0 || i >> 8 == 0 || color != null && color.equals(Color.white)) {
            return;
        }
        if (this.lineCells == null) {
            this.lineCells = new Vector();
        }
        int j = this.lineCells.size();
        int k = rectangle.x;
        int l = rectangle.y;
        int i1 = rectangle.x + rectangle.width;
        int j1 = rectangle.y + rectangle.height;
        if (k == i1) {
            int k1 = 0;
            while (k1 < j) {
                LineCell linecell;
                LineCell linecell2 = linecell = (LineCell)this.lineCells.elementAt(k1);
                if (linecell2.penStyle == i && RecordTable.objectEquals(linecell2.color, color) && linecell2.width == 0 && k == linecell2.x) {
                    int i2 = RecordTable.min(linecell2.y, linecell2.y + linecell2.height);
                    int k2 = RecordTable.max(linecell2.y, linecell2.y + linecell2.height);
                    int i3 = RecordTable.min(l, j1);
                    int k3 = RecordTable.max(l, j1);
                    if (k3 >= i2 && i3 <= k2) {
                        linecell2.y = RecordTable.min(i2, i3);
                        linecell2.height = RecordTable.max(k2, k3) - linecell2.y;
                        return;
                    }
                }
                ++k1;
            }
        }
        if (l == j1) {
            int l1 = 0;
            while (l1 < j) {
                LineCell linecell1;
                LineCell linecell3 = linecell1 = (LineCell)this.lineCells.elementAt(l1);
                if (linecell3.penStyle == i && RecordTable.objectEquals(linecell3.color, color) && linecell3.height == 0 && l == linecell3.y) {
                    int j2 = RecordTable.min(linecell3.x, linecell3.x + linecell3.width);
                    int l2 = RecordTable.max(linecell3.x, linecell3.x + linecell3.width);
                    int j3 = RecordTable.min(k, i1);
                    int l3 = RecordTable.max(k, i1);
                    if (l3 >= j2 && j3 <= l2) {
                        linecell3.x = RecordTable.min(j2, j3);
                        linecell3.width = RecordTable.max(l2, l3) - linecell3.x;
                        return;
                    }
                }
                ++l1;
            }
        }
        this.lineCells.addElement(new LineCell(rectangle, i, color));
    }

    protected void draw() {
        Dimension dimension = this.getSize();
        if (this.offDimension == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offDimension = dimension;
            this.offImage = this.createImage(dimension.width, dimension.height);
            if (this.offImage == null) {
                this.offDimension = null;
                return;
            }
            this.offGraphics = this.offImage.getGraphics();
        }
        Color color = this.getBackground();
        Color color1 = this.getForeground();
        if (color1 == null) {
            color1 = Color.black;
        }
        Font font = new Font("Dialog", 0, 14);
        this.offGraphics.setFont(font);
        this.offGraphics.setPaintMode();
        this.offGraphics.setColor(color);
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(color1);
        int i = this.tableColumns.length;
        FontMetrics fontmetrics = this.offGraphics.getFontMetrics();
        int j = (this.gridWidths != null && this.gridWidths.length != 0 ? this.gridWidths[0] : 0) - this.xPosition;
        int k = this.findGridWidth() - this.xPosition;
        int l = (this.gridHeights != null && this.gridHeights.length != 0 ? this.gridHeights[0] : 0) - this.yPosition;
        int i1 = this.findGridHeight() - this.yPosition;
        if (this.gridHeights != null) {
            int j1 = this.topFixedRowHeight - this.yPosition;
            int k2 = 0;
            while (k2 < this.gridHeights.length) {
                this.offGraphics.drawLine(this.leftFixedColWidth + j, j1 += this.gridHeights[k2], this.leftFixedColWidth + k, j1);
                ++k2;
            }
        }
        if (this.gridWidths != null) {
            int k1 = this.leftFixedColWidth - this.xPosition;
            int l2 = 0;
            while (l2 < this.gridWidths.length) {
                this.offGraphics.drawLine(k1 += this.gridWidths[l2], this.topFixedRowHeight + l, k1, this.topFixedRowHeight + i1);
                ++l2;
            }
        }
        if (this.lineCells != null) {
            int l1 = this.lineCells.size();
            int i3 = 0;
            while (i3 < l1) {
                LineCell linecell = (LineCell)this.lineCells.elementAt(i3);
                linecell.paint(this.offGraphics, this.xPosition, this.yPosition);
                ++i3;
            }
        }
        if (this.tableStaticCells != null) {
            int i2 = 0;
            while (i2 < this.tableStaticCells.length) {
                FontMetrics fontmetrics1 = fontmetrics;
                if ((this.tableStaticCells[i2].options & 1) == 0) {
                    if (this.tableStaticCells[i2].font != null) {
                        this.offGraphics.setFont(this.tableStaticCells[i2].font);
                        fontmetrics1 = this.offGraphics.getFontMetrics();
                    }
                    this.tableStaticCells[i2].paint(this.offGraphics, this.tableStaticCells[i2].left - this.xPosition, this.tableStaticCells[i2].top - this.yPosition, this.tableStaticCells[i2].width, this.tableStaticCells[i2].height, fontmetrics1, color, color1);
                    if (this.tableStaticCells[i2].font != null) {
                        this.offGraphics.setFont(this.getFont());
                    }
                }
                ++i2;
            }
        }
        if (this.tableColumns != null) {
            this.dropdownButton.setVisible(false);
            this.setEditorInvisible();
            this.inDrawingRow = -1;
            int j2 = 0;
            while (j2 < this.tableColumns.length) {
                TableColumn tablecolumn = this.tableColumns[j2];
                if ((tablecolumn.options & 1) == 0) {
                    boolean flag;
                    if (tablecolumn.captionPosition > 0) {
                        int l3;
                        int k3;
                        FontMetrics fontmetrics2 = fontmetrics;
                        int j3 = fontmetrics2.getAscent();
                        if (tablecolumn.captionPosition == 2) {
                            int j4 = tablecolumn.captionWidth;
                            if (j4 == 0) {
                                j4 = fontmetrics2.stringWidth(tablecolumn.displayCaption);
                            }
                            k3 = tablecolumn.left - tablecolumn.captionGap - j4;
                            l3 = tablecolumn.top + j3 + 1;
                        } else if (tablecolumn.captionPosition == 1) {
                            l3 = tablecolumn.top - tablecolumn.captionGap;
                            k3 = tablecolumn.left;
                        } else if (tablecolumn.captionPosition == 3) {
                            l3 = tablecolumn.top + tablecolumn.height + j3 + 1 + tablecolumn.captionGap;
                            k3 = tablecolumn.left;
                        } else {
                            k3 = tablecolumn.left + tablecolumn.width + tablecolumn.captionGap;
                            l3 = tablecolumn.top + j3 + 1;
                        }
                        this.offGraphics.setColor(tablecolumn.captionColor != null ? tablecolumn.captionColor : ((tablecolumn.options & 0x8000) == 0 && (tablecolumn.extOptions & 1) == 0 ? ((tablecolumn.options & 0x100) == 0 ? color1 : Color.gray) : Color.blue));
                        this.offGraphics.drawString(tablecolumn.displayCaption, k3 - this.xPosition, l3 - this.yPosition);
                    }
                    Object obj = tablecolumn.getDataSetValueAt(this.dataSet, -1);
                    boolean bl = flag = j2 == this.colSelected;
                    if (flag && this.editingValue != null) {
                        obj = this.editingValue;
                    }
                    boolean flag1 = flag && this.showDropdownButton();
                    int i4 = tablecolumn.left - this.xPosition;
                    int k4 = tablecolumn.top - this.yPosition;
                    int l4 = tablecolumn.width - (flag1 ? 16 : 0);
                    int i5 = tablecolumn.height;
                    tablecolumn.paint(this.offGraphics, i4, k4, l4, i5, obj, fontmetrics, 4 | (!flag || !this.hasFocusOrSubComponentHasFocus() ? 2 : 3) | (flag1 ? 32 : 0), color, color1, null);
                    if (j2 == this.colSelected) {
                        this.drawedSelectedCol = j2;
                    }
                    if (flag) {
                        this.moveEditor();
                    }
                }
                ++j2;
            }
        }
    }

    protected void onRowNavigated(boolean flag) {
        super.onRowNavigated(flag);
        this.forceRedraw = true;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseevent) {
        super.mousePressed(mouseevent);
        if ((mouseevent.getModifiers() & 0x10) == 0) {
            return;
        }
        int i = this.atColumn(mouseevent.getX() + this.xPosition, mouseevent.getY() + this.yPosition);
        if (i >= 0) {
            if (i == this.colSelected) {
                mouseevent = new MouseEvent((Component)mouseevent.getSource(), mouseevent.getID(), mouseevent.getWhen(), mouseevent.getModifiers(), mouseevent.getX() + this.xPosition, mouseevent.getY() + this.yPosition, mouseevent.getClickCount(), mouseevent.isPopupTrigger());
                this.startEdit(mouseevent);
                return;
            }
            if (!this.postPendingValue()) {
                return;
            }
            int j = this.colSelected;
            this.colSelected = i;
            this.onSelectedCellChanged(j, mouseevent);
        }
    }

    private void keyMoveSelectedCell(int i, KeyEvent keyevent) {
        if (this.colSelected >= 0 && this.tableColumns != null) {
            int j = this.colSelected;
            int k = this.tableColumns[this.colSelected].findNearCell(this.tableColumns, i);
            if (k >= 0) {
                this.colSelected = k;
                this.onSelectedCellChanged(j, keyevent);
                return;
            }
        }
        this.focusNeighbourComponent(i);
    }

    public void keyPressed(KeyEvent keyevent) {
        if (this.dataSet == null) {
            return;
        }
        if (this.tableCellEditor != null && this.tableCellEditor.keyUnTraversable(keyevent.getKeyCode(), keyevent.getKeyChar())) {
            this.startEdit(keyevent);
            return;
        }
        switch (keyevent.getKeyCode()) {
            default: {
                break;
            }
            case 37: {
                int i;
                if (this.editor == this.textField && this.textField.getCaretPosition() > 0 || !this.postPendingValue()) {
                    return;
                }
                this.keyMoveSelectedCell(2, keyevent);
                if (this.colSelected < 0 || this.tableColumns == null || (i = this.tableColumns[this.colSelected].findNearCell(this.tableColumns, 2)) >= 0) break;
                this.scrollTo(0, this.yPosition);
                break;
            }
            case 39: {
                if (this.editor == this.textField && this.textField.getCaretPosition() < this.textField.getText().length() || !this.postPendingValue()) {
                    return;
                }
                if (this.isCurrentColumnTexteditable()) break;
                this.keyMoveSelectedCell(4, keyevent);
                break;
            }
            case 9: 
            case 10: {
                int j = this.colSelected;
                if (!this.postPendingValue()) {
                    return;
                }
                this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, j, true);
                if (this.colSelected < 0 && this.tableColumns != null) {
                    if (this.getNeighbourComponent(3) != null) {
                        keyevent.setKeyCode(0);
                        this.colSelected = j;
                        this.focusNeighbourComponent(3);
                    } else {
                        this.colSelected = TableColumn.nextVisibleColumn(this.tableColumns, -1, true);
                    }
                }
                this.onSelectedCellChanged(j);
                break;
            }
            case 38: {
                int k;
                if (this.inAidInputing() || !this.postPendingValue()) {
                    return;
                }
                this.keyMoveSelectedCell(1, keyevent);
                if (this.colSelected < 0 || this.tableColumns == null || (k = this.tableColumns[this.colSelected].findNearCell(this.tableColumns, 1)) >= 0) break;
                this.scrollTo(this.xPosition, 0);
                break;
            }
            case 40: {
                if (this.inAidInputing() || !this.postPendingValue()) {
                    return;
                }
                this.keyMoveSelectedCell(3, keyevent);
                break;
            }
            case 33: {
                if (this.inAidInputing() || !this.dataSetNavigateAble() || this.dataSet.atFirst()) {
                    return;
                }
                try {
                    if (keyevent.isControlDown()) {
                        this.dataSet.first();
                    } else {
                        this.dataSet.prior();
                    }
                }
                catch (DataSetException dataSetException) {
                    // empty catch block
                }
                this.onSelectedCellChanged(-1, keyevent);
                return;
            }
            case 34: {
                if (this.inAidInputing() || !this.dataSetNavigateAble()) {
                    return;
                }
                try {
                    if (keyevent.isControlDown()) {
                        this.dataSet.last();
                    } else {
                        int l = this.dataSet.getRow();
                        this.dataSet.next();
                        if (l == this.dataSet.getRow()) {
                            this.onRowNavigated(false);
                        }
                    }
                }
                catch (DataSetException dataSetException) {
                    // empty catch block
                }
                this.onSelectedCellChanged(-1, keyevent);
                return;
            }
        }
        super.keyPressed(keyevent);
    }

    private static final boolean objectEquals(Object obj, Object obj1) {
        return obj == obj1 || obj != null && obj.equals(obj1);
    }

    static final int min(int i, int j) {
        return i >= j ? j : i;
    }

    static final int max(int i, int j) {
        return i <= j ? j : i;
    }

    public static class LineCell
    extends Rectangle {
        public Color color;
        int penStyle;

        public void paint(Graphics g, int i, int j) {
            AwtUtil.drawLine(g, this.x - i, this.y - j, this.x + this.width - i, this.y + this.height - j, this.color != null ? this.color : Color.black, this.penStyle & 0xFF, this.penStyle >> 8);
        }

        public LineCell(Rectangle rectangle, int i, Color color1) {
            super(rectangle);
            this.penStyle = i;
            this.color = color1;
        }
    }
}

