/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Hashtable;
import softcore.table.RecordTable;
import softcore.table.Table;
import softcore.table.TableCellLayout;
import softcore.table.TableColumn;
import softcore.table.TableStaticCell;

public class TableCellGroupGridLayout
implements TableCellLayout {
    public boolean removeFromTable;
    public int rowHeight;
    public int leftMargin = 2;
    public int topMargin = 4;
    public Group[] groups;

    public void layoutTableCells(Table table) {
        TableColumn[] atablecolumn = table.tableColumns;
        if (this.groups == null || atablecolumn == null || !table.isColumnsConfiged()) {
            return;
        }
        FontMetrics fontmetrics = table.getFontMetrics(table.getFont());
        int j = this.rowHeight;
        if (j == 0 && (j = fontmetrics.getHeight() + 2) < 18) {
            j = 18;
        }
        int k = 0;
        int l = 0;
        int i1 = 0;
        while (i1 < this.groups.length) {
            this.groups[i1].layout0(fontmetrics, j);
            if (k < this.groups[i1].gridX + this.groups[i1].gridW) {
                k = this.groups[i1].gridX + this.groups[i1].gridW;
            }
            if (l < this.groups[i1].gridY + this.groups[i1].gridH) {
                l = this.groups[i1].gridY + this.groups[i1].gridH;
            }
            ++i1;
        }
        int[] ai = new int[k];
        int[] ai1 = new int[l];
        int j1 = 0;
        while (j1 < k) {
            int k1 = 0;
            while (k1 < this.groups.length) {
                if (this.groups[k1].gridX + this.groups[k1].gridW - 1 == j1) {
                    int i2 = this.groups[k1].bounds.width;
                    int l2 = 0;
                    int k3 = this.groups[k1].gridX;
                    while (k3 < this.groups[k1].gridX + this.groups[k1].gridW) {
                        l2 += ai[k3];
                        ++k3;
                    }
                    if (i2 > l2) {
                        int n = j1;
                        ai[n] = ai[n] + (i2 - l2);
                    }
                }
                ++k1;
            }
            ++j1;
        }
        int l1 = 0;
        while (l1 < l) {
            int j2 = 0;
            while (j2 < this.groups.length) {
                if (this.groups[j2].gridY + this.groups[j2].gridH - 1 == l1) {
                    int i3 = this.groups[j2].bounds.height;
                    int l3 = 0;
                    int j4 = this.groups[j2].gridY;
                    while (j4 < this.groups[j2].gridY + this.groups[j2].gridH) {
                        l3 += ai1[j4];
                        ++j4;
                    }
                    if (i3 > l3) {
                        int n = l1;
                        ai1[n] = ai1[n] + (i3 - l3);
                    }
                }
                ++j2;
            }
            ++l1;
        }
        int k2 = 0;
        while (k2 < this.groups.length) {
            this.groups[k2].bounds.x = this.leftMargin;
            this.groups[k2].bounds.y = this.topMargin;
            this.groups[k2].bounds.width = 0;
            this.groups[k2].bounds.height = 0;
            int j3 = 0;
            while (j3 < this.groups[k2].gridX + this.groups[k2].gridW) {
                if (j3 < this.groups[k2].gridX) {
                    this.groups[k2].bounds.x += ai[j3];
                } else {
                    this.groups[k2].bounds.width += ai[j3];
                }
                ++j3;
            }
            int i4 = 0;
            while (i4 < this.groups[k2].gridY + this.groups[k2].gridH) {
                if (i4 < this.groups[k2].gridY) {
                    this.groups[k2].bounds.y += ai1[i4];
                } else {
                    this.groups[k2].bounds.height += ai1[i4];
                }
                ++i4;
            }
            this.groups[k2].layout1(this.groups[k2].bounds.x, this.groups[k2].bounds.y);
            ++k2;
        }
        table.setRightFixedColWidth(4);
        if (this.removeFromTable && table instanceof RecordTable && ((RecordTable)table).getTableCellLayout() == this) {
            this.groups = null;
            int i = 0;
            while (i < atablecolumn.length) {
                atablecolumn[i].dockAlign = 0;
                atablecolumn[i].dockY = atablecolumn[i].top;
                atablecolumn[i].dockX = atablecolumn[i].left;
                ++i;
            }
        }
    }

    public static class Group {
        public TableStaticCell titleCell;
        public TableColumn[] tableColumns;
        public int gridX;
        public int gridY;
        public int gridW = 1;
        public int gridH = 1;
        public int layoutWidths = 3;
        public int cellCaptionGap = 4;
        public int cellGap = 5;
        public Insets innerInsets;
        public Insets externalInsets;
        public final Rectangle bounds = new Rectangle();
        public final Hashtable props = new Hashtable();
        public int align;

        void layout0(FontMetrics fontmetrics, int i) {
            if (this.tableColumns == null || this.tableColumns.length == 0) {
                return;
            }
            if (this.gridX < 0) {
                this.gridX = 0;
            }
            if (this.gridY < 0) {
                this.gridY = 0;
            }
            if (this.gridW <= 0) {
                this.gridW = 1;
            }
            if (this.gridH <= 0) {
                this.gridH = 1;
            }
            if (this.layoutWidths <= 0) {
                this.layoutWidths = 3;
            }
            int j = 0;
            int k = 0;
            int l = this.layoutWidths;
            if (l <= 0) {
                l = 1;
            }
            int[] ai = new int[l * 4];
            boolean flag = false;
            int i1 = 0;
            while (i1 < this.tableColumns.length) {
                if ((this.tableColumns[i1].options & 1) == 0) {
                    int j1;
                    if (this.tableColumns[i1].gridWidth <= 0) {
                        this.tableColumns[i1].gridWidth = 1;
                    }
                    if (j > 0 && (j + this.tableColumns[i1].gridWidth > l || flag)) {
                        j = 0;
                        ++k;
                    }
                    boolean bl = flag = this.props.get("layoutnewline." + this.tableColumns[i1].cellId) != null;
                    if (this.tableColumns[i1].displayCaption != null && (j1 = fontmetrics.stringWidth(this.tableColumns[i1].displayCaption)) > ai[4 * j + 1]) {
                        ai[4 * j + 1] = j1;
                    }
                    if (this.tableColumns[i1].gridWidth == 1 && this.tableColumns[i1].width > ai[4 * j + 2]) {
                        ai[4 * j + 2] = this.tableColumns[i1].width;
                    }
                    this.tableColumns[i1].gridX = j;
                    j += this.tableColumns[i1].gridWidth;
                    this.tableColumns[i1].gridY = k;
                }
                ++i1;
            }
            int k1 = this.externalInsets.left;
            int l1 = this.externalInsets.top;
            if (this.titleCell != null) {
                this.titleCell.top = l1;
                this.titleCell.left = k1 + 10;
                k1 += 2 + this.innerInsets.left;
                l1 += this.titleCell.height + 2 + this.innerInsets.top;
            }
            int i2 = 0;
            while (i2 < l) {
                ai[i2 * 4] = k1;
                k1 += ai[i2 * 4 + 1] + this.cellCaptionGap + ai[i2 * 4 + 2] + this.cellGap;
                ++i2;
            }
            int j2 = k1;
            this.bounds.width = k1 - this.cellGap + this.externalInsets.right;
            if (this.titleCell != null) {
                this.bounds.width += this.innerInsets.right + 2;
            }
            this.bounds.height = l1;
            int k2 = 0;
            while (k2 < this.tableColumns.length) {
                int l2 = this.tableColumns[k2].gridX;
                this.tableColumns[k2].captionWidth = ai[l2 * 4 + 1];
                this.tableColumns[k2].captionGap = this.cellCaptionGap;
                this.tableColumns[k2].left = ai[l2 * 4] + ai[l2 * 4 + 1] + this.cellCaptionGap;
                this.tableColumns[k2].top = l1 + this.tableColumns[k2].gridY * i;
                int i3 = l2 + this.tableColumns[k2].gridWidth;
                int j3 = (i3 < l ? ai[i3 * 4] : j2) - this.cellGap;
                if (this.align != 1) {
                    if (this.align == 2) {
                        int l3 = j3 - this.tableColumns[k2].width;
                        int k3 = this.tableColumns[k2].left;
                        if (l3 > k3) {
                            this.tableColumns[k2].left = l3;
                            this.tableColumns[k2].captionGap += l3 - k3;
                        }
                    } else {
                        this.tableColumns[k2].width = j3 - this.tableColumns[k2].left;
                    }
                }
                if (this.bounds.height < this.tableColumns[k2].top + i) {
                    this.bounds.height = this.tableColumns[k2].top + i;
                }
                ++k2;
            }
            this.bounds.height += this.externalInsets.bottom;
            if (this.titleCell != null) {
                this.bounds.height += 2 + this.innerInsets.bottom;
                this.titleCell.grpLine = new Dimension(this.bounds.width - this.externalInsets.left - this.externalInsets.right, this.bounds.height - this.externalInsets.top - this.titleCell.height / 2 - this.externalInsets.bottom);
            }
        }

        void layout1(int i, int j) {
            if (this.titleCell != null) {
                this.titleCell.left += i;
                this.titleCell.top += j;
                this.titleCell.dockAlign = 0;
                this.titleCell.dockX = this.titleCell.left;
                this.titleCell.dockY = this.titleCell.top;
            }
            if (this.tableColumns != null) {
                int k = 0;
                while (k < this.tableColumns.length) {
                    this.tableColumns[k].left += i;
                    this.tableColumns[k].top += j;
                    ++k;
                }
            }
        }

        public Group() {
            this.innerInsets = new Insets(2, 4, 2, 4);
            this.externalInsets = new Insets(2, 2, 2, 2);
        }
    }
}

