/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import softcore.awt.ExtObject;
import softcore.awt.MutilineTextAidInputer;
import softcore.table.CodeFullnameMap;
import softcore.table.CodeNameMap;
import softcore.table.CodeNameSortedArray;
import softcore.table.PopupListAidInputer;
import softcore.table.Table;
import softcore.table.TableCell;
import softcore.table.TableCellDataAccess;
import softcore.table.TableCellEditor;
import softcore.table.TableColumnObjectGetter;
import softcore.tac.Tac;
import softcore.util.AidInputer;
import softcore.util.Constants;
import softcore.util.Message;
import softcore.util.ObjectGetter;
import softcore.util.Type;
import softcore.util.Utilities;
import softcore.yacc.Null;

public final class TableColumn
extends TableCell
implements Cloneable {
    public Color captionColor;
    public Font captionFont;
    public int captionPosition;
    public int captionWidth;
    public int captionGap;
    int maxChars;
    int minDecimals = -1;
    int maxDecimals = -1;
    int decimals;
    public static final int ocZeroInvisible = 2;
    public static final int ocShowNegInRed = 16;
    public static final int ocShowGroupingSeparator = 32;
    public static final int ocShowCode = 64;
    public static final int ocShowName = 128;
    public static final int ocReadonly = 256;
    public static final int ocEditDisable = 512;
    public static final int ocShowFullname = 1024;
    public static final int ocTrimName = 2048;
    public static final int ocNotNullable = 4096;
    public static final int ocForceShowAsInt = 8192;
    public static final int ocPasswordChar = 16384;
    public static final int ocForceInput = 32768;
    public static final int ocEnableDataChangedEvent = 65536;
    public static final int ocSaveValueBeforeRowChanged = 131072;
    public static final int ocReserveLastValueAsDefault = 262144;
    public static final int ocTrim = 0x100000;
    public static final int ocToUpper = 0x200000;
    public static final int ocInvisibleIfSamePrevRow = 0x400000;
    public static final int ocSpinButton = 0x1000000;
    public static final int ocDropDownButton = 0x2000000;
    public static final int ocAidInputOverWriteSelectedOnly = 0x4000000;
    public static final int ocAidinputAbleIfReadonly = 0x8000000;
    public static final int oc3dBorder = 0x10000000;
    public static final int ocOneTouchActive = 0x40000000;
    public static final int ocCharNoEnterAidinput = Integer.MIN_VALUE;
    public int extOptions;
    public int percent;
    public int initDisplayWidth;
    public double autoResizeWeight;
    public Object[] mapKeys;
    public String[] mapValues;
    CodeNameMap codeNameMap;
    public int fullnmFromLevl;
    int dataColumnIndex = -1;
    int dataType;
    Class javaClass;
    String dataColumnName;
    public int dataColumnBit = -1;
    public Object[] bottomValue;
    public Variant valueBeforeRowChanged;
    AidInputer aidInputer;
    TableCellDataAccess dataAccess;
    private static final byte[] booleanIcon_Line;
    public ExtObject imageObject;
    boolean bColorWhenMap;
    private static int[] rightAlignType;
    TableCellEditor editor;
    CaptionCell captionCell;

    static {
        byte[] byArray = new byte[24];
        byArray[0] = 1;
        byArray[1] = 11;
        byArray[2] = 11;
        byArray[3] = 11;
        byArray[4] = 11;
        byArray[5] = 1;
        byArray[6] = 11;
        byArray[7] = 11;
        byArray[10] = 11;
        byArray[15] = 11;
        byArray[16] = 1;
        byArray[17] = 1;
        byArray[18] = 10;
        byArray[19] = 1;
        byArray[20] = 1;
        byArray[21] = 1;
        byArray[22] = 1;
        byArray[23] = 10;
        booleanIcon_Line = byArray;
        rightAlignType = new int[]{2, 3, 4, 5, 6, 7, 10};
    }

    public void setExtOptions(int i, boolean flag) {
        this.extOptions = flag ? (this.extOptions |= i) : (this.extOptions &= ~i);
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int i) {
        this.maxChars = i;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public void setDisplayWidth(int i) {
        this.width = i;
    }

    public int getMinDecimals() {
        return this.minDecimals;
    }

    public void setMinDecimals(int i) {
        this.minDecimals = i;
    }

    public int getMaxDecimals() {
        return this.maxDecimals;
    }

    public void setMaxDecimals(int i) {
        this.maxDecimals = i;
    }

    public void setDecimals(int i) {
        this.decimals = i;
    }

    public int getDecimals() {
        return this.decimals;
    }

    Object getMapValue(Object obj) {
        block6: {
            if (this.mapValues == null || this.mapKeys == null || obj == null) break block6;
            if (this.mapKeys instanceof String[]) {
                int i = 0;
                while (i < this.mapKeys.length) {
                    if (((String)this.mapKeys[i]).equals(obj.toString())) {
                        return this.mapValues[i];
                    }
                    ++i;
                }
            } else {
                int j = 0;
                while (j < this.mapKeys.length) {
                    if (this.mapKeys[j] instanceof Number && obj instanceof Number && ((Number)this.mapKeys[j]).intValue() == ((Number)obj).intValue() || this.mapKeys[j] != null && this.mapKeys[j].equals(obj)) {
                        return this.mapValues[j];
                    }
                    ++j;
                }
            }
        }
        return obj;
    }

    Object getMapKey(Object obj) {
        if (this.mapValues != null && this.mapKeys != null) {
            int i = 0;
            while (i < this.mapKeys.length) {
                if (this.mapValues[i] != null && this.mapValues[i].equals(obj)) {
                    return this.mapKeys[i];
                }
                ++i;
            }
        }
        return obj;
    }

    public void setValueMap(Object[] aobj, String[] as) {
        this.mapKeys = aobj;
        this.mapValues = as;
        this.options |= 0x200;
    }

    public void createShortStringMapx(short[] aword0, String[] as) {
        this.mapKeys = as;
        this.mapValues = as;
    }

    public void createShortStringMapx(String[] str, String[] as) {
        this.mapKeys = str;
        this.mapValues = as;
    }

    public void createShortStringMapxx(short[] aword0, String[] as) {
        this.mapKeys = new Short[as.length];
        int i = 0;
        while (i < this.mapKeys.length) {
            this.mapKeys[i] = new Short(aword0 != null ? aword0[i] : (short)i);
            ++i;
        }
        this.mapValues = as;
    }

    public void createShortStringMap(short[] aword0, String[] as) {
        this.mapKeys = new Short[as.length];
        int i = 0;
        while (i < this.mapKeys.length) {
            this.mapKeys[i] = new Short(aword0 != null ? aword0[i] : (short)i);
            ++i;
        }
        this.mapValues = as;
        this.options |= 0x200;
    }

    public void createShortStringMap(String[] as) {
        this.createShortStringMap(null, as);
    }

    public void createIntStringMap(int[] ai, String[] as) {
        this.mapKeys = new Integer[as.length];
        int i = 0;
        while (i < this.mapKeys.length) {
            this.mapKeys[i] = new Integer(ai != null ? ai[i] : i);
            ++i;
        }
        this.mapValues = as;
        this.options |= 0x200;
    }

    public void createIntStringMap(String[] as) {
        this.createIntStringMap(null, as);
    }

    public void setCodeNameMap(CodeNameMap codenamemap) {
        this.codeNameMap = codenamemap;
        this.options |= 0xC0;
    }

    public void setCodeNameMap(CodeNameMap codenamemap, int i) {
        this.codeNameMap = codenamemap;
        this.options |= i;
    }

    public CodeNameMap getCodeNameMap() {
        return this.codeNameMap;
    }

    public CodeNameMap getCodeNameMapX() {
        if (this.codeNameMap != null) {
            return this.codeNameMap;
        }
        if (this.mapKeys != null && this.mapValues != null && this.mapValues.length == this.mapKeys.length) {
            CodeNameSortedArray codenamesortedarray = new CodeNameSortedArray();
            Object[][] aobj = new Object[this.mapKeys.length][2];
            int i = 0;
            while (i < this.mapKeys.length) {
                aobj[i][0] = this.mapKeys[i];
                aobj[i][1] = this.mapValues[i];
                ++i;
            }
            codenamesortedarray.setArray(aobj, false);
            return codenamesortedarray;
        }
        return null;
    }

    public Object toStoreValueFromDisplayValue(Object obj) {
        int i;
        if (this.mapValues != null) {
            return this.getMapKey(obj);
        }
        if (obj instanceof String && this.codeNameMap != null && (i = ((String)obj).indexOf(58)) >= 0) {
            return ((String)obj).substring(0, i);
        }
        return obj;
    }

    public String findFullname(String s) {
        if (this.codeNameMap instanceof CodeFullnameMap) {
            return ((CodeFullnameMap)this.codeNameMap).getFullNameByCode(s);
        }
        return Utilities.findFullname(this.codeNameMap, s, this.fullnmFromLevl, '-');
    }

    public boolean isValidForCode(Object obj) {
        if (this.codeNameMap != null) {
            return this.codeNameMap.getNameByCode(obj) != null;
        }
        if (this.mapKeys != null) {
            return this.getMapValue(obj) != obj;
        }
        return true;
    }

    public Object toDisplayValueFromStoreValue(Object obj, boolean flag) {
        if (this.codeNameMap != null && obj != null && (this.options & 0x480) != 0) {
            String s;
            if ((this.options & 0x400) != 0) {
                s = this.findFullname(obj.toString());
            } else {
                s = this.codeNameMap.getNameByCode(obj);
                if (s != null && (this.options & 0x800) != 0) {
                    s = s.trim();
                }
            }
            if (s != null && s.trim().length() > 0) {
                return (this.options & 0x40) == 0 && !flag ? s : String.valueOf(obj.toString()) + ':' + s;
            }
        } else if (this.mapKeys != null) {
            return this.getMapValue(obj);
        }
        return obj;
    }

    public Object toNameValue(Object obj, boolean flag) {
        String s;
        if (this.mapKeys != null) {
            return this.getMapValue(obj);
        }
        if (this.codeNameMap != null && obj != null && (s = flag ? this.findFullname(obj.toString()) : this.codeNameMap.getNameByCode(obj)) != null) {
            return s;
        }
        return obj;
    }

    public Object toNameValue(Object obj) {
        return this.toNameValue(obj, false);
    }

    public boolean isBooleanType() {
        return this.dataColumnBit >= 0 || this.dataType == 11;
    }

    public boolean isValueToggleable() {
        return this.mapKeys != null;
    }

    public Object toggleNextValue(Object obj) {
        if (this.mapValues == null) {
            return null;
        }
        int i = 0;
        while (i < this.mapValues.length) {
            if (obj != null && obj.toString().length() != 0 ? obj.equals(this.mapValues[i]) : this.mapValues[i] == null || this.mapValues[i].equals("")) break;
            ++i;
        }
        return i < this.mapValues.length - 1 ? this.mapValues[i + 1] : this.mapValues[0];
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int i) {
        this.dataType = i;
        if (this.width == 0) {
            int j = 0;
            if (this.table != null && this.table.getFont() != null) {
                j = this.table.getFont().getSize() / 2;
            }
            this.width = TableColumn.getDefaultDisplayWidth(i, j);
            if ((this.options & 0x2000000) != 0) {
                this.width += 18;
            }
        }
        if ((this.options & 0xC) == 0) {
            this.options |= TableColumn.getDefaultAlign(i);
        }
        this.options |= TableColumn.getShowNegInRed(i) | TableColumn.getShowGroupingSeparator(i);
        if (i == 10) {
            if (this.minDecimals < 0) {
                this.minDecimals = 2;
            }
            if (this.maxDecimals < 0) {
                this.maxDecimals = 4;
            }
        }
        this.javaClass = Utilities.getJavaClassFromVariantType(i);
    }

    public void loadValueBeforeRowChanged(DataSet dataset) throws DataSetException {
        if (this.valueBeforeRowChanged == null) {
            this.valueBeforeRowChanged = new Variant();
        }
        this.getDataSetValueAt(dataset, -1, this.valueBeforeRowChanged);
    }

    public void setBottomValue(Object[] aobj) {
        this.bottomValue = aobj;
        if (aobj != null) {
            int i = 0;
            while (i < aobj.length) {
                if (aobj[i] instanceof TableColumnObjectGetter && ((TableColumnObjectGetter)aobj[i]).useOldColumnValue()) {
                    this.setOptions(131072, true);
                }
                ++i;
            }
        }
    }

    public Object getBottomValue(int i) {
        if (this.bottomValue == null || i >= this.bottomValue.length) {
            return null;
        }
        if (this.bottomValue[i] instanceof ObjectGetter) {
            return ((ObjectGetter)this.bottomValue[i]).getObject();
        }
        return this.bottomValue[i];
    }

    public int getDataColumnIndex() {
        return this.dataColumnIndex;
    }

    public void setDataColumnIndex(int i) {
        this.dataColumnIndex = i;
    }

    public void setColumnBit(String s) {
        int i = s.indexOf(35);
        if (i > 0) {
            this.dataColumnBit = Integer.parseInt(s.substring(i + 1));
        }
    }

    public void setCellId(String s, String s1) {
        String s2;
        this.cellId = s;
        int i = s.indexOf(35);
        if (i > 0) {
            s2 = s.substring(0, i);
            this.dataColumnBit = Integer.parseInt(s.substring(i + 1));
        } else {
            s2 = s;
        }
        if (s2.length() > 0 && s2.charAt(0) != '*') {
            this.dataColumnName = s2;
        }
        if (s1 != null) {
            this.displayCaption = s1;
        } else if (this.displayCaption == null) {
            this.displayCaption = s;
        }
    }

    public void setDataColumnName(String s) {
        this.dataColumnName = s;
    }

    public String getDataColumnName() {
        return this.dataColumnName;
    }

    public void setAidInputer(AidInputer aidinputer) {
        this.aidInputer = aidinputer;
        this.options |= 0x2000000;
    }

    public void setMutilineTextAidInputer() {
        MutilineTextAidInputer mutilinetextaidinputer = new MutilineTextAidInputer(this.displayCaption);
        if ((this.extOptions & 4) != 0) {
            mutilinetextaidinputer.getTextArea().setLineWrap(true);
        }
        if ((this.extOptions & 0x10) != 0) {
            mutilinetextaidinputer.getTextArea().setWrapStyleWord(true);
        }
        this.setAidInputer(mutilinetextaidinputer);
    }

    public AidInputer getAidInputer() {
        return this.aidInputer;
    }

    public Object doAidInput(int i, String s, Table table) {
        DataSet dataset = table.getDataSet();
        if (s == null) {
            this.toString(this.getDataSetValueAt(dataset, -1), true, true);
        }
        if (this.aidInputer != null) {
            return this.aidInputer.doAidInput(table, s, i);
        }
        String[] as = this.mapValues;
        if (as == null && this.mapKeys instanceof String[]) {
            as = (String[])this.mapKeys;
        }
        if (as != null || this.codeNameMap != null) {
            int[] ai = new int[4];
            table.getSelectedCellEditRect(ai, true);
            PopupListAidInputer popuplistaidinputer = table.getPopupListAidInputer();
            int j = as != null ? popuplistaidinputer.addItems(as, s) : popuplistaidinputer.addItems(this.codeNameMap, s);
            if (j > 0) {
                popuplistaidinputer.setAt(ai[0], ai[1] + ai[3], ai[3]);
                popuplistaidinputer.setMinWidth(ai[2]);
                popuplistaidinputer.doAidInput(table, s);
            }
        }
        return s;
    }

    public Object[][] getCodeNameAsArray() {
        if (this.codeNameMap != null) {
            return this.codeNameMap.getCodeNameAsArray();
        }
        if (this.mapKeys != null) {
            Object[][] aobj = new Object[this.mapKeys.length][2];
            int i = 0;
            while (i < this.mapKeys.length) {
                aobj[i][0] = this.mapKeys[i];
                if (this.mapValues != null) {
                    aobj[i][1] = this.mapValues[i];
                }
                ++i;
            }
            return aobj;
        }
        if (this.mapValues != null) {
            Object[][] aobj1 = new Object[this.mapValues.length][2];
            int j = 0;
            while (j < this.mapValues.length) {
                aobj1[j][0] = this.mapValues[j];
                ++j;
            }
            return aobj1;
        }
        return null;
    }

    public void setTableCellDataAccess(TableCellDataAccess tablecelldataaccess) {
        this.dataAccess = tablecelldataaccess;
    }

    public TableCellDataAccess getTableCellDataAccess() {
        return this.dataAccess;
    }

    public synchronized void getDataSetValueAt(DataSet dataset, int i, Variant variant) throws DataSetException {
        Object obj2;
        variant.setAssignedNull();
        if (this.table != null && this.table.cellValueBuffer != null && (obj2 = this.table.cellValueBuffer.get(String.valueOf(i) + "-" + this.cellId)) != null) {
            if (obj2 != Null.NULL) {
                variant.setObject(obj2);
            }
            return;
        }
        if (dataset == null) {
            return;
        }
        if (this.dataAccess != null) {
            if (!this.dataAccess.getTableCellData(dataset, i, this, variant)) {
                return;
            }
        } else if (this.dataColumnIndex >= 0) {
            if (i == -1) {
                dataset.getVariant(this.dataColumnIndex, variant);
            } else {
                dataset.getVariant(this.dataColumnIndex, i, variant);
            }
        }
        if (this.dataColumnBit >= 0) {
            if (this.dataColumnBit == 255) {
                try {
                    if (!Utilities.isVariantAsNull(variant)) {
                        variant.setBoolean(true);
                    }
                }
                catch (Exception obj2) {}
            } else {
                int j = variant.getAsInt();
                variant.setBoolean((j & 1 << this.dataColumnBit) != 0);
            }
        }
    }

    public synchronized Object getDataSetValueAt(DataSet dataset, int i) {
        Variant variant;
        block16: {
            block15: {
                Object obj;
                variant = new Variant();
                if (this.table != null && this.table.cellValueBuffer != null && (obj = this.table.cellValueBuffer.get(String.valueOf(i) + "-" + this.cellId)) != null) {
                    return obj != Null.NULL ? obj : null;
                }
                try {
                    if (this.dataAccess == null) break block15;
                    if (!this.dataAccess.getTableCellData(dataset, i, this, variant)) {
                        return null;
                    }
                    break block16;
                }
                catch (DataSetException datasetexception) {
                    return null;
                }
            }
            if (this.dataColumnIndex >= 0) {
                if (i == -1) {
                    dataset.getVariant(this.dataColumnIndex, variant);
                    break block16;
                }
                if (i < dataset.getRowCount()) {
                    dataset.getVariant(this.dataColumnIndex, i, variant);
                    break block16;
                }
                return null;
            }
            return null;
        }
        if (this.dataColumnBit >= 0) {
            if (this.dataColumnBit == 255) {
                try {
                    if (!Utilities.isVariantAsNull(variant)) {
                        variant.setBoolean(true);
                    }
                }
                catch (Exception obj) {}
            } else {
                int j = variant.getAsInt();
                return (j & 1 << this.dataColumnBit) == 0 ? null : Boolean.TRUE;
            }
        }
        return variant.getAsObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setDataSetValueAt(DataSet dataset, Object obj) {
        Variant variant = new Variant();
        try {
            block31: {
                block36: {
                    block35: {
                        block34: {
                            block32: {
                                int i;
                                block33: {
                                    if (this.dataColumnBit < 0) break block32;
                                    if (this.dataAccess != null) {
                                        if (!this.dataAccess.getTableCellData(dataset, -1, this, variant)) {
                                            return false;
                                        }
                                    } else {
                                        if (this.dataColumnIndex < 0) return false;
                                        dataset.getVariant(this.dataColumnIndex, variant);
                                    }
                                    i = variant.getAsInt();
                                    i = obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue() ? (i |= 1 << this.dataColumnBit) : (i &= ~(1 << this.dataColumnBit));
                                    if (this.dataType != 2) break block33;
                                    variant.setByte((byte)i);
                                    break block31;
                                }
                                if (this.dataType == 3) {
                                    variant.setShort((short)i);
                                    break block31;
                                } else if (this.dataType == 10) {
                                    variant.setBigDecimal(new BigDecimal((double)i));
                                    break block31;
                                } else {
                                    variant.setInt(i);
                                }
                                break block31;
                            }
                            if (obj != null) {
                                if (obj instanceof String) {
                                    Object object = obj = ((String)obj).length() != 0 ? Utilities.parseStringFromVariantType((String)obj, this.dataType) : null;
                                    if (obj instanceof String) {
                                        if ((this.options & 0x100000) != 0) {
                                            obj = ((String)obj).trim();
                                        }
                                        if ((this.options & 0x200000) != 0) {
                                            obj = ((String)obj).toUpperCase();
                                        }
                                        if (this.dataType == 16 && this.maxChars > 0 && ((String)obj).getBytes().length > this.maxChars) {
                                            throw new RuntimeException("\u8be5\u5b57\u6bb5\u6700\u5927\u957f\u5ea6\u4e3a" + this.maxChars);
                                        }
                                    }
                                } else if (obj.getClass() != this.javaClass && this.javaClass != null) {
                                    if (obj instanceof Number) {
                                        obj = Type.toNumber((Number)obj, this.javaClass);
                                    } else if (obj instanceof Date) {
                                        obj = Type.toDate((Date)obj, this.javaClass);
                                    }
                                }
                            }
                            if (obj != null) break block34;
                            variant.setAssignedNull();
                            if ((this.options & 0x1000) != 0 && this.dataType == 16) {
                                variant.setAsObject((Object)" ", this.dataType);
                            }
                            break block31;
                        }
                        if (this.dataType != 12) break block35;
                        if (obj instanceof String) {
                            obj = new ByteArrayInputStream(((String)obj).getBytes());
                            break block36;
                        } else if (obj instanceof byte[]) {
                            obj = new ByteArrayInputStream((byte[])obj);
                        }
                        break block36;
                    }
                    if (obj instanceof Number) {
                        BigDecimal bigdecimal1;
                        if (this.percent > 0) {
                            BigDecimal bigdecimal = new BigDecimal(((Number)obj).doubleValue() / (double)this.percent);
                            if (bigdecimal.scale() > 8) {
                                bigdecimal = bigdecimal.setScale(8, 4);
                            }
                            obj = bigdecimal;
                        }
                        if (this.decimals > 0 && (bigdecimal1 = Type.toBigDecimal((Number)obj)) != null && bigdecimal1.scale() > this.decimals) {
                            bigdecimal1 = bigdecimal1.setScale(this.decimals, 4);
                            obj = Type.toNumber(bigdecimal1, obj.getClass());
                        }
                    }
                }
                variant.setAsObject(obj, this.dataType);
            }
            if (this.dataAccess != null) {
                return this.dataAccess.setTableCellData(dataset, this, variant);
            }
            if (this.dataColumnIndex < 0) return true;
            dataset.setVariant(this.dataColumnIndex, variant);
            try {
                if ((this.options & 0x40000) == 0) return true;
                dataset.getColumn(this.dataColumnIndex).setDefaultValue(variant);
                return true;
            }
            catch (Exception bigdecimal1) {
                return true;
            }
        }
        catch (Exception exception1) {
            Message.showInformationDialog("\u9519\u8bef", String.valueOf(this.displayCaption) + ":\r\n" + exception1.getMessage() + "\r\n" + obj);
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public TableColumn() {
    }

    public TableColumn(String s, String s1) {
        this.setCellId(s, s1);
    }

    public TableColumn(String s) {
        this.setCellId(s, null);
        this.displayCaption = null;
    }

    public int spliteCaption(FontMetrics fontmetrics, String[] as) {
        String[] as1 = TableColumn.spliteCaption(this.displayCaption, this.width, fontmetrics);
        if (as1 == null) {
            return 0;
        }
        if (as != null) {
            System.arraycopy(as1, 0, as, 0, as1.length >= as.length ? as.length : as1.length);
        }
        return as1.length;
    }

    public static String[] spliteCaption(String s, int i, FontMetrics fontmetrics) {
        if (i == 0 || s == null) {
            return null;
        }
        int j = s.length();
        char[] ac = new char[j];
        s.getChars(0, j, ac, 0);
        Vector<String> vector = new Vector<String>();
        int k = 0;
        block0: while (k < j) {
            int l = k + 2;
            while (true) {
                if (l > j || fontmetrics.charsWidth(ac, k, l - k) >= i) {
                    vector.addElement(new String(ac, k, l - 1 - k));
                    k = l - 1;
                    continue block0;
                }
                ++l;
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toString(Object obj, boolean flag, boolean flag1) {
        if (flag1) {
            obj = this.toDisplayValueFromStoreValue(obj, flag);
        }
        if (obj == null) {
            return "";
        }
        if ((this.options & 2) != 0 && obj instanceof Number && Tac.valueSignnum((Number)obj) == 0) {
            return "";
        }
        if (obj instanceof BigDecimal) {
            if ((this.options & 0x2000) != 0) {
                return "" + ((Number)obj).intValue();
            }
            String s = "";
            if (this.percent > 0) {
                obj = ((BigDecimal)obj).multiply(new BigDecimal((double)this.percent));
                if (!flag) {
                    s = this.percent != 100 ? "/" + this.percent : "%";
                }
            }
            return String.valueOf(Utilities.format((BigDecimal)obj, this.minDecimals, this.maxDecimals, (this.options & 0x20) != 0 && !flag)) + s;
        }
        if (obj instanceof Double) {
            if ((this.options & 0x2000) != 0) {
                return "" + ((Number)obj).intValue();
            }
            String s1 = "";
            if (this.percent > 0) {
                obj = new Double((Double)obj * (double)this.percent);
                if (!flag) {
                    s1 = this.percent != 100 ? "/" + this.percent : "%";
                }
            }
            return String.valueOf(Utilities.format(((Number)obj).doubleValue(), this.minDecimals, this.maxDecimals, (this.options & 0x20) != 0 && !flag)) + s1;
        }
        if (obj instanceof Timestamp) {
            return Utilities.dateToString((Date)((Timestamp)obj), true);
        }
        if (obj instanceof InputStream) {
            try {
                InputStream inputstream = (InputStream)obj;
                obj = Utilities.getTextFromInputStream(inputstream);
                inputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static final void findXPosition(TableColumn[] atablecolumn) {
        int i = 0;
        if (atablecolumn != null) {
            int j = 0;
            while (j < atablecolumn.length) {
                atablecolumn[j].left = i;
                if ((atablecolumn[j].options & 1) == 0) {
                    i += atablecolumn[j].width;
                }
                ++j;
            }
        }
    }

    public static final int nextVisibleColumn(TableColumn[] atablecolumn, int i) {
        return TableColumn.nextVisibleColumn(atablecolumn, i, false);
    }

    public static final int nextVisibleColumn(TableColumn[] atablecolumn, int i, boolean flag) {
        if (atablecolumn != null) {
            int j = i + 1;
            while (j < atablecolumn.length) {
                if (!((atablecolumn[j].options & 1) != 0 || flag && (atablecolumn[j].extOptions & 8) != 0)) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    public static final int prevVisibleColumn(TableColumn[] atablecolumn, int i) {
        return TableColumn.prevVisibleColumn(atablecolumn, i, false);
    }

    public static final int prevVisibleColumn(TableColumn[] atablecolumn, int i, boolean flag) {
        if (atablecolumn != null) {
            int j = i - 1;
            while (j >= 0) {
                if (!((atablecolumn[j].options & 1) != 0 || flag && (atablecolumn[j].extOptions & 8) != 0)) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    boolean isPointAtBooleanIcon(int i, int j) {
        int k = i - this.width / 2;
        int l = j - this.height / 2;
        return k >= -4 && k <= 4 && l >= -4 && l <= 4;
    }

    public static void drawBooleanValue(Graphics g, int i, int j, int k, int l, boolean flag, Color color) {
        int i1 = (k - 15) / 2;
        int j1 = (l - 15) / 2;
        if (i1 < 0 || j1 < 0) {
            g = g.create(i, j, k, l);
            i = i1;
            j = j1;
        } else {
            i += i1;
            j += j1;
        }
        if (color != null) {
            g.setColor(color);
            g.fillRect(i + 1, j + 1, 14, 14);
        }
        g.setColor(Color.lightGray);
        g.drawRect(i + 0, j + 0, 16, 16);
        g.drawRect(i + 1, j + 1, 14, 14);
        int byte0 = 2;
        int k1 = 0;
        while (k1 < booleanIcon_Line.length) {
            if (k1 == 8) {
                g.setColor(Color.gray);
            } else if (k1 == 16) {
                g.setColor(Color.black);
            }
            g.drawLine(i + booleanIcon_Line[k1 + 0] + 2, j + booleanIcon_Line[k1 + 1] + 2, i + booleanIcon_Line[k1 + 2] + 2, j + booleanIcon_Line[k1 + 3] + 2);
            k1 += 4;
        }
        if (flag) {
            int l1 = 7;
            int i2 = 0;
            while (i2 < 7) {
                g.drawLine(i + 5 + i2, j + l1, i + 5 + i2, j + l1 + 2);
                l1 += i2 >= 2 ? -1 : 1;
                ++i2;
            }
        }
    }

    public void setImageObject(ExtObject extobject) {
        this.imageObject = extobject;
    }

    public void setColorWhenMap(boolean flag) {
        this.bColorWhenMap = flag;
    }

    public void paint(Graphics g, int i, int j, int k, int l, Object obj, FontMetrics fontmetrics, int i1, Color color, Color color1, Color color2) {
        String s;
        Color color3;
        Color color4 = color3 = this.foreground != null ? this.foreground : color1;
        if (color3 == null) {
            color3 = Color.black;
        }
        if ((i1 & 1) != 0) {
            if ((i1 & 0x10) != 0) {
                g.setColor(color2 != null ? color2 : Constants.color_220_220_220);
            } else {
                color3 = Color.white;
                g.setColor(new Color(10, 36, 106));
            }
            g.fillRect(i + 1, j + 1, k - 1, l - 1);
        } else if ((i1 & 2) != 0) {
            g.setColor(this.background != null ? this.background : color);
            g.fillRect(i + 1, j + 1, k - 1, l - 1);
        }
        if ((i1 & 4) != 0 && (this.options & 0x10000000) != 0) {
            Utilities.drawLowered3DRect(g, i - 2, j - 2, k + 4 + ((i1 & 0x20) == 0 ? 0 : 16), l + 4);
        }
        if (obj == null) {
            if ((i1 & 1) != 0 && (this.dataColumnBit >= 0 || this.dataType == 11)) {
                obj = Boolean.FALSE;
            } else {
                return;
            }
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue() || (i1 & 1) != 0) {
                TableColumn.drawBooleanValue(g, i, j, k, l, (Boolean)obj, (i1 & 1) == 0 ? null : (this.background != null ? this.background : color));
            }
            return;
        }
        if (this.renderer != null) {
            JComponent jcomponent;
            if (this.rendererPane == null) {
                this.rendererPane = new CellRendererPane();
            }
            if ((jcomponent = this.renderer.getTableCellRenderer(this.table, obj, this, (i1 & 1) != 0, this.table.hasFocus())) != null) {
                this.rendererPane.paintComponent(g, jcomponent, this.table, i + 1, j + 1, k - 1, l - 1, true);
            }
            return;
        }
        if (this.imageObject != null) {
            int j1 = this.imageObject.getObjectType();
            if (j1 == 0 || j1 == 6) {
                j1 = ExtObject.getDataType(obj);
            }
            s = j1 == 2 || j1 == 4 ? "[\u56fe\u7247]" : (j1 == 1 ? "[Word\u6587\u6863]" : (j1 == 5 ? "[Excel\u6587\u6863]" : (j1 == 8 ? "[PDF\u6587\u6863]" : (j1 == 9 ? "[IE\u5730\u5740]" : "[?]"))));
        } else {
            s = this.toString(obj, false, (i1 & 8) == 0);
        }
        if (s == null || s.length() == 0) {
            return;
        }
        if ((this.options & 0x10) != 0 && s.length() > 0 && s.charAt(0) == '-') {
            s = s.substring(1);
            color3 = Color.red;
        }
        if ((this.options & 0x4000) != 0) {
            s = Utilities.stringFromDupChar('*', s.length());
        }
        int k1 = fontmetrics.stringWidth(s);
        int l1 = 1;
        if (this.bColorWhenMap && this.codeNameMap != null && this.dataType == 16) {
            String s1;
            String string = s1 = obj != null ? obj.toString() : "";
            if (!s1.equals(s) && s != null && s.startsWith(s1)) {
                int i2 = fontmetrics.stringWidth(s1);
                if (i2 > k - 2) {
                    Graphics g2 = g.create(i + 1, j, k - 2, l);
                    g2.setColor(Color.blue);
                    g2.drawString(s1, l1 - 1, fontmetrics.getAscent() + 1);
                } else {
                    g.setColor(Color.blue);
                    g.drawString(s1, i + l1, j + fontmetrics.getAscent() + 1);
                }
                k -= i2;
                i += i2;
                s1 = s.substring(s1.length());
                i2 = fontmetrics.stringWidth(s1);
                if (i2 > k - 2) {
                    Graphics g3 = g.create(i + 1, j, k - 2, l);
                    g3.setColor(color3);
                    g3.drawString(s1, l1 - 1, fontmetrics.getAscent() + 1);
                } else {
                    g.setColor(color3);
                    g.drawString(s1, i + l1, j + fontmetrics.getAscent() + 1);
                }
                return;
            }
        }
        if ((this.options & 4) != 0) {
            l1 = k - 1 - k1;
        } else if ((this.options & 8) != 0) {
            l1 = (k - k1) / 2;
        }
        if (k1 > k - 2 || l1 < 1) {
            Graphics g1 = g.create(i + 1, j, k - 2, l);
            g1.setColor(color3);
            g1.drawString(s, l1 - 1, fontmetrics.getAscent() + 1);
        } else {
            g.setColor(color3);
            g.drawString(s, i + l1, j + fontmetrics.getAscent() + 1);
        }
    }

    public static int getDefaultDisplayWidth(int i, int j) {
        if (j <= 0) {
            j = 8;
        }
        switch (i) {
            case 2: {
                return 3 * j;
            }
            case 3: {
                return 4 * j;
            }
            case 4: {
                return 5 * j;
            }
            case 5: {
                return 6 * j;
            }
            case 6: {
                return 10 * j;
            }
            case 7: {
                return 14 * j;
            }
            case 10: {
                return 16 * j;
            }
            case 11: {
                return 4 * j;
            }
        }
        return 12 * j;
    }

    public static int getDefaultAlign(int i) {
        if (Utilities.findAtIntArray(rightAlignType, i) >= 0) {
            return 4;
        }
        return i != 11 ? 0 : 8;
    }

    public static int getShowNegInRed(int i) {
        return i != 10 ? 0 : 16;
    }

    public static int getShowGroupingSeparator(int i) {
        return i != 10 ? 0 : 32;
    }

    public void setEditor(TableCellEditor tablecelleditor) {
        this.editor = tablecelleditor;
    }

    public TableCellEditor getEditor() {
        return this.editor;
    }

    private static void findCaptionSubCellDrawWidth(Vector vector) {
        if (vector != null && vector.size() > 1) {
            CaptionCell[] acaptioncell = new CaptionCell[vector.size()];
            vector.toArray(acaptioncell);
            TableColumn.findCaptionSubCellDrawWidth(acaptioncell);
        }
        vector.removeAllElements();
    }

    public static void findCaptionSubCellDrawWidth(CaptionCell[] acaptioncell) {
        if (acaptioncell == null || acaptioncell.length <= 1) {
            return;
        }
        Vector<CaptionCell> vector = new Vector<CaptionCell>();
        CaptionCell captioncell = null;
        int i = 0;
        while (i < acaptioncell.length) {
            CaptionCell captioncell1 = acaptioncell[i];
            if (!captioncell1.nonMergeAble && captioncell1.subCell != null && captioncell1.subCell.length > 0) {
                if (captioncell != null && !captioncell.equals(captioncell1.subCell[0])) {
                    captioncell.resetSubCellWidth();
                    TableColumn.findCaptionSubCellDrawWidth(vector);
                    captioncell = null;
                }
                CaptionCell captioncell2 = new CaptionCell();
                captioncell2.drawWidth = captioncell1.drawWidth;
                if (captioncell1.subCell.length > 1) {
                    captioncell2.subCell = new CaptionCell[captioncell1.subCell.length - 1];
                    System.arraycopy(captioncell1.subCell, 1, captioncell2.subCell, 0, captioncell2.subCell.length - 1);
                }
                vector.addElement(captioncell2);
                if (captioncell == null) {
                    captioncell = captioncell1.subCell[0];
                } else {
                    captioncell.drawWidth += captioncell1.subCell[0].drawWidth;
                    captioncell1.subCell[0].mergedBy = captioncell;
                }
            } else {
                if (captioncell != null) {
                    captioncell.resetSubCellWidth();
                    captioncell = null;
                }
                TableColumn.findCaptionSubCellDrawWidth(vector);
            }
            ++i;
        }
        if (captioncell != null) {
            captioncell.resetSubCellWidth();
            captioncell = null;
        }
        TableColumn.findCaptionSubCellDrawWidth(vector);
    }

    public static void configCaptionCell(FontMetrics fontmetrics, TableColumn[] atablecolumn, int i, int j) {
        CaptionCell[] acaptioncell = new CaptionCell[atablecolumn.length];
        int k = 0;
        while (k < atablecolumn.length) {
            atablecolumn[k].captionCell.initDrawWidth(atablecolumn[k], k >= i && k < i + j);
            acaptioncell[k] = atablecolumn[k].captionCell;
            ++k;
        }
        TableColumn.findCaptionSubCellDrawWidth(acaptioncell);
        int l = 0;
        while (l < atablecolumn.length) {
            atablecolumn[l].captionCell.splitText(fontmetrics);
            ++l;
        }
    }

    public static CaptionCell parseGroupedCaption(String s) {
        if (s == null) {
            s = "";
        }
        Vector<String> vector = new Vector<String>();
        int i = s.length();
        if (i >= 2 && s.charAt(0) == '(' && s.charAt(i - 1) == ')') {
            int j = 1;
            boolean flag = true;
            int i1 = 1;
            while (i1 < i - 1) {
                char c = s.charAt(i1);
                if (c == '(') {
                    ++j;
                } else if (c == ')' && --j <= 0) {
                    flag = false;
                    break;
                }
                ++i1;
            }
            if (flag) {
                s = s.substring(1, i - 1);
            }
            i -= 2;
        }
        int k = 0;
        int l = 0;
        int j1 = 0;
        while (j1 < i) {
            char c1 = s.charAt(j1);
            if (c1 == '|' && k == 0) {
                vector.addElement(s.substring(l, j1));
                l = j1 + 1;
            } else if (c1 == '(') {
                ++k;
            } else if (c1 == ')') {
                --k;
            }
            ++j1;
        }
        vector.addElement(s.substring(l, i));
        if (vector.size() == 1) {
            return new CaptionCell((String)vector.elementAt(0));
        }
        CaptionCell[] acaptioncell = new CaptionCell[vector.size()];
        int k1 = 0;
        while (k1 < vector.size()) {
            acaptioncell[k1] = TableColumn.parseGroupedCaption((String)vector.elementAt(k1));
            ++k1;
        }
        return new CaptionCell(s, acaptioncell);
    }

    private static boolean objEquals(Object obj, Object obj1) {
        return obj == obj1 || obj != null && obj.equals(obj1);
    }

    public static class CaptionCell {
        public String text;
        String[] splitedText;
        public CaptionCell[] subCell;
        int drawWidth;
        int drawRows;
        CaptionCell mergedBy;
        boolean nonMergeAble;

        public void initDrawWidth(TableColumn tablecolumn, boolean flag) {
            this.nonMergeAble = flag;
            int n = this.drawWidth = (tablecolumn.options & 1) != 0 ? 0 : tablecolumn.width;
            if (this.subCell != null) {
                int i = 0;
                while (i < this.subCell.length) {
                    this.subCell[i].initDrawWidth(tablecolumn, flag);
                    ++i;
                }
            }
        }

        void resetSubCellWidth() {
            if (this.subCell == null) {
                return;
            }
            int i = 0;
            while (i < this.subCell.length) {
                this.subCell[i].drawWidth = this.drawWidth;
                this.subCell[i].resetSubCellWidth();
                ++i;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaptionCell)) {
                return false;
            }
            CaptionCell captioncell = (CaptionCell)obj;
            if (this.subCell != null && captioncell.subCell != null) {
                if (this.subCell.length != captioncell.subCell.length) {
                    return false;
                }
                int i = 0;
                while (i < this.subCell.length) {
                    if (!TableColumn.objEquals(this.subCell[i], captioncell.subCell[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (this.subCell != null || captioncell.subCell != null) {
                return false;
            }
            return TableColumn.objEquals(this.text, captioncell.text);
        }

        public void splitText(FontMetrics fontmetrics) {
            this.splitedText = null;
            this.drawRows = 0;
            if (this.subCell != null) {
                int i = 0;
                while (i < this.subCell.length) {
                    this.subCell[i].splitText(fontmetrics);
                    this.drawRows += this.subCell[i].drawRows;
                    ++i;
                }
            } else if (this.mergedBy != null) {
                this.drawRows = this.mergedBy.drawRows;
            } else if (this.drawWidth > 8) {
                this.splitedText = TableColumn.spliteCaption(this.text, this.drawWidth, fontmetrics);
                this.drawRows = this.splitedText != null ? this.splitedText.length : 0;
            }
        }

        public String toString() {
            String s = this.text;
            if (this.subCell != null) {
                s = String.valueOf(s) + '{';
                int i = 0;
                while (i < this.subCell.length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ',';
                    }
                    s = String.valueOf(s) + (this.subCell[i] != null ? this.subCell[i].toString() : "null");
                    ++i;
                }
                s = String.valueOf(s) + '}';
            }
            return s;
        }

        public CaptionCell() {
        }

        public CaptionCell(String s) {
            this.text = s;
        }

        public CaptionCell(String s, CaptionCell[] acaptioncell) {
            this.text = s;
            this.subCell = acaptioncell;
        }
    }
}

