/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import softcore.table.TableCellDataAccess;
import softcore.table.TableColumn;
import softcore.util.Utilities;

public class TableDateCellDataAccess
implements TableCellDataAccess {
    private int dataColumnIndex = -1;
    private String dateColumnName;
    private int ymd;
    Variant tmpVariant = new Variant();

    private int findYMD(TableColumn tablecolumn) {
        if (this.ymd == 0 && tablecolumn.cellId != null) {
            if (tablecolumn.cellId.endsWith("year")) {
                return 1;
            }
            if (tablecolumn.cellId.endsWith("month")) {
                return 2;
            }
            if (tablecolumn.cellId.endsWith("day")) {
                return 3;
            }
        }
        return this.ymd;
    }

    public TableDateCellDataAccess(int i, int j) {
        this.dataColumnIndex = i;
        this.ymd = j;
    }

    public TableDateCellDataAccess(int i) {
        this.dataColumnIndex = i;
    }

    public TableDateCellDataAccess(String s, int i) {
        this.dateColumnName = s;
        this.ymd = i;
    }

    public TableDateCellDataAccess(String s) {
        this.dateColumnName = s;
    }

    protected boolean getDateVariantValue(DataSet dataset, int i, Variant variant) throws DataSetException {
        if (this.dataColumnIndex >= 0) {
            if (i == -1) {
                dataset.getVariant(this.dataColumnIndex, variant);
            } else {
                dataset.getVariant(this.dataColumnIndex, i, variant);
            }
        } else if (this.dateColumnName != null) {
            if (i == -1) {
                dataset.getVariant(this.dateColumnName, variant);
            } else {
                dataset.getVariant(this.dateColumnName, i, variant);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean getTableCellData(DataSet dataset, int i, TableColumn tablecolumn, Variant variant) throws DataSetException {
        if (!this.getDateVariantValue(dataset, i, variant)) {
            return false;
        }
        int j = this.findYMD(tablecolumn);
        if (j <= 0 || j > 3) {
            return false;
        }
        Object obj = variant.getAsObject();
        if (obj == null || !(obj instanceof Date)) {
            variant.setAssignedNull();
        } else {
            Calendar calendar = Utilities.getStaticCalendars((Date)obj);
            if (j == 1) {
                variant.setInt(calendar.get(1));
            } else if (j == 2) {
                variant.setInt(calendar.get(2) + 1);
            } else if (j == 3) {
                variant.setInt(calendar.get(5));
            }
        }
        return true;
    }

    public boolean setTableCellData(DataSet dataset, TableColumn tablecolumn, Variant variant) throws DataSetException {
        Date obj2;
        Column column;
        if (variant.isAssignedNull()) {
            return false;
        }
        int i = variant.getInt();
        this.getDateVariantValue(dataset, -1, this.tmpVariant);
        int j = this.findYMD(tablecolumn);
        if (j <= 0 || j > 3) {
            return false;
        }
        Object obj = this.tmpVariant.getAsObject();
        Calendar obj1 = obj instanceof Date ? Utilities.getStaticCalendars((Date)obj) : new GregorianCalendar();
        if (j == 1) {
            if (i < 1900 || i > 2999) {
                return false;
            }
            obj1.set(1, i);
        } else if (j == 2) {
            if (i < 1 || i > 12) {
                return false;
            }
            obj1.set(2, i - 1);
        } else if (j == 3) {
            if (i < 1 || i > 31) {
                return false;
            }
            obj1.set(5, i);
        }
        obj1.set(11, 0);
        obj1.set(12, 0);
        obj1.set(13, 0);
        obj1.set(14, 0);
        if (this.dataColumnIndex >= 0) {
            column = dataset.getColumn(this.dataColumnIndex);
        } else if (this.dateColumnName != null) {
            column = dataset.getColumn(this.dateColumnName);
        } else {
            return false;
        }
        int k = column.getDataType();
        long l = obj1.getTime().getTime();
        if (k == 13) {
            obj2 = new java.sql.Date(l);
        } else if (k == 15) {
            obj2 = new Timestamp(l);
        } else {
            return false;
        }
        this.tmpVariant.setAsObject((Object)obj2, k);
        if (this.dataColumnIndex >= 0) {
            dataset.setVariant(this.dataColumnIndex, this.tmpVariant);
        } else if (this.dateColumnName != null) {
            dataset.setVariant(this.dateColumnName, this.tmpVariant);
        }
        return true;
    }
}

