/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import softcore.table.TableCellDataAccess;
import softcore.table.TableColumn;
import softcore.util.Utilities;

public class TableSplitCellDataAccess
implements TableCellDataAccess {
    private String dateColumnName;
    private int index = -1;
    private final char delim;
    Variant tmpVariant = new Variant();

    private int findIndex(TableColumn tablecolumn) {
        int i;
        if (this.index < 0 && tablecolumn.cellId != null && (i = tablecolumn.cellId.indexOf(64)) > 0) {
            try {
                return Integer.parseInt(tablecolumn.cellId.substring(i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.index;
    }

    public TableSplitCellDataAccess(String s, char c) {
        this.dateColumnName = s;
        this.delim = c;
    }

    private String getFieldText(DataSet dataset, int i) throws DataSetException {
        if (this.dateColumnName != null) {
            if (i == -1) {
                dataset.getVariant(this.dateColumnName, this.tmpVariant);
            } else {
                dataset.getVariant(this.dateColumnName, i, this.tmpVariant);
            }
            Object obj = this.tmpVariant.getAsObject();
            return obj instanceof String ? (String)obj : null;
        }
        return null;
    }

    public boolean getTableCellData(DataSet dataset, int i, TableColumn tablecolumn, Variant variant) throws DataSetException {
        int j = this.findIndex(tablecolumn);
        if (j < 0) {
            return false;
        }
        String s = Utilities.subSplitString(this.getFieldText(dataset, i), this.delim, j);
        if (s != null) {
            variant.setString(s);
        } else {
            variant.setAssignedNull();
        }
        return true;
    }

    public boolean setTableCellData(DataSet dataset, TableColumn tablecolumn, Variant variant) throws DataSetException {
        int j;
        String s = this.getFieldText(dataset, -1);
        int i = this.findIndex(tablecolumn);
        if (i < 0) {
            return false;
        }
        Object obj = variant.getAsObject();
        String s1 = obj instanceof String ? (String)obj : null;
        String[] as = Utilities.splitString(s, this.delim);
        int n = j = as != null ? as.length : 0;
        if (j <= i) {
            String[] as1 = new String[i + 1];
            if (j > 0) {
                System.arraycopy(as, 0, as1, 0, j);
            }
            as = as1;
        }
        as[i] = s1;
        int k = 0;
        int l = 0;
        while (l < as.length) {
            String s2;
            String string = s2 = as[l] != null ? Utilities.trimRight(as[l]) : "";
            if (s2.length() > 0) {
                ++k;
            }
            s1 = l == 0 ? s2 : String.valueOf(s1) + this.delim + s2;
            ++l;
        }
        if (this.dateColumnName != null) {
            if (s1 == null || k == 0) {
                dataset.setAssignedNull(this.dateColumnName);
            } else {
                dataset.setString(this.dateColumnName, s1);
            }
        }
        return true;
    }
}

