/*
 * Decompiled with CFR 0.152.
 */
package softcore.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import softcore.table.Table;
import softcore.table.TableColumn;
import softcore.util.Message;

public class TableTranferData
implements Serializable {
    private String tblID;
    private int[] columnTypes;
    private Object[][] datas;

    public TableTranferData() {
    }

    public TableTranferData(Table table) {
        this(table, 0, 0, -1, -1);
    }

    public TableTranferData(Table table, int i, int j, int k, int l) {
        this.tblID = table.getTableId();
        TableColumn[] atablecolumn = table.getTableColumns();
        int[] ai = new int[atablecolumn.length];
        int i1 = 0;
        while (i1 < ai.length) {
            ai[i1] = -1;
            ++i1;
        }
        int j1 = 0;
        int k1 = 0;
        int l1 = 0;
        while (l1 < atablecolumn.length) {
            if (++j1 > j && (atablecolumn[l1].options & 1) == 0) {
                ai[k1++] = j1 - 1;
            }
            if (l >= 0 && k1 >= l) break;
            ++l1;
        }
        int i2 = table.getRowCount();
        int j2 = 0;
        if (k < 0) {
            j2 = i2 - i;
        } else {
            j2 = k;
            if (i + j2 > i2) {
                j2 = i2 - i;
            }
        }
        if (j2 <= 0 || k1 <= 0) {
            return;
        }
        this.columnTypes = new int[k1];
        int k2 = 0;
        while (k2 < k1) {
            this.columnTypes[k2] = atablecolumn[ai[k2]].getDataType();
            ++k2;
        }
        this.datas = new Object[j2][k1];
        int l2 = 0;
        while (l2 < j2) {
            int i3 = 0;
            while (i3 < k1) {
                this.datas[l2][i3] = table.getCellValue(l2 + i, atablecolumn[ai[i3]]);
                ++i3;
            }
            ++l2;
        }
    }

    public void pasteToTable(Table table) throws Exception {
        int i = this.getColumnCount();
        int j = this.getRowCount();
        if (i == 0 || j == 0) {
            return;
        }
        TableColumn tablecolumn = table.getSelectedColumn();
        if (tablecolumn == null) {
            Message.showErrorDialog("\u9519\u8bef", "\u8bf7\u9009\u7c98\u8d34\u4f4d\u7f6e");
            return;
        }
        TableColumn[] atablecolumn = table.getTableColumns();
        int k = atablecolumn.length;
        int[] ai = new int[atablecolumn.length];
        int[] ai1 = new int[atablecolumn.length];
        int l = 0;
        while (l < ai.length) {
            ai[l] = -1;
            ++l;
        }
        boolean flag = false;
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int l1 = 0;
        while (l1 < atablecolumn.length) {
            ++i1;
            if (atablecolumn[l1] == tablecolumn) {
                k1 = l1;
                flag = true;
            }
            if (flag && (atablecolumn[l1].options & 1) == 0) {
                ai[j1] = i1 - 1;
                ai1[j1] = atablecolumn[l1].getDataType();
                ++j1;
            }
            ++l1;
        }
        if (i > j1) {
            Message.showErrorDialog("\u9519\u8bef", "\u7c98\u8d34\u7684\u5217\u6570\u5927\u4e8e\u8868\u4e2d\u6240\u8981\u7c98\u8d34\u7684\u5217\u6570\uff01");
            return;
        }
        int i2 = 0;
        while (i2 < i && i2 < j1) {
            if (!this.isTypeEquals(ai1[i2], this.columnTypes[i2])) {
                if (Message.showQuestionDialog("\u63d0\u793a", "\u5217\u7684\u7c7b\u578b\u4e0d\u76f8\u540c\uff0c\u662f\u5426\u7c98\u8d34?") == 0) break;
                return;
            }
            ++i2;
        }
        int j2 = table.getRowSelected();
        int k2 = table.getRowCount();
        if (k2 == 1 && (table.getDataSet().isNew(0) || table.getDataSet().isEmpty())) {
            k2 = 0;
        }
        int l2 = 0;
        while (l2 < j) {
            int i3 = 0;
            while (i3 < i) {
                if (i3 + k1 >= k) break;
                table.setCellValue(atablecolumn[ai[i3]], this.datas[l2][i3], true);
                ++i3;
            }
            if (l2 < j - 1) {
                table.goNext();
            }
            if (k2 == 0 && l2 < j - 1) {
                table.insertRow();
            }
            ++l2;
        }
    }

    boolean isTypeEquals(int i, int j) {
        if (i == j) {
            return true;
        }
        if (!(i != 1 && i != 12 || j != 1 && j != 12)) {
            return true;
        }
        if (!(i != 5 && i != 4 && i != 5 || j != 5 && j != 4 && j != 5)) {
            return true;
        }
        return !(i != 6 && i != 8 && i != 3 || j != 6 && j != 8 && j != 3);
    }

    public boolean isValidate() {
        return this.columnTypes != null && this.datas != null;
    }

    public String getTblID() {
        return this.tblID;
    }

    public Object[][] getDatas() {
        return this.datas;
    }

    public int getRowCount() {
        return this.datas != null ? this.datas.length : 0;
    }

    public int getColumnCount() {
        int i = this.getRowCount();
        return i != 0 ? this.datas[0].length : 0;
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    public int getColumnType(int i) throws Exception {
        if (this.columnTypes == null || i < 0 || i >= this.columnTypes.length) {
            throw new Exception("index incorrect!");
        }
        return this.columnTypes[i];
    }

    private void readObject(ObjectInputStream objectinputstream) throws ClassNotFoundException, IOException {
        if (objectinputstream.readBoolean()) {
            this.columnTypes = (int[])objectinputstream.readObject();
            this.datas = (Object[][])objectinputstream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectoutputstream) throws IOException {
        boolean flag = this.isValidate();
        objectoutputstream.writeBoolean(flag);
        if (flag) {
            objectoutputstream.writeUTF(this.tblID == null ? "" : this.tblID);
            objectoutputstream.writeObject(this.columnTypes);
            objectoutputstream.writeObject(this.datas);
        }
    }

    public void clear() {
        this.tblID = null;
        this.columnTypes = null;
        this.datas = null;
    }

    public String toString() {
        String s = "tableName:" + (this.tblID != null ? this.tblID : "") + "\n columnTypes:";
        if (this.isValidate()) {
            int i = 0;
            while (i < this.columnTypes.length) {
                s = String.valueOf(s) + " " + i + ":" + this.columnTypes[i];
                ++i;
            }
        }
        return s;
    }
}

