/*
 * Decompiled with CFR 0.152.
 */
package softcore.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;

class IconJAI
implements Icon {
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected Rectangle imageBounds;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int originX;
    protected int originY;
    private Color grayColor = new Color(192, 192, 192);
    private Color backgroundColor = null;

    public IconJAI(RenderedImage renderedimage) {
        int i = renderedimage.getMinX();
        int j = renderedimage.getMinY();
        if (i < 0 || j < 0) {
            ParameterBlock parameterblock = new ParameterBlock();
            parameterblock.addSource(renderedimage);
            parameterblock.add(Math.max(-i, 0));
            parameterblock.add(Math.max(-j, 0));
            parameterblock.add(new InterpolationNearest());
            renderedimage = JAI.create((String)"translate", (ParameterBlock)parameterblock, null);
        }
        this.im = renderedimage;
        this.sampleModel = renderedimage.getSampleModel();
        this.colorModel = renderedimage.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)renderedimage.getSampleModel());
        }
        if (this.colorModel == null) {
            throw new IllegalArgumentException("IconJAI is unable to display supplied RenderedImage.");
        }
        if (this.colorModel.getTransparency() != 1) {
            Object obj = renderedimage.getProperty("background_color");
            this.backgroundColor = obj != null ? (Color)obj : new Color(0, 0, 0);
        }
        this.minX = renderedimage.getMinX();
        this.minY = renderedimage.getMinY();
        this.width = renderedimage.getWidth();
        this.height = renderedimage.getHeight();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        this.minTileX = renderedimage.getMinTileX();
        this.maxTileX = renderedimage.getMinTileX() + renderedimage.getNumXTiles() - 1;
        this.minTileY = renderedimage.getMinTileY();
        this.maxTileY = renderedimage.getMinTileY() + renderedimage.getNumYTiles() - 1;
        this.tileWidth = renderedimage.getTileWidth();
        this.tileHeight = renderedimage.getTileHeight();
        this.tileGridXOffset = renderedimage.getTileGridXOffset();
        this.tileGridYOffset = renderedimage.getTileGridYOffset();
        this.originY = 0;
        this.originX = 0;
    }

    public int getIconWidth() {
        return this.im.getWidth();
    }

    public int getIconHeight() {
        return this.im.getHeight();
    }

    public void paintIcon(Component component, Graphics g, int i, int j) {
        Graphics2D graphics2d = null;
        if (!(g instanceof Graphics2D)) {
            System.err.println("IconJAI: not a Graphics2D.");
            return;
        }
        graphics2d = (Graphics2D)g;
        Rectangle rectangle = g.getClipBounds();
        int k = i;
        int l = j;
        Rectangle rectangle1 = new Rectangle(this.minX + k, this.minY + l, this.width, this.height);
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        }
        int i1 = PlanarImage.XToTileX((int)(rectangle.x - k), (int)this.tileGridXOffset, (int)this.tileWidth);
        i1 = Math.max(i1, this.minTileX);
        i1 = Math.min(i1, this.maxTileX);
        int j1 = PlanarImage.XToTileX((int)(rectangle.x + rectangle.width - 1 - k), (int)this.tileGridXOffset, (int)this.tileWidth);
        j1 = Math.max(j1, this.minTileX);
        j1 = Math.min(j1, this.maxTileX);
        int k1 = PlanarImage.YToTileY((int)(rectangle.y - l), (int)this.tileGridYOffset, (int)this.tileHeight);
        k1 = Math.max(k1, this.minTileY);
        k1 = Math.min(k1, this.maxTileY);
        int l1 = PlanarImage.YToTileY((int)(rectangle.y + rectangle.height - 1 - l), (int)this.tileGridYOffset, (int)this.tileHeight);
        l1 = Math.max(l1, this.minTileY);
        l1 = Math.min(l1, this.maxTileY);
        graphics2d.clip(rectangle1);
        if (this.backgroundColor != null) {
            graphics2d.setColor(this.backgroundColor);
        }
        int j2 = k1;
        while (j2 <= l1) {
            int i2 = i1;
            while (i2 <= j1) {
                int k2 = PlanarImage.tileXToX((int)i2, (int)this.tileGridXOffset, (int)this.tileWidth);
                int l2 = PlanarImage.tileYToY((int)j2, (int)this.tileGridYOffset, (int)this.tileHeight);
                Raster raster = this.im.getTile(i2, j2);
                DataBuffer databuffer = raster.getDataBuffer();
                Point point = new Point(0, 0);
                WritableRaster writableraster = Raster.createWritableRaster(this.sampleModel, databuffer, point);
                BufferedImage bufferedimage = new BufferedImage(this.colorModel, writableraster, false, null);
                AffineTransform affinetransform = AffineTransform.getTranslateInstance(k2 + k, l2 + l);
                if (this.backgroundColor != null) {
                    graphics2d.fillRect(k2 + k, l2 + l, this.tileWidth, this.tileHeight);
                }
                graphics2d.drawImage(bufferedimage, affinetransform, null);
                ++i2;
            }
            ++j2;
        }
    }
}

